#!/bin/sh
echo 'name: snap
version: 0.12.0
id: snap-0.12.0-78b0ff5906343d34fc1043a914ada5e0

license: BSD3
copyright:
maintainer: snap@snapframework.com
stability:
homepage: http://snapframework.com/
package-url:
synopsis: Top-level package for the Snap Web Framework
description: This is the top-level package for the official Snap Framework libraries.
             It includes:
             .
             * The Snaplets API
             .
             * The \"snap\" executable program for generating starter projects
             .
             * Snaplets for sessions, authentication, and templates
             .
             To get started, issue the following sequence of commands:
             .
             @$ cabal install snap
             $ mkdir myproject
             $ cd myproject
             $ snap init@
             .
             If you have trouble or any questions, see our FAQ page
             (<http://snapframework.com/faq>) or the documentation
             (<http://snapframework.com/docs>).
category: Web, Snap
author: Ozgun Ataman, Doug Beardsley, Gregory Collins, Carl Howells, Chris Smith
pkgpath: www/hs-snap
exposed: True
exposed-modules: Snap Snap.Snaplet Snap.Snaplet.Heist
                 Snap.Snaplet.HeistNoClass Snap.Snaplet.Heist.Compiled
                 Snap.Snaplet.Heist.Generic Snap.Snaplet.Heist.Interpreted
                 Snap.Snaplet.Auth Snap.Snaplet.Auth.Backends.JsonFile
                 Snap.Snaplet.Config Snap.Snaplet.Session
                 Snap.Snaplet.Session.Common Snap.Snaplet.Session.SessionManager
                 Snap.Snaplet.Session.Backends.CookieSession Snap.Snaplet.Test
hidden-modules: Control.Access.RoleBased.Checker
                Control.Access.RoleBased.Role Control.Access.RoleBased.Types
                Control.Access.RoleBased.Internal.Role
                Control.Access.RoleBased.Internal.RoleMap
                Control.Access.RoleBased.Internal.Rule
                Control.Access.RoleBased.Internal.Types
                Snap.Snaplet.Auth.AuthManager Snap.Snaplet.Auth.Types
                Snap.Snaplet.Auth.Handlers Snap.Snaplet.Auth.SpliceHelpers
                Snap.Snaplet.Heist.Internal Snap.Snaplet.Internal.Initializer
                Snap.Snaplet.Internal.LensT Snap.Snaplet.Internal.Lensed
                Snap.Snaplet.Internal.RST Snap.Snaplet.Internal.Types
                Snap.Snaplet.Session.SecureCookie
trusted: False
import-dirs: /usr/local/lib/ghc/snap-0.12.0
library-dirs: /usr/local/lib/ghc/snap-0.12.0
hs-libraries: HSsnap-0.12.0
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: MonadCatchIO-transformers-0.3.0.0-00f5ba39422294066c7f13d4ef6c89a7
         aeson-0.6.2.1-92173c75149e34c3bea9cafc379c1c76
         attoparsec-0.10.4.0-d9fd97cfc1a1748b3cde35adf7fd233b
         base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         bytestring-0.10.0.2-1c6ab0cabcb254a0e55d751d8ef17b51
         cereal-0.3.5.2-a9ff0516a3b8fef3d6dca329fe564618
         clientsession-0.8.0.1-ca77cc2a91046b6d607decaed0ad0352
         comonad-3.0.3-069bdb9621e61706823278b4810c21d4
         configurator-0.2.0.0-3768e2c0e23982f83faf58658c8b8b19
         containers-0.5.0.0-ab1dae9a94cd3cc84e7b2805636ebfa2
         directory-1.2.0.1-1e5a1d00411e436c303c3932f4640124
         directory-tree-0.11.0-5c20bbe86d621a648706bf53701cb991
         dlist-0.5-6480552fbf191185cc86167748682e90
         errors-1.4.2-34975bd2e1590962642c5f29c9201c34
         filepath-1.3.0.1-b12cbe18566fe1532a1fda4c85e31cbe
         hashable-1.1.2.5-e0f2541518f84d3123a819112b4ffe20
         heist-0.12.0-f7d773500ed4670c319cb795ee40e448
         lens-3.7.6-279ef4ec8bf447996174817bf749a957
         logict-0.5.0.1-f5871108fc142912fe5ecea3a877dda7
         mtl-2.1.2-94c72af955e94b8d7b2f359dadd0cb62
         mwc-random-0.12.0.1-0eb81e69e8af3373af6d996297c93350
         pwstore-fast-2.3-b2fbe273aaf671cb3dac424097cf6560
         regex-posix-0.95.2-320e6bd67debb5ce05f7a0fda4ec39c1
         snap-core-0.9.4.0-143c7f74b4da1dfd50b84e8329b69c2e
         snap-server-0.9.3.3-512360e773cc88d02ff8a9ceddc91384
         stm-2.4.2-b5d718b1a5f1fbcdb61a336aef0c2130
         syb-0.4.0-c48d52f3188b986ddaa9dd9ae40072f8
         text-0.11.3.1-5af30448b2c3a30eee31b3ea9b549812
         time-1.4.0.1-10dc4804a19dc0000fab79908f1a9f50
         transformers-0.3.0.0-ff2bb6ac67241ebb987351a3db564af0
         unordered-containers-0.2.3.0-c7952fe8bed178bdf8ed4d090730c9da
         vector-0.10.0.1-869166d5d49db46ce6c328ea5f8defbf
         vector-algorithms-0.5.4.2-121a1f6b21832cab9f9b2bcd06ce88a8
         xmlhtml-0.2.1-658d8ec37c0651e1f661d3d92991944e
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-snap-0.12.0/html/snap.haddock
haddock-html: /usr/local/share/doc/hs-snap-0.12.0/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
