/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Component;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.html.FormSubmitEvent;
import javax.swing.text.html.FrameSetView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;

class FrameView
extends ComponentView
implements HyperlinkListener {
    FrameView(Element el) {
        super(el);
    }

    protected Component createComponent() {
        Element el = this.getElement();
        AttributeSet atts = el.getAttributes();
        JEditorPane html = new JEditorPane();
        html.addHyperlinkListener(this);
        URL base = ((HTMLDocument)el.getDocument()).getBase();
        String srcAtt = (String)atts.getAttribute(HTML.Attribute.SRC);
        if (srcAtt != null && !srcAtt.equals("")) {
            try {
                URL page = new URL(base, srcAtt);
                html.setPage(page);
                ((HTMLDocument)html.getDocument()).setFrameDocument(true);
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {}
        }
        return html;
    }

    public void hyperlinkUpdate(HyperlinkEvent event) {
        JEditorPane outer = this.getTopEditorPane();
        if (outer != null) {
            if (event instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent hfhe = (HTMLFrameHyperlinkEvent)event;
                if (hfhe.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String target = hfhe.getTarget();
                    if (event instanceof FormSubmitEvent) {
                        this.handleFormSubmitEvent(hfhe, outer, target);
                    } else {
                        this.handleHyperlinkEvent(hfhe, outer, target);
                    }
                }
            } else {
                outer.fireHyperlinkUpdate(event);
            }
        }
    }

    private void handleHyperlinkEvent(HyperlinkEvent event, JEditorPane outer, String target) {
        if (target.equals("_top")) {
            try {
                outer.setPage(event.getURL());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (!outer.isEditable()) {
            outer.fireHyperlinkUpdate(new HTMLFrameHyperlinkEvent(outer, event.getEventType(), event.getURL(), event.getDescription(), this.getElement(), target));
        }
    }

    private void handleFormSubmitEvent(HTMLFrameHyperlinkEvent event, JEditorPane outer, String target) {
        HTMLEditorKit kit = (HTMLEditorKit)outer.getEditorKit();
        if (kit != null && kit.isAutoFormSubmission()) {
            if (target.equals("_top")) {
                try {
                    outer.setPage(event.getURL());
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            } else {
                HTMLDocument doc = (HTMLDocument)outer.getDocument();
                doc.processHTMLFrameHyperlinkEvent(event);
            }
        } else {
            outer.fireHyperlinkUpdate(event);
        }
    }

    private JEditorPane getTopEditorPane() {
        View parent = this.getParent();
        View top = null;
        while (parent != null) {
            if (!(parent instanceof FrameSetView)) continue;
            top = parent;
        }
        JEditorPane editor = null;
        if (top != null) {
            editor = (JEditorPane)top.getContainer();
        }
        return editor;
    }
}

