/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JToolBar;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;
import javax.swing.plaf.metal.OceanTheme;
import javax.swing.text.JTextComponent;

public class MetalBorders {
    private static Border buttonBorder;
    private static Border toggleButtonBorder;
    private static Border desktopIconBorder;
    private static Border toolbarButtonBorder;
    private static Border textFieldBorder;
    private static Border textBorder;
    private static Border rolloverBorder;
    private static BasicBorders.MarginBorder marginBorder;

    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            ButtonBorder outer = new ButtonBorder();
            Border inner = MetalBorders.getMarginBorder();
            buttonBorder = new BorderUIResource.CompoundBorderUIResource(outer, inner);
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        if (toggleButtonBorder == null) {
            ToggleButtonBorder outer = new ToggleButtonBorder();
            Border inner = MetalBorders.getMarginBorder();
            toggleButtonBorder = new BorderUIResource.CompoundBorderUIResource(outer, inner);
        }
        return toggleButtonBorder;
    }

    public static Border getDesktopIconBorder() {
        if (desktopIconBorder == null) {
            desktopIconBorder = new DesktopIconBorder();
        }
        return desktopIconBorder;
    }

    public static Border getTextFieldBorder() {
        if (textFieldBorder == null) {
            Border inner = MetalBorders.getMarginBorder();
            TextFieldBorder outer = new TextFieldBorder();
            textFieldBorder = new BorderUIResource.CompoundBorderUIResource(outer, inner);
        }
        return textFieldBorder;
    }

    public static Border getTextBorder() {
        if (textBorder == null) {
            Border inner = MetalBorders.getMarginBorder();
            Flush3DBorder outer = new Flush3DBorder();
            textBorder = new BorderUIResource.CompoundBorderUIResource(outer, inner);
        }
        return textBorder;
    }

    static Border getToolbarButtonBorder() {
        if (toolbarButtonBorder == null) {
            ButtonBorder outer = new ButtonBorder();
            RolloverMarginBorder inner = new RolloverMarginBorder();
            toolbarButtonBorder = new CompoundBorder(outer, inner);
        }
        return toolbarButtonBorder;
    }

    static Border getMarginBorder() {
        if (marginBorder == null) {
            marginBorder = new BasicBorders.MarginBorder();
        }
        return marginBorder;
    }

    static Border getRolloverBorder() {
        if (rolloverBorder == null) {
            RolloverButtonBorder outer = new RolloverButtonBorder();
            Border inner = MetalBorders.getMarginBorder();
            rolloverBorder = new BorderUIResource.CompoundBorderUIResource(outer, inner);
        }
        return rolloverBorder;
    }

    public static class ButtonBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(3, 3, 3, 3);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme) {
                this.paintOceanButtonBorder(c, g, x, y, w, h);
            } else {
                this.paintDefaultButtonBorder(c, g, x, y, w, h);
            }
        }

        private void paintDefaultButtonBorder(Component c, Graphics g, int x, int y, int w, int h) {
            ButtonModel bmodel = null;
            if (!(c instanceof AbstractButton)) {
                throw new IllegalStateException("A ButtonBorder is supposed to work only with AbstractButton andsubclasses.");
            }
            bmodel = ((AbstractButton)c).getModel();
            ColorUIResource darkShadow = MetalLookAndFeel.getControlDarkShadow();
            ColorUIResource shadow = MetalLookAndFeel.getControlShadow();
            ColorUIResource light = MetalLookAndFeel.getControlHighlight();
            ColorUIResource middle = MetalLookAndFeel.getControl();
            if (c.isEnabled()) {
                g.setColor(darkShadow);
                g.drawRect(x, y, w - 2, h - 2);
                if (c instanceof JButton && ((JButton)c).isDefaultButton()) {
                    g.drawRect(x + 1, y + 1, w - 4, h - 4);
                    g.setColor(light);
                    g.drawLine(x + 2, y + 2, x + w - 4, y + 2);
                    g.drawLine(x + 2, y + 2, x + 2, y + h - 4);
                    g.drawLine(x + 2, y + h - 1, x + w - 1, y + h - 1);
                    g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 1);
                    g.setColor(middle);
                    g.fillRect(x + w - 2, y + 2, 1, 1);
                    g.fillRect(x + 2, y + h - 2, 1, 1);
                } else if (!bmodel.isPressed() || !bmodel.isArmed()) {
                    g.setColor(light);
                    g.drawRect(x + 1, y + 1, w - 2, h - 2);
                    g.setColor(middle);
                    g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                    g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                } else {
                    g.setColor(light);
                    g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
                    g.drawLine(x + 1, y + h - 1, x + w - 1, y + h - 1);
                    g.setColor(middle);
                    g.drawLine(x + 1, y + 1, x + w - 2, y + 1);
                    g.drawLine(x + 1, y + 1, x + 1, y + h - 2);
                    g.setColor(shadow);
                    g.drawRect(x + 1, y + h - 2, 0, 0);
                    g.drawRect(x + w - 2, y + 1, 0, 0);
                }
            } else {
                g.setColor(MetalLookAndFeel.getInactiveControlTextColor());
                g.drawRect(x, y, w - 2, h - 2);
            }
        }

        private void paintOceanButtonBorder(Component c, Graphics g, int x, int y, int w, int h) {
            ButtonModel bmodel = null;
            if (!(c instanceof AbstractButton)) {
                throw new IllegalStateException("A ButtonBorder is supposed to work only with AbstractButton andsubclasses.");
            }
            bmodel = ((AbstractButton)c).getModel();
            ColorUIResource darkShadow = MetalLookAndFeel.getControlDarkShadow();
            ColorUIResource shadow = MetalLookAndFeel.getControlShadow();
            MetalLookAndFeel.getControlHighlight();
            MetalLookAndFeel.getControl();
            if (c.isEnabled()) {
                if (bmodel.isPressed() || c instanceof JButton && ((JButton)c).isDefaultButton()) {
                    g.setColor(darkShadow);
                    g.drawRect(x, y, w - 1, h - 1);
                    g.drawRect(x + 1, y + 1, w - 3, h - 3);
                } else if (bmodel.isRollover() && !(c.getParent() instanceof JToolBar)) {
                    g.setColor(shadow);
                    g.drawRect(x, y, w - 1, h - 1);
                    g.drawRect(x + 2, y + 2, w - 5, h - 5);
                    g.setColor(darkShadow);
                    g.drawRect(x + 1, y + 1, w - 3, h - 3);
                } else {
                    g.setColor(darkShadow);
                    g.drawRect(x, y, w - 1, h - 1);
                }
            } else {
                g.setColor(MetalLookAndFeel.getInactiveControlTextColor());
                g.drawRect(x, y, w - 2, h - 2);
            }
        }

        public Insets getBorderInsets(Component c) {
            return borderInsets;
        }

        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.bottom = ButtonBorder.borderInsets.bottom;
            newInsets.left = ButtonBorder.borderInsets.left;
            newInsets.right = ButtonBorder.borderInsets.right;
            newInsets.top = ButtonBorder.borderInsets.top;
            return newInsets;
        }
    }

    static class DesktopIconBorder
    extends AbstractBorder
    implements UIResource {
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, null);
        }

        public Insets getBorderInsets(Component c, Insets newInsets) {
            if (newInsets == null) {
                newInsets = new Insets(3, 3, 2, 3);
            } else {
                newInsets.top = 3;
                newInsets.left = 3;
                newInsets.bottom = 2;
                newInsets.right = 3;
            }
            return newInsets;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawRect(x, y, w - 1, h - 1);
        }
    }

    public static class Flush3DBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets borderInsets = new Insets(2, 2, 2, 2);

        public Insets getBorderInsets(Component c) {
            return borderInsets;
        }

        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = Flush3DBorder.borderInsets.top;
            newInsets.left = Flush3DBorder.borderInsets.left;
            newInsets.bottom = Flush3DBorder.borderInsets.bottom;
            newInsets.right = Flush3DBorder.borderInsets.right;
            return newInsets;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color savedColor = g.getColor();
            g.setColor(MetalLookAndFeel.getControlDarkShadow());
            g.drawRect(x, y, w - 2, h - 2);
            g.setColor(MetalLookAndFeel.getControlHighlight());
            g.drawRect(x + 1, y + 1, w - 2, h - 2);
            g.setColor(MetalLookAndFeel.getControl());
            g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
            g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
            g.setColor(savedColor);
        }
    }

    public static class InternalFrameBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets borderInsets = new Insets(5, 5, 5, 5);

        public Insets getBorderInsets(Component c) {
            return borderInsets;
        }

        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = InternalFrameBorder.borderInsets.top;
            newInsets.left = InternalFrameBorder.borderInsets.left;
            newInsets.bottom = InternalFrameBorder.borderInsets.bottom;
            newInsets.right = InternalFrameBorder.borderInsets.right;
            return newInsets;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JInternalFrame f = (JInternalFrame)c;
            if (f.isSelected()) {
                g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            } else {
                g.setColor(MetalLookAndFeel.getControlDarkShadow());
            }
            g.fillRect(x, y, w, 5);
            g.fillRect(x, y, 5, h);
            g.fillRect(x + w - 5, y, 5, h);
            g.fillRect(x, y + h - 5, w, 5);
            g.setColor(MetalLookAndFeel.getControl());
            g.fillRect(x, y, 1, 1);
            g.fillRect(x + w - 1, y, 1, 1);
            g.fillRect(x + w - 1, y + h - 1, 1, 1);
            g.fillRect(x, y + h - 1, 1, 1);
            g.setColor(MetalLookAndFeel.getBlack());
            g.drawLine(x + 14, y + 2, x + w - 15, y + 2);
            g.drawLine(x + 14, y + h - 3, x + w - 15, y + h - 3);
            g.drawLine(x + 2, y + 14, x + 2, y + h - 15);
            g.drawLine(x + w - 3, y + 14, x + w - 3, y + h - 15);
            if (f.isSelected()) {
                g.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            } else {
                g.setColor(MetalLookAndFeel.getControlShadow());
            }
            g.drawLine(x + 15, y + 3, x + w - 14, y + 3);
            g.drawLine(x + 15, y + h - 2, x + w - 14, y + h - 2);
            g.drawLine(x + 3, y + 15, x + 3, y + h - 14);
            g.drawLine(x + w - 2, y + 15, x + w - 2, y + h - 14);
        }
    }

    public static class MenuBarBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(1, 0, 1, 0);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            if (MetalLookAndFeel.getCurrentTheme() instanceof OceanTheme) {
                g.setColor(UIManager.getColor("MenuBar.borderColor"));
            } else {
                g.setColor(MetalLookAndFeel.getControlShadow());
            }
            g.drawLine(x, y + h - 1, x + w, y + h - 1);
        }

        public Insets getBorderInsets(Component c) {
            return borderInsets;
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.left = MenuBarBorder.borderInsets.left;
            insets.top = MenuBarBorder.borderInsets.top;
            insets.bottom = MenuBarBorder.borderInsets.bottom;
            insets.right = MenuBarBorder.borderInsets.right;
            return insets;
        }
    }

    public static class MenuItemBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            ColorUIResource dark = MetalLookAndFeel.getPrimaryControlDarkShadow();
            ColorUIResource light = MetalLookAndFeel.getPrimaryControlHighlight();
            if (c instanceof JMenu) {
                JMenu menu = (JMenu)c;
                if (menu.isSelected()) {
                    g.setColor(dark);
                    g.drawLine(x, y, x, y + h);
                    g.drawLine(x, y, x + w, y);
                    g.drawLine(x + w - 2, y + 1, x + w - 2, y + h);
                    g.setColor(light);
                    g.drawLine(x + w - 1, y + 1, x + w - 1, y + h);
                }
            } else if (c instanceof JMenuItem) {
                JMenuItem item = (JMenuItem)c;
                if (item.isArmed()) {
                    g.setColor(dark);
                    g.drawLine(x, y, x + w, y);
                    g.setColor(light);
                    g.drawLine(x, y + h - 1, x + w, y + h - 1);
                } else {
                    g.setColor(light);
                    g.drawLine(x, y, x, y + h);
                }
            }
        }

        public Insets getBorderInsets(Component c) {
            return borderInsets;
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.left = MenuItemBorder.borderInsets.left;
            insets.top = MenuItemBorder.borderInsets.top;
            insets.bottom = MenuItemBorder.borderInsets.bottom;
            insets.right = MenuItemBorder.borderInsets.right;
            return insets;
        }
    }

    public static class OptionDialogBorder
    extends AbstractBorder
    implements UIResource {
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, null);
        }

        public Insets getBorderInsets(Component c, Insets newInsets) {
            if (newInsets == null) {
                newInsets = new Insets(3, 3, 3, 3);
            } else {
                newInsets.top = 3;
                newInsets.left = 3;
                newInsets.bottom = 3;
                newInsets.right = 3;
            }
            return newInsets;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JInternalFrame f = (JInternalFrame)c;
            g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            if (f.getContentPane() instanceof JOptionPane) {
                Color bc;
                JOptionPane pane = (JOptionPane)f.getContentPane();
                int type = pane.getMessageType();
                if (type == 3 && (bc = UIManager.getColor("OptionPane.questionDialog.border.background")) != null) {
                    g.setColor(bc);
                }
                if (type == 2) {
                    bc = UIManager.getColor("OptionPane.warningDialog.border.background");
                    if (bc != null) {
                        g.setColor(bc);
                    }
                } else if (type == 0 && (bc = UIManager.getColor("OptionPane.errorDialog.border.background")) != null) {
                    g.setColor(bc);
                }
            }
            g.fillRect(x, y, w, 3);
            g.fillRect(x, y, 3, h);
            g.fillRect(x + w - 3, y, 3, h);
            g.fillRect(x, y + h - 3, w, 3);
            g.setColor(MetalLookAndFeel.getControl());
            g.fillRect(x, y, 1, 1);
            g.fillRect(x + w - 1, y, 1, 1);
            g.fillRect(x + w - 1, y + h - 1, 1, 1);
            g.fillRect(x, y + h - 1, 1, 1);
        }
    }

    public static class PaletteBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets borderInsets = new Insets(1, 1, 1, 1);

        public Insets getBorderInsets(Component c) {
            return borderInsets;
        }

        public Insets getBorderInsets(Component c, Insets newInsets) {
            newInsets.top = PaletteBorder.borderInsets.top;
            newInsets.left = PaletteBorder.borderInsets.left;
            newInsets.bottom = PaletteBorder.borderInsets.bottom;
            newInsets.right = PaletteBorder.borderInsets.right;
            return newInsets;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color savedColor = g.getColor();
            g.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            g.drawRect(x, y, w - 1, h - 1);
            g.setColor(MetalLookAndFeel.getControl());
            g.fillRect(x, y, 1, 1);
            g.fillRect(x + w - 1, y, 1, 1);
            g.fillRect(x + w - 1, y + h - 1, 1, 1);
            g.fillRect(x, y + h - 1, 1, 1);
            g.setColor(savedColor);
        }
    }

    public static class PopupMenuBorder
    extends AbstractBorder
    implements UIResource {
        protected static Insets borderInsets = new Insets(3, 1, 2, 1);

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, null);
        }

        public Insets getBorderInsets(Component c, Insets i) {
            Insets insets;
            if (i == null) {
                insets = new Insets(PopupMenuBorder.borderInsets.top, PopupMenuBorder.borderInsets.left, PopupMenuBorder.borderInsets.bottom, PopupMenuBorder.borderInsets.right);
            } else {
                insets = i;
                insets.top = PopupMenuBorder.borderInsets.top;
                insets.left = PopupMenuBorder.borderInsets.left;
                insets.bottom = PopupMenuBorder.borderInsets.bottom;
                insets.right = PopupMenuBorder.borderInsets.right;
            }
            return insets;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            ColorUIResource darkShadow = MetalLookAndFeel.getPrimaryControlDarkShadow();
            ColorUIResource light = MetalLookAndFeel.getPrimaryControlHighlight();
            g.setColor(darkShadow);
            g.drawRect(x, y, w - 1, h - 1);
            g.setColor(light);
            g.drawLine(x + 1, y + 1, x + w - 2, y + 1);
        }
    }

    public static class RolloverButtonBorder
    extends ButtonBorder {
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            super.paintBorder(c, g, x, y, w, h);
        }
    }

    static class RolloverMarginBorder
    extends AbstractBorder {
        protected static Insets borderInsets = new Insets(3, 3, 3, 3);

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, null);
        }

        public Insets getBorderInsets(Component c, Insets newInsets) {
            if (newInsets == null) {
                newInsets = new Insets(0, 0, 0, 0);
            }
            AbstractButton b = (AbstractButton)c;
            b.getMargin();
            newInsets.bottom = RolloverMarginBorder.borderInsets.bottom;
            newInsets.left = RolloverMarginBorder.borderInsets.left;
            newInsets.right = RolloverMarginBorder.borderInsets.right;
            newInsets.top = RolloverMarginBorder.borderInsets.top;
            return newInsets;
        }
    }

    public static class ScrollPaneBorder
    extends AbstractBorder
    implements UIResource {
        private static Insets insets = new Insets(1, 1, 2, 2);

        public Insets getBorderInsets(Component c) {
            return insets;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            ColorUIResource darkShadow = MetalLookAndFeel.getControlDarkShadow();
            MetalLookAndFeel.getControlShadow();
            ColorUIResource light = MetalLookAndFeel.getWhite();
            ColorUIResource middle = MetalLookAndFeel.getControl();
            g.setColor(darkShadow);
            g.drawLine(x, y, x + w - 2, y);
            g.drawLine(x, y, x, y + h - 2);
            g.drawLine(x + w - 2, y, x + w - 2, y + h + 1);
            g.drawLine(x + 2, y + h - 2, x + w - 2, y + h - 2);
            g.setColor(light);
            g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            g.setColor(middle);
            g.drawLine(x + w - 1, y, x + w - 1, y);
            g.drawLine(x + w - 2, y + 2, x + w - 2, y + 2);
            g.drawLine(x, y + h - 1, x, y + h - 1);
            g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
        }
    }

    public static class TableHeaderBorder
    extends AbstractBorder {
        protected Insets editorBorderInsets = new Insets(1, 1, 1, 1);

        public Insets getBorderInsets(Component c) {
            return this.editorBorderInsets;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            ColorUIResource dark = MetalLookAndFeel.getControlDarkShadow();
            ColorUIResource light = MetalLookAndFeel.getWhite();
            Color old = g.getColor();
            g.setColor(light);
            g.drawLine(x, y, x + w - 2, y);
            g.drawLine(x, y, x, y + h - 2);
            g.setColor(dark);
            g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
            g.drawLine(x + 1, y + h - 1, x + w - 1, y + h - 1);
            g.setColor(old);
        }
    }

    public static class TextFieldBorder
    extends Flush3DBorder
    implements UIResource {
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JTextComponent tc;
            boolean enabledTextBorder = c instanceof JTextComponent ? (tc = (JTextComponent)c).isEnabled() && tc.isEditable() : false;
            if (enabledTextBorder) {
                super.paintBorder(c, g, x, y, w, h);
            } else {
                Color savedColor = g.getColor();
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.drawRect(x, y, w - 1, h - 1);
                g.setColor(savedColor);
            }
        }
    }

    public static class ToggleButtonBorder
    extends ButtonBorder {
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            ButtonModel bmodel = null;
            if (c instanceof AbstractButton) {
                bmodel = ((AbstractButton)c).getModel();
            }
            ColorUIResource darkShadow = MetalLookAndFeel.getControlDarkShadow();
            ColorUIResource shadow = MetalLookAndFeel.getControlShadow();
            ColorUIResource light = MetalLookAndFeel.getWhite();
            ColorUIResource middle = MetalLookAndFeel.getControl();
            if (c.isEnabled()) {
                g.setColor(darkShadow);
                g.drawRect(x, y, w - 2, h - 2);
                if (!bmodel.isArmed()) {
                    g.setColor(light);
                    g.drawLine(x + 1, y + h - 1, x + w - 1, y + h - 1);
                    g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
                    if (bmodel.isSelected()) {
                        g.setColor(middle);
                    }
                    g.drawLine(x + 1, y + 1, x + w - 3, y + 1);
                    g.drawLine(x + 1, y + 1, x + 1, y + h - 3);
                    g.setColor(shadow);
                    g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                    g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                } else {
                    g.setColor(light);
                    g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
                    g.drawLine(x + 1, y + h - 1, x + w - 1, y + h - 1);
                    g.setColor(shadow);
                    g.drawLine(x + 1, y + 1, x + w - 2, y + 1);
                    g.drawLine(x + 1, y + 1, x + 1, y + h - 2);
                    g.setColor(shadow);
                    g.drawLine(x + 1, y + h - 2, x + 1, y + h - 2);
                    g.drawLine(x + w - 2, y + 1, x + w - 2, y + 1);
                }
                g.setColor(middle);
                g.drawLine(x, y + h - 1, x, y + h - 1);
                g.drawLine(x + w - 1, y, x + w - 1, y);
            } else {
                g.setColor(MetalLookAndFeel.getControlDisabled());
                g.drawRect(x, y, w - 2, h - 2);
            }
        }
    }

    public static class ToolBarBorder
    extends AbstractBorder
    implements UIResource,
    SwingConstants {
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, null);
        }

        public Insets getBorderInsets(Component c, Insets newInsets) {
            JToolBar tb = (JToolBar)c;
            if (tb.getOrientation() == 0) {
                if (newInsets == null) {
                    newInsets = new Insets(2, 16, 2, 2);
                } else {
                    newInsets.top = 2;
                    newInsets.left = 16;
                    newInsets.bottom = 2;
                    newInsets.right = 2;
                }
                return newInsets;
            }
            if (newInsets == null) {
                newInsets = new Insets(16, 2, 2, 2);
            } else {
                newInsets.top = 16;
                newInsets.left = 2;
                newInsets.bottom = 2;
                newInsets.right = 2;
            }
            return newInsets;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JToolBar tb = (JToolBar)c;
            if (tb.getOrientation() == 0) {
                MetalUtils.fillMetalPattern(tb, g, x + 2, y + 2, x + 11, y + h - 5, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow());
            } else {
                MetalUtils.fillMetalPattern(tb, g, x + 2, y + 2, x + w - 5, y + 11, MetalLookAndFeel.getControlHighlight(), MetalLookAndFeel.getControlDarkShadow());
            }
        }
    }
}

