/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;

public class JTextPane
extends JEditorPane {
    public JTextPane() {
    }

    public JTextPane(StyledDocument document) {
        this();
        this.setStyledDocument(document);
    }

    public String getUIClassID() {
        return "TextPaneUI";
    }

    public void setDocument(Document document) {
        if (document != null && !(document instanceof StyledDocument)) {
            throw new IllegalArgumentException("JTextPane can only handle StyledDocuments");
        }
        this.setStyledDocument((StyledDocument)document);
    }

    public StyledDocument getStyledDocument() {
        return (StyledDocument)super.getDocument();
    }

    public void setStyledDocument(StyledDocument document) {
        super.setDocument(document);
    }

    public void replaceSelection(String content) {
        Caret caret = this.getCaret();
        StyledDocument doc = this.getStyledDocument();
        AttributeSet a = this.getInputAttributes().copyAttributes();
        if (doc == null) {
            return;
        }
        int dot = caret.getDot();
        int mark = caret.getMark();
        int p0 = Math.min(dot, mark);
        int p1 = Math.max(dot, mark);
        try {
            if (doc instanceof AbstractDocument) {
                ((AbstractDocument)((Object)doc)).replace(p0, p1 - p0, content, a);
            } else {
                if (dot != mark) {
                    doc.remove(p0, p1 - p0);
                }
                if (content != null && content.length() > 0) {
                    doc.insertString(p0, content, a);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            throw new AssertionError((Object)"No BadLocationException should be thrown here");
        }
    }

    public void insertComponent(Component component) {
        SimpleAttributeSet atts = new SimpleAttributeSet();
        atts.addAttribute(StyleConstants.ComponentAttribute, component);
        atts.addAttribute(StyleConstants.NameAttribute, "component");
        try {
            this.getDocument().insertString(this.getCaret().getDot(), " ", atts);
        }
        catch (BadLocationException ex) {
            AssertionError err = new AssertionError((Object)"Unexpected bad location");
            ((Throwable)((Object)err)).initCause(ex);
            throw err;
        }
    }

    public void insertIcon(Icon icon) {
        MutableAttributeSet inputAtts = this.getInputAttributes();
        inputAtts.removeAttributes(inputAtts);
        StyleConstants.setIcon(inputAtts, icon);
        this.replaceSelection(" ");
        inputAtts.removeAttributes(inputAtts);
    }

    public Style addStyle(String nm, Style parent) {
        return this.getStyledDocument().addStyle(nm, parent);
    }

    public void removeStyle(String nm) {
        this.getStyledDocument().removeStyle(nm);
    }

    public Style getStyle(String nm) {
        return this.getStyledDocument().getStyle(nm);
    }

    public Style getLogicalStyle() {
        return this.getStyledDocument().getLogicalStyle(this.getCaretPosition());
    }

    public void setLogicalStyle(Style style) {
        this.getStyledDocument().setLogicalStyle(this.getCaretPosition(), style);
    }

    public AttributeSet getCharacterAttributes() {
        StyledDocument doc = this.getStyledDocument();
        Element el = doc.getCharacterElement(this.getCaretPosition());
        return el.getAttributes();
    }

    public void setCharacterAttributes(AttributeSet attribute, boolean replace) {
        int dot = this.getCaret().getDot();
        int start = this.getSelectionStart();
        int end = this.getSelectionEnd();
        if (start == dot && end == dot) {
            MutableAttributeSet inputAttributes = this.getStyledEditorKit().getInputAttributes();
            if (replace) {
                inputAttributes.removeAttributes(inputAttributes);
            }
            inputAttributes.addAttributes(attribute);
        } else {
            this.getStyledDocument().setCharacterAttributes(start, end - start, attribute, replace);
        }
    }

    public AttributeSet getParagraphAttributes() {
        StyledDocument doc = this.getStyledDocument();
        Element el = doc.getParagraphElement(this.getCaretPosition());
        return el.getAttributes();
    }

    public void setParagraphAttributes(AttributeSet attribute, boolean replace) {
    }

    public MutableAttributeSet getInputAttributes() {
        return this.getStyledEditorKit().getInputAttributes();
    }

    protected final StyledEditorKit getStyledEditorKit() {
        return (StyledEditorKit)this.getEditorKit();
    }

    protected EditorKit createDefaultEditorKit() {
        return new StyledEditorKit();
    }

    public final void setEditorKit(EditorKit editor) {
        if (!(editor instanceof StyledEditorKit)) {
            throw new IllegalArgumentException("JTextPanes can only handle StyledEditorKits");
        }
        super.setEditorKit(editor);
    }

    protected String paramString() {
        return super.paramString();
    }
}

