/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.callback;

import java.io.Serializable;
import javax.security.auth.callback.Callback;

public class ChoiceCallback
implements Callback,
Serializable {
    private String prompt;
    private String[] choices;
    private int defaultChoice;
    private boolean multipleSelectionsAllowed;
    private int[] selections;

    public ChoiceCallback(String prompt, String[] choices, int defaultChoice, boolean multipleSelectionsAllowed) {
        this.setPrompt(prompt);
        this.setChoices(choices);
        if (defaultChoice < 0 || defaultChoice >= this.choices.length) {
            throw new IllegalArgumentException("default choice is out of bounds");
        }
        this.defaultChoice = defaultChoice;
        this.multipleSelectionsAllowed = multipleSelectionsAllowed;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public String[] getChoices() {
        return this.choices;
    }

    public int getDefaultChoice() {
        return this.defaultChoice;
    }

    public boolean allowMultipleSelections() {
        return this.multipleSelectionsAllowed;
    }

    public void setSelectedIndex(int selection) {
        this.selections = new int[1];
        this.selections[0] = selection;
    }

    public void setSelectedIndexes(int[] selections) {
        if (!this.multipleSelectionsAllowed) {
            throw new UnsupportedOperationException("not allowed");
        }
        this.selections = selections;
    }

    public int[] getSelectedIndexes() {
        return this.selections;
    }

    private void setPrompt(String prompt) throws IllegalArgumentException {
        if (prompt == null || prompt.length() == 0) {
            throw new IllegalArgumentException("invalid prompt");
        }
        this.prompt = prompt;
    }

    private void setChoices(String[] choices) throws IllegalArgumentException {
        if (choices == null || choices.length == 0) {
            throw new IllegalArgumentException("invalid choices");
        }
        int i = 0;
        while (i < choices.length) {
            if (choices[i] == null || choices[i].length() == 0) {
                throw new IllegalArgumentException("invalid choice at index #" + i);
            }
            ++i;
        }
        this.choices = choices;
    }
}

