/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute;

import java.io.Serializable;

public abstract class ResolutionSyntax
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2706743076526672017L;
    public static final int DPCM = 254;
    public static final int DPI = 100;
    private int crossFeedResolution;
    private int feedResolution;

    public ResolutionSyntax(int crossFeedResolution, int feedResolution, int units) {
        if (crossFeedResolution < 1 || feedResolution < 1 || units < 1) {
            throw new IllegalArgumentException("no argument may be less than 1");
        }
        this.crossFeedResolution = crossFeedResolution * units;
        this.feedResolution = feedResolution * units;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ResolutionSyntax)) {
            return false;
        }
        ResolutionSyntax tmp = (ResolutionSyntax)obj;
        return this.crossFeedResolution == tmp.getCrossFeedResolutionDphi() && this.feedResolution == tmp.getFeedResolutionDphi();
    }

    public int getCrossFeedResolution(int units) {
        if (units < 1) {
            throw new IllegalArgumentException("units may not be less then 1");
        }
        return this.crossFeedResolution / units;
    }

    protected int getCrossFeedResolutionDphi() {
        return this.crossFeedResolution;
    }

    public int getFeedResolution(int units) {
        if (units < 1) {
            throw new IllegalArgumentException("units may not be less then 1");
        }
        return this.feedResolution / units;
    }

    protected int getFeedResolutionDphi() {
        return this.feedResolution;
    }

    public int[] getResolution(int units) {
        int[] resolution = new int[]{this.getCrossFeedResolution(units), this.getFeedResolution(units)};
        return resolution;
    }

    public int hashCode() {
        return this.crossFeedResolution + this.feedResolution;
    }

    public boolean lessThanOrEquals(ResolutionSyntax other) {
        if (other == null) {
            throw new NullPointerException("other may not be null");
        }
        return this.crossFeedResolution <= other.getCrossFeedResolutionDphi() && this.feedResolution <= other.getFeedResolutionDphi();
    }

    public String toString() {
        return this.toString(1, "dphi");
    }

    public String toString(int units, String unitsName) {
        if (unitsName == null) {
            return String.valueOf(this.getCrossFeedResolution(units)) + "x" + this.getFeedResolution(units);
        }
        return this.getCrossFeedResolution(units) + "x" + this.getFeedResolution(units) + " " + unitsName;
    }
}

