/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.java.lang.CPStringBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Double
extends Number
implements Comparable<Double> {
    private static final long serialVersionUID = -9172774392245257468L;
    public static final double MAX_VALUE = 1.7976931348623157E308;
    public static final double MIN_VALUE = 4.9E-324;
    public static final double NEGATIVE_INFINITY = -1.0 / 0.0;
    public static final double POSITIVE_INFINITY = 1.0 / 0.0;
    public static final double NaN = 0.0 / 0.0;
    public static final int SIZE = 64;
    public static final Class<Double> TYPE = VMClassLoader.getPrimitiveClass('D');
    private static final Double ZERO = new Double(0.0);
    private static final Double ONE = new Double(1.0);
    private final double value;

    public Double(double value) {
        this.value = value;
    }

    public Double(String s) {
        this.value = Double.parseDouble(s);
    }

    public static String toString(double d) {
        return VMDouble.toString(d, false);
    }

    public static String toHexString(double d) {
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (Double.isInfinite(d)) {
            return d < 0.0 ? "-Infinity" : "Infinity";
        }
        long bits = Double.doubleToLongBits(d);
        CPStringBuilder result = new CPStringBuilder();
        if (bits < 0L) {
            result.append('-');
        }
        result.append("0x");
        long mantMask = 0xFFFFFFFFFFFFFL;
        long mantissa = bits & mantMask;
        long expMask = 2047L;
        long exponent = bits >>> 52 & expMask;
        result.append(exponent == 0L ? (char)'0' : '1');
        result.append('.');
        result.append(Long.toHexString(mantissa));
        if (exponent == 0L && mantissa != 0L) {
            int offset = 4 + (bits < 0L ? 1 : 0);
            int desiredLength = offset + 13;
            while (result.length() < desiredLength) {
                result.insert(offset, '0');
            }
        }
        result.append('p');
        if (exponent != 0L || mantissa != 0L) {
            boolean denormal = exponent == 0L;
            exponent -= 1023L;
            if (denormal) {
                ++exponent;
            }
        }
        result.append(Long.toString(exponent));
        return result.toString();
    }

    public static Double valueOf(double val) {
        if (val == 0.0 && Double.doubleToRawLongBits(val) == 0L) {
            return ZERO;
        }
        if (val == 1.0) {
            return ONE;
        }
        return new Double(val);
    }

    public static Double valueOf(String s) {
        return Double.parseDouble(s);
    }

    public static double parseDouble(String str) {
        return VMDouble.parseDouble(str);
    }

    public static boolean isNaN(double v) {
        return v != v;
    }

    public static boolean isInfinite(double v) {
        return v == Double.POSITIVE_INFINITY || v == Double.NEGATIVE_INFINITY;
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        long v = Double.doubleToLongBits(this.value);
        return (int)(v ^ v >>> 32);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Double) {
            double d = ((Double)obj).value;
            return Double.doubleToRawLongBits(this.value) == Double.doubleToRawLongBits(d) || Double.isNaN(this.value) && Double.isNaN(d);
        }
        return false;
    }

    public static long doubleToLongBits(double value) {
        if (Double.isNaN(value)) {
            return 9221120237041090560L;
        }
        return VMDouble.doubleToRawLongBits(value);
    }

    public static long doubleToRawLongBits(double value) {
        return VMDouble.doubleToRawLongBits(value);
    }

    public static double longBitsToDouble(long bits) {
        return VMDouble.longBitsToDouble(bits);
    }

    @Override
    public int compareTo(Double d) {
        return Double.compare(this.value, d.value);
    }

    public static int compare(double x, double y) {
        long ly;
        if (x < y) {
            return -1;
        }
        if (x > y) {
            return 1;
        }
        long lx = Double.doubleToRawLongBits(x);
        if (lx == (ly = Double.doubleToRawLongBits(y))) {
            return 0;
        }
        if (x != x) {
            return y != y ? 0 : 1;
        }
        if (y != y) {
            return -1;
        }
        return lx < ly ? -1 : 1;
    }
}

