/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.stream;

import gnu.xml.stream.XMLEventImpl;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartDocument;

public class StartDocumentImpl
extends XMLEventImpl
implements StartDocument {
    protected final String systemId;
    protected final String encoding;
    protected final String xmlVersion;
    protected final boolean xmlStandalone;
    protected final boolean standaloneDeclared;
    protected final boolean encodingDeclared;

    protected StartDocumentImpl(Location location, String systemId, String encoding, String xmlVersion, boolean xmlStandalone, boolean standaloneDeclared, boolean encodingDeclared) {
        super(location);
        this.systemId = systemId;
        this.encoding = encoding;
        this.xmlVersion = xmlVersion;
        this.xmlStandalone = xmlStandalone;
        this.standaloneDeclared = standaloneDeclared;
        this.encodingDeclared = encodingDeclared;
    }

    public int getEventType() {
        return 7;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getCharacterEncodingScheme() {
        return this.encoding;
    }

    public boolean encodingSet() {
        return this.encodingDeclared;
    }

    public boolean isStandalone() {
        return this.xmlStandalone;
    }

    public boolean standaloneSet() {
        return this.standaloneDeclared;
    }

    public String getVersion() {
        return this.xmlVersion;
    }

    public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
        try {
            writer.write("<?xml version='");
            writer.write(this.xmlVersion);
            writer.write(39);
            if (this.standaloneDeclared) {
                writer.write(" standalone='");
                writer.write(this.xmlStandalone ? "yes" : "no");
                writer.write(39);
            }
            if (this.encodingDeclared) {
                writer.write(" encoding='");
                writer.write(this.encoding);
                writer.write(39);
            }
            writer.write("?>");
        }
        catch (IOException e) {
            XMLStreamException e2 = new XMLStreamException(e.getMessage());
            e2.initCause(e);
            throw e2;
        }
    }
}

