/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.swing.text.html;

import java.awt.Color;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;

public class CharacterAttributeTranslator {
    private static final HashMap colorMap = new HashMap();

    static {
        colorMap.put("aqua", "#00FFFF");
        colorMap.put("blue", "#0000FF");
        colorMap.put("black", "#000000");
        colorMap.put("fuchsia", "#FF00FF");
        colorMap.put("gray", "#808080");
        colorMap.put("green", "#008000");
        colorMap.put("lime", "#00FF00");
        colorMap.put("maroon", "#800000");
        colorMap.put("navy", "#000080");
        colorMap.put("olive", "#808000");
        colorMap.put("purple", "#800080");
        colorMap.put("red", "#FF0000");
        colorMap.put("silver", "#C0C0C0");
        colorMap.put("teal", "#008080");
        colorMap.put("white", "#FFFFFF");
        colorMap.put("yellow", "#FFFF00");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Color getColor(String colorName) {
        colorName = colorName.toLowerCase();
        try {
            if (colorName.startsWith("rgb")) {
                StringTokenizer st = new StringTokenizer(colorName, " ,()");
                String representation = st.nextToken();
                if (!representation.equals("rgb")) {
                    return null;
                }
                int red = Integer.parseInt(st.nextToken());
                int green = Integer.parseInt(st.nextToken());
                int blue = Integer.parseInt(st.nextToken());
                return new Color(red, green, blue);
            }
            String s2 = (String)colorMap.get(colorName);
            if (s2 == null) {
                s2 = colorName;
            }
            return Color.decode(s2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean translateTag(MutableAttributeSet charAttr, HTML.Tag t, MutableAttributeSet a) {
        if (t == HTML.Tag.FONT) {
            Object color = a.getAttribute(HTML.Attribute.COLOR);
            if (color != null) {
                Color c = CharacterAttributeTranslator.getColor(color.toString());
                if (c == null) {
                    return false;
                }
                charAttr.addAttribute(StyleConstants.Foreground, c);
                return true;
            }
            if (a.getAttribute(HTML.Attribute.SIZE) != null) {
                return true;
            }
        }
        if (t == HTML.Tag.B) {
            charAttr.addAttribute(StyleConstants.Bold, Boolean.TRUE);
            return true;
        }
        if (t == HTML.Tag.I) {
            charAttr.addAttribute(StyleConstants.Italic, Boolean.TRUE);
            return true;
        }
        if (t == HTML.Tag.U) {
            charAttr.addAttribute(StyleConstants.Underline, Boolean.TRUE);
            return true;
        }
        if (t == HTML.Tag.STRIKE) {
            charAttr.addAttribute(StyleConstants.StrikeThrough, Boolean.TRUE);
            return true;
        }
        if (t == HTML.Tag.SUP) {
            charAttr.addAttribute(StyleConstants.Superscript, Boolean.TRUE);
            return true;
        }
        if (t == HTML.Tag.SUB) {
            charAttr.addAttribute(StyleConstants.Subscript, Boolean.TRUE);
            return true;
        }
        return false;
    }
}

