/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.classpath.debug.Component;
import gnu.classpath.debug.SystemLogger;
import gnu.javax.net.ssl.provider.SSLContextImpl;
import gnu.javax.net.ssl.provider.SSLEngineImpl;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

public class SSLSocketImpl
extends SSLSocket {
    private static final SystemLogger logger = SystemLogger.getSystemLogger();
    private SSLEngineImpl engine;
    private Set<HandshakeCompletedListener> listeners;
    private Socket underlyingSocket;
    private boolean isHandshaking;
    private IOException handshakeException;
    private boolean initialHandshakeDone = false;
    private final boolean autoClose;

    public SSLSocketImpl(SSLContextImpl contextImpl, String host, int port) {
        this(contextImpl, host, port, new Socket(), true);
    }

    public SSLSocketImpl(SSLContextImpl contextImpl, String host, int port, Socket underlyingSocket, boolean autoClose) {
        this.engine = new SSLEngineImpl(contextImpl, host, port);
        this.engine.setUseClientMode(true);
        this.listeners = new HashSet<HandshakeCompletedListener>();
        this.underlyingSocket = underlyingSocket;
        this.autoClose = autoClose;
    }

    public void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
        this.listeners.add(listener);
    }

    public boolean getEnableSessionCreation() {
        return this.engine.getEnableSessionCreation();
    }

    public String[] getEnabledCipherSuites() {
        return this.engine.getEnabledCipherSuites();
    }

    public String[] getEnabledProtocols() {
        return this.engine.getEnabledProtocols();
    }

    public boolean getNeedClientAuth() {
        return this.engine.getNeedClientAuth();
    }

    public SSLSession getSession() {
        return this.engine.getSession();
    }

    public String[] getSupportedCipherSuites() {
        return this.engine.getSupportedCipherSuites();
    }

    public String[] getSupportedProtocols() {
        return this.engine.getSupportedProtocols();
    }

    public boolean getUseClientMode() {
        return this.engine.getUseClientMode();
    }

    public boolean getWantClientAuth() {
        return this.engine.getWantClientAuth();
    }

    public void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
        this.listeners.remove(listener);
    }

    public void setEnableSessionCreation(boolean enable) {
        this.engine.setEnableSessionCreation(enable);
    }

    public void setEnabledCipherSuites(String[] suites) {
        this.engine.setEnabledCipherSuites(suites);
    }

    public void setEnabledProtocols(String[] protocols) {
        this.engine.setEnabledProtocols(protocols);
    }

    public void setNeedClientAuth(boolean needAuth) {
        this.engine.setNeedClientAuth(needAuth);
    }

    public void setUseClientMode(boolean clientMode) {
        this.engine.setUseClientMode(clientMode);
    }

    public void setWantClientAuth(boolean wantAuth) {
        this.engine.setWantClientAuth(wantAuth);
    }

    public void startHandshake() throws IOException {
        if (this.isHandshaking) {
            return;
        }
        if (this.handshakeException != null) {
            throw this.handshakeException;
        }
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    SSLSocketImpl.this.doHandshake();
                }
                catch (IOException ioe) {
                    SSLSocketImpl.this.handshakeException = ioe;
                }
            }
        }, "HandshakeThread@" + System.identityHashCode(this));
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doHandshake() throws IOException {
        SSLEngineImpl sSLEngineImpl = this.engine;
        synchronized (sSLEngineImpl) {
            if (this.isHandshaking) {
                try {
                    this.engine.wait();
                }
                catch (InterruptedException interruptedException) {}
                return;
            }
            this.isHandshaking = true;
        }
        if (this.initialHandshakeDone) {
            throw new SSLException("rehandshaking not yet implemented");
        }
        long now = -System.currentTimeMillis();
        this.engine.beginHandshake();
        SSLEngineResult.HandshakeStatus status = this.engine.getHandshakeStatus();
        assert (status != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING);
        ByteBuffer inBuffer = ByteBuffer.wrap(new byte[this.getSession().getPacketBufferSize()]);
        inBuffer.position(inBuffer.limit());
        ByteBuffer outBuffer = ByteBuffer.wrap(new byte[this.getSession().getPacketBufferSize()]);
        ByteBuffer emptyBuffer = ByteBuffer.allocate(0);
        SSLEngineResult result = null;
        DataInputStream sockIn = new DataInputStream(this.underlyingSocket.getInputStream());
        OutputStream sockOut = this.underlyingSocket.getOutputStream();
        try {
            try {
                while (status != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING && status != SSLEngineResult.HandshakeStatus.FINISHED) {
                    logger.logv(Component.SSL_HANDSHAKE, "socket processing state {0}", new Object[]{status});
                    if (inBuffer.capacity() != this.getSession().getPacketBufferSize()) {
                        ByteBuffer b = ByteBuffer.wrap(new byte[this.getSession().getPacketBufferSize()]);
                        if (inBuffer.hasRemaining()) {
                            b.put(inBuffer).flip();
                        }
                        inBuffer = b;
                    }
                    if (outBuffer.capacity() != this.getSession().getPacketBufferSize()) {
                        outBuffer = ByteBuffer.wrap(new byte[this.getSession().getPacketBufferSize()]);
                    }
                    switch (status) {
                        case NEED_UNWRAP: {
                            inBuffer.clear();
                            int i = sockIn.read();
                            if (i == -1) {
                                throw new EOFException();
                            }
                            if ((i & 0x80) == 128) {
                                inBuffer.put((byte)i);
                                int v2len = (i & 0x7F) << 8;
                                i = sockIn.read();
                                inBuffer.put((byte)i);
                                sockIn.readFully(inBuffer.array(), 2, v2len |= i & 0xFF);
                                inBuffer.position(0).limit(v2len + 2);
                            } else {
                                inBuffer.put((byte)i);
                                inBuffer.putInt(sockIn.readInt());
                                int reclen = inBuffer.getShort(3) & 0xFFFF;
                                sockIn.readFully(inBuffer.array(), 5, reclen);
                                inBuffer.position(0).limit(reclen + 5);
                            }
                            result = this.engine.unwrap(inBuffer, emptyBuffer);
                            status = result.getHandshakeStatus();
                            if (result.getStatus() == SSLEngineResult.Status.OK) break;
                            throw new SSLException("unexpected SSL status " + (Object)((Object)result.getStatus()));
                        }
                        case NEED_WRAP: {
                            outBuffer.clear();
                            result = this.engine.wrap(emptyBuffer, outBuffer);
                            status = result.getHandshakeStatus();
                            if (result.getStatus() != SSLEngineResult.Status.OK) {
                                throw new SSLException("unexpected SSL status " + (Object)((Object)result.getStatus()));
                            }
                            outBuffer.flip();
                            sockOut.write(outBuffer.array(), outBuffer.position(), outBuffer.limit());
                            break;
                        }
                        case NEED_TASK: {
                            Runnable task;
                            while ((task = this.engine.getDelegatedTask()) != null) {
                                task.run();
                            }
                            status = this.engine.getHandshakeStatus();
                            break;
                        }
                    }
                }
                this.initialHandshakeDone = true;
                HandshakeCompletedEvent hce = new HandshakeCompletedEvent(this, this.getSession());
                for (HandshakeCompletedListener l : this.listeners) {
                    try {
                        l.handshakeCompleted(hce);
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable x) {
                        logger.log(Component.WARNING, "HandshakeCompletedListener threw exception", x);
                    }
                }
                logger.logv(Component.SSL_HANDSHAKE, "handshake completed in {0}ms in thread {1}", now += System.currentTimeMillis(), Thread.currentThread().getName());
            }
            catch (SSLException ssle) {
                this.handshakeException = ssle;
                throw ssle;
            }
        }
        catch (Throwable throwable) {
            SSLEngineImpl sSLEngineImpl2 = this.engine;
            synchronized (sSLEngineImpl2) {
                this.isHandshaking = false;
                this.engine.notifyAll();
            }
            throw throwable;
        }
        SSLEngineImpl sSLEngineImpl3 = this.engine;
        synchronized (sSLEngineImpl3) {
            this.isHandshaking = false;
            this.engine.notifyAll();
        }
    }

    public void bind(SocketAddress bindpoint) throws IOException {
        this.underlyingSocket.bind(bindpoint);
    }

    public void connect(SocketAddress endpoint) throws IOException {
        this.underlyingSocket.connect(endpoint);
    }

    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        this.underlyingSocket.connect(endpoint, timeout);
    }

    public InetAddress getInetAddress() {
        return this.underlyingSocket.getInetAddress();
    }

    public InetAddress getLocalAddress() {
        return this.underlyingSocket.getLocalAddress();
    }

    public int getPort() {
        return this.underlyingSocket.getPort();
    }

    public int getLocalPort() {
        return this.underlyingSocket.getLocalPort();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.underlyingSocket.getRemoteSocketAddress();
    }

    public SocketAddress getLocalSocketAddress() {
        return this.underlyingSocket.getLocalSocketAddress();
    }

    public SocketChannel getChannel() {
        throw new UnsupportedOperationException("use javax.net.ssl.SSLEngine for NIO");
    }

    public InputStream getInputStream() throws IOException {
        return new SocketInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        return new SocketOutputStream();
    }

    public void setTcpNoDelay(boolean on) throws SocketException {
        this.underlyingSocket.setTcpNoDelay(on);
    }

    public boolean getTcpNoDelay() throws SocketException {
        return this.underlyingSocket.getTcpNoDelay();
    }

    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.underlyingSocket.setSoLinger(on, linger);
    }

    public int getSoLinger() throws SocketException {
        return this.underlyingSocket.getSoLinger();
    }

    public void sendUrgentData(int x) throws IOException {
        throw new UnsupportedOperationException("not supported");
    }

    public void setOOBInline(boolean on) throws SocketException {
        this.underlyingSocket.setOOBInline(on);
    }

    public boolean getOOBInline() throws SocketException {
        return this.underlyingSocket.getOOBInline();
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.underlyingSocket.setSoTimeout(timeout);
    }

    public int getSoTimeout() throws SocketException {
        return this.underlyingSocket.getSoTimeout();
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.underlyingSocket.setSendBufferSize(size);
    }

    public int getSendBufferSize() throws SocketException {
        return this.underlyingSocket.getSendBufferSize();
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.underlyingSocket.setReceiveBufferSize(size);
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.underlyingSocket.getReceiveBufferSize();
    }

    public void setKeepAlive(boolean on) throws SocketException {
        this.underlyingSocket.setKeepAlive(on);
    }

    public boolean getKeepAlive() throws SocketException {
        return this.underlyingSocket.getKeepAlive();
    }

    public void setTrafficClass(int tc) throws SocketException {
        this.underlyingSocket.setTrafficClass(tc);
    }

    public int getTrafficClass() throws SocketException {
        return this.underlyingSocket.getTrafficClass();
    }

    public void setReuseAddress(boolean reuseAddress) throws SocketException {
        this.underlyingSocket.setReuseAddress(reuseAddress);
    }

    public boolean getReuseAddress() throws SocketException {
        return this.underlyingSocket.getReuseAddress();
    }

    public void close() throws IOException {
        if (this.autoClose) {
            this.underlyingSocket.close();
        }
    }

    public void shutdownInput() throws IOException {
        this.underlyingSocket.shutdownInput();
    }

    public void shutdownOutput() throws IOException {
        this.underlyingSocket.shutdownOutput();
    }

    public boolean isConnected() {
        return this.underlyingSocket.isConnected();
    }

    public boolean isBound() {
        return this.underlyingSocket.isBound();
    }

    public boolean isClosed() {
        return this.underlyingSocket.isClosed();
    }

    public boolean isInputShutdown() {
        return this.underlyingSocket.isInputShutdown();
    }

    public boolean isOutputShutdown() {
        return this.underlyingSocket.isOutputShutdown();
    }

    private class SocketInputStream
    extends InputStream {
        private final ByteBuffer inBuffer;
        private final ByteBuffer appBuffer;
        private final DataInputStream in;

        SocketInputStream() throws IOException {
            this.inBuffer = ByteBuffer.wrap(new byte[SSLSocketImpl.this.getSession().getPacketBufferSize()]);
            this.inBuffer.limit(0);
            this.appBuffer = ByteBuffer.allocate(SSLSocketImpl.this.getSession().getApplicationBufferSize());
            this.appBuffer.flip();
            this.in = SSLSocketImpl.this.underlyingSocket != null ? new DataInputStream(SSLSocketImpl.this.underlyingSocket.getInputStream()) : new DataInputStream(SSLSocketImpl.super.getInputStream());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int read(byte[] buf, int off, int len) throws IOException {
            if (!SSLSocketImpl.this.initialHandshakeDone || SSLSocketImpl.this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                SSLSocketImpl.this.doHandshake();
                if (SSLSocketImpl.this.handshakeException != null) {
                    throw SSLSocketImpl.this.handshakeException;
                }
            }
            if (!this.appBuffer.hasRemaining()) {
                int x = this.in.read();
                if (x == -1) {
                    return -1;
                }
                this.inBuffer.clear();
                this.inBuffer.put((byte)x);
                this.inBuffer.putInt(this.in.readInt());
                int reclen = this.inBuffer.getShort(3) & 0xFFFF;
                this.in.readFully(this.inBuffer.array(), 5, reclen);
                this.inBuffer.position(0).limit(reclen + 5);
                SSLEngineImpl sSLEngineImpl = SSLSocketImpl.this.engine;
                synchronized (sSLEngineImpl) {
                    this.appBuffer.clear();
                    SSLEngineResult result = SSLSocketImpl.this.engine.unwrap(this.inBuffer, this.appBuffer);
                    SSLEngineResult.Status status = result.getStatus();
                    if (status == SSLEngineResult.Status.CLOSED && result.bytesProduced() == 0) {
                        return -1;
                    }
                }
                this.inBuffer.compact();
                this.appBuffer.flip();
            }
            int l = Math.min(len, this.appBuffer.remaining());
            this.appBuffer.get(buf, off, l);
            return l;
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            if (this.read(b) == -1) {
                return -1;
            }
            return b[0] & 0xFF;
        }
    }

    private class SocketOutputStream
    extends OutputStream {
        private final ByteBuffer buffer;
        private final OutputStream out;

        SocketOutputStream() throws IOException {
            this.buffer = ByteBuffer.wrap(new byte[SSLSocketImpl.this.getSession().getPacketBufferSize()]);
            this.out = SSLSocketImpl.this.underlyingSocket != null ? SSLSocketImpl.this.underlyingSocket.getOutputStream() : SSLSocketImpl.super.getOutputStream();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] buf, int off, int len) throws IOException {
            SSLEngineResult result;
            if (!SSLSocketImpl.this.initialHandshakeDone || SSLSocketImpl.this.engine.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
                SSLSocketImpl.this.doHandshake();
                if (SSLSocketImpl.this.handshakeException != null) {
                    throw SSLSocketImpl.this.handshakeException;
                }
            }
            for (int k = 0; k < len; k += result.bytesConsumed()) {
                SSLEngineImpl sSLEngineImpl = SSLSocketImpl.this.engine;
                synchronized (sSLEngineImpl) {
                    int l = Math.min(len - k, SSLSocketImpl.this.getSession().getApplicationBufferSize());
                    ByteBuffer in = ByteBuffer.wrap(buf, off + k, l);
                    result = SSLSocketImpl.this.engine.wrap(in, this.buffer);
                    if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                        return;
                    }
                    if (result.getStatus() != SSLEngineResult.Status.OK) {
                        throw new SSLException("unexpected SSL state " + (Object)((Object)result.getStatus()));
                    }
                    this.buffer.flip();
                    this.out.write(this.buffer.array(), 0, this.buffer.limit());
                    this.buffer.clear();
                    continue;
                }
            }
        }

        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }

        public void close() throws IOException {
            SSLSocketImpl.this.close();
        }
    }
}

