/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Builder;
import gnu.javax.net.ssl.provider.CertificateRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateRequestBuilder
extends CertificateRequest
implements Builder {
    public CertificateRequestBuilder() {
        super(ByteBuffer.allocate(1024));
    }

    @Override
    public ByteBuffer buffer() {
        return ((ByteBuffer)this.buffer.duplicate().limit(this.length())).slice();
    }

    public void setTypes(List<CertificateRequest.ClientCertificateType> types) {
        this.ensureCapacity(types.size() + 3);
        this.buffer.put(0, (byte)types.size());
        ByteBuffer b = (ByteBuffer)this.buffer.duplicate().position(1);
        for (CertificateRequest.ClientCertificateType type : types) {
            b.put((byte)type.getValue());
        }
    }

    public void setAuthorities(List<X500Principal> authorities) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        for (X500Principal auth : authorities) {
            byte[] encoded = auth.getEncoded();
            out.write(encoded.length >>> 8 & 0xFF);
            out.write(encoded.length & 0xFF);
            try {
                out.write(encoded);
            }
            catch (IOException iOException) {}
        }
        byte[] auths = out.toByteArray();
        int typesLen = 1 + (this.buffer.get(0) & 0xFF);
        int len = typesLen + auths.length + 2;
        this.ensureCapacity(len);
        this.buffer.putShort(typesLen, (short)auths.length);
        ((ByteBuffer)this.buffer.duplicate().position(typesLen + 2)).put(auths);
    }

    public void ensureCapacity(int capacity) {
        if (this.buffer.capacity() >= capacity) {
            return;
        }
        ByteBuffer newBuffer = ByteBuffer.allocate(capacity);
        newBuffer.duplicate().put(this.buffer);
        this.buffer = newBuffer;
    }
}

