/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.util.regex;

import gnu.java.lang.CPStringBuilder;
import gnu.java.util.regex.CharIndexed;
import gnu.java.util.regex.REMatch;
import gnu.java.util.regex.REToken;

class RETokenStart
extends REToken {
    private String newline;
    private boolean check_java_line_terminators;

    RETokenStart(int subIndex, String newline) {
        super(subIndex);
        this.newline = newline;
        this.check_java_line_terminators = false;
    }

    RETokenStart(int subIndex, String newline, boolean b) {
        super(subIndex);
        this.newline = newline;
        this.check_java_line_terminators = b;
    }

    int getMaximumLength() {
        return 0;
    }

    REMatch matchThis(CharIndexed input, REMatch mymatch) {
        int len;
        char ch;
        if (this.check_java_line_terminators && (ch = input.charAt(mymatch.index - 1)) != '\uffff') {
            if (ch == '\n') {
                return mymatch;
            }
            if (ch == '\r') {
                char ch1 = input.charAt(mymatch.index);
                if (ch1 != '\n') {
                    return mymatch;
                }
                return null;
            }
            if (ch == '\u0085') {
                return mymatch;
            }
            if (ch == '\u2028') {
                return mymatch;
            }
            if (ch == '\u2029') {
                return mymatch;
            }
        }
        if (this.newline != null && mymatch.offset >= (len = this.newline.length())) {
            boolean found = true;
            int i = 0;
            char ch2 = input.charAt(mymatch.index - len);
            do {
                char z;
                if (ch2 != (z = this.newline.charAt(i))) {
                    found = false;
                    break;
                }
                ch2 = input.charAt(mymatch.index - len + ++i);
            } while (i < len);
            if (found) {
                return mymatch;
            }
        }
        if ((mymatch.eflags & 0x10) > 0) {
            return null;
        }
        if ((mymatch.eflags & 0x40) > 0) {
            return mymatch.anchor == mymatch.offset ? mymatch : null;
        }
        return mymatch.index == 0 && mymatch.offset == 0 ? mymatch : null;
    }

    boolean returnsFixedLengthMatches() {
        return true;
    }

    int findFixedLengthMatches(CharIndexed input, REMatch mymatch, int max) {
        if (this.matchThis(input, mymatch) != null) {
            return max;
        }
        return 0;
    }

    void dump(CPStringBuilder os) {
        os.append('^');
    }
}

