/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.qt;

import gnu.java.awt.peer.qt.QtFontPeer;
import gnu.java.awt.peer.qt.QtGraphics;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;

public class QtFontMetrics
extends FontMetrics {
    private long nativeObject;
    private QtFontPeer peer;

    public QtFontMetrics(Font f) {
        super(f);
        if (f.getPeer() == null || !(f.getPeer() instanceof QtFontPeer)) {
            throw new IllegalArgumentException("Invalid Font object.");
        }
        this.peer = (QtFontPeer)f.getPeer();
        this.init(this.peer);
    }

    public QtFontMetrics(Font f, Graphics g) {
        super(f);
        if (f.getPeer() == null || !(f.getPeer() instanceof QtFontPeer)) {
            throw new IllegalArgumentException("Invalid Font object.");
        }
        if (!(g instanceof QtGraphics)) {
            throw new IllegalArgumentException("Invalid graphics object.");
        }
        this.peer = (QtFontPeer)f.getPeer();
        this.initGraphics(this.peer, (QtGraphics)g);
    }

    QtFontMetrics(QtFontPeer f, Graphics g) {
        super(null);
        if (!(g instanceof QtGraphics)) {
            throw new IllegalArgumentException("Invalid graphics object.");
        }
        this.peer = f;
        this.initGraphics(this.peer, (QtGraphics)g);
    }

    public QtFontMetrics(QtFontPeer fp) {
        super(null);
        this.peer = fp;
        this.init(this.peer);
    }

    private native void init(QtFontPeer var1);

    private native void initGraphics(QtFontPeer var1, QtGraphics var2);

    private native void dispose();

    native Rectangle2D getStringBounds(String var1);

    native boolean canDisplay(int var1);

    public native int getAscent();

    public native int getDescent();

    public native int getHeight();

    public native int getLeading();

    public native int getMaxAdvance();

    public native int charWidth(char var1);

    public int charsWidth(char[] chars, int off, int len) {
        return this.stringWidth(new String(chars, off, len));
    }

    public native int stringWidth(String var1);

    public Rectangle2D getStringBounds(String str, Graphics context) {
        QtFontMetrics fm = new QtFontMetrics(this.peer, context);
        return fm.getStringBounds(str);
    }
}

