/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.gjdoc.expr;

import gnu.classpath.tools.gjdoc.expr.BinaryComputationExpression;
import gnu.classpath.tools.gjdoc.expr.ConstantExpression;
import gnu.classpath.tools.gjdoc.expr.ConstantString;
import gnu.classpath.tools.gjdoc.expr.Context;
import gnu.classpath.tools.gjdoc.expr.Expression;
import gnu.classpath.tools.gjdoc.expr.IllegalExpressionException;
import gnu.classpath.tools.gjdoc.expr.Type;

class AdditionExpression
extends BinaryComputationExpression {
    public AdditionExpression(Expression left, Expression right) {
        super(left, right);
    }

    protected double compute(double leftValue, double rightValue) {
        return leftValue + rightValue;
    }

    protected float compute(float leftValue, float rightValue) {
        return leftValue + rightValue;
    }

    protected long compute(long leftValue, long rightValue) {
        return leftValue + rightValue;
    }

    protected int compute(int leftValue, int rightValue) {
        return leftValue + rightValue;
    }

    public ConstantExpression evaluate(Context context) throws IllegalExpressionException {
        ConstantExpression leftValue = this.left.evaluate(context);
        ConstantExpression rightValue = this.right.evaluate(context);
        if (Type.STRING == leftValue.getType() || Type.STRING == rightValue.getType()) {
            return new ConstantString(String.valueOf(leftValue.asObject().toString()) + rightValue.asObject().toString());
        }
        return super.evaluate(leftValue, rightValue);
    }
}

