/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.gjdoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.Tag;
import gnu.classpath.tools.gjdoc.AbstractTagImpl;
import gnu.classpath.tools.gjdoc.ClassDocImpl;
import gnu.classpath.tools.gjdoc.Main;
import gnu.classpath.tools.gjdoc.TextTagImpl;

public class SeeTagImpl
extends AbstractTagImpl
implements SeeTag {
    protected String reference;
    private String referencedClassName;
    private String referencedMemberName;
    private ClassDoc referencedClass;
    private MemberDoc referencedMember;
    private PackageDoc referencedPackage;
    private String label;
    private ClassDocImpl contextClass;

    public SeeTagImpl(String text, ClassDocImpl contextClass) {
        super(text);
        this.contextClass = contextClass;
    }

    public void resolve() {
        String referencedFqName;
        super.resolve();
        this.text = this.text.trim();
        if (this.text.startsWith("<") || this.text.startsWith("\"")) {
            this.label = this.text;
            return;
        }
        int labelNdx = this.text.indexOf(59);
        if (labelNdx >= 0) {
            this.label = "";
            return;
        }
        int i = 0;
        while (i < this.text.length()) {
            if (" \t\r\n".indexOf(this.text.charAt(i)) >= 0) {
                labelNdx = i;
                break;
            }
            ++i;
        }
        int openParenNdx = this.text.indexOf(40);
        if (openParenNdx >= 0 && openParenNdx < labelNdx && (labelNdx = this.text.indexOf(41, openParenNdx)) >= 0) {
            ++labelNdx;
        }
        if (labelNdx < 0 || labelNdx >= this.text.length()) {
            this.reference = this.text.trim();
            this.label = "";
        } else {
            this.reference = this.text.substring(0, labelNdx).trim();
            this.label = this.text.substring(labelNdx).trim();
        }
        int mspecNdx = this.reference.indexOf(35);
        if (mspecNdx < 0) {
            referencedFqName = this.reference;
        } else {
            referencedFqName = this.reference.substring(0, mspecNdx);
            this.referencedMemberName = this.reference.substring(mspecNdx + 1);
        }
        if (referencedFqName.trim().length() > 0) {
            this.referencedClassName = referencedFqName;
            this.referencedClass = this.contextClass == null ? Main.getRootDoc().classNamed(referencedFqName) : this.contextClass.findClass(referencedFqName);
        } else {
            this.referencedClassName = "";
            this.referencedClass = this.contextClass;
        }
        if (this.referencedClass == null) {
            this.referencedClass = Main.getRootDoc().classNamed("java.lang." + referencedFqName);
        }
        if (this.referencedClass != null && !this.referencedClass.isIncluded()) {
            this.referencedClass = null;
        }
        if (this.referencedClass != null) {
            this.referencedPackage = this.referencedClass.containingPackage();
            this.referencedClassName = this.referencedClass.qualifiedName();
            if (this.referencedMemberName != null) {
                if (this.referencedMemberName.indexOf(40) < 0) {
                    this.referencedMember = ((ClassDocImpl)this.referencedClass).findFieldRec(this.referencedMemberName);
                    if (this.referencedMember == null) {
                        MethodDoc[] methods = ((ClassDocImpl)this.referencedClass).methods();
                        int i2 = 0;
                        while (i2 < methods.length) {
                            if (methods[i2].name().equals(this.referencedMemberName)) {
                                if (this.referencedMember != null) {
                                    this.referencedClass = null;
                                    this.referencedMember = null;
                                    break;
                                }
                                this.referencedMember = methods[i2];
                            }
                            ++i2;
                        }
                    } else {
                        this.referencedClass = this.referencedMember.containingClass();
                    }
                } else {
                    this.referencedMember = ((ClassDocImpl)this.referencedClass).findExecutableRec(this.referencedMemberName);
                    if (this.referencedMember == null) {
                        this.referencedClass = null;
                    }
                }
            }
        }
    }

    public ClassDoc referencedClass() {
        return this.referencedClass;
    }

    public String referencedClassName() {
        return this.referencedClassName;
    }

    public MemberDoc referencedMember() {
        return this.referencedMember;
    }

    public String referencedMemberName() {
        return this.referencedMemberName;
    }

    public PackageDoc referencedPackage() {
        return this.referencedPackage;
    }

    public String label() {
        return this.label;
    }

    public String kind() {
        return "@see";
    }

    public String name() {
        return "@see";
    }

    public Tag[] firstSentenceTags() {
        return this.inlineTags();
    }

    public Tag[] inlineTags() {
        return new Tag[]{new TextTagImpl(this.referencedClassName)};
    }
}

