/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class SelfEncapsulateFieldAction
extends SelectionDispatchAction {
    private CompilationUnitEditor fEditor;

    public SelfEncapsulateFieldAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.SelfEncapsulateFieldAction_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.self_encapsulate_action");
    }

    public SelfEncapsulateFieldAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isSelfEncapsulateAvailable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        try {
            IJavaElement[] elements = SelectionConverter.codeResolve(this.fEditor);
            if (elements.length != 1 || !(elements[0] instanceof IField)) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.SelfEncapsulateFieldAction_dialog_title, (String)ActionMessages.SelfEncapsulateFieldAction_dialog_unavailable);
                return;
            }
            IField field = (IField)elements[0];
            if (!RefactoringAvailabilityTester.isSelfEncapsulateAvailable(field)) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.SelfEncapsulateFieldAction_dialog_title, (String)ActionMessages.SelfEncapsulateFieldAction_dialog_unavailable);
                return;
            }
            this.run(field);
        }
        catch (JavaModelException exception) {
            JavaPlugin.log(exception);
            return;
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isSelfEncapsulateAvailable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection selection) {
        try {
            if (RefactoringAvailabilityTester.isSelfEncapsulateAvailable(selection)) {
                this.run((IField)selection.getFirstElement());
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    public void run(IField field) {
        RefactoringExecutionStarter.startSelfEncapsulateRefactoring(field, this.getShell());
    }
}

