/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom.fragments;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.internal.corext.dom.JdtASTMatcher;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTMatchingFragmentFinder;
import org.eclipse.jdt.internal.corext.dom.fragments.IASTFragment;

class SimpleFragment
extends ASTFragment {
    private ASTNode fNode;

    SimpleFragment(ASTNode node) {
        this.fNode = node;
    }

    public IASTFragment[] getMatchingFragmentsWithNode(ASTNode node) {
        if (!JdtASTMatcher.doNodesMatch(this.getAssociatedNode(), node)) {
            return new IASTFragment[0];
        }
        IASTFragment match = ASTFragmentFactory.createFragmentForFullSubtree(node);
        Assert.isTrue((match.matches(this) || this.matches(match) ? 1 : 0) != 0);
        return new IASTFragment[]{match};
    }

    public boolean matches(IASTFragment other) {
        Assert.isNotNull((Object)other);
        return other.getClass().equals(this.getClass()) && JdtASTMatcher.doNodesMatch(other.getAssociatedNode(), this.getAssociatedNode());
    }

    public IASTFragment[] getSubFragmentsMatching(IASTFragment toMatch) {
        return ASTMatchingFragmentFinder.findMatchingFragments(this.getAssociatedNode(), (ASTFragment)toMatch);
    }

    public int getStartPosition() {
        return this.fNode.getStartPosition();
    }

    public int getLength() {
        return this.fNode.getLength();
    }

    public ASTNode getAssociatedNode() {
        Assert.isNotNull((Object)this.fNode);
        return this.fNode;
    }
}

