/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.buildpath;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.junit.buildpath.BuildPathSupport;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;

public class JUnitContainerInitializer
extends ClasspathContainerInitializer {
    public static final String JUNIT_CONTAINER_ID = "org.eclipse.jdt.junit.JUNIT_CONTAINER";
    public static final String JUNIT3 = "3.8.1";
    public static final String JUNIT4 = "4";
    public static final IPath JUNIT3_PATH = new Path("org.eclipse.jdt.junit.JUNIT_CONTAINER").append("3.8.1");
    public static final IPath JUNIT4_PATH = new Path("org.eclipse.jdt.junit.JUNIT_CONTAINER").append("4");

    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        if (JUnitContainerInitializer.isValidJUnitContainerPath(containerPath)) {
            IClasspathEntry entry = null;
            String version = containerPath.segment(1);
            if (JUNIT3.equals(version)) {
                entry = BuildPathSupport.getJUnit3LibraryEntry();
            } else if (JUNIT4.equals(version)) {
                entry = BuildPathSupport.getJUnit4LibraryEntry();
            }
            IClasspathEntry[] entries = entry != null ? new IClasspathEntry[]{entry} : new IClasspathEntry[]{};
            JUnitContainer container = new JUnitContainer(containerPath, entries);
            JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{container}, null);
        }
    }

    private static boolean isValidJUnitContainerPath(IPath path) {
        return path != null && path.segmentCount() == 2 && JUNIT_CONTAINER_ID.equals(path.segment(0));
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return true;
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
        JavaCore.setClasspathContainer((IPath)containerPath, (IJavaProject[])new IJavaProject[]{project}, (IClasspathContainer[])new IClasspathContainer[]{containerSuggestion}, null);
    }

    public String getDescription(IPath containerPath, IJavaProject project) {
        if (JUnitContainerInitializer.isValidJUnitContainerPath(containerPath)) {
            String version = containerPath.segment(1);
            if (JUNIT3.equals(version)) {
                return JUnitMessages.JUnitContainerInitializer_description_initializer_junit3;
            }
            if (JUNIT4.equals(version)) {
                return JUnitMessages.JUnitContainerInitializer_description_initializer_junit4;
            }
        }
        return JUnitMessages.JUnitContainerInitializer_description_initializer_unresolved;
    }

    public Object getComparisonID(IPath containerPath, IJavaProject project) {
        return containerPath;
    }

    private static class JUnitContainer
    implements IClasspathContainer {
        private final IClasspathEntry[] fEntries;
        private final IPath fPath;

        public JUnitContainer(IPath path, IClasspathEntry[] entries) {
            this.fPath = path;
            this.fEntries = entries;
        }

        public IClasspathEntry[] getClasspathEntries() {
            return this.fEntries;
        }

        public String getDescription() {
            if (JUNIT4_PATH.equals((Object)this.fPath)) {
                return JUnitMessages.JUnitContainerInitializer_description_junit4;
            }
            return JUnitMessages.JUnitContainerInitializer_description_junit3;
        }

        public int getKind() {
            return 1;
        }

        public IPath getPath() {
            return this.fPath;
        }
    }
}

