/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.util;

import fr.jayasoft.ivy.util.FileUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public class ChecksumHelper {
    private static Map _algorithms = new HashMap();
    private static final char[] CHARS;

    public static boolean check(File dest, File checksumFile, String algorithm) throws IOException {
        String csFileContent = FileUtil.readEntirely(new BufferedReader(new FileReader(checksumFile))).trim().toLowerCase();
        int spaceIndex = csFileContent.indexOf(32);
        String expected = spaceIndex != -1 ? csFileContent.substring(0, spaceIndex) : csFileContent;
        String computed = ChecksumHelper.computeAsString(dest, algorithm).trim().toLowerCase();
        return expected.equals(computed);
    }

    public static String computeAsString(File f, String algorithm) throws IOException {
        return ChecksumHelper.byteArrayToHexString(ChecksumHelper.compute(f, algorithm));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] compute(File f, String algorithm) throws IOException {
        FileInputStream is = new FileInputStream(f);
        try {
            MessageDigest md = ChecksumHelper.getMessageDigest(algorithm);
            md.reset();
            byte[] buf = new byte[2048];
            int len = 0;
            while ((len = ((InputStream)is).read(buf)) != -1) {
                md.update(buf, 0, len);
            }
            byte[] byArray = md.digest();
            return byArray;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private static MessageDigest getMessageDigest(String algorithm) {
        String mdAlgorithm = (String)_algorithms.get(algorithm);
        if (mdAlgorithm == null) {
            throw new IllegalArgumentException("unknown algorithm " + algorithm);
        }
        try {
            return MessageDigest.getInstance(mdAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("unknown algorithm " + algorithm);
        }
    }

    public static String byteArrayToHexString(byte[] in) {
        byte ch = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        StringBuffer out = new StringBuffer(in.length * 2);
        for (int i = 0; i < in.length; ++i) {
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(CHARS[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(CHARS[ch]);
        }
        return out.toString();
    }

    static {
        _algorithms.put("md5", "MD5");
        _algorithms.put("sha1", "SHA-1");
        CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

