/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.Debug;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Package;
import org.armedbear.lisp.Packages;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.StandardGenericFunction;
import org.armedbear.lisp.Stream;
import org.armedbear.lisp.Symbol;

public class Profiler {
    static int sleep = 1;
    public static final Primitive _START_PROFILER = new Primitive("%start-profiler", Lisp.PACKAGE_PROF, false){

        public LispObject execute(LispObject first, LispObject second) {
            final LispThread thread = LispThread.currentThread();
            Stream out = Lisp.getStandardOutput();
            out.freshLine();
            if (Lisp.profiling) {
                out._writeLine("; Profiler already started.");
            } else {
                if (first == Keyword.TIME) {
                    Lisp.sampling = true;
                } else if (first == Keyword.COUNT_ONLY) {
                    Lisp.sampling = false;
                } else {
                    return Lisp.error(new LispError("%START-PROFILER: argument must be either :TIME or :COUNT-ONLY"));
                }
                Package[] packages = Packages.getAllPackages();
                for (int i = 0; i < packages.length; ++i) {
                    Package pkg = packages[i];
                    Symbol[] symbols = pkg.symbols();
                    for (int j = 0; j < symbols.length; ++j) {
                        Symbol symbol = symbols[j];
                        LispObject object = symbol.getSymbolFunction();
                        if (object == null) continue;
                        object.setCallCount(0);
                        object.setHotCount(0);
                        LispObject methods = null;
                        if (object instanceof StandardGenericFunction) {
                            methods = Symbol.GENERIC_FUNCTION_METHODS.execute(object);
                        }
                        while (methods != null && methods != Lisp.NIL) {
                            LispObject method = methods.car();
                            LispObject function = Symbol.METHOD_FUNCTION.execute(method);
                            if (function == Lisp.NIL) continue;
                            function.setCallCount(0);
                            function.setHotCount(0);
                            methods = methods.cdr();
                        }
                    }
                }
                if (Lisp.sampling) {
                    sleep = Fixnum.getValue(second);
                    Runnable profilerRunnable = new Runnable(){

                        public void run() {
                            Lisp.profiling = true;
                            while (Lisp.profiling) {
                                try {
                                    thread.incrementCallCounts();
                                    Thread.sleep(sleep);
                                }
                                catch (InterruptedException e) {
                                    Debug.trace(e);
                                }
                            }
                        }
                    };
                    Thread t = new Thread(profilerRunnable);
                    t.setPriority(10);
                    new Thread(profilerRunnable).start();
                }
                out._writeLine("; Profiler started.");
            }
            return thread.nothing();
        }
    };
    public static final Primitive STOP_PROFILER = new Primitive("stop-profiler", Lisp.PACKAGE_PROF, true){

        public LispObject execute() {
            Stream out = Lisp.getStandardOutput();
            out.freshLine();
            if (Lisp.profiling) {
                Lisp.profiling = false;
                out._writeLine("; Profiler stopped.");
            } else {
                out._writeLine("; Profiler was not started.");
            }
            out._finishOutput();
            return LispThread.currentThread().nothing();
        }
    };
}

