'''OpenGL extension EXT.polygon_offset

Overview (from the spec)
	
	The depth values of fragments generated by rendering polygons are
	displaced by an amount that is proportional to the maximum absolute
	value of the depth slope of the polygon, measured and applied in window
	coordinates.  This displacement allows lines (or points) and polygons
	in the same plane to be rendered without interaction -- the lines
	rendered either completely in front of or behind the polygons
	(depending on the sign of the offset factor).  It also allows multiple
	coplanar polygons to be rendered without interaction, if different
	offset factors are used for each polygon.  Applications include
	rendering hidden-line images, rendering solids with highlighted edges,
	and applying `decals' to surfaces.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/EXT/polygon_offset.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_EXT_polygon_offset'
GL_POLYGON_OFFSET_EXT = constant.Constant( 'GL_POLYGON_OFFSET_EXT', 0x8037 )
glget.addGLGetConstant( GL_POLYGON_OFFSET_EXT, (1,) )
GL_POLYGON_OFFSET_FACTOR_EXT = constant.Constant( 'GL_POLYGON_OFFSET_FACTOR_EXT', 0x8038 )
glget.addGLGetConstant( GL_POLYGON_OFFSET_FACTOR_EXT, (1,) )
GL_POLYGON_OFFSET_BIAS_EXT = constant.Constant( 'GL_POLYGON_OFFSET_BIAS_EXT', 0x8039 )
glget.addGLGetConstant( GL_POLYGON_OFFSET_BIAS_EXT, (1,) )
glPolygonOffsetEXT = platform.createExtensionFunction( 
	'glPolygonOffsetEXT', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLfloat, constants.GLfloat,),
	doc = 'glPolygonOffsetEXT( GLfloat(factor), GLfloat(bias) ) -> None',
	argNames = ('factor', 'bias',),
)


def glInitPolygonOffsetEXT():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( EXTENSION_NAME )
