require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MIPS64_PMAP_H_)) {
    eval 'sub _MIPS64_PMAP_H_ () {1;}' unless defined(&_MIPS64_PMAP_H_);
    if(defined(&_KERNEL)) {
	require 'machine/pte.ph';
	if(defined(&MIPS_PTE64)) {
	    eval 'sub PMAP_L2SHIFT () {14;}' unless defined(&PMAP_L2SHIFT);
	} else {
	    eval 'sub PMAP_L2SHIFT () {12;}' unless defined(&PMAP_L2SHIFT);
	}
	eval 'sub PMAP_L2SIZE () {(1 <<  &PMAP_L2SHIFT);}' unless defined(&PMAP_L2SIZE);
	eval 'sub NPTEPG () {( &PMAP_L2SIZE / $sizeof{ &pt_entry_t});}' unless defined(&NPTEPG);
	if(defined(&MIPS_PTE64)) {
	    eval 'sub SEGSHIFT () {( &PAGE_SHIFT +  &PMAP_L2SHIFT - 3);}' unless defined(&SEGSHIFT);
	} else {
	    eval 'sub SEGSHIFT () {( &PAGE_SHIFT +  &PMAP_L2SHIFT - 2);}' unless defined(&SEGSHIFT);
	}
	eval 'sub NBSEG () {(1 <<  &SEGSHIFT);}' unless defined(&NBSEG);
	eval 'sub SEGOFSET () {( &NBSEG - 1);}' unless defined(&SEGOFSET);
	eval 'sub mips_trunc_seg {
	    my($x) = @_;
    	    eval q((( &vaddr_t)($x) & ~ &SEGOFSET));
	}' unless defined(&mips_trunc_seg);
	eval 'sub mips_round_seg {
	    my($x) = @_;
    	    eval q(((( &vaddr_t)($x) +  &SEGOFSET) & ~ &SEGOFSET));
	}' unless defined(&mips_round_seg);
	eval 'sub pmap_segmap {
	    my($m, $v) = @_;
    	    eval q((($m)-> ($p$m_segtab->{seg_tab[&((v)>>SEGSHIFT)]})));
	}' unless defined(&pmap_segmap);
	eval 'sub PMAP_SEGTABSIZE () {( &PMAP_L2SIZE / $sizeof{ &void });}' unless defined(&PMAP_SEGTABSIZE);
	eval 'sub PMAP_SIZEOF {
	    my($x) = @_;
    	    eval q(( &ALIGN($sizeof{\'struct pmap\'} + ($sizeof{\'struct pmap_asid_info\'} * (($x) - 1)))));
	}' unless defined(&PMAP_SIZEOF);
	eval 'sub PV_UNCACHED () { &PG_PMAP0;}' unless defined(&PV_UNCACHED);
	eval 'sub PV_CACHED () { &PG_PMAP1;}' unless defined(&PV_CACHED);
	eval 'sub PV_ATTR_MOD () { &PG_PMAP2;}' unless defined(&PV_ATTR_MOD);
	eval 'sub PV_ATTR_REF () { &PG_PMAP3;}' unless defined(&PV_ATTR_REF);
	eval 'sub PV_PRESERVE () {( &PV_ATTR_MOD |  &PV_ATTR_REF);}' unless defined(&PV_PRESERVE);
	eval 'sub pmap_resident_count {
	    my($pmap) = @_;
    	    eval q((($pmap)-> ($pm_stats->{resident_count})));
	}' unless defined(&pmap_resident_count);
	eval 'sub pmap_wired_count {
	    my($pmap) = @_;
    	    eval q((($pmap)-> ($pm_stats->{wired_count})));
	}' unless defined(&pmap_wired_count);
	eval 'sub pmap_kernel () {
	    eval q(( &kernel_pmap_ptr));
	}' unless defined(&pmap_kernel);
	eval 'sub PMAP_STEAL_MEMORY () {1;}' unless defined(&PMAP_STEAL_MEMORY);
	eval 'sub PMAP_PREFER {
	    my($pa, $va) = @_;
    	    eval q( &pmap_prefer($pa, $va));
	}' unless defined(&PMAP_PREFER);
	eval 'sub PMAP_PREFER_ALIGN () {
	    eval q(( &pmap_prefer_mask ?  &pmap_prefer_mask + 1: 0));
	}' unless defined(&PMAP_PREFER_ALIGN);
	eval 'sub PMAP_PREFER_OFFSET {
	    my($of) = @_;
    	    eval q((($of) &  &pmap_prefer_mask));
	}' unless defined(&PMAP_PREFER_OFFSET);
	eval 'sub pmap_update {
	    my($x) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&pmap_update);
	eval 'sub pmap_collect {
	    my($x) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&pmap_collect);
	eval 'sub pmap_unuse_final {
	    my($p) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&pmap_unuse_final);
	eval 'sub pmap_remove_holes {
	    my($map) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&pmap_remove_holes);
	if(defined(&MULTIPROCESSOR)) {
	} else {
	    eval 'sub pmap_update_kernel_page {
	        my($va, $entry) = @_;
    		eval q( &tlb_update($va, $entry));
	    }' unless defined(&pmap_update_kernel_page);
	}
	if(!defined(&CPU_R5000)  && !defined(&CPU_RM7000)) {
	    eval 'sub __HAVE_PMAP_DIRECT () {1;}' unless defined(&__HAVE_PMAP_DIRECT);
	}
	eval 'sub PMAP_PA_MASK () {~(( &paddr_t) &PAGE_MASK);}' unless defined(&PMAP_PA_MASK);
	eval 'sub kvtopte {
	    my($va) = @_;
    	    eval q(( &Sysmap + ((( &vaddr_t)($va) -  &VM_MIN_KERNEL_ADDRESS) >>  &PAGE_SHIFT)));
	}' unless defined(&kvtopte);
	eval 'sub uvtopte {
	    my($va) = @_;
    	    eval q(((($va) >>  &PAGE_SHIFT) & ( &NPTEPG -1)));
	}' unless defined(&uvtopte);
    }
    if(!defined(&_LOCORE)) {
	eval 'sub VM_MDPAGE_INIT {
	    my($pg) = @_;
    	    eval q( &do { ($pg)-> ($mdpage->{pv_ent}->{pv_next}) =  &NULL; ($pg)-> ($mdpage->{pv_ent}->{pv_pmap}) =  &NULL; ($pg)-> ($mdpage->{pv_ent}->{pv_va}) = 0; }  &while (0));
	}' unless defined(&VM_MDPAGE_INIT);
    }
}
1;
