require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_ARM_CPU_H_)) {
    eval 'sub _ARM_CPU_H_ () {1;}' unless defined(&_ARM_CPU_H_);
    eval 'sub CPU_CONSDEV () {4;}' unless defined(&CPU_CONSDEV);
    eval 'sub CPU_POWERSAVE () {5;}' unless defined(&CPU_POWERSAVE);
    eval 'sub CPU_ALLOWAPERTURE () {6;}' unless defined(&CPU_ALLOWAPERTURE);
    eval 'sub CPU_APMWARN () {7;}' unless defined(&CPU_APMWARN);
    eval 'sub CPU_MAXSPEED () {11;}' unless defined(&CPU_MAXSPEED);
    eval 'sub CPU_LIDSUSPEND () {12;}' unless defined(&CPU_LIDSUSPEND);
    eval 'sub CPU_MAXID () {13;}' unless defined(&CPU_MAXID);
    eval 'sub CTL_MACHDEP_NAMES () {{ { 0, 0}, { 0, 0}, { 0, 0}, { 0, 0}, { "console_device",  &CTLTYPE_STRUCT }, { "powersave",  &CTLTYPE_INT }, { "allowaperture",  &CTLTYPE_INT }, { "apmwarn",  &CTLTYPE_INT }, { 0, 0}, { 0, 0}, { 0, 0}, { "maxspeed",  &CTLTYPE_INT }, { "lidsuspend",  &CTLTYPE_INT } };}' unless defined(&CTL_MACHDEP_NAMES);
    if(defined(&_KERNEL)) {
	require 'arm/cpuconf.ph';
	require 'machine/intr.ph';
	unless(defined(&_LOCORE)) {
	    if(0) {
		require 'sys/user.ph';
	    }
	    require 'machine/frame.ph';
	    require 'machine/pcb.ph';
	}
	require 'arm/armreg.ph';
	unless(defined(&_LOCORE)) {
	}
	if(defined(&_LOCORE)) {
	    eval 'sub IRQdisable () { &stmfd  &sp!, { &r0} ;  &mrs  &r0,  &cpsr ;  &orr  &r0,  &r0, ( &I32_bit) ;  &msr  &cpsr_c,  &r0 ;  &ldmfd  &sp!, { &r0};}' unless defined(&IRQdisable);
	    eval 'sub IRQenable () { &stmfd  &sp!, { &r0} ;  &mrs  &r0,  &cpsr ;  &bic  &r0,  &r0, ( &I32_bit) ;  &msr  &cpsr_c,  &r0 ;  &ldmfd  &sp!, { &r0};}' unless defined(&IRQenable);
	} else {
	    eval 'sub IRQdisable () { &__set_cpsr_c( &I32_bit,  &I32_bit);;}' unless defined(&IRQdisable);
	    eval 'sub IRQenable () { &__set_cpsr_c( &I32_bit, 0);;}' unless defined(&IRQenable);
	}
	unless(defined(&_LOCORE)) {
	    eval 'sub CLKF_USERMODE {
	        my($frame) = @_;
    		eval q((( ($frame->{if_spsr}) &  &PSR_MODE) ==  &PSR_USR32_MODE));
	    }' unless defined(&CLKF_USERMODE);
	    eval 'sub CLKF_INTR {
	        my($frame) = @_;
    		eval q(( &curcpu()-> &ci_idepth > 1));
	    }' unless defined(&CLKF_INTR);
	    eval 'sub CLKF_PC {
	        my($frame) = @_;
    		eval q(( ($frame->{if_pc})));
	    }' unless defined(&CLKF_PC);
	    eval 'sub PROC_PC {
	        my($p) = @_;
    		eval q((($p)-> ($p_addr->{u_pcb}->{pcb_tf}->{tf_pc})));
	    }' unless defined(&PROC_PC);
	    eval 'sub PROC_STACK {
	        my($p) = @_;
    		eval q((($p)-> ($p_addr->{u_pcb}->{pcb_tf}->{tf_usr_sp})));
	    }' unless defined(&PROC_STACK);
	    eval 'sub ARM_VEC_RESET () {(1<< 0);}' unless defined(&ARM_VEC_RESET);
	    eval 'sub ARM_VEC_UNDEFINED () {(1<< 1);}' unless defined(&ARM_VEC_UNDEFINED);
	    eval 'sub ARM_VEC_SWI () {(1<< 2);}' unless defined(&ARM_VEC_SWI);
	    eval 'sub ARM_VEC_PREFETCH_ABORT () {(1<< 3);}' unless defined(&ARM_VEC_PREFETCH_ABORT);
	    eval 'sub ARM_VEC_DATA_ABORT () {(1<< 4);}' unless defined(&ARM_VEC_DATA_ABORT);
	    eval 'sub ARM_VEC_ADDRESS_EXCEPTION () {(1<< 5);}' unless defined(&ARM_VEC_ADDRESS_EXCEPTION);
	    eval 'sub ARM_VEC_IRQ () {(1<< 6);}' unless defined(&ARM_VEC_IRQ);
	    eval 'sub ARM_VEC_FIQ () {(1<< 7);}' unless defined(&ARM_VEC_FIQ);
	    eval 'sub ARM_NVEC () {8;}' unless defined(&ARM_NVEC);
	    eval 'sub ARM_VEC_ALL () {0xffffffff;}' unless defined(&ARM_VEC_ALL);
	    require 'sys/device.ph';
	    require 'sys/sched.ph';
	    if(defined(&DIAGNOSTIC)) {
	    }
	    if(defined(&GPROF)) {
	    }
	    unless(defined(&MULTIPROCESSOR)) {
		eval 'sub curcpu () {
		    eval q(( &cpu_info_primary));
		}' unless defined(&curcpu);
		eval 'sub cpu_number () {
		    eval q(0);
		}' unless defined(&cpu_number);
		eval 'sub CPU_IS_PRIMARY {
		    my($ci) = @_;
    		    eval q(1);
		}' unless defined(&CPU_IS_PRIMARY);
		eval 'sub CPU_INFO_ITERATOR () {\'int\';}' unless defined(&CPU_INFO_ITERATOR);
		eval 'sub CPU_INFO_FOREACH {
		    my($cii, $ci) = @_;
    		    eval q( &for ($cii = 0, $ci =  &curcpu(); $ci !=  &NULL; $ci =  &NULL));
		}' unless defined(&CPU_INFO_FOREACH);
		eval 'sub CPU_INFO_UNIT {
		    my($ci) = @_;
    		    eval q(0);
		}' unless defined(&CPU_INFO_UNIT);
		eval 'sub MAXCPUS () {1;}' unless defined(&MAXCPUS);
		eval 'sub cpu_unidle {
		    my($ci) = @_;
    		    eval q();
		}' unless defined(&cpu_unidle);
	    } else {
		eval 'sub cpu_number () {
		    eval q(( &curcpu()-> &ci_cpuid));
		}' unless defined(&cpu_number);
		eval 'sub CPU_IS_PRIMARY {
		    my($ci) = @_;
    		    eval q((($ci) ==  &cpu_info_primary));
		}' unless defined(&CPU_IS_PRIMARY);
		eval 'sub CPU_INFO_ITERATOR () {\'int\';}' unless defined(&CPU_INFO_ITERATOR);
		eval 'sub CPU_INFO_FOREACH {
		    my($cii, $ci) = @_;
    		    eval q( &for ($cii = 0, $ci =  &cpu_info_list; $ci !=  &NULL; $ci =  ($ci->{ci_next})));
		}' unless defined(&CPU_INFO_FOREACH);
		eval 'sub CPU_INFO_UNIT {
		    my($ci) = @_;
    		    eval q((($ci)-> &ci_dev ? ($ci)-> ($ci_dev->{dv_unit}) : 0));
		}' unless defined(&CPU_INFO_UNIT);
		eval 'sub MAXCPUS () {4;}' unless defined(&MAXCPUS);
		eval 'sub cpu_unidle {
		    my($ci) = @_;
    		    eval q();
		}' unless defined(&cpu_unidle);
	    }
	    eval 'sub curpcb () { &curcpu()-> &ci_curpcb;}' unless defined(&curpcb);
	    eval 'sub setsoftast () {
	        eval q(( &astpending = 1));
	    }' unless defined(&setsoftast);
	    eval 'sub signotify {
	        my($p) = @_;
    		eval q( &setsoftast());
	    }' unless defined(&signotify);
	    eval 'sub need_resched {
	        my($ci) = @_;
    		eval q(( &want_resched = 1,  &setsoftast()));
	    }' unless defined(&need_resched);
	    eval 'sub clear_resched {
	        my($ci) = @_;
    		eval q( &want_resched = 0);
	    }' unless defined(&clear_resched);
	    eval 'sub need_proftick {
	        my($p) = @_;
    		eval q( &setsoftast());
	    }' unless defined(&need_proftick);
	}
    }
}
1;
