/* This file is autogenerated by u_format_table.py from u_format.csv. Do not edit directly. */

/**************************************************************************
 *
 * Copyright 2010 VMware, Inc.
 * All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sub license, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice (including the
 * next paragraph) shall be included in all copies or substantial portions
 * of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT.
 * IN NO EVENT SHALL VMWARE AND/OR ITS SUPPLIERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 **************************************************************************/

#include "u_format.h"
#include "u_format_s3tc.h"
#include "u_format_rgtc.h"
#include "u_format_latc.h"


#include "pipe/p_compiler.h"
#include "u_math.h"
#include "u_half.h"
#include "u_format.h"
#include "u_format_other.h"
#include "u_format_srgb.h"
#include "u_format_yuv.h"
#include "u_format_zs.h"

union util_format_none {
   uint8_t value;
   struct {
      uint8_t r;
   } chan;
};

static INLINE void
util_format_none_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         r = value;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_none_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)CLAMP(src[0], 0, 255);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_none_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         r = value;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_none_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         r = value;
         dst[0] = (uint8_t)(((uint32_t)MIN2(r, 1)) * 0xff / 0x1); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_none_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)(((uint32_t)src[0]) * 0x1 / 0xff);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b8g8r8a8_unorm {
   uint32_t value;
   struct {
      uint8_t b;
      uint8_t g;
      uint8_t r;
      uint8_t a;
   } chan;
};

static INLINE void
util_format_b8g8r8a8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         b = (value) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_b8g8r8a8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (float_to_ubyte(src[2])) & 0xff;
         value |= ((float_to_ubyte(src[1])) & 0xff) << 8;
         value |= ((float_to_ubyte(src[0])) & 0xff) << 16;
         value |= (float_to_ubyte(src[3])) << 24;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_b8g8r8a8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         b = (value) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
}

static INLINE void
util_format_b8g8r8a8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         b = (value) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = r; /* r */
         dst[1] = g; /* g */
         dst[2] = b; /* b */
         dst[3] = a; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_b8g8r8a8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (src[2]) & 0xff;
         value |= ((src[1]) & 0xff) << 8;
         value |= ((src[0]) & 0xff) << 16;
         value |= (src[3]) << 24;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b8g8r8x8_unorm {
   uint32_t value;
   struct {
      uint8_t b;
      uint8_t g;
      uint8_t r;
      uint8_t x;
   } chan;
};

static INLINE void
util_format_b8g8r8x8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         b = (value) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value >> 16) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_b8g8r8x8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (float_to_ubyte(src[2])) & 0xff;
         value |= ((float_to_ubyte(src[1])) & 0xff) << 8;
         value |= ((float_to_ubyte(src[0])) & 0xff) << 16;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_b8g8r8x8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         b = (value) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value >> 16) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_b8g8r8x8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         b = (value) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value >> 16) & 0xff;
         dst[0] = r; /* r */
         dst[1] = g; /* g */
         dst[2] = b; /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_b8g8r8x8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (src[2]) & 0xff;
         value |= ((src[1]) & 0xff) << 8;
         value |= ((src[0]) & 0xff) << 16;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a8r8g8b8_unorm {
   uint32_t value;
   struct {
      uint8_t a;
      uint8_t r;
      uint8_t g;
      uint8_t b;
   } chan;
};

static INLINE void
util_format_a8r8g8b8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t r;
         uint32_t g;
         uint32_t b;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         a = (value) & 0xff;
         r = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         b = value >> 24;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_a8r8g8b8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (float_to_ubyte(src[3])) & 0xff;
         value |= ((float_to_ubyte(src[0])) & 0xff) << 8;
         value |= ((float_to_ubyte(src[1])) & 0xff) << 16;
         value |= (float_to_ubyte(src[2])) << 24;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_a8r8g8b8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t r;
         uint32_t g;
         uint32_t b;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         a = (value) & 0xff;
         r = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         b = value >> 24;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
}

static INLINE void
util_format_a8r8g8b8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t r;
         uint32_t g;
         uint32_t b;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         a = (value) & 0xff;
         r = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         b = value >> 24;
         dst[0] = r; /* r */
         dst[1] = g; /* g */
         dst[2] = b; /* b */
         dst[3] = a; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_a8r8g8b8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (src[3]) & 0xff;
         value |= ((src[0]) & 0xff) << 8;
         value |= ((src[1]) & 0xff) << 16;
         value |= (src[2]) << 24;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_x8r8g8b8_unorm {
   uint32_t value;
   struct {
      uint8_t x;
      uint8_t r;
      uint8_t g;
      uint8_t b;
   } chan;
};

static INLINE void
util_format_x8r8g8b8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         b = value >> 24;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_x8r8g8b8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= ((float_to_ubyte(src[0])) & 0xff) << 8;
         value |= ((float_to_ubyte(src[1])) & 0xff) << 16;
         value |= (float_to_ubyte(src[2])) << 24;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_x8r8g8b8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         b = value >> 24;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_x8r8g8b8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         b = value >> 24;
         dst[0] = r; /* r */
         dst[1] = g; /* g */
         dst[2] = b; /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_x8r8g8b8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= ((src[0]) & 0xff) << 8;
         value |= ((src[1]) & 0xff) << 16;
         value |= (src[2]) << 24;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a8b8g8r8_unorm {
   uint32_t value;
   struct {
      uint8_t a;
      uint8_t b;
      uint8_t g;
      uint8_t r;
   } chan;
};

static INLINE void
util_format_a8b8g8r8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t b;
         uint32_t g;
         uint32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         a = (value) & 0xff;
         b = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         r = value >> 24;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_a8b8g8r8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (float_to_ubyte(src[3])) & 0xff;
         value |= ((float_to_ubyte(src[2])) & 0xff) << 8;
         value |= ((float_to_ubyte(src[1])) & 0xff) << 16;
         value |= (float_to_ubyte(src[0])) << 24;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_a8b8g8r8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t b;
         uint32_t g;
         uint32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         a = (value) & 0xff;
         b = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         r = value >> 24;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
}

static INLINE void
util_format_a8b8g8r8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t b;
         uint32_t g;
         uint32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         a = (value) & 0xff;
         b = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         r = value >> 24;
         dst[0] = r; /* r */
         dst[1] = g; /* g */
         dst[2] = b; /* b */
         dst[3] = a; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_a8b8g8r8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (src[3]) & 0xff;
         value |= ((src[2]) & 0xff) << 8;
         value |= ((src[1]) & 0xff) << 16;
         value |= (src[0]) << 24;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_x8b8g8r8_unorm {
   uint32_t value;
   struct {
      uint8_t x;
      uint8_t b;
      uint8_t g;
      uint8_t r;
   } chan;
};

static INLINE void
util_format_x8b8g8r8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         b = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         r = value >> 24;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_x8b8g8r8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= ((float_to_ubyte(src[2])) & 0xff) << 8;
         value |= ((float_to_ubyte(src[1])) & 0xff) << 16;
         value |= (float_to_ubyte(src[0])) << 24;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_x8b8g8r8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         b = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         r = value >> 24;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_x8b8g8r8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         b = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         r = value >> 24;
         dst[0] = r; /* r */
         dst[1] = g; /* g */
         dst[2] = b; /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_x8b8g8r8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= ((src[2]) & 0xff) << 8;
         value |= ((src[1]) & 0xff) << 16;
         value |= (src[0]) << 24;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8x8_unorm {
   uint32_t value;
   struct {
      uint8_t r;
      uint8_t g;
      uint8_t b;
      uint8_t x;
   } chan;
};

static INLINE void
util_format_r8g8b8x8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8b8x8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (float_to_ubyte(src[0])) & 0xff;
         value |= ((float_to_ubyte(src[1])) & 0xff) << 8;
         value |= ((float_to_ubyte(src[2])) & 0xff) << 16;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r8g8b8x8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r8g8b8x8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         dst[0] = r; /* r */
         dst[1] = g; /* g */
         dst[2] = b; /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8b8x8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (src[0]) & 0xff;
         value |= ((src[1]) & 0xff) << 8;
         value |= ((src[2]) & 0xff) << 16;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b5g5r5x1_unorm {
   uint16_t value;
   struct {
      unsigned b:5;
      unsigned g:5;
      unsigned r:5;
      unsigned x:1;
   } chan;
};

static INLINE void
util_format_b5g5r5x1_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         b = (value) & 0x1f;
         g = (value >> 5) & 0x1f;
         r = (value >> 10) & 0x1f;
         dst[0] = (float)(r * (1.0f/0x1f)); /* r */
         dst[1] = (float)(g * (1.0f/0x1f)); /* g */
         dst[2] = (float)(b * (1.0f/0x1f)); /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_b5g5r5x1_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= ((uint16_t)(CLAMP(src[2], 0, 1) * 0x1f)) & 0x1f;
         value |= (((uint16_t)(CLAMP(src[1], 0, 1) * 0x1f)) & 0x1f) << 5;
         value |= (((uint16_t)(CLAMP(src[0], 0, 1) * 0x1f)) & 0x1f) << 10;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_b5g5r5x1_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         b = (value) & 0x1f;
         g = (value >> 5) & 0x1f;
         r = (value >> 10) & 0x1f;
         dst[0] = (float)(r * (1.0f/0x1f)); /* r */
         dst[1] = (float)(g * (1.0f/0x1f)); /* g */
         dst[2] = (float)(b * (1.0f/0x1f)); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_b5g5r5x1_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         b = (value) & 0x1f;
         g = (value >> 5) & 0x1f;
         r = (value >> 10) & 0x1f;
         dst[0] = (uint8_t)(((uint32_t)r) * 0xff / 0x1f); /* r */
         dst[1] = (uint8_t)(((uint32_t)g) * 0xff / 0x1f); /* g */
         dst[2] = (uint8_t)(((uint32_t)b) * 0xff / 0x1f); /* b */
         dst[3] = 255; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_b5g5r5x1_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= ((uint16_t)(src[2] >> 3)) & 0x1f;
         value |= (((uint16_t)(src[1] >> 3)) & 0x1f) << 5;
         value |= (((uint16_t)(src[0] >> 3)) & 0x1f) << 10;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b5g5r5a1_unorm {
   uint16_t value;
   struct {
      unsigned b:5;
      unsigned g:5;
      unsigned r:5;
      unsigned a:1;
   } chan;
};

static INLINE void
util_format_b5g5r5a1_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
         uint16_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         b = (value) & 0x1f;
         g = (value >> 5) & 0x1f;
         r = (value >> 10) & 0x1f;
         a = value >> 15;
         dst[0] = (float)(r * (1.0f/0x1f)); /* r */
         dst[1] = (float)(g * (1.0f/0x1f)); /* g */
         dst[2] = (float)(b * (1.0f/0x1f)); /* b */
         dst[3] = (float)(a * (1.0f/0x1)); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_b5g5r5a1_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= ((uint16_t)(CLAMP(src[2], 0, 1) * 0x1f)) & 0x1f;
         value |= (((uint16_t)(CLAMP(src[1], 0, 1) * 0x1f)) & 0x1f) << 5;
         value |= (((uint16_t)(CLAMP(src[0], 0, 1) * 0x1f)) & 0x1f) << 10;
         value |= ((uint16_t)(CLAMP(src[3], 0, 1) * 0x1)) << 15;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_b5g5r5a1_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
         uint16_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         b = (value) & 0x1f;
         g = (value >> 5) & 0x1f;
         r = (value >> 10) & 0x1f;
         a = value >> 15;
         dst[0] = (float)(r * (1.0f/0x1f)); /* r */
         dst[1] = (float)(g * (1.0f/0x1f)); /* g */
         dst[2] = (float)(b * (1.0f/0x1f)); /* b */
         dst[3] = (float)(a * (1.0f/0x1)); /* a */
}

static INLINE void
util_format_b5g5r5a1_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
         uint16_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         b = (value) & 0x1f;
         g = (value >> 5) & 0x1f;
         r = (value >> 10) & 0x1f;
         a = value >> 15;
         dst[0] = (uint8_t)(((uint32_t)r) * 0xff / 0x1f); /* r */
         dst[1] = (uint8_t)(((uint32_t)g) * 0xff / 0x1f); /* g */
         dst[2] = (uint8_t)(((uint32_t)b) * 0xff / 0x1f); /* b */
         dst[3] = (uint8_t)(((uint32_t)a) * 0xff / 0x1); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_b5g5r5a1_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= ((uint16_t)(src[2] >> 3)) & 0x1f;
         value |= (((uint16_t)(src[1] >> 3)) & 0x1f) << 5;
         value |= (((uint16_t)(src[0] >> 3)) & 0x1f) << 10;
         value |= ((uint16_t)(src[3] >> 7)) << 15;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b4g4r4a4_unorm {
   uint16_t value;
   struct {
      unsigned b:4;
      unsigned g:4;
      unsigned r:4;
      unsigned a:4;
   } chan;
};

static INLINE void
util_format_b4g4r4a4_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
         uint16_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         b = (value) & 0xf;
         g = (value >> 4) & 0xf;
         r = (value >> 8) & 0xf;
         a = value >> 12;
         dst[0] = (float)(r * (1.0f/0xf)); /* r */
         dst[1] = (float)(g * (1.0f/0xf)); /* g */
         dst[2] = (float)(b * (1.0f/0xf)); /* b */
         dst[3] = (float)(a * (1.0f/0xf)); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_b4g4r4a4_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= ((uint16_t)(CLAMP(src[2], 0, 1) * 0xf)) & 0xf;
         value |= (((uint16_t)(CLAMP(src[1], 0, 1) * 0xf)) & 0xf) << 4;
         value |= (((uint16_t)(CLAMP(src[0], 0, 1) * 0xf)) & 0xf) << 8;
         value |= ((uint16_t)(CLAMP(src[3], 0, 1) * 0xf)) << 12;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_b4g4r4a4_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
         uint16_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         b = (value) & 0xf;
         g = (value >> 4) & 0xf;
         r = (value >> 8) & 0xf;
         a = value >> 12;
         dst[0] = (float)(r * (1.0f/0xf)); /* r */
         dst[1] = (float)(g * (1.0f/0xf)); /* g */
         dst[2] = (float)(b * (1.0f/0xf)); /* b */
         dst[3] = (float)(a * (1.0f/0xf)); /* a */
}

static INLINE void
util_format_b4g4r4a4_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
         uint16_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         b = (value) & 0xf;
         g = (value >> 4) & 0xf;
         r = (value >> 8) & 0xf;
         a = value >> 12;
         dst[0] = (uint8_t)(((uint32_t)r) * 0xff / 0xf); /* r */
         dst[1] = (uint8_t)(((uint32_t)g) * 0xff / 0xf); /* g */
         dst[2] = (uint8_t)(((uint32_t)b) * 0xff / 0xf); /* b */
         dst[3] = (uint8_t)(((uint32_t)a) * 0xff / 0xf); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_b4g4r4a4_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= ((uint16_t)(src[2] >> 4)) & 0xf;
         value |= (((uint16_t)(src[1] >> 4)) & 0xf) << 4;
         value |= (((uint16_t)(src[0] >> 4)) & 0xf) << 8;
         value |= ((uint16_t)(src[3] >> 4)) << 12;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b4g4r4x4_unorm {
   uint16_t value;
   struct {
      unsigned b:4;
      unsigned g:4;
      unsigned r:4;
      unsigned x:4;
   } chan;
};

static INLINE void
util_format_b4g4r4x4_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         b = (value) & 0xf;
         g = (value >> 4) & 0xf;
         r = (value >> 8) & 0xf;
         dst[0] = (float)(r * (1.0f/0xf)); /* r */
         dst[1] = (float)(g * (1.0f/0xf)); /* g */
         dst[2] = (float)(b * (1.0f/0xf)); /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_b4g4r4x4_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= ((uint16_t)(CLAMP(src[2], 0, 1) * 0xf)) & 0xf;
         value |= (((uint16_t)(CLAMP(src[1], 0, 1) * 0xf)) & 0xf) << 4;
         value |= (((uint16_t)(CLAMP(src[0], 0, 1) * 0xf)) & 0xf) << 8;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_b4g4r4x4_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         b = (value) & 0xf;
         g = (value >> 4) & 0xf;
         r = (value >> 8) & 0xf;
         dst[0] = (float)(r * (1.0f/0xf)); /* r */
         dst[1] = (float)(g * (1.0f/0xf)); /* g */
         dst[2] = (float)(b * (1.0f/0xf)); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_b4g4r4x4_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         b = (value) & 0xf;
         g = (value >> 4) & 0xf;
         r = (value >> 8) & 0xf;
         dst[0] = (uint8_t)(((uint32_t)r) * 0xff / 0xf); /* r */
         dst[1] = (uint8_t)(((uint32_t)g) * 0xff / 0xf); /* g */
         dst[2] = (uint8_t)(((uint32_t)b) * 0xff / 0xf); /* b */
         dst[3] = 255; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_b4g4r4x4_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= ((uint16_t)(src[2] >> 4)) & 0xf;
         value |= (((uint16_t)(src[1] >> 4)) & 0xf) << 4;
         value |= (((uint16_t)(src[0] >> 4)) & 0xf) << 8;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b5g6r5_unorm {
   uint16_t value;
   struct {
      unsigned b:5;
      unsigned g:6;
      unsigned r:5;
   } chan;
};

static INLINE void
util_format_b5g6r5_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         b = (value) & 0x1f;
         g = (value >> 5) & 0x3f;
         r = value >> 11;
         dst[0] = (float)(r * (1.0f/0x1f)); /* r */
         dst[1] = (float)(g * (1.0f/0x3f)); /* g */
         dst[2] = (float)(b * (1.0f/0x1f)); /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_b5g6r5_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= ((uint16_t)(CLAMP(src[2], 0, 1) * 0x1f)) & 0x1f;
         value |= (((uint16_t)(CLAMP(src[1], 0, 1) * 0x3f)) & 0x3f) << 5;
         value |= ((uint16_t)(CLAMP(src[0], 0, 1) * 0x1f)) << 11;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_b5g6r5_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         b = (value) & 0x1f;
         g = (value >> 5) & 0x3f;
         r = value >> 11;
         dst[0] = (float)(r * (1.0f/0x1f)); /* r */
         dst[1] = (float)(g * (1.0f/0x3f)); /* g */
         dst[2] = (float)(b * (1.0f/0x1f)); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_b5g6r5_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t b;
         uint16_t g;
         uint16_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         b = (value) & 0x1f;
         g = (value >> 5) & 0x3f;
         r = value >> 11;
         dst[0] = (uint8_t)(((uint32_t)r) * 0xff / 0x1f); /* r */
         dst[1] = (uint8_t)(((uint32_t)g) * 0xff / 0x3f); /* g */
         dst[2] = (uint8_t)(((uint32_t)b) * 0xff / 0x1f); /* b */
         dst[3] = 255; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_b5g6r5_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= ((uint16_t)(src[2] >> 3)) & 0x1f;
         value |= (((uint16_t)(src[1] >> 2)) & 0x3f) << 5;
         value |= ((uint16_t)(src[0] >> 3)) << 11;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r10g10b10a2_unorm {
   uint32_t value;
   struct {
      unsigned r:10;
      unsigned g:10;
      unsigned b:10;
      unsigned a:2;
   } chan;
};

static INLINE void
util_format_r10g10b10a2_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value >> 20) & 0x3ff;
         a = value >> 30;
         dst[0] = (float)(r * (1.0f/0x3ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x3ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x3ff)); /* b */
         dst[3] = (float)(a * (1.0f/0x3)); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r10g10b10a2_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= ((uint32_t)(CLAMP(src[0], 0, 1) * 0x3ff)) & 0x3ff;
         value |= (((uint32_t)(CLAMP(src[1], 0, 1) * 0x3ff)) & 0x3ff) << 10;
         value |= (((uint32_t)(CLAMP(src[2], 0, 1) * 0x3ff)) & 0x3ff) << 20;
         value |= ((uint32_t)(CLAMP(src[3], 0, 1) * 0x3)) << 30;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r10g10b10a2_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value >> 20) & 0x3ff;
         a = value >> 30;
         dst[0] = (float)(r * (1.0f/0x3ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x3ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x3ff)); /* b */
         dst[3] = (float)(a * (1.0f/0x3)); /* a */
}

static INLINE void
util_format_r10g10b10a2_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value >> 20) & 0x3ff;
         a = value >> 30;
         dst[0] = (uint8_t)(r >> 2); /* r */
         dst[1] = (uint8_t)(g >> 2); /* g */
         dst[2] = (uint8_t)(b >> 2); /* b */
         dst[3] = (uint8_t)(((uint32_t)a) * 0xff / 0x3); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r10g10b10a2_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= ((uint32_t)(((uint32_t)src[0]) * 0x3ff / 0xff)) & 0x3ff;
         value |= (((uint32_t)(((uint32_t)src[1]) * 0x3ff / 0xff)) & 0x3ff) << 10;
         value |= (((uint32_t)(((uint32_t)src[2]) * 0x3ff / 0xff)) & 0x3ff) << 20;
         value |= ((uint32_t)(src[3] >> 6)) << 30;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b10g10r10a2_unorm {
   uint32_t value;
   struct {
      unsigned b:10;
      unsigned g:10;
      unsigned r:10;
      unsigned a:2;
   } chan;
};

static INLINE void
util_format_b10g10r10a2_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         b = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         r = (value >> 20) & 0x3ff;
         a = value >> 30;
         dst[0] = (float)(r * (1.0f/0x3ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x3ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x3ff)); /* b */
         dst[3] = (float)(a * (1.0f/0x3)); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_b10g10r10a2_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= ((uint32_t)(CLAMP(src[2], 0, 1) * 0x3ff)) & 0x3ff;
         value |= (((uint32_t)(CLAMP(src[1], 0, 1) * 0x3ff)) & 0x3ff) << 10;
         value |= (((uint32_t)(CLAMP(src[0], 0, 1) * 0x3ff)) & 0x3ff) << 20;
         value |= ((uint32_t)(CLAMP(src[3], 0, 1) * 0x3)) << 30;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_b10g10r10a2_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         b = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         r = (value >> 20) & 0x3ff;
         a = value >> 30;
         dst[0] = (float)(r * (1.0f/0x3ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x3ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x3ff)); /* b */
         dst[3] = (float)(a * (1.0f/0x3)); /* a */
}

static INLINE void
util_format_b10g10r10a2_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         b = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         r = (value >> 20) & 0x3ff;
         a = value >> 30;
         dst[0] = (uint8_t)(r >> 2); /* r */
         dst[1] = (uint8_t)(g >> 2); /* g */
         dst[2] = (uint8_t)(b >> 2); /* b */
         dst[3] = (uint8_t)(((uint32_t)a) * 0xff / 0x3); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_b10g10r10a2_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= ((uint32_t)(((uint32_t)src[2]) * 0x3ff / 0xff)) & 0x3ff;
         value |= (((uint32_t)(((uint32_t)src[1]) * 0x3ff / 0xff)) & 0x3ff) << 10;
         value |= (((uint32_t)(((uint32_t)src[0]) * 0x3ff / 0xff)) & 0x3ff) << 20;
         value |= ((uint32_t)(src[3] >> 6)) << 30;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b2g3r3_unorm {
   uint8_t value;
   struct {
      unsigned b:2;
      unsigned g:3;
      unsigned r:3;
   } chan;
};

static INLINE void
util_format_b2g3r3_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t b;
         uint8_t g;
         uint8_t r;
         b = (value) & 0x3;
         g = (value >> 2) & 0x7;
         r = value >> 5;
         dst[0] = (float)(r * (1.0f/0x7)); /* r */
         dst[1] = (float)(g * (1.0f/0x7)); /* g */
         dst[2] = (float)(b * (1.0f/0x3)); /* b */
         dst[3] = 1; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_b2g3r3_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= ((uint8_t)(CLAMP(src[2], 0, 1) * 0x3)) & 0x3;
         value |= (((uint8_t)(CLAMP(src[1], 0, 1) * 0x7)) & 0x7) << 2;
         value |= ((uint8_t)(CLAMP(src[0], 0, 1) * 0x7)) << 5;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_b2g3r3_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         uint8_t b;
         uint8_t g;
         uint8_t r;
         b = (value) & 0x3;
         g = (value >> 2) & 0x7;
         r = value >> 5;
         dst[0] = (float)(r * (1.0f/0x7)); /* r */
         dst[1] = (float)(g * (1.0f/0x7)); /* g */
         dst[2] = (float)(b * (1.0f/0x3)); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_b2g3r3_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t b;
         uint8_t g;
         uint8_t r;
         b = (value) & 0x3;
         g = (value >> 2) & 0x7;
         r = value >> 5;
         dst[0] = (uint8_t)(((uint32_t)r) * 0xff / 0x7); /* r */
         dst[1] = (uint8_t)(((uint32_t)g) * 0xff / 0x7); /* g */
         dst[2] = (uint8_t)(((uint32_t)b) * 0xff / 0x3); /* b */
         dst[3] = 255; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_b2g3r3_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= ((uint8_t)(src[2] >> 6)) & 0x3;
         value |= (((uint8_t)(src[1] >> 5)) & 0x7) << 2;
         value |= ((uint8_t)(src[0] >> 5)) << 5;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l8_unorm {
   uint8_t value;
   struct {
      uint8_t rgb;
   } chan;
};

static INLINE void
util_format_l8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgb;
         rgb = value;
         dst[0] = ubyte_to_float(rgb); /* r */
         dst[1] = ubyte_to_float(rgb); /* g */
         dst[2] = ubyte_to_float(rgb); /* b */
         dst[3] = 1; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= float_to_ubyte(src[2]);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_l8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgb;
         rgb = value;
         dst[0] = ubyte_to_float(rgb); /* r */
         dst[1] = ubyte_to_float(rgb); /* g */
         dst[2] = ubyte_to_float(rgb); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_l8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgb;
         rgb = value;
         dst[0] = rgb; /* r */
         dst[1] = rgb; /* g */
         dst[2] = rgb; /* b */
         dst[3] = 255; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= src[2];
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a8_unorm {
   uint8_t value;
   struct {
      uint8_t a;
   } chan;
};

static INLINE void
util_format_a8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t a;
         a = value;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = ubyte_to_float(a); /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_a8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= float_to_ubyte(src[3]);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_a8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         uint8_t a;
         a = value;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = ubyte_to_float(a); /* a */
}

static INLINE void
util_format_a8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t a;
         a = value;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = a; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_a8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= src[3];
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_i8_unorm {
   uint8_t value;
   struct {
      uint8_t rgba;
   } chan;
};

static INLINE void
util_format_i8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgba;
         rgba = value;
         dst[0] = ubyte_to_float(rgba); /* r */
         dst[1] = ubyte_to_float(rgba); /* g */
         dst[2] = ubyte_to_float(rgba); /* b */
         dst[3] = ubyte_to_float(rgba); /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_i8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= float_to_ubyte(src[3]);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_i8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgba;
         rgba = value;
         dst[0] = ubyte_to_float(rgba); /* r */
         dst[1] = ubyte_to_float(rgba); /* g */
         dst[2] = ubyte_to_float(rgba); /* b */
         dst[3] = ubyte_to_float(rgba); /* a */
}

static INLINE void
util_format_i8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgba;
         rgba = value;
         dst[0] = rgba; /* r */
         dst[1] = rgba; /* g */
         dst[2] = rgba; /* b */
         dst[3] = rgba; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_i8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= src[3];
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l4a4_unorm {
   uint8_t value;
   struct {
      unsigned rgb:4;
      unsigned a:4;
   } chan;
};

static INLINE void
util_format_l4a4_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgb;
         uint8_t a;
         rgb = (value) & 0xf;
         a = value >> 4;
         dst[0] = (float)(rgb * (1.0f/0xf)); /* r */
         dst[1] = (float)(rgb * (1.0f/0xf)); /* g */
         dst[2] = (float)(rgb * (1.0f/0xf)); /* b */
         dst[3] = (float)(a * (1.0f/0xf)); /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l4a4_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= ((uint8_t)(CLAMP(src[2], 0, 1) * 0xf)) & 0xf;
         value |= ((uint8_t)(CLAMP(src[3], 0, 1) * 0xf)) << 4;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_l4a4_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgb;
         uint8_t a;
         rgb = (value) & 0xf;
         a = value >> 4;
         dst[0] = (float)(rgb * (1.0f/0xf)); /* r */
         dst[1] = (float)(rgb * (1.0f/0xf)); /* g */
         dst[2] = (float)(rgb * (1.0f/0xf)); /* b */
         dst[3] = (float)(a * (1.0f/0xf)); /* a */
}

static INLINE void
util_format_l4a4_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgb;
         uint8_t a;
         rgb = (value) & 0xf;
         a = value >> 4;
         dst[0] = (uint8_t)(((uint32_t)rgb) * 0xff / 0xf); /* r */
         dst[1] = (uint8_t)(((uint32_t)rgb) * 0xff / 0xf); /* g */
         dst[2] = (uint8_t)(((uint32_t)rgb) * 0xff / 0xf); /* b */
         dst[3] = (uint8_t)(((uint32_t)a) * 0xff / 0xf); /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l4a4_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= ((uint8_t)(src[2] >> 4)) & 0xf;
         value |= ((uint8_t)(src[3] >> 4)) << 4;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l8a8_unorm {
   uint16_t value;
   struct {
      uint8_t rgb;
      uint8_t a;
   } chan;
};

static INLINE void
util_format_l8a8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         uint16_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         rgb = (value) & 0xff;
         a = value >> 8;
         dst[0] = ubyte_to_float(rgb); /* r */
         dst[1] = ubyte_to_float(rgb); /* g */
         dst[2] = ubyte_to_float(rgb); /* b */
         dst[3] = ubyte_to_float(a); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l8a8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (float_to_ubyte(src[2])) & 0xff;
         value |= (float_to_ubyte(src[3])) << 8;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_l8a8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         uint16_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         rgb = (value) & 0xff;
         a = value >> 8;
         dst[0] = ubyte_to_float(rgb); /* r */
         dst[1] = ubyte_to_float(rgb); /* g */
         dst[2] = ubyte_to_float(rgb); /* b */
         dst[3] = ubyte_to_float(a); /* a */
}

static INLINE void
util_format_l8a8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         uint16_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         rgb = (value) & 0xff;
         a = value >> 8;
         dst[0] = rgb; /* r */
         dst[1] = rgb; /* g */
         dst[2] = rgb; /* b */
         dst[3] = a; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l8a8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (src[2]) & 0xff;
         value |= (src[3]) << 8;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l16_unorm {
   uint16_t value;
   struct {
      uint16_t rgb;
   } chan;
};

static INLINE void
util_format_l16_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         rgb = value;
         dst[0] = (float)(rgb * (1.0f/0xffff)); /* r */
         dst[1] = (float)(rgb * (1.0f/0xffff)); /* g */
         dst[2] = (float)(rgb * (1.0f/0xffff)); /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l16_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)(CLAMP(src[2], 0, 1) * 0xffff);
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_l16_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         rgb = value;
         dst[0] = (float)(rgb * (1.0f/0xffff)); /* r */
         dst[1] = (float)(rgb * (1.0f/0xffff)); /* g */
         dst[2] = (float)(rgb * (1.0f/0xffff)); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_l16_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         rgb = value;
         dst[0] = (uint8_t)(rgb >> 8); /* r */
         dst[1] = (uint8_t)(rgb >> 8); /* g */
         dst[2] = (uint8_t)(rgb >> 8); /* b */
         dst[3] = 255; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l16_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)(((uint32_t)src[2]) * 0xffff / 0xff);
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a16_unorm {
   uint16_t value;
   struct {
      uint16_t a;
   } chan;
};

static INLINE void
util_format_a16_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         a = value;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0xffff)); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_a16_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)(CLAMP(src[3], 0, 1) * 0xffff);
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_a16_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         uint16_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         a = value;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0xffff)); /* a */
}

static INLINE void
util_format_a16_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         a = value;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (uint8_t)(a >> 8); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_a16_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)(((uint32_t)src[3]) * 0xffff / 0xff);
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_i16_unorm {
   uint16_t value;
   struct {
      uint16_t rgba;
   } chan;
};

static INLINE void
util_format_i16_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgba;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         rgba = value;
         dst[0] = (float)(rgba * (1.0f/0xffff)); /* r */
         dst[1] = (float)(rgba * (1.0f/0xffff)); /* g */
         dst[2] = (float)(rgba * (1.0f/0xffff)); /* b */
         dst[3] = (float)(rgba * (1.0f/0xffff)); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_i16_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)(CLAMP(src[3], 0, 1) * 0xffff);
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_i16_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgba;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         rgba = value;
         dst[0] = (float)(rgba * (1.0f/0xffff)); /* r */
         dst[1] = (float)(rgba * (1.0f/0xffff)); /* g */
         dst[2] = (float)(rgba * (1.0f/0xffff)); /* b */
         dst[3] = (float)(rgba * (1.0f/0xffff)); /* a */
}

static INLINE void
util_format_i16_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgba;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         rgba = value;
         dst[0] = (uint8_t)(rgba >> 8); /* r */
         dst[1] = (uint8_t)(rgba >> 8); /* g */
         dst[2] = (uint8_t)(rgba >> 8); /* b */
         dst[3] = (uint8_t)(rgba >> 8); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_i16_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)(((uint32_t)src[3]) * 0xffff / 0xff);
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l16a16_unorm {
   uint32_t value;
   struct {
      uint16_t rgb;
      uint16_t a;
   } chan;
};

static INLINE void
util_format_l16a16_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t rgb;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         rgb = (value) & 0xffff;
         a = value >> 16;
         dst[0] = (float)(rgb * (1.0f/0xffff)); /* r */
         dst[1] = (float)(rgb * (1.0f/0xffff)); /* g */
         dst[2] = (float)(rgb * (1.0f/0xffff)); /* b */
         dst[3] = (float)(a * (1.0f/0xffff)); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l16a16_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= ((uint16_t)(CLAMP(src[2], 0, 1) * 0xffff)) & 0xffff;
         value |= ((uint16_t)(CLAMP(src[3], 0, 1) * 0xffff)) << 16;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_l16a16_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t rgb;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         rgb = (value) & 0xffff;
         a = value >> 16;
         dst[0] = (float)(rgb * (1.0f/0xffff)); /* r */
         dst[1] = (float)(rgb * (1.0f/0xffff)); /* g */
         dst[2] = (float)(rgb * (1.0f/0xffff)); /* b */
         dst[3] = (float)(a * (1.0f/0xffff)); /* a */
}

static INLINE void
util_format_l16a16_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t rgb;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         rgb = (value) & 0xffff;
         a = value >> 16;
         dst[0] = (uint8_t)(rgb >> 8); /* r */
         dst[1] = (uint8_t)(rgb >> 8); /* g */
         dst[2] = (uint8_t)(rgb >> 8); /* b */
         dst[3] = (uint8_t)(a >> 8); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l16a16_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= ((uint16_t)(((uint32_t)src[2]) * 0xffff / 0xff)) & 0xffff;
         value |= ((uint16_t)(((uint32_t)src[3]) * 0xffff / 0xff)) << 16;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a8_snorm {
   uint8_t value;
   struct {
      int8_t a;
   } chan;
};

static INLINE void
util_format_a8_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t a;
         a = (int8_t)(value) ;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0x7f)); /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_a8_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)(CLAMP(src[3], -1, 1) * 0x7f)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_a8_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         int8_t a;
         a = (int8_t)(value) ;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0x7f)); /* a */
}

static INLINE void
util_format_a8_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t a;
         a = (int8_t)(value) ;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (uint8_t)(((uint32_t)MAX2(a, 0)) * 0xff / 0x7f); /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_a8_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)(src[3] >> 1)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l8_snorm {
   uint8_t value;
   struct {
      int8_t rgb;
   } chan;
};

static INLINE void
util_format_l8_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t rgb;
         rgb = (int8_t)(value) ;
         dst[0] = (float)(rgb * (1.0f/0x7f)); /* r */
         dst[1] = (float)(rgb * (1.0f/0x7f)); /* g */
         dst[2] = (float)(rgb * (1.0f/0x7f)); /* b */
         dst[3] = 1; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l8_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)(CLAMP(src[2], -1, 1) * 0x7f)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_l8_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         int8_t rgb;
         rgb = (int8_t)(value) ;
         dst[0] = (float)(rgb * (1.0f/0x7f)); /* r */
         dst[1] = (float)(rgb * (1.0f/0x7f)); /* g */
         dst[2] = (float)(rgb * (1.0f/0x7f)); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_l8_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t rgb;
         rgb = (int8_t)(value) ;
         dst[0] = (uint8_t)(((uint32_t)MAX2(rgb, 0)) * 0xff / 0x7f); /* r */
         dst[1] = (uint8_t)(((uint32_t)MAX2(rgb, 0)) * 0xff / 0x7f); /* g */
         dst[2] = (uint8_t)(((uint32_t)MAX2(rgb, 0)) * 0xff / 0x7f); /* b */
         dst[3] = 255; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l8_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)(src[2] >> 1)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l8a8_snorm {
   uint16_t value;
   struct {
      int8_t rgb;
      int8_t a;
   } chan;
};

static INLINE void
util_format_l8a8_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t rgb;
         int16_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         rgb = ((int16_t)(value << 8) ) >> 8;
         a = ((int16_t)(value) ) >> 8;
         dst[0] = (float)(rgb * (1.0f/0x7f)); /* r */
         dst[1] = (float)(rgb * (1.0f/0x7f)); /* g */
         dst[2] = (float)(rgb * (1.0f/0x7f)); /* b */
         dst[3] = (float)(a * (1.0f/0x7f)); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l8a8_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)(CLAMP(src[2], -1, 1) * 0x7f)) & 0xff) ;
         value |= (uint16_t)(((int8_t)(CLAMP(src[3], -1, 1) * 0x7f)) << 8) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_l8a8_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         int16_t rgb;
         int16_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         rgb = ((int16_t)(value << 8) ) >> 8;
         a = ((int16_t)(value) ) >> 8;
         dst[0] = (float)(rgb * (1.0f/0x7f)); /* r */
         dst[1] = (float)(rgb * (1.0f/0x7f)); /* g */
         dst[2] = (float)(rgb * (1.0f/0x7f)); /* b */
         dst[3] = (float)(a * (1.0f/0x7f)); /* a */
}

static INLINE void
util_format_l8a8_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t rgb;
         int16_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         rgb = ((int16_t)(value << 8) ) >> 8;
         a = ((int16_t)(value) ) >> 8;
         dst[0] = (uint8_t)(((uint32_t)MAX2(rgb, 0)) * 0xff / 0x7f); /* r */
         dst[1] = (uint8_t)(((uint32_t)MAX2(rgb, 0)) * 0xff / 0x7f); /* g */
         dst[2] = (uint8_t)(((uint32_t)MAX2(rgb, 0)) * 0xff / 0x7f); /* b */
         dst[3] = (uint8_t)(((uint32_t)MAX2(a, 0)) * 0xff / 0x7f); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l8a8_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)(src[2] >> 1)) & 0xff) ;
         value |= (uint16_t)(((int8_t)(src[3] >> 1)) << 8) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_i8_snorm {
   uint8_t value;
   struct {
      int8_t rgba;
   } chan;
};

static INLINE void
util_format_i8_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t rgba;
         rgba = (int8_t)(value) ;
         dst[0] = (float)(rgba * (1.0f/0x7f)); /* r */
         dst[1] = (float)(rgba * (1.0f/0x7f)); /* g */
         dst[2] = (float)(rgba * (1.0f/0x7f)); /* b */
         dst[3] = (float)(rgba * (1.0f/0x7f)); /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_i8_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)(CLAMP(src[3], -1, 1) * 0x7f)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_i8_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         int8_t rgba;
         rgba = (int8_t)(value) ;
         dst[0] = (float)(rgba * (1.0f/0x7f)); /* r */
         dst[1] = (float)(rgba * (1.0f/0x7f)); /* g */
         dst[2] = (float)(rgba * (1.0f/0x7f)); /* b */
         dst[3] = (float)(rgba * (1.0f/0x7f)); /* a */
}

static INLINE void
util_format_i8_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t rgba;
         rgba = (int8_t)(value) ;
         dst[0] = (uint8_t)(((uint32_t)MAX2(rgba, 0)) * 0xff / 0x7f); /* r */
         dst[1] = (uint8_t)(((uint32_t)MAX2(rgba, 0)) * 0xff / 0x7f); /* g */
         dst[2] = (uint8_t)(((uint32_t)MAX2(rgba, 0)) * 0xff / 0x7f); /* b */
         dst[3] = (uint8_t)(((uint32_t)MAX2(rgba, 0)) * 0xff / 0x7f); /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_i8_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)(src[3] >> 1)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a16_snorm {
   uint16_t value;
   struct {
      int16_t a;
   } chan;
};

static INLINE void
util_format_a16_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         a = (int16_t)(value) ;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0x7fff)); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_a16_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)(CLAMP(src[3], -1, 1) * 0x7fff)) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_a16_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         int16_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         a = (int16_t)(value) ;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (float)(a * (1.0f/0x7fff)); /* a */
}

static INLINE void
util_format_a16_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         a = (int16_t)(value) ;
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = (uint8_t)(MAX2(a, 0) >> 7); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_a16_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)(((uint32_t)src[3]) * 0x7fff / 0xff)) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l16_snorm {
   uint16_t value;
   struct {
      int16_t rgb;
   } chan;
};

static INLINE void
util_format_l16_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t rgb;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         rgb = (int16_t)(value) ;
         dst[0] = (float)(rgb * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(rgb * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(rgb * (1.0f/0x7fff)); /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l16_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)(CLAMP(src[2], -1, 1) * 0x7fff)) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_l16_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         int16_t rgb;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         rgb = (int16_t)(value) ;
         dst[0] = (float)(rgb * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(rgb * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(rgb * (1.0f/0x7fff)); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_l16_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t rgb;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         rgb = (int16_t)(value) ;
         dst[0] = (uint8_t)(MAX2(rgb, 0) >> 7); /* r */
         dst[1] = (uint8_t)(MAX2(rgb, 0) >> 7); /* g */
         dst[2] = (uint8_t)(MAX2(rgb, 0) >> 7); /* b */
         dst[3] = 255; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l16_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)(((uint32_t)src[2]) * 0x7fff / 0xff)) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l16a16_snorm {
   uint32_t value;
   struct {
      int16_t rgb;
      int16_t a;
   } chan;
};

static INLINE void
util_format_l16a16_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t rgb;
         int32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         rgb = ((int32_t)(value << 16) ) >> 16;
         a = ((int32_t)(value) ) >> 16;
         dst[0] = (float)(rgb * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(rgb * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(rgb * (1.0f/0x7fff)); /* b */
         dst[3] = (float)(a * (1.0f/0x7fff)); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l16a16_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)(CLAMP(src[2], -1, 1) * 0x7fff)) & 0xffff) ;
         value |= (uint32_t)(((int16_t)(CLAMP(src[3], -1, 1) * 0x7fff)) << 16) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_l16a16_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         int32_t rgb;
         int32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         rgb = ((int32_t)(value << 16) ) >> 16;
         a = ((int32_t)(value) ) >> 16;
         dst[0] = (float)(rgb * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(rgb * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(rgb * (1.0f/0x7fff)); /* b */
         dst[3] = (float)(a * (1.0f/0x7fff)); /* a */
}

static INLINE void
util_format_l16a16_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t rgb;
         int32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         rgb = ((int32_t)(value << 16) ) >> 16;
         a = ((int32_t)(value) ) >> 16;
         dst[0] = (uint8_t)(MAX2(rgb, 0) >> 7); /* r */
         dst[1] = (uint8_t)(MAX2(rgb, 0) >> 7); /* g */
         dst[2] = (uint8_t)(MAX2(rgb, 0) >> 7); /* b */
         dst[3] = (uint8_t)(MAX2(a, 0) >> 7); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l16a16_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)(((uint32_t)src[2]) * 0x7fff / 0xff)) & 0xffff) ;
         value |= (uint32_t)(((int16_t)(((uint32_t)src[3]) * 0x7fff / 0xff)) << 16) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_i16_snorm {
   uint16_t value;
   struct {
      int16_t rgba;
   } chan;
};

static INLINE void
util_format_i16_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t rgba;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         rgba = (int16_t)(value) ;
         dst[0] = (float)(rgba * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(rgba * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(rgba * (1.0f/0x7fff)); /* b */
         dst[3] = (float)(rgba * (1.0f/0x7fff)); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_i16_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)(CLAMP(src[3], -1, 1) * 0x7fff)) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_i16_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         int16_t rgba;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         rgba = (int16_t)(value) ;
         dst[0] = (float)(rgba * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(rgba * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(rgba * (1.0f/0x7fff)); /* b */
         dst[3] = (float)(rgba * (1.0f/0x7fff)); /* a */
}

static INLINE void
util_format_i16_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t rgba;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         rgba = (int16_t)(value) ;
         dst[0] = (uint8_t)(MAX2(rgba, 0) >> 7); /* r */
         dst[1] = (uint8_t)(MAX2(rgba, 0) >> 7); /* g */
         dst[2] = (uint8_t)(MAX2(rgba, 0) >> 7); /* b */
         dst[3] = (uint8_t)(MAX2(rgba, 0) >> 7); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_i16_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)(((uint32_t)src[3]) * 0x7fff / 0xff)) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a16_float {
   uint16_t value;
   struct {
      uint16_t a;
   } chan;
};

static INLINE void
util_format_a16_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = util_half_to_float(pixel.chan.a); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_a16_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_a16_float pixel;
         pixel.chan.a = util_float_to_half(src[3]);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_a16_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = util_half_to_float(pixel.chan.a); /* a */
}

static INLINE void
util_format_a16_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = float_to_ubyte(util_half_to_float(pixel.chan.a)); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_a16_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_a16_float pixel;
         pixel.chan.a = util_float_to_half((float)(src[3] * (1.0f/0xff)));
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l16_float {
   uint16_t value;
   struct {
      uint16_t rgb;
   } chan;
};

static INLINE void
util_format_l16_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_l16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.rgb); /* r */
         dst[1] = util_half_to_float(pixel.chan.rgb); /* g */
         dst[2] = util_half_to_float(pixel.chan.rgb); /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l16_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_l16_float pixel;
         pixel.chan.rgb = util_float_to_half(src[2]);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_l16_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_l16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.rgb); /* r */
         dst[1] = util_half_to_float(pixel.chan.rgb); /* g */
         dst[2] = util_half_to_float(pixel.chan.rgb); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_l16_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_l16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(util_half_to_float(pixel.chan.rgb)); /* r */
         dst[1] = float_to_ubyte(util_half_to_float(pixel.chan.rgb)); /* g */
         dst[2] = float_to_ubyte(util_half_to_float(pixel.chan.rgb)); /* b */
         dst[3] = 255; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l16_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_l16_float pixel;
         pixel.chan.rgb = util_float_to_half((float)(src[2] * (1.0f/0xff)));
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l16a16_float {
   uint32_t value;
   struct {
      uint16_t rgb;
      uint16_t a;
   } chan;
};

static INLINE void
util_format_l16a16_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_l16a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.rgb); /* r */
         dst[1] = util_half_to_float(pixel.chan.rgb); /* g */
         dst[2] = util_half_to_float(pixel.chan.rgb); /* b */
         dst[3] = util_half_to_float(pixel.chan.a); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l16a16_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_l16a16_float pixel;
         pixel.chan.rgb = util_float_to_half(src[2]);
         pixel.chan.a = util_float_to_half(src[3]);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_l16a16_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_l16a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.rgb); /* r */
         dst[1] = util_half_to_float(pixel.chan.rgb); /* g */
         dst[2] = util_half_to_float(pixel.chan.rgb); /* b */
         dst[3] = util_half_to_float(pixel.chan.a); /* a */
}

static INLINE void
util_format_l16a16_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_l16a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(util_half_to_float(pixel.chan.rgb)); /* r */
         dst[1] = float_to_ubyte(util_half_to_float(pixel.chan.rgb)); /* g */
         dst[2] = float_to_ubyte(util_half_to_float(pixel.chan.rgb)); /* b */
         dst[3] = float_to_ubyte(util_half_to_float(pixel.chan.a)); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l16a16_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_l16a16_float pixel;
         pixel.chan.rgb = util_float_to_half((float)(src[2] * (1.0f/0xff)));
         pixel.chan.a = util_float_to_half((float)(src[3] * (1.0f/0xff)));
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_i16_float {
   uint16_t value;
   struct {
      uint16_t rgba;
   } chan;
};

static INLINE void
util_format_i16_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_i16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.rgba); /* r */
         dst[1] = util_half_to_float(pixel.chan.rgba); /* g */
         dst[2] = util_half_to_float(pixel.chan.rgba); /* b */
         dst[3] = util_half_to_float(pixel.chan.rgba); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_i16_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_i16_float pixel;
         pixel.chan.rgba = util_float_to_half(src[3]);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_i16_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_i16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.rgba); /* r */
         dst[1] = util_half_to_float(pixel.chan.rgba); /* g */
         dst[2] = util_half_to_float(pixel.chan.rgba); /* b */
         dst[3] = util_half_to_float(pixel.chan.rgba); /* a */
}

static INLINE void
util_format_i16_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_i16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(util_half_to_float(pixel.chan.rgba)); /* r */
         dst[1] = float_to_ubyte(util_half_to_float(pixel.chan.rgba)); /* g */
         dst[2] = float_to_ubyte(util_half_to_float(pixel.chan.rgba)); /* b */
         dst[3] = float_to_ubyte(util_half_to_float(pixel.chan.rgba)); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_i16_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_i16_float pixel;
         pixel.chan.rgba = util_float_to_half((float)(src[3] * (1.0f/0xff)));
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a32_float {
   uint32_t value;
   struct {
      float a;
   } chan;
};

static INLINE void
util_format_a32_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = pixel.chan.a; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_a32_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_a32_float pixel;
         pixel.chan.a = src[3];
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_a32_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = pixel.chan.a; /* a */
}

static INLINE void
util_format_a32_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = 0; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = float_to_ubyte(pixel.chan.a); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_a32_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_a32_float pixel;
         pixel.chan.a = ubyte_to_float(src[3]);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l32_float {
   uint32_t value;
   struct {
      float rgb;
   } chan;
};

static INLINE void
util_format_l32_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_l32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.rgb; /* r */
         dst[1] = pixel.chan.rgb; /* g */
         dst[2] = pixel.chan.rgb; /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l32_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_l32_float pixel;
         pixel.chan.rgb = src[2];
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_l32_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_l32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.rgb; /* r */
         dst[1] = pixel.chan.rgb; /* g */
         dst[2] = pixel.chan.rgb; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_l32_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_l32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(pixel.chan.rgb); /* r */
         dst[1] = float_to_ubyte(pixel.chan.rgb); /* g */
         dst[2] = float_to_ubyte(pixel.chan.rgb); /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l32_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_l32_float pixel;
         pixel.chan.rgb = ubyte_to_float(src[2]);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l32a32_float {
   uint64_t value;
   struct {
      float rgb;
      float a;
   } chan;
};

static INLINE void
util_format_l32a32_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_l32a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.rgb; /* r */
         dst[1] = pixel.chan.rgb; /* g */
         dst[2] = pixel.chan.rgb; /* b */
         dst[3] = pixel.chan.a; /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l32a32_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_l32a32_float pixel;
         pixel.chan.rgb = src[2];
         pixel.chan.a = src[3];
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_l32a32_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_l32a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.rgb; /* r */
         dst[1] = pixel.chan.rgb; /* g */
         dst[2] = pixel.chan.rgb; /* b */
         dst[3] = pixel.chan.a; /* a */
}

static INLINE void
util_format_l32a32_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_l32a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(pixel.chan.rgb); /* r */
         dst[1] = float_to_ubyte(pixel.chan.rgb); /* g */
         dst[2] = float_to_ubyte(pixel.chan.rgb); /* b */
         dst[3] = float_to_ubyte(pixel.chan.a); /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l32a32_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_l32a32_float pixel;
         pixel.chan.rgb = ubyte_to_float(src[2]);
         pixel.chan.a = ubyte_to_float(src[3]);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_i32_float {
   uint32_t value;
   struct {
      float rgba;
   } chan;
};

static INLINE void
util_format_i32_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_i32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.rgba; /* r */
         dst[1] = pixel.chan.rgba; /* g */
         dst[2] = pixel.chan.rgba; /* b */
         dst[3] = pixel.chan.rgba; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_i32_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_i32_float pixel;
         pixel.chan.rgba = src[3];
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_i32_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_i32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.rgba; /* r */
         dst[1] = pixel.chan.rgba; /* g */
         dst[2] = pixel.chan.rgba; /* b */
         dst[3] = pixel.chan.rgba; /* a */
}

static INLINE void
util_format_i32_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_i32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(pixel.chan.rgba); /* r */
         dst[1] = float_to_ubyte(pixel.chan.rgba); /* g */
         dst[2] = float_to_ubyte(pixel.chan.rgba); /* b */
         dst[3] = float_to_ubyte(pixel.chan.rgba); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_i32_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_i32_float pixel;
         pixel.chan.rgba = ubyte_to_float(src[3]);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l8_srgb {
   uint8_t value;
   struct {
      uint8_t rgb;
   } chan;
};

static INLINE void
util_format_l8_srgb_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgb;
         rgb = value;
         dst[0] = util_format_srgb_8unorm_to_linear_float(rgb); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(rgb); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(rgb); /* b */
         dst[3] = 1; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l8_srgb_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= util_format_linear_float_to_srgb_8unorm(src[2]);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_l8_srgb_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgb;
         rgb = value;
         dst[0] = util_format_srgb_8unorm_to_linear_float(rgb); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(rgb); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(rgb); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_l8_srgb_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t rgb;
         rgb = value;
         dst[0] = util_format_srgb_to_linear_8unorm(rgb); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(rgb); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(rgb); /* b */
         dst[3] = 255; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l8_srgb_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= util_format_linear_to_srgb_8unorm(src[2]);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_l8a8_srgb {
   uint16_t value;
   struct {
      uint8_t rgb;
      uint8_t a;
   } chan;
};

static INLINE void
util_format_l8a8_srgb_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         uint16_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         rgb = (value) & 0xff;
         a = value >> 8;
         dst[0] = util_format_srgb_8unorm_to_linear_float(rgb); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(rgb); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(rgb); /* b */
         dst[3] = ubyte_to_float(a); /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l8a8_srgb_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (util_format_linear_float_to_srgb_8unorm(src[2])) & 0xff;
         value |= (float_to_ubyte(src[3])) << 8;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_l8a8_srgb_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         uint16_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         rgb = (value) & 0xff;
         a = value >> 8;
         dst[0] = util_format_srgb_8unorm_to_linear_float(rgb); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(rgb); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(rgb); /* b */
         dst[3] = ubyte_to_float(a); /* a */
}

static INLINE void
util_format_l8a8_srgb_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t rgb;
         uint16_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         rgb = (value) & 0xff;
         a = value >> 8;
         dst[0] = util_format_srgb_to_linear_8unorm(rgb); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(rgb); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(rgb); /* b */
         dst[3] = a; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_l8a8_srgb_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (util_format_linear_to_srgb_8unorm(src[2])) & 0xff;
         value |= (src[3]) << 8;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8_srgb {
   struct {
      uint8_t r;
      uint8_t g;
      uint8_t b;
   } chan;
};

static INLINE void
util_format_r8g8b8_srgb_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r8g8b8_srgb pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_format_srgb_8unorm_to_linear_float(pixel.chan.r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(pixel.chan.g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(pixel.chan.b); /* b */
         dst[3] = 1; /* a */
         src += 3;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8b8_srgb_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r8g8b8_srgb pixel;
         pixel.chan.r = util_format_linear_float_to_srgb_8unorm(src[0]);
         pixel.chan.g = util_format_linear_float_to_srgb_8unorm(src[1]);
         pixel.chan.b = util_format_linear_float_to_srgb_8unorm(src[2]);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 3;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r8g8b8_srgb_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r8g8b8_srgb pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_format_srgb_8unorm_to_linear_float(pixel.chan.r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(pixel.chan.g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(pixel.chan.b); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r8g8b8_srgb_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r8g8b8_srgb pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_format_srgb_to_linear_8unorm(pixel.chan.r); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(pixel.chan.g); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(pixel.chan.b); /* b */
         dst[3] = 255; /* a */
         src += 3;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8b8_srgb_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r8g8b8_srgb pixel;
         pixel.chan.r = util_format_linear_to_srgb_8unorm(src[0]);
         pixel.chan.g = util_format_linear_to_srgb_8unorm(src[1]);
         pixel.chan.b = util_format_linear_to_srgb_8unorm(src[2]);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 3;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8a8_srgb {
   uint32_t value;
   struct {
      uint8_t r;
      uint8_t g;
      uint8_t b;
      uint8_t a;
   } chan;
};

static INLINE void
util_format_r8g8b8a8_srgb_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8b8a8_srgb_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (util_format_linear_float_to_srgb_8unorm(src[0])) & 0xff;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[1])) & 0xff) << 8;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[2])) & 0xff) << 16;
         value |= (float_to_ubyte(src[3])) << 24;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r8g8b8a8_srgb_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
}

static INLINE void
util_format_r8g8b8a8_srgb_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = util_format_srgb_to_linear_8unorm(r); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(g); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(b); /* b */
         dst[3] = a; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8b8a8_srgb_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (util_format_linear_to_srgb_8unorm(src[0])) & 0xff;
         value |= ((util_format_linear_to_srgb_8unorm(src[1])) & 0xff) << 8;
         value |= ((util_format_linear_to_srgb_8unorm(src[2])) & 0xff) << 16;
         value |= (src[3]) << 24;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a8b8g8r8_srgb {
   uint32_t value;
   struct {
      uint8_t a;
      uint8_t b;
      uint8_t g;
      uint8_t r;
   } chan;
};

static INLINE void
util_format_a8b8g8r8_srgb_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t b;
         uint32_t g;
         uint32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         a = (value) & 0xff;
         b = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         r = value >> 24;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_a8b8g8r8_srgb_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (float_to_ubyte(src[3])) & 0xff;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[2])) & 0xff) << 8;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[1])) & 0xff) << 16;
         value |= (util_format_linear_float_to_srgb_8unorm(src[0])) << 24;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_a8b8g8r8_srgb_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t b;
         uint32_t g;
         uint32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         a = (value) & 0xff;
         b = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         r = value >> 24;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
}

static INLINE void
util_format_a8b8g8r8_srgb_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t b;
         uint32_t g;
         uint32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         a = (value) & 0xff;
         b = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         r = value >> 24;
         dst[0] = util_format_srgb_to_linear_8unorm(r); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(g); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(b); /* b */
         dst[3] = a; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_a8b8g8r8_srgb_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (src[3]) & 0xff;
         value |= ((util_format_linear_to_srgb_8unorm(src[2])) & 0xff) << 8;
         value |= ((util_format_linear_to_srgb_8unorm(src[1])) & 0xff) << 16;
         value |= (util_format_linear_to_srgb_8unorm(src[0])) << 24;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_x8b8g8r8_srgb {
   uint32_t value;
   struct {
      uint8_t x;
      uint8_t b;
      uint8_t g;
      uint8_t r;
   } chan;
};

static INLINE void
util_format_x8b8g8r8_srgb_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         b = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         r = value >> 24;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_x8b8g8r8_srgb_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[2])) & 0xff) << 8;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[1])) & 0xff) << 16;
         value |= (util_format_linear_float_to_srgb_8unorm(src[0])) << 24;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_x8b8g8r8_srgb_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         b = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         r = value >> 24;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_x8b8g8r8_srgb_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         b = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         r = value >> 24;
         dst[0] = util_format_srgb_to_linear_8unorm(r); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(g); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(b); /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_x8b8g8r8_srgb_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= ((util_format_linear_to_srgb_8unorm(src[2])) & 0xff) << 8;
         value |= ((util_format_linear_to_srgb_8unorm(src[1])) & 0xff) << 16;
         value |= (util_format_linear_to_srgb_8unorm(src[0])) << 24;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b8g8r8a8_srgb {
   uint32_t value;
   struct {
      uint8_t b;
      uint8_t g;
      uint8_t r;
      uint8_t a;
   } chan;
};

static INLINE void
util_format_b8g8r8a8_srgb_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         b = (value) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_b8g8r8a8_srgb_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (util_format_linear_float_to_srgb_8unorm(src[2])) & 0xff;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[1])) & 0xff) << 8;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[0])) & 0xff) << 16;
         value |= (float_to_ubyte(src[3])) << 24;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_b8g8r8a8_srgb_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         b = (value) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
}

static INLINE void
util_format_b8g8r8a8_srgb_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         b = (value) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = util_format_srgb_to_linear_8unorm(r); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(g); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(b); /* b */
         dst[3] = a; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_b8g8r8a8_srgb_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (util_format_linear_to_srgb_8unorm(src[2])) & 0xff;
         value |= ((util_format_linear_to_srgb_8unorm(src[1])) & 0xff) << 8;
         value |= ((util_format_linear_to_srgb_8unorm(src[0])) & 0xff) << 16;
         value |= (src[3]) << 24;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_b8g8r8x8_srgb {
   uint32_t value;
   struct {
      uint8_t b;
      uint8_t g;
      uint8_t r;
      uint8_t x;
   } chan;
};

static INLINE void
util_format_b8g8r8x8_srgb_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         b = (value) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value >> 16) & 0xff;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_b8g8r8x8_srgb_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (util_format_linear_float_to_srgb_8unorm(src[2])) & 0xff;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[1])) & 0xff) << 8;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[0])) & 0xff) << 16;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_b8g8r8x8_srgb_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         b = (value) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value >> 16) & 0xff;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_b8g8r8x8_srgb_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t b;
         uint32_t g;
         uint32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         b = (value) & 0xff;
         g = (value >> 8) & 0xff;
         r = (value >> 16) & 0xff;
         dst[0] = util_format_srgb_to_linear_8unorm(r); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(g); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(b); /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_b8g8r8x8_srgb_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (util_format_linear_to_srgb_8unorm(src[2])) & 0xff;
         value |= ((util_format_linear_to_srgb_8unorm(src[1])) & 0xff) << 8;
         value |= ((util_format_linear_to_srgb_8unorm(src[0])) & 0xff) << 16;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_a8r8g8b8_srgb {
   uint32_t value;
   struct {
      uint8_t a;
      uint8_t r;
      uint8_t g;
      uint8_t b;
   } chan;
};

static INLINE void
util_format_a8r8g8b8_srgb_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t r;
         uint32_t g;
         uint32_t b;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         a = (value) & 0xff;
         r = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         b = value >> 24;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_a8r8g8b8_srgb_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (float_to_ubyte(src[3])) & 0xff;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[0])) & 0xff) << 8;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[1])) & 0xff) << 16;
         value |= (util_format_linear_float_to_srgb_8unorm(src[2])) << 24;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_a8r8g8b8_srgb_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t r;
         uint32_t g;
         uint32_t b;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         a = (value) & 0xff;
         r = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         b = value >> 24;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
}

static INLINE void
util_format_a8r8g8b8_srgb_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t a;
         uint32_t r;
         uint32_t g;
         uint32_t b;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         a = (value) & 0xff;
         r = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         b = value >> 24;
         dst[0] = util_format_srgb_to_linear_8unorm(r); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(g); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(b); /* b */
         dst[3] = a; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_a8r8g8b8_srgb_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (src[3]) & 0xff;
         value |= ((util_format_linear_to_srgb_8unorm(src[0])) & 0xff) << 8;
         value |= ((util_format_linear_to_srgb_8unorm(src[1])) & 0xff) << 16;
         value |= (util_format_linear_to_srgb_8unorm(src[2])) << 24;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_x8r8g8b8_srgb {
   uint32_t value;
   struct {
      uint8_t x;
      uint8_t r;
      uint8_t g;
      uint8_t b;
   } chan;
};

static INLINE void
util_format_x8r8g8b8_srgb_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         b = value >> 24;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_x8r8g8b8_srgb_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[0])) & 0xff) << 8;
         value |= ((util_format_linear_float_to_srgb_8unorm(src[1])) & 0xff) << 16;
         value |= (util_format_linear_float_to_srgb_8unorm(src[2])) << 24;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_x8r8g8b8_srgb_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         b = value >> 24;
         dst[0] = util_format_srgb_8unorm_to_linear_float(r); /* r */
         dst[1] = util_format_srgb_8unorm_to_linear_float(g); /* g */
         dst[2] = util_format_srgb_8unorm_to_linear_float(b); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_x8r8g8b8_srgb_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value >> 8) & 0xff;
         g = (value >> 16) & 0xff;
         b = value >> 24;
         dst[0] = util_format_srgb_to_linear_8unorm(r); /* r */
         dst[1] = util_format_srgb_to_linear_8unorm(g); /* g */
         dst[2] = util_format_srgb_to_linear_8unorm(b); /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_x8r8g8b8_srgb_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= ((util_format_linear_to_srgb_8unorm(src[0])) & 0xff) << 8;
         value |= ((util_format_linear_to_srgb_8unorm(src[1])) & 0xff) << 16;
         value |= (util_format_linear_to_srgb_8unorm(src[2])) << 24;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8sg8sb8ux8u_norm {
   uint32_t value;
   struct {
      int8_t r;
      int8_t g;
      uint8_t b;
      uint8_t x;
   } chan;
};

static INLINE void
util_format_r8sg8sb8ux8u_norm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         uint32_t b;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = ((int32_t)(value << 24) ) >> 24;
         g = ((int32_t)(value << 16) ) >> 24;
         b = (value >> 16) & 0xff;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(g * (1.0f/0x7f)); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8sg8sb8ux8u_norm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)(((int8_t)(CLAMP(src[0], -1, 1) * 0x7f)) & 0xff) ;
         value |= (uint32_t)((((int8_t)(CLAMP(src[1], -1, 1) * 0x7f)) & 0xff) << 8) ;
         value |= ((float_to_ubyte(src[2])) & 0xff) << 16;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r8sg8sb8ux8u_norm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         uint32_t b;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = ((int32_t)(value << 24) ) >> 24;
         g = ((int32_t)(value << 16) ) >> 24;
         b = (value >> 16) & 0xff;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(g * (1.0f/0x7f)); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r8sg8sb8ux8u_norm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         uint32_t b;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = ((int32_t)(value << 24) ) >> 24;
         g = ((int32_t)(value << 16) ) >> 24;
         b = (value >> 16) & 0xff;
         dst[0] = (uint8_t)(((uint32_t)MAX2(r, 0)) * 0xff / 0x7f); /* r */
         dst[1] = (uint8_t)(((uint32_t)MAX2(g, 0)) * 0xff / 0x7f); /* g */
         dst[2] = b; /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8sg8sb8ux8u_norm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)(((int8_t)(src[0] >> 1)) & 0xff) ;
         value |= (uint32_t)((((int8_t)(src[1] >> 1)) & 0xff) << 8) ;
         value |= ((src[2]) & 0xff) << 16;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r10sg10sb10sa2u_norm {
   uint32_t value;
   struct {
      int r:10;
      int g:10;
      int b:10;
      unsigned a:2;
   } chan;
};

static INLINE void
util_format_r10sg10sb10sa2u_norm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = ((int32_t)(value << 22) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         b = ((int32_t)(value << 2) ) >> 22;
         a = value >> 30;
         dst[0] = (float)(r * (1.0f/0x1ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x1ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x1ff)); /* b */
         dst[3] = (float)(a * (1.0f/0x3)); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r10sg10sb10sa2u_norm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)(CLAMP(src[0], -1, 1) * 0x1ff)) & 0x3ff) ;
         value |= (uint32_t)((((uint32_t)(CLAMP(src[1], -1, 1) * 0x1ff)) & 0x3ff) << 10) ;
         value |= (uint32_t)((((uint32_t)(CLAMP(src[2], -1, 1) * 0x1ff)) & 0x3ff) << 20) ;
         value |= ((uint32_t)(CLAMP(src[3], 0, 1) * 0x3)) << 30;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r10sg10sb10sa2u_norm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = ((int32_t)(value << 22) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         b = ((int32_t)(value << 2) ) >> 22;
         a = value >> 30;
         dst[0] = (float)(r * (1.0f/0x1ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x1ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x1ff)); /* b */
         dst[3] = (float)(a * (1.0f/0x3)); /* a */
}

static INLINE void
util_format_r10sg10sb10sa2u_norm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = ((int32_t)(value << 22) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         b = ((int32_t)(value << 2) ) >> 22;
         a = value >> 30;
         dst[0] = (uint8_t)(MAX2(r, 0) >> 1); /* r */
         dst[1] = (uint8_t)(MAX2(g, 0) >> 1); /* g */
         dst[2] = (uint8_t)(MAX2(b, 0) >> 1); /* b */
         dst[3] = (uint8_t)(((uint32_t)a) * 0xff / 0x3); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r10sg10sb10sa2u_norm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)(((uint32_t)src[0]) * 0x1ff / 0xff)) & 0x3ff) ;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[1]) * 0x1ff / 0xff)) & 0x3ff) << 10) ;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[2]) * 0x1ff / 0xff)) & 0x3ff) << 20) ;
         value |= ((uint32_t)(src[3] >> 6)) << 30;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r5sg5sb6u_norm {
   uint16_t value;
   struct {
      int r:5;
      int g:5;
      unsigned b:6;
   } chan;
};

static INLINE void
util_format_r5sg5sb6u_norm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
         uint16_t b;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         r = ((int16_t)(value << 11) ) >> 11;
         g = ((int16_t)(value << 6) ) >> 11;
         b = value >> 10;
         dst[0] = (float)(r * (1.0f/0xf)); /* r */
         dst[1] = (float)(g * (1.0f/0xf)); /* g */
         dst[2] = (float)(b * (1.0f/0x3f)); /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r5sg5sb6u_norm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)(((uint16_t)(CLAMP(src[0], -1, 1) * 0xf)) & 0x1f) ;
         value |= (uint16_t)((((uint16_t)(CLAMP(src[1], -1, 1) * 0xf)) & 0x1f) << 5) ;
         value |= ((uint16_t)(CLAMP(src[2], 0, 1) * 0x3f)) << 10;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r5sg5sb6u_norm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
         uint16_t b;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         r = ((int16_t)(value << 11) ) >> 11;
         g = ((int16_t)(value << 6) ) >> 11;
         b = value >> 10;
         dst[0] = (float)(r * (1.0f/0xf)); /* r */
         dst[1] = (float)(g * (1.0f/0xf)); /* g */
         dst[2] = (float)(b * (1.0f/0x3f)); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r5sg5sb6u_norm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
         uint16_t b;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         r = ((int16_t)(value << 11) ) >> 11;
         g = ((int16_t)(value << 6) ) >> 11;
         b = value >> 10;
         dst[0] = (uint8_t)(((uint32_t)MAX2(r, 0)) * 0xff / 0xf); /* r */
         dst[1] = (uint8_t)(((uint32_t)MAX2(g, 0)) * 0xff / 0xf); /* g */
         dst[2] = (uint8_t)(((uint32_t)b) * 0xff / 0x3f); /* b */
         dst[3] = 255; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r5sg5sb6u_norm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)(((uint16_t)(src[0] >> 4)) & 0x1f) ;
         value |= (uint16_t)((((uint16_t)(src[1] >> 4)) & 0x1f) << 5) ;
         value |= ((uint16_t)(src[2] >> 2)) << 10;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r10g10b10a2_uscaled {
   uint32_t value;
   struct {
      unsigned r:10;
      unsigned g:10;
      unsigned b:10;
      unsigned a:2;
   } chan;
};

static INLINE void
util_format_r10g10b10a2_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value >> 20) & 0x3ff;
         a = value >> 30;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r10g10b10a2_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= ((uint32_t)CLAMP(src[0], 0, 1023)) & 0x3ff;
         value |= (((uint32_t)CLAMP(src[1], 0, 1023)) & 0x3ff) << 10;
         value |= (((uint32_t)CLAMP(src[2], 0, 1023)) & 0x3ff) << 20;
         value |= ((uint32_t)CLAMP(src[3], 0, 3)) << 30;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r10g10b10a2_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value >> 20) & 0x3ff;
         a = value >> 30;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
}

static INLINE void
util_format_r10g10b10a2_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value >> 20) & 0x3ff;
         a = value >> 30;
         dst[0] = (uint8_t)(((uint32_t)MIN2(r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)MIN2(g, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)MIN2(b, 1)) * 0xff / 0x1); /* b */
         dst[3] = (uint8_t)(((uint32_t)MIN2(a, 1)) * 0xff / 0x1); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r10g10b10a2_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= ((uint32_t)(((uint32_t)src[0]) * 0x1 / 0xff)) & 0x3ff;
         value |= (((uint32_t)(((uint32_t)src[1]) * 0x1 / 0xff)) & 0x3ff) << 10;
         value |= (((uint32_t)(((uint32_t)src[2]) * 0x1 / 0xff)) & 0x3ff) << 20;
         value |= ((uint32_t)(((uint32_t)src[3]) * 0x1 / 0xff)) << 30;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r64_float {
   uint64_t value;
   struct {
      double r;
   } chan;
};

static INLINE void
util_format_r64_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r64_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r64_float pixel;
         pixel.chan.r = (double)src[0];
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r64_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r64_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(CLAMP(pixel.chan.r, 0, 1) * 0xff); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r64_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r64_float pixel;
         pixel.chan.r = (double)(src[0] * (1.0f/0xff));
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r64g64_float {
   struct {
      double r;
      double g;
   } chan;
};

static INLINE void
util_format_r64g64_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r64g64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r64g64_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r64g64_float pixel;
         pixel.chan.r = (double)src[0];
         pixel.chan.g = (double)src[1];
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r64g64_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r64g64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r64g64_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r64g64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(CLAMP(pixel.chan.r, 0, 1) * 0xff); /* r */
         dst[1] = (uint8_t)(CLAMP(pixel.chan.g, 0, 1) * 0xff); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r64g64_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r64g64_float pixel;
         pixel.chan.r = (double)(src[0] * (1.0f/0xff));
         pixel.chan.g = (double)(src[1] * (1.0f/0xff));
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r64g64b64_float {
   struct {
      double r;
      double g;
      double b;
   } chan;
};

static INLINE void
util_format_r64g64b64_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r64g64b64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
         src += 24;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r64g64b64_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r64g64b64_float pixel;
         pixel.chan.r = (double)src[0];
         pixel.chan.g = (double)src[1];
         pixel.chan.b = (double)src[2];
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 24;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r64g64b64_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r64g64b64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r64g64b64_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r64g64b64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(CLAMP(pixel.chan.r, 0, 1) * 0xff); /* r */
         dst[1] = (uint8_t)(CLAMP(pixel.chan.g, 0, 1) * 0xff); /* g */
         dst[2] = (uint8_t)(CLAMP(pixel.chan.b, 0, 1) * 0xff); /* b */
         dst[3] = 255; /* a */
         src += 24;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r64g64b64_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r64g64b64_float pixel;
         pixel.chan.r = (double)(src[0] * (1.0f/0xff));
         pixel.chan.g = (double)(src[1] * (1.0f/0xff));
         pixel.chan.b = (double)(src[2] * (1.0f/0xff));
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 24;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r64g64b64a64_float {
   struct {
      double r;
      double g;
      double b;
      double a;
   } chan;
};

static INLINE void
util_format_r64g64b64a64_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r64g64b64a64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
         src += 32;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r64g64b64a64_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r64g64b64a64_float pixel;
         pixel.chan.r = (double)src[0];
         pixel.chan.g = (double)src[1];
         pixel.chan.b = (double)src[2];
         pixel.chan.a = (double)src[3];
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 32;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r64g64b64a64_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r64g64b64a64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
}

static INLINE void
util_format_r64g64b64a64_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r64g64b64a64_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(CLAMP(pixel.chan.r, 0, 1) * 0xff); /* r */
         dst[1] = (uint8_t)(CLAMP(pixel.chan.g, 0, 1) * 0xff); /* g */
         dst[2] = (uint8_t)(CLAMP(pixel.chan.b, 0, 1) * 0xff); /* b */
         dst[3] = (uint8_t)(CLAMP(pixel.chan.a, 0, 1) * 0xff); /* a */
         src += 32;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r64g64b64a64_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r64g64b64a64_float pixel;
         pixel.chan.r = (double)(src[0] * (1.0f/0xff));
         pixel.chan.g = (double)(src[1] * (1.0f/0xff));
         pixel.chan.b = (double)(src[2] * (1.0f/0xff));
         pixel.chan.a = (double)(src[3] * (1.0f/0xff));
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 32;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32_float {
   uint32_t value;
   struct {
      float r;
   } chan;
};

static INLINE void
util_format_r32_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32_float pixel;
         pixel.chan.r = src[0];
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r32_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r32_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(pixel.chan.r); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32_float pixel;
         pixel.chan.r = ubyte_to_float(src[0]);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32_float {
   uint64_t value;
   struct {
      float r;
      float g;
   } chan;
};

static INLINE void
util_format_r32g32_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32_float pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r32g32_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r32g32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r32g32_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(pixel.chan.r); /* r */
         dst[1] = float_to_ubyte(pixel.chan.g); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32_float pixel;
         pixel.chan.r = ubyte_to_float(src[0]);
         pixel.chan.g = ubyte_to_float(src[1]);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32_float {
   struct {
      float r;
      float g;
      float b;
   } chan;
};

static INLINE void
util_format_r32g32b32_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 1; /* a */
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32b32_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32_float pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         pixel.chan.b = src[2];
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r32g32b32_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r32g32b32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r32g32b32_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(pixel.chan.r); /* r */
         dst[1] = float_to_ubyte(pixel.chan.g); /* g */
         dst[2] = float_to_ubyte(pixel.chan.b); /* b */
         dst[3] = 255; /* a */
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32b32_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32_float pixel;
         pixel.chan.r = ubyte_to_float(src[0]);
         pixel.chan.g = ubyte_to_float(src[1]);
         pixel.chan.b = ubyte_to_float(src[2]);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32a32_float {
   struct {
      float r;
      float g;
      float b;
      float a;
   } chan;
};

static INLINE void
util_format_r32g32b32a32_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = pixel.chan.a; /* a */
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32b32a32_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32a32_float pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         pixel.chan.b = src[2];
         pixel.chan.a = src[3];
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r32g32b32a32_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r32g32b32a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = pixel.chan.a; /* a */
}

static INLINE void
util_format_r32g32b32a32_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32a32_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(pixel.chan.r); /* r */
         dst[1] = float_to_ubyte(pixel.chan.g); /* g */
         dst[2] = float_to_ubyte(pixel.chan.b); /* b */
         dst[3] = float_to_ubyte(pixel.chan.a); /* a */
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32b32a32_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32a32_float pixel;
         pixel.chan.r = ubyte_to_float(src[0]);
         pixel.chan.g = ubyte_to_float(src[1]);
         pixel.chan.b = ubyte_to_float(src[2]);
         pixel.chan.a = ubyte_to_float(src[3]);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32_unorm {
   uint32_t value;
   struct {
      uint32_t r;
   } chan;
};

static INLINE void
util_format_r32_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = value;
         dst[0] = (float)(r * (1.0/0xffffffff)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)(CLAMP(src[0], 0, 1) * (double)0xffffffff);
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r32_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = value;
         dst[0] = (float)(r * (1.0/0xffffffff)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r32_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = value;
         dst[0] = (uint8_t)(r >> 24); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)(((uint64_t)src[0]) * 0xffffffff / 0xff);
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32_unorm {
   uint64_t value;
   struct {
      uint32_t r;
      uint32_t g;
   } chan;
};

static INLINE void
util_format_r32g32_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0xffffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0xffffffff)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32_unorm pixel;
         pixel.chan.r = (uint32_t)(CLAMP(src[0], 0, 1) * (double)0xffffffff);
         pixel.chan.g = (uint32_t)(CLAMP(src[1], 0, 1) * (double)0xffffffff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r32g32_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r32g32_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0xffffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0xffffffff)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r32g32_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(pixel.chan.r >> 24); /* r */
         dst[1] = (uint8_t)(pixel.chan.g >> 24); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32_unorm pixel;
         pixel.chan.r = (uint32_t)(((uint64_t)src[0]) * 0xffffffff / 0xff);
         pixel.chan.g = (uint32_t)(((uint64_t)src[1]) * 0xffffffff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32_unorm {
   struct {
      uint32_t r;
      uint32_t g;
      uint32_t b;
   } chan;
};

static INLINE void
util_format_r32g32b32_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0xffffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0xffffffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0xffffffff)); /* b */
         dst[3] = 1; /* a */
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32b32_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32_unorm pixel;
         pixel.chan.r = (uint32_t)(CLAMP(src[0], 0, 1) * (double)0xffffffff);
         pixel.chan.g = (uint32_t)(CLAMP(src[1], 0, 1) * (double)0xffffffff);
         pixel.chan.b = (uint32_t)(CLAMP(src[2], 0, 1) * (double)0xffffffff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r32g32b32_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r32g32b32_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0xffffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0xffffffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0xffffffff)); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r32g32b32_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(pixel.chan.r >> 24); /* r */
         dst[1] = (uint8_t)(pixel.chan.g >> 24); /* g */
         dst[2] = (uint8_t)(pixel.chan.b >> 24); /* b */
         dst[3] = 255; /* a */
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32b32_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32_unorm pixel;
         pixel.chan.r = (uint32_t)(((uint64_t)src[0]) * 0xffffffff / 0xff);
         pixel.chan.g = (uint32_t)(((uint64_t)src[1]) * 0xffffffff / 0xff);
         pixel.chan.b = (uint32_t)(((uint64_t)src[2]) * 0xffffffff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32a32_unorm {
   struct {
      uint32_t r;
      uint32_t g;
      uint32_t b;
      uint32_t a;
   } chan;
};

static INLINE void
util_format_r32g32b32a32_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32a32_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0xffffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0xffffffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0xffffffff)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0/0xffffffff)); /* a */
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32b32a32_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32a32_unorm pixel;
         pixel.chan.r = (uint32_t)(CLAMP(src[0], 0, 1) * (double)0xffffffff);
         pixel.chan.g = (uint32_t)(CLAMP(src[1], 0, 1) * (double)0xffffffff);
         pixel.chan.b = (uint32_t)(CLAMP(src[2], 0, 1) * (double)0xffffffff);
         pixel.chan.a = (uint32_t)(CLAMP(src[3], 0, 1) * (double)0xffffffff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r32g32b32a32_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r32g32b32a32_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0xffffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0xffffffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0xffffffff)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0/0xffffffff)); /* a */
}

static INLINE void
util_format_r32g32b32a32_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32a32_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(pixel.chan.r >> 24); /* r */
         dst[1] = (uint8_t)(pixel.chan.g >> 24); /* g */
         dst[2] = (uint8_t)(pixel.chan.b >> 24); /* b */
         dst[3] = (uint8_t)(pixel.chan.a >> 24); /* a */
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32b32a32_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32a32_unorm pixel;
         pixel.chan.r = (uint32_t)(((uint64_t)src[0]) * 0xffffffff / 0xff);
         pixel.chan.g = (uint32_t)(((uint64_t)src[1]) * 0xffffffff / 0xff);
         pixel.chan.b = (uint32_t)(((uint64_t)src[2]) * 0xffffffff / 0xff);
         pixel.chan.a = (uint32_t)(((uint64_t)src[3]) * 0xffffffff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32_uscaled {
   uint32_t value;
   struct {
      uint32_t r;
   } chan;
};

static INLINE void
util_format_r32_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = value;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)CLAMP(src[0], 0, 4294967295);
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r32_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = value;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r32_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = value;
         dst[0] = (uint8_t)(((uint64_t)MIN2(r, 1)) * 0xff / 0x1); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)(((uint64_t)src[0]) * 0x1 / 0xff);
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32_uscaled {
   uint64_t value;
   struct {
      uint32_t r;
      uint32_t g;
   } chan;
};

static INLINE void
util_format_r32g32_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32_uscaled pixel;
         pixel.chan.r = (uint32_t)CLAMP(src[0], 0, 4294967295);
         pixel.chan.g = (uint32_t)CLAMP(src[1], 0, 4294967295);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r32g32_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r32g32_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r32g32_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint64_t)MIN2(pixel.chan.r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint64_t)MIN2(pixel.chan.g, 1)) * 0xff / 0x1); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32_uscaled pixel;
         pixel.chan.r = (uint32_t)(((uint64_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (uint32_t)(((uint64_t)src[1]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32_uscaled {
   struct {
      uint32_t r;
      uint32_t g;
      uint32_t b;
   } chan;
};

static INLINE void
util_format_r32g32b32_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32b32_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32_uscaled pixel;
         pixel.chan.r = (uint32_t)CLAMP(src[0], 0, 4294967295);
         pixel.chan.g = (uint32_t)CLAMP(src[1], 0, 4294967295);
         pixel.chan.b = (uint32_t)CLAMP(src[2], 0, 4294967295);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r32g32b32_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r32g32b32_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r32g32b32_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint64_t)MIN2(pixel.chan.r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint64_t)MIN2(pixel.chan.g, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint64_t)MIN2(pixel.chan.b, 1)) * 0xff / 0x1); /* b */
         dst[3] = 255; /* a */
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32b32_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32_uscaled pixel;
         pixel.chan.r = (uint32_t)(((uint64_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (uint32_t)(((uint64_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (uint32_t)(((uint64_t)src[2]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32a32_uscaled {
   struct {
      uint32_t r;
      uint32_t g;
      uint32_t b;
      uint32_t a;
   } chan;
};

static INLINE void
util_format_r32g32b32a32_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32a32_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32b32a32_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32a32_uscaled pixel;
         pixel.chan.r = (uint32_t)CLAMP(src[0], 0, 4294967295);
         pixel.chan.g = (uint32_t)CLAMP(src[1], 0, 4294967295);
         pixel.chan.b = (uint32_t)CLAMP(src[2], 0, 4294967295);
         pixel.chan.a = (uint32_t)CLAMP(src[3], 0, 4294967295);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r32g32b32a32_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r32g32b32a32_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
}

static INLINE void
util_format_r32g32b32a32_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32a32_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint64_t)MIN2(pixel.chan.r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint64_t)MIN2(pixel.chan.g, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint64_t)MIN2(pixel.chan.b, 1)) * 0xff / 0x1); /* b */
         dst[3] = (uint8_t)(((uint64_t)MIN2(pixel.chan.a, 1)) * 0xff / 0x1); /* a */
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32b32a32_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32a32_uscaled pixel;
         pixel.chan.r = (uint32_t)(((uint64_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (uint32_t)(((uint64_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (uint32_t)(((uint64_t)src[2]) * 0x1 / 0xff);
         pixel.chan.a = (uint32_t)(((uint64_t)src[3]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32_snorm {
   uint32_t value;
   struct {
      int32_t r;
   } chan;
};

static INLINE void
util_format_r32_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (int32_t)(value) ;
         dst[0] = (float)(r * (1.0/0x7fffffff)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)((int32_t)(CLAMP(src[0], -1, 1) * (double)0x7fffffff)) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r32_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (int32_t)(value) ;
         dst[0] = (float)(r * (1.0/0x7fffffff)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r32_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (int32_t)(value) ;
         dst[0] = (uint8_t)(MAX2(r, 0) >> 23); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)((int32_t)(((uint64_t)src[0]) * 0x7fffffff / 0xff)) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32_snorm {
   uint64_t value;
   struct {
      int32_t r;
      int32_t g;
   } chan;
};

static INLINE void
util_format_r32g32_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x7fffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x7fffffff)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32_snorm pixel;
         pixel.chan.r = (int32_t)(CLAMP(src[0], -1, 1) * (double)0x7fffffff);
         pixel.chan.g = (int32_t)(CLAMP(src[1], -1, 1) * (double)0x7fffffff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r32g32_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r32g32_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x7fffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x7fffffff)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r32g32_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(MAX2(pixel.chan.r, 0) >> 23); /* r */
         dst[1] = (uint8_t)(MAX2(pixel.chan.g, 0) >> 23); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32_snorm pixel;
         pixel.chan.r = (int32_t)(((uint64_t)src[0]) * 0x7fffffff / 0xff);
         pixel.chan.g = (int32_t)(((uint64_t)src[1]) * 0x7fffffff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32_snorm {
   struct {
      int32_t r;
      int32_t g;
      int32_t b;
   } chan;
};

static INLINE void
util_format_r32g32b32_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x7fffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x7fffffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0x7fffffff)); /* b */
         dst[3] = 1; /* a */
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32b32_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32_snorm pixel;
         pixel.chan.r = (int32_t)(CLAMP(src[0], -1, 1) * (double)0x7fffffff);
         pixel.chan.g = (int32_t)(CLAMP(src[1], -1, 1) * (double)0x7fffffff);
         pixel.chan.b = (int32_t)(CLAMP(src[2], -1, 1) * (double)0x7fffffff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r32g32b32_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r32g32b32_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x7fffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x7fffffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0x7fffffff)); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r32g32b32_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(MAX2(pixel.chan.r, 0) >> 23); /* r */
         dst[1] = (uint8_t)(MAX2(pixel.chan.g, 0) >> 23); /* g */
         dst[2] = (uint8_t)(MAX2(pixel.chan.b, 0) >> 23); /* b */
         dst[3] = 255; /* a */
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32b32_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32_snorm pixel;
         pixel.chan.r = (int32_t)(((uint64_t)src[0]) * 0x7fffffff / 0xff);
         pixel.chan.g = (int32_t)(((uint64_t)src[1]) * 0x7fffffff / 0xff);
         pixel.chan.b = (int32_t)(((uint64_t)src[2]) * 0x7fffffff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32a32_snorm {
   struct {
      int32_t r;
      int32_t g;
      int32_t b;
      int32_t a;
   } chan;
};

static INLINE void
util_format_r32g32b32a32_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32a32_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x7fffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x7fffffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0x7fffffff)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0/0x7fffffff)); /* a */
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32b32a32_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32a32_snorm pixel;
         pixel.chan.r = (int32_t)(CLAMP(src[0], -1, 1) * (double)0x7fffffff);
         pixel.chan.g = (int32_t)(CLAMP(src[1], -1, 1) * (double)0x7fffffff);
         pixel.chan.b = (int32_t)(CLAMP(src[2], -1, 1) * (double)0x7fffffff);
         pixel.chan.a = (int32_t)(CLAMP(src[3], -1, 1) * (double)0x7fffffff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r32g32b32a32_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r32g32b32a32_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x7fffffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x7fffffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0x7fffffff)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0/0x7fffffff)); /* a */
}

static INLINE void
util_format_r32g32b32a32_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32a32_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(MAX2(pixel.chan.r, 0) >> 23); /* r */
         dst[1] = (uint8_t)(MAX2(pixel.chan.g, 0) >> 23); /* g */
         dst[2] = (uint8_t)(MAX2(pixel.chan.b, 0) >> 23); /* b */
         dst[3] = (uint8_t)(MAX2(pixel.chan.a, 0) >> 23); /* a */
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32b32a32_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32a32_snorm pixel;
         pixel.chan.r = (int32_t)(((uint64_t)src[0]) * 0x7fffffff / 0xff);
         pixel.chan.g = (int32_t)(((uint64_t)src[1]) * 0x7fffffff / 0xff);
         pixel.chan.b = (int32_t)(((uint64_t)src[2]) * 0x7fffffff / 0xff);
         pixel.chan.a = (int32_t)(((uint64_t)src[3]) * 0x7fffffff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32_sscaled {
   uint32_t value;
   struct {
      int32_t r;
   } chan;
};

static INLINE void
util_format_r32_sscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (int32_t)(value) ;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32_sscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)((int32_t)CLAMP(src[0], -2147483648, 2147483647)) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r32_sscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (int32_t)(value) ;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r32_sscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (int32_t)(value) ;
         dst[0] = (uint8_t)(((uint64_t)CLAMP(r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32_sscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)((int32_t)(((uint64_t)src[0]) * 0x1 / 0xff)) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32_sscaled {
   uint64_t value;
   struct {
      int32_t r;
      int32_t g;
   } chan;
};

static INLINE void
util_format_r32g32_sscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32_sscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32_sscaled pixel;
         pixel.chan.r = (int32_t)CLAMP(src[0], -2147483648, 2147483647);
         pixel.chan.g = (int32_t)CLAMP(src[1], -2147483648, 2147483647);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r32g32_sscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r32g32_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r32g32_sscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint64_t)CLAMP(pixel.chan.r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint64_t)CLAMP(pixel.chan.g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32_sscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32_sscaled pixel;
         pixel.chan.r = (int32_t)(((uint64_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (int32_t)(((uint64_t)src[1]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32_sscaled {
   struct {
      int32_t r;
      int32_t g;
      int32_t b;
   } chan;
};

static INLINE void
util_format_r32g32b32_sscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32b32_sscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32_sscaled pixel;
         pixel.chan.r = (int32_t)CLAMP(src[0], -2147483648, 2147483647);
         pixel.chan.g = (int32_t)CLAMP(src[1], -2147483648, 2147483647);
         pixel.chan.b = (int32_t)CLAMP(src[2], -2147483648, 2147483647);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r32g32b32_sscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r32g32b32_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r32g32b32_sscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint64_t)CLAMP(pixel.chan.r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint64_t)CLAMP(pixel.chan.g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint64_t)CLAMP(pixel.chan.b, 0, 1)) * 0xff / 0x1); /* b */
         dst[3] = 255; /* a */
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32b32_sscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32_sscaled pixel;
         pixel.chan.r = (int32_t)(((uint64_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (int32_t)(((uint64_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (int32_t)(((uint64_t)src[2]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32a32_sscaled {
   struct {
      int32_t r;
      int32_t g;
      int32_t b;
      int32_t a;
   } chan;
};

static INLINE void
util_format_r32g32b32a32_sscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32a32_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32b32a32_sscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32a32_sscaled pixel;
         pixel.chan.r = (int32_t)CLAMP(src[0], -2147483648, 2147483647);
         pixel.chan.g = (int32_t)CLAMP(src[1], -2147483648, 2147483647);
         pixel.chan.b = (int32_t)CLAMP(src[2], -2147483648, 2147483647);
         pixel.chan.a = (int32_t)CLAMP(src[3], -2147483648, 2147483647);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r32g32b32a32_sscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r32g32b32a32_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
}

static INLINE void
util_format_r32g32b32a32_sscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32a32_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint64_t)CLAMP(pixel.chan.r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint64_t)CLAMP(pixel.chan.g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint64_t)CLAMP(pixel.chan.b, 0, 1)) * 0xff / 0x1); /* b */
         dst[3] = (uint8_t)(((uint64_t)CLAMP(pixel.chan.a, 0, 1)) * 0xff / 0x1); /* a */
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32b32a32_sscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32a32_sscaled pixel;
         pixel.chan.r = (int32_t)(((uint64_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (int32_t)(((uint64_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (int32_t)(((uint64_t)src[2]) * 0x1 / 0xff);
         pixel.chan.a = (int32_t)(((uint64_t)src[3]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16_float {
   uint16_t value;
   struct {
      uint16_t r;
   } chan;
};

static INLINE void
util_format_r16_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16_float pixel;
         pixel.chan.r = util_float_to_half(src[0]);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r16_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r16_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(util_half_to_float(pixel.chan.r)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16_float pixel;
         pixel.chan.r = util_float_to_half((float)(src[0] * (1.0f/0xff)));
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16_float {
   uint32_t value;
   struct {
      uint16_t r;
      uint16_t g;
   } chan;
};

static INLINE void
util_format_r16g16_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = util_half_to_float(pixel.chan.g); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16_float pixel;
         pixel.chan.r = util_float_to_half(src[0]);
         pixel.chan.g = util_float_to_half(src[1]);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r16g16_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r16g16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = util_half_to_float(pixel.chan.g); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r16g16_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(util_half_to_float(pixel.chan.r)); /* r */
         dst[1] = float_to_ubyte(util_half_to_float(pixel.chan.g)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16_float pixel;
         pixel.chan.r = util_float_to_half((float)(src[0] * (1.0f/0xff)));
         pixel.chan.g = util_float_to_half((float)(src[1] * (1.0f/0xff)));
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16_float {
   struct {
      uint16_t r;
      uint16_t g;
      uint16_t b;
   } chan;
};

static INLINE void
util_format_r16g16b16_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = util_half_to_float(pixel.chan.g); /* g */
         dst[2] = util_half_to_float(pixel.chan.b); /* b */
         dst[3] = 1; /* a */
         src += 6;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16b16_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16_float pixel;
         pixel.chan.r = util_float_to_half(src[0]);
         pixel.chan.g = util_float_to_half(src[1]);
         pixel.chan.b = util_float_to_half(src[2]);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 6;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r16g16b16_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r16g16b16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = util_half_to_float(pixel.chan.g); /* g */
         dst[2] = util_half_to_float(pixel.chan.b); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r16g16b16_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(util_half_to_float(pixel.chan.r)); /* r */
         dst[1] = float_to_ubyte(util_half_to_float(pixel.chan.g)); /* g */
         dst[2] = float_to_ubyte(util_half_to_float(pixel.chan.b)); /* b */
         dst[3] = 255; /* a */
         src += 6;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16b16_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16_float pixel;
         pixel.chan.r = util_float_to_half((float)(src[0] * (1.0f/0xff)));
         pixel.chan.g = util_float_to_half((float)(src[1] * (1.0f/0xff)));
         pixel.chan.b = util_float_to_half((float)(src[2] * (1.0f/0xff)));
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 6;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16a16_float {
   uint64_t value;
   struct {
      uint16_t r;
      uint16_t g;
      uint16_t b;
      uint16_t a;
   } chan;
};

static INLINE void
util_format_r16g16b16a16_float_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = util_half_to_float(pixel.chan.g); /* g */
         dst[2] = util_half_to_float(pixel.chan.b); /* b */
         dst[3] = util_half_to_float(pixel.chan.a); /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16b16a16_float_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16a16_float pixel;
         pixel.chan.r = util_float_to_half(src[0]);
         pixel.chan.g = util_float_to_half(src[1]);
         pixel.chan.b = util_float_to_half(src[2]);
         pixel.chan.a = util_float_to_half(src[3]);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r16g16b16a16_float_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r16g16b16a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = util_half_to_float(pixel.chan.r); /* r */
         dst[1] = util_half_to_float(pixel.chan.g); /* g */
         dst[2] = util_half_to_float(pixel.chan.b); /* b */
         dst[3] = util_half_to_float(pixel.chan.a); /* a */
}

static INLINE void
util_format_r16g16b16a16_float_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16a16_float pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = float_to_ubyte(util_half_to_float(pixel.chan.r)); /* r */
         dst[1] = float_to_ubyte(util_half_to_float(pixel.chan.g)); /* g */
         dst[2] = float_to_ubyte(util_half_to_float(pixel.chan.b)); /* b */
         dst[3] = float_to_ubyte(util_half_to_float(pixel.chan.a)); /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16b16a16_float_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16a16_float pixel;
         pixel.chan.r = util_float_to_half((float)(src[0] * (1.0f/0xff)));
         pixel.chan.g = util_float_to_half((float)(src[1] * (1.0f/0xff)));
         pixel.chan.b = util_float_to_half((float)(src[2] * (1.0f/0xff)));
         pixel.chan.a = util_float_to_half((float)(src[3] * (1.0f/0xff)));
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16_unorm {
   uint16_t value;
   struct {
      uint16_t r;
   } chan;
};

static INLINE void
util_format_r16_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         r = value;
         dst[0] = (float)(r * (1.0f/0xffff)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)(CLAMP(src[0], 0, 1) * 0xffff);
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r16_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         r = value;
         dst[0] = (float)(r * (1.0f/0xffff)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r16_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         r = value;
         dst[0] = (uint8_t)(r >> 8); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)(((uint32_t)src[0]) * 0xffff / 0xff);
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16_unorm {
   uint32_t value;
   struct {
      uint16_t r;
      uint16_t g;
   } chan;
};

static INLINE void
util_format_r16g16_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value) & 0xffff;
         g = value >> 16;
         dst[0] = (float)(r * (1.0f/0xffff)); /* r */
         dst[1] = (float)(g * (1.0f/0xffff)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= ((uint16_t)(CLAMP(src[0], 0, 1) * 0xffff)) & 0xffff;
         value |= ((uint16_t)(CLAMP(src[1], 0, 1) * 0xffff)) << 16;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r16g16_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value) & 0xffff;
         g = value >> 16;
         dst[0] = (float)(r * (1.0f/0xffff)); /* r */
         dst[1] = (float)(g * (1.0f/0xffff)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r16g16_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value) & 0xffff;
         g = value >> 16;
         dst[0] = (uint8_t)(r >> 8); /* r */
         dst[1] = (uint8_t)(g >> 8); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= ((uint16_t)(((uint32_t)src[0]) * 0xffff / 0xff)) & 0xffff;
         value |= ((uint16_t)(((uint32_t)src[1]) * 0xffff / 0xff)) << 16;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16_unorm {
   struct {
      uint16_t r;
      uint16_t g;
      uint16_t b;
   } chan;
};

static INLINE void
util_format_r16g16b16_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0xffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0xffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0xffff)); /* b */
         dst[3] = 1; /* a */
         src += 6;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16b16_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16_unorm pixel;
         pixel.chan.r = (uint16_t)(CLAMP(src[0], 0, 1) * 0xffff);
         pixel.chan.g = (uint16_t)(CLAMP(src[1], 0, 1) * 0xffff);
         pixel.chan.b = (uint16_t)(CLAMP(src[2], 0, 1) * 0xffff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 6;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r16g16b16_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r16g16b16_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0xffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0xffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0xffff)); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r16g16b16_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(pixel.chan.r >> 8); /* r */
         dst[1] = (uint8_t)(pixel.chan.g >> 8); /* g */
         dst[2] = (uint8_t)(pixel.chan.b >> 8); /* b */
         dst[3] = 255; /* a */
         src += 6;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16b16_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16_unorm pixel;
         pixel.chan.r = (uint16_t)(((uint32_t)src[0]) * 0xffff / 0xff);
         pixel.chan.g = (uint16_t)(((uint32_t)src[1]) * 0xffff / 0xff);
         pixel.chan.b = (uint16_t)(((uint32_t)src[2]) * 0xffff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 6;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16a16_unorm {
   uint64_t value;
   struct {
      uint16_t r;
      uint16_t g;
      uint16_t b;
      uint16_t a;
   } chan;
};

static INLINE void
util_format_r16g16b16a16_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16a16_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0xffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0xffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0xffff)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0f/0xffff)); /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16b16a16_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16a16_unorm pixel;
         pixel.chan.r = (uint16_t)(CLAMP(src[0], 0, 1) * 0xffff);
         pixel.chan.g = (uint16_t)(CLAMP(src[1], 0, 1) * 0xffff);
         pixel.chan.b = (uint16_t)(CLAMP(src[2], 0, 1) * 0xffff);
         pixel.chan.a = (uint16_t)(CLAMP(src[3], 0, 1) * 0xffff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r16g16b16a16_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r16g16b16a16_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0xffff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0xffff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0xffff)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0f/0xffff)); /* a */
}

static INLINE void
util_format_r16g16b16a16_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16a16_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(pixel.chan.r >> 8); /* r */
         dst[1] = (uint8_t)(pixel.chan.g >> 8); /* g */
         dst[2] = (uint8_t)(pixel.chan.b >> 8); /* b */
         dst[3] = (uint8_t)(pixel.chan.a >> 8); /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16b16a16_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16a16_unorm pixel;
         pixel.chan.r = (uint16_t)(((uint32_t)src[0]) * 0xffff / 0xff);
         pixel.chan.g = (uint16_t)(((uint32_t)src[1]) * 0xffff / 0xff);
         pixel.chan.b = (uint16_t)(((uint32_t)src[2]) * 0xffff / 0xff);
         pixel.chan.a = (uint16_t)(((uint32_t)src[3]) * 0xffff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16_uscaled {
   uint16_t value;
   struct {
      uint16_t r;
   } chan;
};

static INLINE void
util_format_r16_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         r = value;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)CLAMP(src[0], 0, 65535);
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r16_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         r = value;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r16_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         r = value;
         dst[0] = (uint8_t)(((uint32_t)MIN2(r, 1)) * 0xff / 0x1); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)(((uint32_t)src[0]) * 0x1 / 0xff);
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16_uscaled {
   uint32_t value;
   struct {
      uint16_t r;
      uint16_t g;
   } chan;
};

static INLINE void
util_format_r16g16_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value) & 0xffff;
         g = value >> 16;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= ((uint16_t)CLAMP(src[0], 0, 65535)) & 0xffff;
         value |= ((uint16_t)CLAMP(src[1], 0, 65535)) << 16;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r16g16_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value) & 0xffff;
         g = value >> 16;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r16g16_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value) & 0xffff;
         g = value >> 16;
         dst[0] = (uint8_t)(((uint32_t)MIN2(r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)MIN2(g, 1)) * 0xff / 0x1); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= ((uint16_t)(((uint32_t)src[0]) * 0x1 / 0xff)) & 0xffff;
         value |= ((uint16_t)(((uint32_t)src[1]) * 0x1 / 0xff)) << 16;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16_uscaled {
   struct {
      uint16_t r;
      uint16_t g;
      uint16_t b;
   } chan;
};

static INLINE void
util_format_r16g16b16_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
         src += 6;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16b16_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16_uscaled pixel;
         pixel.chan.r = (uint16_t)CLAMP(src[0], 0, 65535);
         pixel.chan.g = (uint16_t)CLAMP(src[1], 0, 65535);
         pixel.chan.b = (uint16_t)CLAMP(src[2], 0, 65535);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 6;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r16g16b16_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r16g16b16_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r16g16b16_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint32_t)MIN2(pixel.chan.r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)MIN2(pixel.chan.g, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)MIN2(pixel.chan.b, 1)) * 0xff / 0x1); /* b */
         dst[3] = 255; /* a */
         src += 6;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16b16_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16_uscaled pixel;
         pixel.chan.r = (uint16_t)(((uint32_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (uint16_t)(((uint32_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (uint16_t)(((uint32_t)src[2]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 6;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16a16_uscaled {
   uint64_t value;
   struct {
      uint16_t r;
      uint16_t g;
      uint16_t b;
      uint16_t a;
   } chan;
};

static INLINE void
util_format_r16g16b16a16_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16a16_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16b16a16_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16a16_uscaled pixel;
         pixel.chan.r = (uint16_t)CLAMP(src[0], 0, 65535);
         pixel.chan.g = (uint16_t)CLAMP(src[1], 0, 65535);
         pixel.chan.b = (uint16_t)CLAMP(src[2], 0, 65535);
         pixel.chan.a = (uint16_t)CLAMP(src[3], 0, 65535);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r16g16b16a16_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r16g16b16a16_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
}

static INLINE void
util_format_r16g16b16a16_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16a16_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint32_t)MIN2(pixel.chan.r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)MIN2(pixel.chan.g, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)MIN2(pixel.chan.b, 1)) * 0xff / 0x1); /* b */
         dst[3] = (uint8_t)(((uint32_t)MIN2(pixel.chan.a, 1)) * 0xff / 0x1); /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16b16a16_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16a16_uscaled pixel;
         pixel.chan.r = (uint16_t)(((uint32_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (uint16_t)(((uint32_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (uint16_t)(((uint32_t)src[2]) * 0x1 / 0xff);
         pixel.chan.a = (uint16_t)(((uint32_t)src[3]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16_snorm {
   uint16_t value;
   struct {
      int16_t r;
   } chan;
};

static INLINE void
util_format_r16_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         r = (int16_t)(value) ;
         dst[0] = (float)(r * (1.0f/0x7fff)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)(CLAMP(src[0], -1, 1) * 0x7fff)) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r16_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         r = (int16_t)(value) ;
         dst[0] = (float)(r * (1.0f/0x7fff)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r16_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         r = (int16_t)(value) ;
         dst[0] = (uint8_t)(MAX2(r, 0) >> 7); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)(((uint32_t)src[0]) * 0x7fff / 0xff)) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16_snorm {
   uint32_t value;
   struct {
      int16_t r;
      int16_t g;
   } chan;
};

static INLINE void
util_format_r16g16_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = ((int32_t)(value << 16) ) >> 16;
         g = ((int32_t)(value) ) >> 16;
         dst[0] = (float)(r * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(g * (1.0f/0x7fff)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)(CLAMP(src[0], -1, 1) * 0x7fff)) & 0xffff) ;
         value |= (uint32_t)(((int16_t)(CLAMP(src[1], -1, 1) * 0x7fff)) << 16) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r16g16_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = ((int32_t)(value << 16) ) >> 16;
         g = ((int32_t)(value) ) >> 16;
         dst[0] = (float)(r * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(g * (1.0f/0x7fff)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r16g16_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = ((int32_t)(value << 16) ) >> 16;
         g = ((int32_t)(value) ) >> 16;
         dst[0] = (uint8_t)(MAX2(r, 0) >> 7); /* r */
         dst[1] = (uint8_t)(MAX2(g, 0) >> 7); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)(((uint32_t)src[0]) * 0x7fff / 0xff)) & 0xffff) ;
         value |= (uint32_t)(((int16_t)(((uint32_t)src[1]) * 0x7fff / 0xff)) << 16) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16_snorm {
   struct {
      int16_t r;
      int16_t g;
      int16_t b;
   } chan;
};

static INLINE void
util_format_r16g16b16_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0x7fff)); /* b */
         dst[3] = 1; /* a */
         src += 6;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16b16_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16_snorm pixel;
         pixel.chan.r = (int16_t)(CLAMP(src[0], -1, 1) * 0x7fff);
         pixel.chan.g = (int16_t)(CLAMP(src[1], -1, 1) * 0x7fff);
         pixel.chan.b = (int16_t)(CLAMP(src[2], -1, 1) * 0x7fff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 6;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r16g16b16_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r16g16b16_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0x7fff)); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r16g16b16_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(MAX2(pixel.chan.r, 0) >> 7); /* r */
         dst[1] = (uint8_t)(MAX2(pixel.chan.g, 0) >> 7); /* g */
         dst[2] = (uint8_t)(MAX2(pixel.chan.b, 0) >> 7); /* b */
         dst[3] = 255; /* a */
         src += 6;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16b16_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16_snorm pixel;
         pixel.chan.r = (int16_t)(((uint32_t)src[0]) * 0x7fff / 0xff);
         pixel.chan.g = (int16_t)(((uint32_t)src[1]) * 0x7fff / 0xff);
         pixel.chan.b = (int16_t)(((uint32_t)src[2]) * 0x7fff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 6;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16a16_snorm {
   uint64_t value;
   struct {
      int16_t r;
      int16_t g;
      int16_t b;
      int16_t a;
   } chan;
};

static INLINE void
util_format_r16g16b16a16_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16a16_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0x7fff)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0f/0x7fff)); /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16b16a16_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16a16_snorm pixel;
         pixel.chan.r = (int16_t)(CLAMP(src[0], -1, 1) * 0x7fff);
         pixel.chan.g = (int16_t)(CLAMP(src[1], -1, 1) * 0x7fff);
         pixel.chan.b = (int16_t)(CLAMP(src[2], -1, 1) * 0x7fff);
         pixel.chan.a = (int16_t)(CLAMP(src[3], -1, 1) * 0x7fff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r16g16b16a16_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r16g16b16a16_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0x7fff)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0x7fff)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0x7fff)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0f/0x7fff)); /* a */
}

static INLINE void
util_format_r16g16b16a16_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16a16_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(MAX2(pixel.chan.r, 0) >> 7); /* r */
         dst[1] = (uint8_t)(MAX2(pixel.chan.g, 0) >> 7); /* g */
         dst[2] = (uint8_t)(MAX2(pixel.chan.b, 0) >> 7); /* b */
         dst[3] = (uint8_t)(MAX2(pixel.chan.a, 0) >> 7); /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16b16a16_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16a16_snorm pixel;
         pixel.chan.r = (int16_t)(((uint32_t)src[0]) * 0x7fff / 0xff);
         pixel.chan.g = (int16_t)(((uint32_t)src[1]) * 0x7fff / 0xff);
         pixel.chan.b = (int16_t)(((uint32_t)src[2]) * 0x7fff / 0xff);
         pixel.chan.a = (int16_t)(((uint32_t)src[3]) * 0x7fff / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16_sscaled {
   uint16_t value;
   struct {
      int16_t r;
   } chan;
};

static INLINE void
util_format_r16_sscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         r = (int16_t)(value) ;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16_sscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)CLAMP(src[0], -32768, 32767)) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r16_sscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         r = (int16_t)(value) ;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r16_sscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         r = (int16_t)(value) ;
         dst[0] = (uint8_t)(((uint32_t)CLAMP(r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16_sscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)((int16_t)(((uint32_t)src[0]) * 0x1 / 0xff)) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16_sscaled {
   uint32_t value;
   struct {
      int16_t r;
      int16_t g;
   } chan;
};

static INLINE void
util_format_r16g16_sscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = ((int32_t)(value << 16) ) >> 16;
         g = ((int32_t)(value) ) >> 16;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16_sscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)CLAMP(src[0], -32768, 32767)) & 0xffff) ;
         value |= (uint32_t)(((int16_t)CLAMP(src[1], -32768, 32767)) << 16) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r16g16_sscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = ((int32_t)(value << 16) ) >> 16;
         g = ((int32_t)(value) ) >> 16;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r16g16_sscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = ((int32_t)(value << 16) ) >> 16;
         g = ((int32_t)(value) ) >> 16;
         dst[0] = (uint8_t)(((uint32_t)CLAMP(r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)CLAMP(g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16_sscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)(((int16_t)(((uint32_t)src[0]) * 0x1 / 0xff)) & 0xffff) ;
         value |= (uint32_t)(((int16_t)(((uint32_t)src[1]) * 0x1 / 0xff)) << 16) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16_sscaled {
   struct {
      int16_t r;
      int16_t g;
      int16_t b;
   } chan;
};

static INLINE void
util_format_r16g16b16_sscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
         src += 6;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16b16_sscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16_sscaled pixel;
         pixel.chan.r = (int16_t)CLAMP(src[0], -32768, 32767);
         pixel.chan.g = (int16_t)CLAMP(src[1], -32768, 32767);
         pixel.chan.b = (int16_t)CLAMP(src[2], -32768, 32767);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 6;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r16g16b16_sscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r16g16b16_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r16g16b16_sscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.b, 0, 1)) * 0xff / 0x1); /* b */
         dst[3] = 255; /* a */
         src += 6;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16b16_sscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16_sscaled pixel;
         pixel.chan.r = (int16_t)(((uint32_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (int16_t)(((uint32_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (int16_t)(((uint32_t)src[2]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 6;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r16g16b16a16_sscaled {
   uint64_t value;
   struct {
      int16_t r;
      int16_t g;
      int16_t b;
      int16_t a;
   } chan;
};

static INLINE void
util_format_r16g16b16a16_sscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16a16_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16b16a16_sscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16a16_sscaled pixel;
         pixel.chan.r = (int16_t)CLAMP(src[0], -32768, 32767);
         pixel.chan.g = (int16_t)CLAMP(src[1], -32768, 32767);
         pixel.chan.b = (int16_t)CLAMP(src[2], -32768, 32767);
         pixel.chan.a = (int16_t)CLAMP(src[3], -32768, 32767);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r16g16b16a16_sscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r16g16b16a16_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = (float)pixel.chan.a; /* a */
}

static INLINE void
util_format_r16g16b16a16_sscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16a16_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.b, 0, 1)) * 0xff / 0x1); /* b */
         dst[3] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.a, 0, 1)) * 0xff / 0x1); /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r16g16b16a16_sscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r16g16b16a16_sscaled pixel;
         pixel.chan.r = (int16_t)(((uint32_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (int16_t)(((uint32_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (int16_t)(((uint32_t)src[2]) * 0x1 / 0xff);
         pixel.chan.a = (int16_t)(((uint32_t)src[3]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8_unorm {
   uint8_t value;
   struct {
      uint8_t r;
   } chan;
};

static INLINE void
util_format_r8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         r = value;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= float_to_ubyte(src[0]);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         r = value;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         r = value;
         dst[0] = r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= src[0];
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8_unorm {
   uint16_t value;
   struct {
      uint8_t r;
      uint8_t g;
   } chan;
};

static INLINE void
util_format_r8g8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         r = (value) & 0xff;
         g = value >> 8;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (float_to_ubyte(src[0])) & 0xff;
         value |= (float_to_ubyte(src[1])) << 8;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r8g8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         r = (value) & 0xff;
         g = value >> 8;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r8g8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         r = (value) & 0xff;
         g = value >> 8;
         dst[0] = r; /* r */
         dst[1] = g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (src[0]) & 0xff;
         value |= (src[1]) << 8;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8_unorm {
   struct {
      uint8_t r;
      uint8_t g;
      uint8_t b;
   } chan;
};

static INLINE void
util_format_r8g8b8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r8g8b8_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = ubyte_to_float(pixel.chan.r); /* r */
         dst[1] = ubyte_to_float(pixel.chan.g); /* g */
         dst[2] = ubyte_to_float(pixel.chan.b); /* b */
         dst[3] = 1; /* a */
         src += 3;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8b8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r8g8b8_unorm pixel;
         pixel.chan.r = float_to_ubyte(src[0]);
         pixel.chan.g = float_to_ubyte(src[1]);
         pixel.chan.b = float_to_ubyte(src[2]);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 3;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r8g8b8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r8g8b8_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = ubyte_to_float(pixel.chan.r); /* r */
         dst[1] = ubyte_to_float(pixel.chan.g); /* g */
         dst[2] = ubyte_to_float(pixel.chan.b); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r8g8b8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r8g8b8_unorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = pixel.chan.r; /* r */
         dst[1] = pixel.chan.g; /* g */
         dst[2] = pixel.chan.b; /* b */
         dst[3] = 255; /* a */
         src += 3;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8b8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r8g8b8_unorm pixel;
         pixel.chan.r = src[0];
         pixel.chan.g = src[1];
         pixel.chan.b = src[2];
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 3;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8a8_unorm {
   uint32_t value;
   struct {
      uint8_t r;
      uint8_t g;
      uint8_t b;
      uint8_t a;
   } chan;
};

static INLINE void
util_format_r8g8b8a8_unorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8b8a8_unorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (float_to_ubyte(src[0])) & 0xff;
         value |= ((float_to_ubyte(src[1])) & 0xff) << 8;
         value |= ((float_to_ubyte(src[2])) & 0xff) << 16;
         value |= (float_to_ubyte(src[3])) << 24;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r8g8b8a8_unorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = ubyte_to_float(r); /* r */
         dst[1] = ubyte_to_float(g); /* g */
         dst[2] = ubyte_to_float(b); /* b */
         dst[3] = ubyte_to_float(a); /* a */
}

static INLINE void
util_format_r8g8b8a8_unorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = r; /* r */
         dst[1] = g; /* g */
         dst[2] = b; /* b */
         dst[3] = a; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8b8a8_unorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (src[0]) & 0xff;
         value |= ((src[1]) & 0xff) << 8;
         value |= ((src[2]) & 0xff) << 16;
         value |= (src[3]) << 24;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8_uscaled {
   uint8_t value;
   struct {
      uint8_t r;
   } chan;
};

static INLINE void
util_format_r8_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         r = value;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)CLAMP(src[0], 0, 255);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r8_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         r = value;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r8_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         uint8_t r;
         r = value;
         dst[0] = (uint8_t)(((uint32_t)MIN2(r, 1)) * 0xff / 0x1); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)(((uint32_t)src[0]) * 0x1 / 0xff);
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8_uscaled {
   uint16_t value;
   struct {
      uint8_t r;
      uint8_t g;
   } chan;
};

static INLINE void
util_format_r8g8_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         r = (value) & 0xff;
         g = value >> 8;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= ((uint8_t)CLAMP(src[0], 0, 255)) & 0xff;
         value |= ((uint8_t)CLAMP(src[1], 0, 255)) << 8;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r8g8_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         r = (value) & 0xff;
         g = value >> 8;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r8g8_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         uint16_t r;
         uint16_t g;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         r = (value) & 0xff;
         g = value >> 8;
         dst[0] = (uint8_t)(((uint32_t)MIN2(r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)MIN2(g, 1)) * 0xff / 0x1); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= ((uint8_t)(((uint32_t)src[0]) * 0x1 / 0xff)) & 0xff;
         value |= ((uint8_t)(((uint32_t)src[1]) * 0x1 / 0xff)) << 8;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8_uscaled {
   struct {
      uint8_t r;
      uint8_t g;
      uint8_t b;
   } chan;
};

static INLINE void
util_format_r8g8b8_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r8g8b8_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
         src += 3;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8b8_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r8g8b8_uscaled pixel;
         pixel.chan.r = (uint8_t)CLAMP(src[0], 0, 255);
         pixel.chan.g = (uint8_t)CLAMP(src[1], 0, 255);
         pixel.chan.b = (uint8_t)CLAMP(src[2], 0, 255);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 3;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r8g8b8_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r8g8b8_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r8g8b8_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r8g8b8_uscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint32_t)MIN2(pixel.chan.r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)MIN2(pixel.chan.g, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)MIN2(pixel.chan.b, 1)) * 0xff / 0x1); /* b */
         dst[3] = 255; /* a */
         src += 3;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8b8_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r8g8b8_uscaled pixel;
         pixel.chan.r = (uint8_t)(((uint32_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (uint8_t)(((uint32_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (uint8_t)(((uint32_t)src[2]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 3;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8a8_uscaled {
   uint32_t value;
   struct {
      uint8_t r;
      uint8_t g;
      uint8_t b;
      uint8_t a;
   } chan;
};

static INLINE void
util_format_r8g8b8a8_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8b8a8_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= ((uint8_t)CLAMP(src[0], 0, 255)) & 0xff;
         value |= (((uint8_t)CLAMP(src[1], 0, 255)) & 0xff) << 8;
         value |= (((uint8_t)CLAMP(src[2], 0, 255)) & 0xff) << 16;
         value |= ((uint8_t)CLAMP(src[3], 0, 255)) << 24;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r8g8b8a8_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
}

static INLINE void
util_format_r8g8b8a8_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
         uint32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value) & 0xff;
         g = (value >> 8) & 0xff;
         b = (value >> 16) & 0xff;
         a = value >> 24;
         dst[0] = (uint8_t)(((uint32_t)MIN2(r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)MIN2(g, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)MIN2(b, 1)) * 0xff / 0x1); /* b */
         dst[3] = (uint8_t)(((uint32_t)MIN2(a, 1)) * 0xff / 0x1); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8b8a8_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= ((uint8_t)(((uint32_t)src[0]) * 0x1 / 0xff)) & 0xff;
         value |= (((uint8_t)(((uint32_t)src[1]) * 0x1 / 0xff)) & 0xff) << 8;
         value |= (((uint8_t)(((uint32_t)src[2]) * 0x1 / 0xff)) & 0xff) << 16;
         value |= ((uint8_t)(((uint32_t)src[3]) * 0x1 / 0xff)) << 24;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8_snorm {
   uint8_t value;
   struct {
      int8_t r;
   } chan;
};

static INLINE void
util_format_r8_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t r;
         r = (int8_t)(value) ;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)(CLAMP(src[0], -1, 1) * 0x7f)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r8_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         int8_t r;
         r = (int8_t)(value) ;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r8_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t r;
         r = (int8_t)(value) ;
         dst[0] = (uint8_t)(((uint32_t)MAX2(r, 0)) * 0xff / 0x7f); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)(src[0] >> 1)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8_snorm {
   uint16_t value;
   struct {
      int8_t r;
      int8_t g;
   } chan;
};

static INLINE void
util_format_r8g8_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         r = ((int16_t)(value << 8) ) >> 8;
         g = ((int16_t)(value) ) >> 8;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(g * (1.0f/0x7f)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)(CLAMP(src[0], -1, 1) * 0x7f)) & 0xff) ;
         value |= (uint16_t)(((int8_t)(CLAMP(src[1], -1, 1) * 0x7f)) << 8) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r8g8_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         r = ((int16_t)(value << 8) ) >> 8;
         g = ((int16_t)(value) ) >> 8;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(g * (1.0f/0x7f)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r8g8_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         r = ((int16_t)(value << 8) ) >> 8;
         g = ((int16_t)(value) ) >> 8;
         dst[0] = (uint8_t)(((uint32_t)MAX2(r, 0)) * 0xff / 0x7f); /* r */
         dst[1] = (uint8_t)(((uint32_t)MAX2(g, 0)) * 0xff / 0x7f); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)(src[0] >> 1)) & 0xff) ;
         value |= (uint16_t)(((int8_t)(src[1] >> 1)) << 8) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8_snorm {
   struct {
      int8_t r;
      int8_t g;
      int8_t b;
   } chan;
};

static INLINE void
util_format_r8g8b8_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r8g8b8_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0x7f)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0x7f)); /* b */
         dst[3] = 1; /* a */
         src += 3;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8b8_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r8g8b8_snorm pixel;
         pixel.chan.r = (int8_t)(CLAMP(src[0], -1, 1) * 0x7f);
         pixel.chan.g = (int8_t)(CLAMP(src[1], -1, 1) * 0x7f);
         pixel.chan.b = (int8_t)(CLAMP(src[2], -1, 1) * 0x7f);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 3;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r8g8b8_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r8g8b8_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0f/0x7f)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0f/0x7f)); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r8g8b8_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r8g8b8_snorm pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint32_t)MAX2(pixel.chan.r, 0)) * 0xff / 0x7f); /* r */
         dst[1] = (uint8_t)(((uint32_t)MAX2(pixel.chan.g, 0)) * 0xff / 0x7f); /* g */
         dst[2] = (uint8_t)(((uint32_t)MAX2(pixel.chan.b, 0)) * 0xff / 0x7f); /* b */
         dst[3] = 255; /* a */
         src += 3;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8b8_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r8g8b8_snorm pixel;
         pixel.chan.r = (int8_t)(src[0] >> 1);
         pixel.chan.g = (int8_t)(src[1] >> 1);
         pixel.chan.b = (int8_t)(src[2] >> 1);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 3;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8a8_snorm {
   uint32_t value;
   struct {
      int8_t r;
      int8_t g;
      int8_t b;
      int8_t a;
   } chan;
};

static INLINE void
util_format_r8g8b8a8_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = ((int32_t)(value << 24) ) >> 24;
         g = ((int32_t)(value << 16) ) >> 24;
         b = ((int32_t)(value << 8) ) >> 24;
         a = ((int32_t)(value) ) >> 24;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(g * (1.0f/0x7f)); /* g */
         dst[2] = (float)(b * (1.0f/0x7f)); /* b */
         dst[3] = (float)(a * (1.0f/0x7f)); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8b8a8_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)(((int8_t)(CLAMP(src[0], -1, 1) * 0x7f)) & 0xff) ;
         value |= (uint32_t)((((int8_t)(CLAMP(src[1], -1, 1) * 0x7f)) & 0xff) << 8) ;
         value |= (uint32_t)((((int8_t)(CLAMP(src[2], -1, 1) * 0x7f)) & 0xff) << 16) ;
         value |= (uint32_t)(((int8_t)(CLAMP(src[3], -1, 1) * 0x7f)) << 24) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r8g8b8a8_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = ((int32_t)(value << 24) ) >> 24;
         g = ((int32_t)(value << 16) ) >> 24;
         b = ((int32_t)(value << 8) ) >> 24;
         a = ((int32_t)(value) ) >> 24;
         dst[0] = (float)(r * (1.0f/0x7f)); /* r */
         dst[1] = (float)(g * (1.0f/0x7f)); /* g */
         dst[2] = (float)(b * (1.0f/0x7f)); /* b */
         dst[3] = (float)(a * (1.0f/0x7f)); /* a */
}

static INLINE void
util_format_r8g8b8a8_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = ((int32_t)(value << 24) ) >> 24;
         g = ((int32_t)(value << 16) ) >> 24;
         b = ((int32_t)(value << 8) ) >> 24;
         a = ((int32_t)(value) ) >> 24;
         dst[0] = (uint8_t)(((uint32_t)MAX2(r, 0)) * 0xff / 0x7f); /* r */
         dst[1] = (uint8_t)(((uint32_t)MAX2(g, 0)) * 0xff / 0x7f); /* g */
         dst[2] = (uint8_t)(((uint32_t)MAX2(b, 0)) * 0xff / 0x7f); /* b */
         dst[3] = (uint8_t)(((uint32_t)MAX2(a, 0)) * 0xff / 0x7f); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8b8a8_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)(((int8_t)(src[0] >> 1)) & 0xff) ;
         value |= (uint32_t)((((int8_t)(src[1] >> 1)) & 0xff) << 8) ;
         value |= (uint32_t)((((int8_t)(src[2] >> 1)) & 0xff) << 16) ;
         value |= (uint32_t)(((int8_t)(src[3] >> 1)) << 24) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8_sscaled {
   uint8_t value;
   struct {
      int8_t r;
   } chan;
};

static INLINE void
util_format_r8_sscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t r;
         r = (int8_t)(value) ;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8_sscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)CLAMP(src[0], -128, 127)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r8_sscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint8_t value = *(const uint8_t *)src;
         int8_t r;
         r = (int8_t)(value) ;
         dst[0] = (float)r; /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r8_sscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = *(const uint8_t *)src;
         int8_t r;
         r = (int8_t)(value) ;
         dst[0] = (uint8_t)(((uint32_t)CLAMP(r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 1;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8_sscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint8_t value = 0;
         value |= (uint8_t)((int8_t)(((uint32_t)src[0]) * 0x1 / 0xff)) ;
         *(uint8_t *)dst = value;
         src += 4;
         dst += 1;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8_sscaled {
   uint16_t value;
   struct {
      int8_t r;
      int8_t g;
   } chan;
};

static INLINE void
util_format_r8g8_sscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         r = ((int16_t)(value << 8) ) >> 8;
         g = ((int16_t)(value) ) >> 8;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8_sscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)CLAMP(src[0], -128, 127)) & 0xff) ;
         value |= (uint16_t)(((int8_t)CLAMP(src[1], -128, 127)) << 8) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r8g8_sscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         r = ((int16_t)(value << 8) ) >> 8;
         g = ((int16_t)(value) ) >> 8;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r8g8_sscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = *(const uint16_t *)src;
         int16_t r;
         int16_t g;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         r = ((int16_t)(value << 8) ) >> 8;
         g = ((int16_t)(value) ) >> 8;
         dst[0] = (uint8_t)(((uint32_t)CLAMP(r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)CLAMP(g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 2;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8_sscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint16_t value = 0;
         value |= (uint16_t)(((int8_t)(((uint32_t)src[0]) * 0x1 / 0xff)) & 0xff) ;
         value |= (uint16_t)(((int8_t)(((uint32_t)src[1]) * 0x1 / 0xff)) << 8) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap16(value);
#endif
         *(uint16_t *)dst = value;
         src += 4;
         dst += 2;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8_sscaled {
   struct {
      int8_t r;
      int8_t g;
      int8_t b;
   } chan;
};

static INLINE void
util_format_r8g8b8_sscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r8g8b8_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
         src += 3;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8b8_sscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r8g8b8_sscaled pixel;
         pixel.chan.r = (int8_t)CLAMP(src[0], -128, 127);
         pixel.chan.g = (int8_t)CLAMP(src[1], -128, 127);
         pixel.chan.b = (int8_t)CLAMP(src[2], -128, 127);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 3;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r8g8b8_sscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r8g8b8_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)pixel.chan.r; /* r */
         dst[1] = (float)pixel.chan.g; /* g */
         dst[2] = (float)pixel.chan.b; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r8g8b8_sscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r8g8b8_sscaled pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)CLAMP(pixel.chan.b, 0, 1)) * 0xff / 0x1); /* b */
         dst[3] = 255; /* a */
         src += 3;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8b8_sscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r8g8b8_sscaled pixel;
         pixel.chan.r = (int8_t)(((uint32_t)src[0]) * 0x1 / 0xff);
         pixel.chan.g = (int8_t)(((uint32_t)src[1]) * 0x1 / 0xff);
         pixel.chan.b = (int8_t)(((uint32_t)src[2]) * 0x1 / 0xff);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 3;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r8g8b8a8_sscaled {
   uint32_t value;
   struct {
      int8_t r;
      int8_t g;
      int8_t b;
      int8_t a;
   } chan;
};

static INLINE void
util_format_r8g8b8a8_sscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = ((int32_t)(value << 24) ) >> 24;
         g = ((int32_t)(value << 16) ) >> 24;
         b = ((int32_t)(value << 8) ) >> 24;
         a = ((int32_t)(value) ) >> 24;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8b8a8_sscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)(((int8_t)CLAMP(src[0], -128, 127)) & 0xff) ;
         value |= (uint32_t)((((int8_t)CLAMP(src[1], -128, 127)) & 0xff) << 8) ;
         value |= (uint32_t)((((int8_t)CLAMP(src[2], -128, 127)) & 0xff) << 16) ;
         value |= (uint32_t)(((int8_t)CLAMP(src[3], -128, 127)) << 24) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r8g8b8a8_sscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = ((int32_t)(value << 24) ) >> 24;
         g = ((int32_t)(value << 16) ) >> 24;
         b = ((int32_t)(value << 8) ) >> 24;
         a = ((int32_t)(value) ) >> 24;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = (float)a; /* a */
}

static INLINE void
util_format_r8g8b8a8_sscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
         int32_t a;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = ((int32_t)(value << 24) ) >> 24;
         g = ((int32_t)(value << 16) ) >> 24;
         b = ((int32_t)(value << 8) ) >> 24;
         a = ((int32_t)(value) ) >> 24;
         dst[0] = (uint8_t)(((uint32_t)CLAMP(r, 0, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)CLAMP(g, 0, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)CLAMP(b, 0, 1)) * 0xff / 0x1); /* b */
         dst[3] = (uint8_t)(((uint32_t)CLAMP(a, 0, 1)) * 0xff / 0x1); /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r8g8b8a8_sscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)(((int8_t)(((uint32_t)src[0]) * 0x1 / 0xff)) & 0xff) ;
         value |= (uint32_t)((((int8_t)(((uint32_t)src[1]) * 0x1 / 0xff)) & 0xff) << 8) ;
         value |= (uint32_t)((((int8_t)(((uint32_t)src[2]) * 0x1 / 0xff)) & 0xff) << 16) ;
         value |= (uint32_t)(((int8_t)(((uint32_t)src[3]) * 0x1 / 0xff)) << 24) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32_fixed {
   uint32_t value;
   struct {
      int32_t r;
   } chan;
};

static INLINE void
util_format_r32_fixed_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x10000)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32_fixed_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32_fixed pixel;
         pixel.chan.r = (int32_t)(CLAMP(src[0], -65536, 65535) * (double)0x10000);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r32_fixed_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x10000)); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r32_fixed_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)((CLAMP(pixel.chan.r, 0, 65536) * (1.0/0x10000)) * 0xff); /* r */
         dst[1] = 0; /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32_fixed_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32_fixed pixel;
         pixel.chan.r = (int32_t)((float)(src[0] * (1.0f/0xff)) * (double)0x10000);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32_fixed {
   uint64_t value;
   struct {
      int32_t r;
      int32_t g;
   } chan;
};

static INLINE void
util_format_r32g32_fixed_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x10000)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x10000)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32_fixed_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32_fixed pixel;
         pixel.chan.r = (int32_t)(CLAMP(src[0], -65536, 65535) * (double)0x10000);
         pixel.chan.g = (int32_t)(CLAMP(src[1], -65536, 65535) * (double)0x10000);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r32g32_fixed_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r32g32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x10000)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x10000)); /* g */
         dst[2] = 0; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r32g32_fixed_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)((CLAMP(pixel.chan.r, 0, 65536) * (1.0/0x10000)) * 0xff); /* r */
         dst[1] = (uint8_t)((CLAMP(pixel.chan.g, 0, 65536) * (1.0/0x10000)) * 0xff); /* g */
         dst[2] = 0; /* b */
         dst[3] = 255; /* a */
         src += 8;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32_fixed_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32_fixed pixel;
         pixel.chan.r = (int32_t)((float)(src[0] * (1.0f/0xff)) * (double)0x10000);
         pixel.chan.g = (int32_t)((float)(src[1] * (1.0f/0xff)) * (double)0x10000);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 8;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32_fixed {
   struct {
      int32_t r;
      int32_t g;
      int32_t b;
   } chan;
};

static INLINE void
util_format_r32g32b32_fixed_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x10000)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x10000)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0x10000)); /* b */
         dst[3] = 1; /* a */
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32b32_fixed_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32_fixed pixel;
         pixel.chan.r = (int32_t)(CLAMP(src[0], -65536, 65535) * (double)0x10000);
         pixel.chan.g = (int32_t)(CLAMP(src[1], -65536, 65535) * (double)0x10000);
         pixel.chan.b = (int32_t)(CLAMP(src[2], -65536, 65535) * (double)0x10000);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r32g32b32_fixed_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r32g32b32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x10000)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x10000)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0x10000)); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r32g32b32_fixed_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)((CLAMP(pixel.chan.r, 0, 65536) * (1.0/0x10000)) * 0xff); /* r */
         dst[1] = (uint8_t)((CLAMP(pixel.chan.g, 0, 65536) * (1.0/0x10000)) * 0xff); /* g */
         dst[2] = (uint8_t)((CLAMP(pixel.chan.b, 0, 65536) * (1.0/0x10000)) * 0xff); /* b */
         dst[3] = 255; /* a */
         src += 12;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32b32_fixed_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32_fixed pixel;
         pixel.chan.r = (int32_t)((float)(src[0] * (1.0f/0xff)) * (double)0x10000);
         pixel.chan.g = (int32_t)((float)(src[1] * (1.0f/0xff)) * (double)0x10000);
         pixel.chan.b = (int32_t)((float)(src[2] * (1.0f/0xff)) * (double)0x10000);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 12;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r32g32b32a32_fixed {
   struct {
      int32_t r;
      int32_t g;
      int32_t b;
      int32_t a;
   } chan;
};

static INLINE void
util_format_r32g32b32a32_fixed_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32a32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x10000)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x10000)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0x10000)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0/0x10000)); /* a */
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32b32a32_fixed_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32a32_fixed pixel;
         pixel.chan.r = (int32_t)(CLAMP(src[0], -65536, 65535) * (double)0x10000);
         pixel.chan.g = (int32_t)(CLAMP(src[1], -65536, 65535) * (double)0x10000);
         pixel.chan.b = (int32_t)(CLAMP(src[2], -65536, 65535) * (double)0x10000);
         pixel.chan.a = (int32_t)(CLAMP(src[3], -65536, 65535) * (double)0x10000);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r32g32b32a32_fixed_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         union util_format_r32g32b32a32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (float)(pixel.chan.r * (1.0/0x10000)); /* r */
         dst[1] = (float)(pixel.chan.g * (1.0/0x10000)); /* g */
         dst[2] = (float)(pixel.chan.b * (1.0/0x10000)); /* b */
         dst[3] = (float)(pixel.chan.a * (1.0/0x10000)); /* a */
}

static INLINE void
util_format_r32g32b32a32_fixed_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32a32_fixed pixel;
         memcpy(&pixel, src, sizeof pixel);
         dst[0] = (uint8_t)((CLAMP(pixel.chan.r, 0, 65536) * (1.0/0x10000)) * 0xff); /* r */
         dst[1] = (uint8_t)((CLAMP(pixel.chan.g, 0, 65536) * (1.0/0x10000)) * 0xff); /* g */
         dst[2] = (uint8_t)((CLAMP(pixel.chan.b, 0, 65536) * (1.0/0x10000)) * 0xff); /* b */
         dst[3] = (uint8_t)((CLAMP(pixel.chan.a, 0, 65536) * (1.0/0x10000)) * 0xff); /* a */
         src += 16;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r32g32b32a32_fixed_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         union util_format_r32g32b32a32_fixed pixel;
         pixel.chan.r = (int32_t)((float)(src[0] * (1.0f/0xff)) * (double)0x10000);
         pixel.chan.g = (int32_t)((float)(src[1] * (1.0f/0xff)) * (double)0x10000);
         pixel.chan.b = (int32_t)((float)(src[2] * (1.0f/0xff)) * (double)0x10000);
         pixel.chan.a = (int32_t)((float)(src[3] * (1.0f/0xff)) * (double)0x10000);
         memcpy(dst, &pixel, sizeof pixel);
         src += 4;
         dst += 16;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r10g10b10x2_uscaled {
   uint32_t value;
   struct {
      unsigned r:10;
      unsigned g:10;
      unsigned b:10;
      unsigned x:2;
   } chan;
};

static INLINE void
util_format_r10g10b10x2_uscaled_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value >> 20) & 0x3ff;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r10g10b10x2_uscaled_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= ((uint32_t)CLAMP(src[0], 0, 1023)) & 0x3ff;
         value |= (((uint32_t)CLAMP(src[1], 0, 1023)) & 0x3ff) << 10;
         value |= (((uint32_t)CLAMP(src[2], 0, 1023)) & 0x3ff) << 20;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r10g10b10x2_uscaled_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value >> 20) & 0x3ff;
         dst[0] = (float)r; /* r */
         dst[1] = (float)g; /* g */
         dst[2] = (float)b; /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r10g10b10x2_uscaled_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         uint32_t r;
         uint32_t g;
         uint32_t b;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = (value) & 0x3ff;
         g = (value >> 10) & 0x3ff;
         b = (value >> 20) & 0x3ff;
         dst[0] = (uint8_t)(((uint32_t)MIN2(r, 1)) * 0xff / 0x1); /* r */
         dst[1] = (uint8_t)(((uint32_t)MIN2(g, 1)) * 0xff / 0x1); /* g */
         dst[2] = (uint8_t)(((uint32_t)MIN2(b, 1)) * 0xff / 0x1); /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r10g10b10x2_uscaled_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= ((uint32_t)(((uint32_t)src[0]) * 0x1 / 0xff)) & 0x3ff;
         value |= (((uint32_t)(((uint32_t)src[1]) * 0x1 / 0xff)) & 0x3ff) << 10;
         value |= (((uint32_t)(((uint32_t)src[2]) * 0x1 / 0xff)) & 0x3ff) << 20;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

union util_format_r10g10b10x2_snorm {
   uint32_t value;
   struct {
      int r:10;
      int g:10;
      int b:10;
      unsigned x:2;
   } chan;
};

static INLINE void
util_format_r10g10b10x2_snorm_unpack_rgba_float(float *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      float *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = ((int32_t)(value << 22) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         b = ((int32_t)(value << 2) ) >> 22;
         dst[0] = (float)(r * (1.0f/0x1ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x1ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x1ff)); /* b */
         dst[3] = 1; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r10g10b10x2_snorm_pack_rgba_float(uint8_t *dst_row, unsigned dst_stride, const float *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const float *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)(CLAMP(src[0], -1, 1) * 0x1ff)) & 0x3ff) ;
         value |= (uint32_t)((((uint32_t)(CLAMP(src[1], -1, 1) * 0x1ff)) & 0x3ff) << 10) ;
         value |= (uint32_t)((((uint32_t)(CLAMP(src[2], -1, 1) * 0x1ff)) & 0x3ff) << 20) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

static INLINE void
util_format_r10g10b10x2_snorm_fetch_rgba_float(float *dst, const uint8_t *src, unsigned i, unsigned j)
{
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = ((int32_t)(value << 22) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         b = ((int32_t)(value << 2) ) >> 22;
         dst[0] = (float)(r * (1.0f/0x1ff)); /* r */
         dst[1] = (float)(g * (1.0f/0x1ff)); /* g */
         dst[2] = (float)(b * (1.0f/0x1ff)); /* b */
         dst[3] = 1; /* a */
}

static INLINE void
util_format_r10g10b10x2_snorm_unpack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      uint8_t *dst = dst_row;
      const uint8_t *src = src_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = *(const uint32_t *)src;
         int32_t r;
         int32_t g;
         int32_t b;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         r = ((int32_t)(value << 22) ) >> 22;
         g = ((int32_t)(value << 12) ) >> 22;
         b = ((int32_t)(value << 2) ) >> 22;
         dst[0] = (uint8_t)(MAX2(r, 0) >> 1); /* r */
         dst[1] = (uint8_t)(MAX2(g, 0) >> 1); /* g */
         dst[2] = (uint8_t)(MAX2(b, 0) >> 1); /* b */
         dst[3] = 255; /* a */
         src += 4;
         dst += 4;
      }
      src_row += src_stride;
      dst_row += dst_stride/sizeof(*dst_row);
   }
}

static INLINE void
util_format_r10g10b10x2_snorm_pack_rgba_8unorm(uint8_t *dst_row, unsigned dst_stride, const uint8_t *src_row, unsigned src_stride, unsigned width, unsigned height)
{
   unsigned x, y;
   for(y = 0; y < height; y += 1) {
      const uint8_t *src = src_row;
      uint8_t *dst = dst_row;
      for(x = 0; x < width; x += 1) {
         uint32_t value = 0;
         value |= (uint32_t)(((uint32_t)(((uint32_t)src[0]) * 0x1ff / 0xff)) & 0x3ff) ;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[1]) * 0x1ff / 0xff)) & 0x3ff) << 10) ;
         value |= (uint32_t)((((uint32_t)(((uint32_t)src[2]) * 0x1ff / 0xff)) & 0x3ff) << 20) ;
#ifdef PIPE_ARCH_BIG_ENDIAN
         value = util_bswap32(value);
#endif
         *(uint32_t *)dst = value;
         src += 4;
         dst += 4;
      }
      dst_row += dst_stride;
      src_row += src_stride/sizeof(*src_row);
   }
}

const struct util_format_description
util_format_none_description = {
   PIPE_FORMAT_NONE,
   "PIPE_FORMAT_NONE",
   "none",
   {1, 1, 8},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 8},	/* x = r */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_0,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_none_unpack_rgba_8unorm,
   &util_format_none_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_none_unpack_rgba_float,
   &util_format_none_pack_rgba_float,
   &util_format_none_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_b8g8r8a8_unorm_description = {
   PIPE_FORMAT_B8G8R8A8_UNORM,
   "PIPE_FORMAT_B8G8R8A8_UNORM",
   "b8g8r8a8_unorm",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* z = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8}	/* w = a */
   },
   {
      UTIL_FORMAT_SWIZZLE_Z,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_b8g8r8a8_unorm_unpack_rgba_8unorm,
   &util_format_b8g8r8a8_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_b8g8r8a8_unorm_unpack_rgba_float,
   &util_format_b8g8r8a8_unorm_pack_rgba_float,
   &util_format_b8g8r8a8_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_b8g8r8x8_unorm_description = {
   PIPE_FORMAT_B8G8R8X8_UNORM,
   "PIPE_FORMAT_B8G8R8X8_UNORM",
   "b8g8r8x8_unorm",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* z = r */
      {UTIL_FORMAT_TYPE_VOID, FALSE, 8}	/* w = x */
   },
   {
      UTIL_FORMAT_SWIZZLE_Z,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_b8g8r8x8_unorm_unpack_rgba_8unorm,
   &util_format_b8g8r8x8_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_b8g8r8x8_unorm_unpack_rgba_float,
   &util_format_b8g8r8x8_unorm_pack_rgba_float,
   &util_format_b8g8r8x8_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_a8r8g8b8_unorm_description = {
   PIPE_FORMAT_A8R8G8B8_UNORM,
   "PIPE_FORMAT_A8R8G8B8_UNORM",
   "a8r8g8b8_unorm",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8}	/* w = b */
   },
   {
      UTIL_FORMAT_SWIZZLE_Y,	/* r */
      UTIL_FORMAT_SWIZZLE_Z,	/* g */
      UTIL_FORMAT_SWIZZLE_W,	/* b */
      UTIL_FORMAT_SWIZZLE_X	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_a8r8g8b8_unorm_unpack_rgba_8unorm,
   &util_format_a8r8g8b8_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_a8r8g8b8_unorm_unpack_rgba_float,
   &util_format_a8r8g8b8_unorm_pack_rgba_float,
   &util_format_a8r8g8b8_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_x8r8g8b8_unorm_description = {
   PIPE_FORMAT_X8R8G8B8_UNORM,
   "PIPE_FORMAT_X8R8G8B8_UNORM",
   "x8r8g8b8_unorm",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 8},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8}	/* w = b */
   },
   {
      UTIL_FORMAT_SWIZZLE_Y,	/* r */
      UTIL_FORMAT_SWIZZLE_Z,	/* g */
      UTIL_FORMAT_SWIZZLE_W,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_x8r8g8b8_unorm_unpack_rgba_8unorm,
   &util_format_x8r8g8b8_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_x8r8g8b8_unorm_unpack_rgba_float,
   &util_format_x8r8g8b8_unorm_pack_rgba_float,
   &util_format_x8r8g8b8_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_a8b8g8r8_unorm_description = {
   PIPE_FORMAT_A8B8G8R8_UNORM,
   "PIPE_FORMAT_A8B8G8R8_UNORM",
   "a8b8g8r8_unorm",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8}	/* w = r */
   },
   {
      UTIL_FORMAT_SWIZZLE_W,	/* r */
      UTIL_FORMAT_SWIZZLE_Z,	/* g */
      UTIL_FORMAT_SWIZZLE_Y,	/* b */
      UTIL_FORMAT_SWIZZLE_X	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_a8b8g8r8_unorm_unpack_rgba_8unorm,
   &util_format_a8b8g8r8_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_a8b8g8r8_unorm_unpack_rgba_float,
   &util_format_a8b8g8r8_unorm_pack_rgba_float,
   &util_format_a8b8g8r8_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_x8b8g8r8_unorm_description = {
   PIPE_FORMAT_X8B8G8R8_UNORM,
   "PIPE_FORMAT_X8B8G8R8_UNORM",
   "x8b8g8r8_unorm",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 8},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8}	/* w = r */
   },
   {
      UTIL_FORMAT_SWIZZLE_W,	/* r */
      UTIL_FORMAT_SWIZZLE_Z,	/* g */
      UTIL_FORMAT_SWIZZLE_Y,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_x8b8g8r8_unorm_unpack_rgba_8unorm,
   &util_format_x8b8g8r8_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_x8b8g8r8_unorm_unpack_rgba_float,
   &util_format_x8b8g8r8_unorm_pack_rgba_float,
   &util_format_x8b8g8r8_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r8g8b8x8_unorm_description = {
   PIPE_FORMAT_R8G8B8X8_UNORM,
   "PIPE_FORMAT_R8G8B8X8_UNORM",
   "r8g8b8x8_unorm",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, FALSE, 8}	/* w = x */
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r8g8b8x8_unorm_unpack_rgba_8unorm,
   &util_format_r8g8b8x8_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r8g8b8x8_unorm_unpack_rgba_float,
   &util_format_r8g8b8x8_unorm_pack_rgba_float,
   &util_format_r8g8b8x8_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_b5g5r5x1_unorm_description = {
   PIPE_FORMAT_B5G5R5X1_UNORM,
   "PIPE_FORMAT_B5G5R5X1_UNORM",
   "b5g5r5x1_unorm",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   FALSE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 5},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 5},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 5},	/* z = r */
      {UTIL_FORMAT_TYPE_VOID, FALSE, 1}	/* w = x */
   },
   {
      UTIL_FORMAT_SWIZZLE_Z,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_b5g5r5x1_unorm_unpack_rgba_8unorm,
   &util_format_b5g5r5x1_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_b5g5r5x1_unorm_unpack_rgba_float,
   &util_format_b5g5r5x1_unorm_pack_rgba_float,
   &util_format_b5g5r5x1_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_b5g5r5a1_unorm_description = {
   PIPE_FORMAT_B5G5R5A1_UNORM,
   "PIPE_FORMAT_B5G5R5A1_UNORM",
   "b5g5r5a1_unorm",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   FALSE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 5},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 5},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 5},	/* z = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 1}	/* w = a */
   },
   {
      UTIL_FORMAT_SWIZZLE_Z,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_b5g5r5a1_unorm_unpack_rgba_8unorm,
   &util_format_b5g5r5a1_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_b5g5r5a1_unorm_unpack_rgba_float,
   &util_format_b5g5r5a1_unorm_pack_rgba_float,
   &util_format_b5g5r5a1_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_b4g4r4a4_unorm_description = {
   PIPE_FORMAT_B4G4R4A4_UNORM,
   "PIPE_FORMAT_B4G4R4A4_UNORM",
   "b4g4r4a4_unorm",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   FALSE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 4},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 4},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 4},	/* z = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 4}	/* w = a */
   },
   {
      UTIL_FORMAT_SWIZZLE_Z,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_b4g4r4a4_unorm_unpack_rgba_8unorm,
   &util_format_b4g4r4a4_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_b4g4r4a4_unorm_unpack_rgba_float,
   &util_format_b4g4r4a4_unorm_pack_rgba_float,
   &util_format_b4g4r4a4_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_b4g4r4x4_unorm_description = {
   PIPE_FORMAT_B4G4R4X4_UNORM,
   "PIPE_FORMAT_B4G4R4X4_UNORM",
   "b4g4r4x4_unorm",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   FALSE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 4},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 4},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 4},	/* z = r */
      {UTIL_FORMAT_TYPE_VOID, FALSE, 4}	/* w = x */
   },
   {
      UTIL_FORMAT_SWIZZLE_Z,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_b4g4r4x4_unorm_unpack_rgba_8unorm,
   &util_format_b4g4r4x4_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_b4g4r4x4_unorm_unpack_rgba_float,
   &util_format_b4g4r4x4_unorm_pack_rgba_float,
   &util_format_b4g4r4x4_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_b5g6r5_unorm_description = {
   PIPE_FORMAT_B5G6R5_UNORM,
   "PIPE_FORMAT_B5G6R5_UNORM",
   "b5g6r5_unorm",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   3,	/* nr_channels */
   FALSE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 5},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 6},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 5},	/* z = r */
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_Z,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_b5g6r5_unorm_unpack_rgba_8unorm,
   &util_format_b5g6r5_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_b5g6r5_unorm_unpack_rgba_float,
   &util_format_b5g6r5_unorm_pack_rgba_float,
   &util_format_b5g6r5_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r10g10b10a2_unorm_description = {
   PIPE_FORMAT_R10G10B10A2_UNORM,
   "PIPE_FORMAT_R10G10B10A2_UNORM",
   "r10g10b10a2_unorm",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   FALSE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 10},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 10},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 10},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 2}	/* w = a */
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r10g10b10a2_unorm_unpack_rgba_8unorm,
   &util_format_r10g10b10a2_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r10g10b10a2_unorm_unpack_rgba_float,
   &util_format_r10g10b10a2_unorm_pack_rgba_float,
   &util_format_r10g10b10a2_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_b10g10r10a2_unorm_description = {
   PIPE_FORMAT_B10G10R10A2_UNORM,
   "PIPE_FORMAT_B10G10R10A2_UNORM",
   "b10g10r10a2_unorm",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   FALSE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 10},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 10},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 10},	/* z = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 2}	/* w = a */
   },
   {
      UTIL_FORMAT_SWIZZLE_Z,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_b10g10r10a2_unorm_unpack_rgba_8unorm,
   &util_format_b10g10r10a2_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_b10g10r10a2_unorm_unpack_rgba_float,
   &util_format_b10g10r10a2_unorm_pack_rgba_float,
   &util_format_b10g10r10a2_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_b2g3r3_unorm_description = {
   PIPE_FORMAT_B2G3R3_UNORM,
   "PIPE_FORMAT_B2G3R3_UNORM",
   "b2g3r3_unorm",
   {1, 1, 8},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   3,	/* nr_channels */
   FALSE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 2},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 3},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 3},	/* z = r */
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_Z,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_b2g3r3_unorm_unpack_rgba_8unorm,
   &util_format_b2g3r3_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_b2g3r3_unorm_unpack_rgba_float,
   &util_format_b2g3r3_unorm_pack_rgba_float,
   &util_format_b2g3r3_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_l8_unorm_description = {
   PIPE_FORMAT_L8_UNORM,
   "PIPE_FORMAT_L8_UNORM",
   "l8_unorm",
   {1, 1, 8},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* x = rgb */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_X,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_l8_unorm_unpack_rgba_8unorm,
   &util_format_l8_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_l8_unorm_unpack_rgba_float,
   &util_format_l8_unorm_pack_rgba_float,
   &util_format_l8_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_a8_unorm_description = {
   PIPE_FORMAT_A8_UNORM,
   "PIPE_FORMAT_A8_UNORM",
   "a8_unorm",
   {1, 1, 8},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* x = a */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_0,	/* r */
      UTIL_FORMAT_SWIZZLE_0,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_X	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_a8_unorm_unpack_rgba_8unorm,
   &util_format_a8_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_a8_unorm_unpack_rgba_float,
   &util_format_a8_unorm_pack_rgba_float,
   &util_format_a8_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_i8_unorm_description = {
   PIPE_FORMAT_I8_UNORM,
   "PIPE_FORMAT_I8_UNORM",
   "i8_unorm",
   {1, 1, 8},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* x = rgba */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_X,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_X	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_i8_unorm_unpack_rgba_8unorm,
   &util_format_i8_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_i8_unorm_unpack_rgba_float,
   &util_format_i8_unorm_pack_rgba_float,
   &util_format_i8_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_l4a4_unorm_description = {
   PIPE_FORMAT_L4A4_UNORM,
   "PIPE_FORMAT_L4A4_UNORM",
   "l4a4_unorm",
   {1, 1, 8},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   FALSE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 4},	/* x = rgb */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 4},	/* y = a */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_X,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_Y	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_l4a4_unorm_unpack_rgba_8unorm,
   &util_format_l4a4_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_l4a4_unorm_unpack_rgba_float,
   &util_format_l4a4_unorm_pack_rgba_float,
   &util_format_l4a4_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_l8a8_unorm_description = {
   PIPE_FORMAT_L8A8_UNORM,
   "PIPE_FORMAT_L8A8_UNORM",
   "l8a8_unorm",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* x = rgb */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* y = a */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_X,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_Y	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_l8a8_unorm_unpack_rgba_8unorm,
   &util_format_l8a8_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_l8a8_unorm_unpack_rgba_float,
   &util_format_l8a8_unorm_pack_rgba_float,
   &util_format_l8a8_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_l16_unorm_description = {
   PIPE_FORMAT_L16_UNORM,
   "PIPE_FORMAT_L16_UNORM",
   "l16_unorm",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 16},	/* x = rgb */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_X,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_l16_unorm_unpack_rgba_8unorm,
   &util_format_l16_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_l16_unorm_unpack_rgba_float,
   &util_format_l16_unorm_pack_rgba_float,
   &util_format_l16_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_a16_unorm_description = {
   PIPE_FORMAT_A16_UNORM,
   "PIPE_FORMAT_A16_UNORM",
   "a16_unorm",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 16},	/* x = a */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_0,	/* r */
      UTIL_FORMAT_SWIZZLE_0,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_X	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_a16_unorm_unpack_rgba_8unorm,
   &util_format_a16_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_a16_unorm_unpack_rgba_float,
   &util_format_a16_unorm_pack_rgba_float,
   &util_format_a16_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_i16_unorm_description = {
   PIPE_FORMAT_I16_UNORM,
   "PIPE_FORMAT_I16_UNORM",
   "i16_unorm",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 16},	/* x = rgba */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_X,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_X	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_i16_unorm_unpack_rgba_8unorm,
   &util_format_i16_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_i16_unorm_unpack_rgba_float,
   &util_format_i16_unorm_pack_rgba_float,
   &util_format_i16_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_l16a16_unorm_description = {
   PIPE_FORMAT_L16A16_UNORM,
   "PIPE_FORMAT_L16A16_UNORM",
   "l16a16_unorm",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 16},	/* x = rgb */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 16},	/* y = a */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_X,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_Y	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_l16a16_unorm_unpack_rgba_8unorm,
   &util_format_l16a16_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_l16a16_unorm_unpack_rgba_float,
   &util_format_l16a16_unorm_pack_rgba_float,
   &util_format_l16a16_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_a8_snorm_description = {
   PIPE_FORMAT_A8_SNORM,
   "PIPE_FORMAT_A8_SNORM",
   "a8_snorm",
   {1, 1, 8},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 8},	/* x = a */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_0,	/* r */
      UTIL_FORMAT_SWIZZLE_0,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_X	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_a8_snorm_unpack_rgba_8unorm,
   &util_format_a8_snorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_a8_snorm_unpack_rgba_float,
   &util_format_a8_snorm_pack_rgba_float,
   &util_format_a8_snorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_l8_snorm_description = {
   PIPE_FORMAT_L8_SNORM,
   "PIPE_FORMAT_L8_SNORM",
   "l8_snorm",
   {1, 1, 8},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 8},	/* x = rgb */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_X,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_l8_snorm_unpack_rgba_8unorm,
   &util_format_l8_snorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_l8_snorm_unpack_rgba_float,
   &util_format_l8_snorm_pack_rgba_float,
   &util_format_l8_snorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_l8a8_snorm_description = {
   PIPE_FORMAT_L8A8_SNORM,
   "PIPE_FORMAT_L8A8_SNORM",
   "l8a8_snorm",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 8},	/* x = rgb */
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 8},	/* y = a */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_X,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_Y	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_l8a8_snorm_unpack_rgba_8unorm,
   &util_format_l8a8_snorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_l8a8_snorm_unpack_rgba_float,
   &util_format_l8a8_snorm_pack_rgba_float,
   &util_format_l8a8_snorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_i8_snorm_description = {
   PIPE_FORMAT_I8_SNORM,
   "PIPE_FORMAT_I8_SNORM",
   "i8_snorm",
   {1, 1, 8},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 8},	/* x = rgba */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_X,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_X	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_i8_snorm_unpack_rgba_8unorm,
   &util_format_i8_snorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_i8_snorm_unpack_rgba_float,
   &util_format_i8_snorm_pack_rgba_float,
   &util_format_i8_snorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_a16_snorm_description = {
   PIPE_FORMAT_A16_SNORM,
   "PIPE_FORMAT_A16_SNORM",
   "a16_snorm",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 16},	/* x = a */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_0,	/* r */
      UTIL_FORMAT_SWIZZLE_0,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_X	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_a16_snorm_unpack_rgba_8unorm,
   &util_format_a16_snorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_a16_snorm_unpack_rgba_float,
   &util_format_a16_snorm_pack_rgba_float,
   &util_format_a16_snorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_l16_snorm_description = {
   PIPE_FORMAT_L16_SNORM,
   "PIPE_FORMAT_L16_SNORM",
   "l16_snorm",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 16},	/* x = rgb */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_X,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_l16_snorm_unpack_rgba_8unorm,
   &util_format_l16_snorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_l16_snorm_unpack_rgba_float,
   &util_format_l16_snorm_pack_rgba_float,
   &util_format_l16_snorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_l16a16_snorm_description = {
   PIPE_FORMAT_L16A16_SNORM,
   "PIPE_FORMAT_L16A16_SNORM",
   "l16a16_snorm",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 16},	/* x = rgb */
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 16},	/* y = a */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_X,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_Y	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_l16a16_snorm_unpack_rgba_8unorm,
   &util_format_l16a16_snorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_l16a16_snorm_unpack_rgba_float,
   &util_format_l16a16_snorm_pack_rgba_float,
   &util_format_l16a16_snorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_i16_snorm_description = {
   PIPE_FORMAT_I16_SNORM,
   "PIPE_FORMAT_I16_SNORM",
   "i16_snorm",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 16},	/* x = rgba */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_X,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_X	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_i16_snorm_unpack_rgba_8unorm,
   &util_format_i16_snorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_i16_snorm_unpack_rgba_float,
   &util_format_i16_snorm_pack_rgba_float,
   &util_format_i16_snorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_a16_float_description = {
   PIPE_FORMAT_A16_FLOAT,
   "PIPE_FORMAT_A16_FLOAT",
   "a16_float",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 16},	/* x = a */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_0,	/* r */
      UTIL_FORMAT_SWIZZLE_0,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_X	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_a16_float_unpack_rgba_8unorm,
   &util_format_a16_float_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_a16_float_unpack_rgba_float,
   &util_format_a16_float_pack_rgba_float,
   &util_format_a16_float_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_l16_float_description = {
   PIPE_FORMAT_L16_FLOAT,
   "PIPE_FORMAT_L16_FLOAT",
   "l16_float",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 16},	/* x = rgb */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_X,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_l16_float_unpack_rgba_8unorm,
   &util_format_l16_float_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_l16_float_unpack_rgba_float,
   &util_format_l16_float_pack_rgba_float,
   &util_format_l16_float_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_l16a16_float_description = {
   PIPE_FORMAT_L16A16_FLOAT,
   "PIPE_FORMAT_L16A16_FLOAT",
   "l16a16_float",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 16},	/* x = rgb */
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 16},	/* y = a */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_X,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_Y	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_l16a16_float_unpack_rgba_8unorm,
   &util_format_l16a16_float_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_l16a16_float_unpack_rgba_float,
   &util_format_l16a16_float_pack_rgba_float,
   &util_format_l16a16_float_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_i16_float_description = {
   PIPE_FORMAT_I16_FLOAT,
   "PIPE_FORMAT_I16_FLOAT",
   "i16_float",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 16},	/* x = rgba */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_X,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_X	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_i16_float_unpack_rgba_8unorm,
   &util_format_i16_float_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_i16_float_unpack_rgba_float,
   &util_format_i16_float_pack_rgba_float,
   &util_format_i16_float_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_a32_float_description = {
   PIPE_FORMAT_A32_FLOAT,
   "PIPE_FORMAT_A32_FLOAT",
   "a32_float",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 32},	/* x = a */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_0,	/* r */
      UTIL_FORMAT_SWIZZLE_0,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_X	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_a32_float_unpack_rgba_8unorm,
   &util_format_a32_float_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_a32_float_unpack_rgba_float,
   &util_format_a32_float_pack_rgba_float,
   &util_format_a32_float_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_l32_float_description = {
   PIPE_FORMAT_L32_FLOAT,
   "PIPE_FORMAT_L32_FLOAT",
   "l32_float",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 32},	/* x = rgb */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_X,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_l32_float_unpack_rgba_8unorm,
   &util_format_l32_float_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_l32_float_unpack_rgba_float,
   &util_format_l32_float_pack_rgba_float,
   &util_format_l32_float_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_l32a32_float_description = {
   PIPE_FORMAT_L32A32_FLOAT,
   "PIPE_FORMAT_L32A32_FLOAT",
   "l32a32_float",
   {1, 1, 64},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 32},	/* x = rgb */
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 32},	/* y = a */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_X,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_Y	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_l32a32_float_unpack_rgba_8unorm,
   &util_format_l32a32_float_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_l32a32_float_unpack_rgba_float,
   &util_format_l32a32_float_pack_rgba_float,
   &util_format_l32a32_float_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_i32_float_description = {
   PIPE_FORMAT_I32_FLOAT,
   "PIPE_FORMAT_I32_FLOAT",
   "i32_float",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 32},	/* x = rgba */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_X,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_X	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_i32_float_unpack_rgba_8unorm,
   &util_format_i32_float_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_i32_float_unpack_rgba_float,
   &util_format_i32_float_pack_rgba_float,
   &util_format_i32_float_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_l8_srgb_description = {
   PIPE_FORMAT_L8_SRGB,
   "PIPE_FORMAT_L8_SRGB",
   "l8_srgb",
   {1, 1, 8},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* x = rgb */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* sr */
      UTIL_FORMAT_SWIZZLE_X,	/* sg */
      UTIL_FORMAT_SWIZZLE_X,	/* sb */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_SRGB,
   &util_format_l8_srgb_unpack_rgba_8unorm,
   &util_format_l8_srgb_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_l8_srgb_unpack_rgba_float,
   &util_format_l8_srgb_pack_rgba_float,
   &util_format_l8_srgb_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_l8a8_srgb_description = {
   PIPE_FORMAT_L8A8_SRGB,
   "PIPE_FORMAT_L8A8_SRGB",
   "l8a8_srgb",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* x = rgb */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* y = a */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* sr */
      UTIL_FORMAT_SWIZZLE_X,	/* sg */
      UTIL_FORMAT_SWIZZLE_X,	/* sb */
      UTIL_FORMAT_SWIZZLE_Y	/* a */
   },
   UTIL_FORMAT_COLORSPACE_SRGB,
   &util_format_l8a8_srgb_unpack_rgba_8unorm,
   &util_format_l8a8_srgb_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_l8a8_srgb_unpack_rgba_float,
   &util_format_l8a8_srgb_pack_rgba_float,
   &util_format_l8a8_srgb_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r8g8b8_srgb_description = {
   PIPE_FORMAT_R8G8B8_SRGB,
   "PIPE_FORMAT_R8G8B8_SRGB",
   "r8g8b8_srgb",
   {1, 1, 24},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   3,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* z = b */
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* sr */
      UTIL_FORMAT_SWIZZLE_Y,	/* sg */
      UTIL_FORMAT_SWIZZLE_Z,	/* sb */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_SRGB,
   &util_format_r8g8b8_srgb_unpack_rgba_8unorm,
   &util_format_r8g8b8_srgb_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r8g8b8_srgb_unpack_rgba_float,
   &util_format_r8g8b8_srgb_pack_rgba_float,
   &util_format_r8g8b8_srgb_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r8g8b8a8_srgb_description = {
   PIPE_FORMAT_R8G8B8A8_SRGB,
   "PIPE_FORMAT_R8G8B8A8_SRGB",
   "r8g8b8a8_srgb",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8}	/* w = a */
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* sr */
      UTIL_FORMAT_SWIZZLE_Y,	/* sg */
      UTIL_FORMAT_SWIZZLE_Z,	/* sb */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_SRGB,
   &util_format_r8g8b8a8_srgb_unpack_rgba_8unorm,
   &util_format_r8g8b8a8_srgb_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r8g8b8a8_srgb_unpack_rgba_float,
   &util_format_r8g8b8a8_srgb_pack_rgba_float,
   &util_format_r8g8b8a8_srgb_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_a8b8g8r8_srgb_description = {
   PIPE_FORMAT_A8B8G8R8_SRGB,
   "PIPE_FORMAT_A8B8G8R8_SRGB",
   "a8b8g8r8_srgb",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8}	/* w = r */
   },
   {
      UTIL_FORMAT_SWIZZLE_W,	/* sr */
      UTIL_FORMAT_SWIZZLE_Z,	/* sg */
      UTIL_FORMAT_SWIZZLE_Y,	/* sb */
      UTIL_FORMAT_SWIZZLE_X	/* a */
   },
   UTIL_FORMAT_COLORSPACE_SRGB,
   &util_format_a8b8g8r8_srgb_unpack_rgba_8unorm,
   &util_format_a8b8g8r8_srgb_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_a8b8g8r8_srgb_unpack_rgba_float,
   &util_format_a8b8g8r8_srgb_pack_rgba_float,
   &util_format_a8b8g8r8_srgb_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_x8b8g8r8_srgb_description = {
   PIPE_FORMAT_X8B8G8R8_SRGB,
   "PIPE_FORMAT_X8B8G8R8_SRGB",
   "x8b8g8r8_srgb",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 8},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* y = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8}	/* w = r */
   },
   {
      UTIL_FORMAT_SWIZZLE_W,	/* sr */
      UTIL_FORMAT_SWIZZLE_Z,	/* sg */
      UTIL_FORMAT_SWIZZLE_Y,	/* sb */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_SRGB,
   &util_format_x8b8g8r8_srgb_unpack_rgba_8unorm,
   &util_format_x8b8g8r8_srgb_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_x8b8g8r8_srgb_unpack_rgba_float,
   &util_format_x8b8g8r8_srgb_pack_rgba_float,
   &util_format_x8b8g8r8_srgb_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_b8g8r8a8_srgb_description = {
   PIPE_FORMAT_B8G8R8A8_SRGB,
   "PIPE_FORMAT_B8G8R8A8_SRGB",
   "b8g8r8a8_srgb",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* z = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8}	/* w = a */
   },
   {
      UTIL_FORMAT_SWIZZLE_Z,	/* sr */
      UTIL_FORMAT_SWIZZLE_Y,	/* sg */
      UTIL_FORMAT_SWIZZLE_X,	/* sb */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_SRGB,
   &util_format_b8g8r8a8_srgb_unpack_rgba_8unorm,
   &util_format_b8g8r8a8_srgb_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_b8g8r8a8_srgb_unpack_rgba_float,
   &util_format_b8g8r8a8_srgb_pack_rgba_float,
   &util_format_b8g8r8a8_srgb_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_b8g8r8x8_srgb_description = {
   PIPE_FORMAT_B8G8R8X8_SRGB,
   "PIPE_FORMAT_B8G8R8X8_SRGB",
   "b8g8r8x8_srgb",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* x = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* z = r */
      {UTIL_FORMAT_TYPE_VOID, FALSE, 8}	/* w = x */
   },
   {
      UTIL_FORMAT_SWIZZLE_Z,	/* sr */
      UTIL_FORMAT_SWIZZLE_Y,	/* sg */
      UTIL_FORMAT_SWIZZLE_X,	/* sb */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_SRGB,
   &util_format_b8g8r8x8_srgb_unpack_rgba_8unorm,
   &util_format_b8g8r8x8_srgb_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_b8g8r8x8_srgb_unpack_rgba_float,
   &util_format_b8g8r8x8_srgb_pack_rgba_float,
   &util_format_b8g8r8x8_srgb_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_a8r8g8b8_srgb_description = {
   PIPE_FORMAT_A8R8G8B8_SRGB,
   "PIPE_FORMAT_A8R8G8B8_SRGB",
   "a8r8g8b8_srgb",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* x = a */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8}	/* w = b */
   },
   {
      UTIL_FORMAT_SWIZZLE_Y,	/* sr */
      UTIL_FORMAT_SWIZZLE_Z,	/* sg */
      UTIL_FORMAT_SWIZZLE_W,	/* sb */
      UTIL_FORMAT_SWIZZLE_X	/* a */
   },
   UTIL_FORMAT_COLORSPACE_SRGB,
   &util_format_a8r8g8b8_srgb_unpack_rgba_8unorm,
   &util_format_a8r8g8b8_srgb_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_a8r8g8b8_srgb_unpack_rgba_float,
   &util_format_a8r8g8b8_srgb_pack_rgba_float,
   &util_format_a8r8g8b8_srgb_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_x8r8g8b8_srgb_description = {
   PIPE_FORMAT_X8R8G8B8_SRGB,
   "PIPE_FORMAT_X8R8G8B8_SRGB",
   "x8r8g8b8_srgb",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 8},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* y = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* z = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8}	/* w = b */
   },
   {
      UTIL_FORMAT_SWIZZLE_Y,	/* sr */
      UTIL_FORMAT_SWIZZLE_Z,	/* sg */
      UTIL_FORMAT_SWIZZLE_W,	/* sb */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_SRGB,
   &util_format_x8r8g8b8_srgb_unpack_rgba_8unorm,
   &util_format_x8r8g8b8_srgb_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_x8r8g8b8_srgb_unpack_rgba_float,
   &util_format_x8r8g8b8_srgb_pack_rgba_float,
   &util_format_x8r8g8b8_srgb_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r8sg8sb8ux8u_norm_description = {
   PIPE_FORMAT_R8SG8SB8UX8U_NORM,
   "PIPE_FORMAT_R8SG8SB8UX8U_NORM",
   "r8sg8sb8ux8u_norm",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   TRUE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 8},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, FALSE, 8}	/* w = x */
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r8sg8sb8ux8u_norm_unpack_rgba_8unorm,
   &util_format_r8sg8sb8ux8u_norm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r8sg8sb8ux8u_norm_unpack_rgba_float,
   &util_format_r8sg8sb8ux8u_norm_pack_rgba_float,
   &util_format_r8sg8sb8ux8u_norm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r10sg10sb10sa2u_norm_description = {
   PIPE_FORMAT_R10SG10SB10SA2U_NORM,
   "PIPE_FORMAT_R10SG10SB10SA2U_NORM",
   "r10sg10sb10sa2u_norm",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   FALSE,	/* is_array */
   TRUE,	/* is_bitmask */
   TRUE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 10},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 10},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 10},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 2}	/* w = a */
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r10sg10sb10sa2u_norm_unpack_rgba_8unorm,
   &util_format_r10sg10sb10sa2u_norm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r10sg10sb10sa2u_norm_unpack_rgba_float,
   &util_format_r10sg10sb10sa2u_norm_pack_rgba_float,
   &util_format_r10sg10sb10sa2u_norm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r5sg5sb6u_norm_description = {
   PIPE_FORMAT_R5SG5SB6U_NORM,
   "PIPE_FORMAT_R5SG5SB6U_NORM",
   "r5sg5sb6u_norm",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   3,	/* nr_channels */
   FALSE,	/* is_array */
   TRUE,	/* is_bitmask */
   TRUE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 5},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 5},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 6},	/* z = b */
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r5sg5sb6u_norm_unpack_rgba_8unorm,
   &util_format_r5sg5sb6u_norm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r5sg5sb6u_norm_unpack_rgba_float,
   &util_format_r5sg5sb6u_norm_pack_rgba_float,
   &util_format_r5sg5sb6u_norm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_s8_uscaled_description = {
   PIPE_FORMAT_S8_USCALED,
   "PIPE_FORMAT_S8_USCALED",
   "s8_uscaled",
   {1, 1, 8},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 8},	/* x = s */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_NONE,	/* z */
      UTIL_FORMAT_SWIZZLE_X,	/* s */
      UTIL_FORMAT_SWIZZLE_NONE,	/* ignored */
      UTIL_FORMAT_SWIZZLE_NONE	/* ignored */
   },
   UTIL_FORMAT_COLORSPACE_ZS,
   NULL, /* unpack_rgba_8unorm */
   NULL, /* pack_rgba_8unorm */
   NULL, /* fetch_rgba_8unorm */
   NULL, /* unpack_rgba_float */
   NULL, /* pack_rgba_float */
   NULL, /* fetch_rgba_float */
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   &util_format_s8_uscaled_unpack_s_8uscaled,
   &util_format_s8_uscaled_pack_s_8uscaled
};

const struct util_format_description
util_format_z16_unorm_description = {
   PIPE_FORMAT_Z16_UNORM,
   "PIPE_FORMAT_Z16_UNORM",
   "z16_unorm",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 16},	/* x = z */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* z */
      UTIL_FORMAT_SWIZZLE_NONE,	/* s */
      UTIL_FORMAT_SWIZZLE_NONE,	/* ignored */
      UTIL_FORMAT_SWIZZLE_NONE	/* ignored */
   },
   UTIL_FORMAT_COLORSPACE_ZS,
   NULL, /* unpack_rgba_8unorm */
   NULL, /* pack_rgba_8unorm */
   NULL, /* fetch_rgba_8unorm */
   NULL, /* unpack_rgba_float */
   NULL, /* pack_rgba_float */
   NULL, /* fetch_rgba_float */
   &util_format_z16_unorm_unpack_z_32unorm,
   &util_format_z16_unorm_pack_z_32unorm,
   &util_format_z16_unorm_unpack_z_float,
   &util_format_z16_unorm_pack_z_float,
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_z32_unorm_description = {
   PIPE_FORMAT_Z32_UNORM,
   "PIPE_FORMAT_Z32_UNORM",
   "z32_unorm",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 32},	/* x = z */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* z */
      UTIL_FORMAT_SWIZZLE_NONE,	/* s */
      UTIL_FORMAT_SWIZZLE_NONE,	/* ignored */
      UTIL_FORMAT_SWIZZLE_NONE	/* ignored */
   },
   UTIL_FORMAT_COLORSPACE_ZS,
   NULL, /* unpack_rgba_8unorm */
   NULL, /* pack_rgba_8unorm */
   NULL, /* fetch_rgba_8unorm */
   NULL, /* unpack_rgba_float */
   NULL, /* pack_rgba_float */
   NULL, /* fetch_rgba_float */
   &util_format_z32_unorm_unpack_z_32unorm,
   &util_format_z32_unorm_pack_z_32unorm,
   &util_format_z32_unorm_unpack_z_float,
   &util_format_z32_unorm_pack_z_float,
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_z32_float_description = {
   PIPE_FORMAT_Z32_FLOAT,
   "PIPE_FORMAT_Z32_FLOAT",
   "z32_float",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 32},	/* x = z */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* z */
      UTIL_FORMAT_SWIZZLE_NONE,	/* s */
      UTIL_FORMAT_SWIZZLE_NONE,	/* ignored */
      UTIL_FORMAT_SWIZZLE_NONE	/* ignored */
   },
   UTIL_FORMAT_COLORSPACE_ZS,
   NULL, /* unpack_rgba_8unorm */
   NULL, /* pack_rgba_8unorm */
   NULL, /* fetch_rgba_8unorm */
   NULL, /* unpack_rgba_float */
   NULL, /* pack_rgba_float */
   NULL, /* fetch_rgba_float */
   &util_format_z32_float_unpack_z_32unorm,
   &util_format_z32_float_pack_z_32unorm,
   &util_format_z32_float_unpack_z_float,
   &util_format_z32_float_pack_z_float,
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_z24_unorm_s8_uscaled_description = {
   PIPE_FORMAT_Z24_UNORM_S8_USCALED,
   "PIPE_FORMAT_Z24_UNORM_S8_USCALED",
   "z24_unorm_s8_uscaled",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   FALSE,	/* is_array */
   TRUE,	/* is_bitmask */
   TRUE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 24},	/* x = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 8},	/* y = s */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* z */
      UTIL_FORMAT_SWIZZLE_Y,	/* s */
      UTIL_FORMAT_SWIZZLE_NONE,	/* ignored */
      UTIL_FORMAT_SWIZZLE_NONE	/* ignored */
   },
   UTIL_FORMAT_COLORSPACE_ZS,
   NULL, /* unpack_rgba_8unorm */
   NULL, /* pack_rgba_8unorm */
   NULL, /* fetch_rgba_8unorm */
   NULL, /* unpack_rgba_float */
   NULL, /* pack_rgba_float */
   NULL, /* fetch_rgba_float */
   &util_format_z24_unorm_s8_uscaled_unpack_z_32unorm,
   &util_format_z24_unorm_s8_uscaled_pack_z_32unorm,
   &util_format_z24_unorm_s8_uscaled_unpack_z_float,
   &util_format_z24_unorm_s8_uscaled_pack_z_float,
   &util_format_z24_unorm_s8_uscaled_unpack_s_8uscaled,
   &util_format_z24_unorm_s8_uscaled_pack_s_8uscaled
};

const struct util_format_description
util_format_s8_uscaled_z24_unorm_description = {
   PIPE_FORMAT_S8_USCALED_Z24_UNORM,
   "PIPE_FORMAT_S8_USCALED_Z24_UNORM",
   "s8_uscaled_z24_unorm",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   FALSE,	/* is_array */
   TRUE,	/* is_bitmask */
   TRUE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 8},	/* x = s */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 24},	/* y = z */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_Y,	/* z */
      UTIL_FORMAT_SWIZZLE_X,	/* s */
      UTIL_FORMAT_SWIZZLE_NONE,	/* ignored */
      UTIL_FORMAT_SWIZZLE_NONE	/* ignored */
   },
   UTIL_FORMAT_COLORSPACE_ZS,
   NULL, /* unpack_rgba_8unorm */
   NULL, /* pack_rgba_8unorm */
   NULL, /* fetch_rgba_8unorm */
   NULL, /* unpack_rgba_float */
   NULL, /* pack_rgba_float */
   NULL, /* fetch_rgba_float */
   &util_format_s8_uscaled_z24_unorm_unpack_z_32unorm,
   &util_format_s8_uscaled_z24_unorm_pack_z_32unorm,
   &util_format_s8_uscaled_z24_unorm_unpack_z_float,
   &util_format_s8_uscaled_z24_unorm_pack_z_float,
   &util_format_s8_uscaled_z24_unorm_unpack_s_8uscaled,
   &util_format_s8_uscaled_z24_unorm_pack_s_8uscaled
};

const struct util_format_description
util_format_x24s8_uscaled_description = {
   PIPE_FORMAT_X24S8_USCALED,
   "PIPE_FORMAT_X24S8_USCALED",
   "x24s8_uscaled",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   FALSE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 24},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 8},	/* y = s */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_NONE,	/* z */
      UTIL_FORMAT_SWIZZLE_Y,	/* s */
      UTIL_FORMAT_SWIZZLE_NONE,	/* ignored */
      UTIL_FORMAT_SWIZZLE_NONE	/* ignored */
   },
   UTIL_FORMAT_COLORSPACE_ZS,
   NULL, /* unpack_rgba_8unorm */
   NULL, /* pack_rgba_8unorm */
   NULL, /* fetch_rgba_8unorm */
   NULL, /* unpack_rgba_float */
   NULL, /* pack_rgba_float */
   NULL, /* fetch_rgba_float */
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   &util_format_x24s8_uscaled_unpack_s_8uscaled,
   &util_format_x24s8_uscaled_pack_s_8uscaled
};

const struct util_format_description
util_format_s8x24_uscaled_description = {
   PIPE_FORMAT_S8X24_USCALED,
   "PIPE_FORMAT_S8X24_USCALED",
   "s8x24_uscaled",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   FALSE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 8},	/* x = s */
      {UTIL_FORMAT_TYPE_VOID, FALSE, 24},	/* y = x */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_NONE,	/* z */
      UTIL_FORMAT_SWIZZLE_X,	/* s */
      UTIL_FORMAT_SWIZZLE_NONE,	/* ignored */
      UTIL_FORMAT_SWIZZLE_NONE	/* ignored */
   },
   UTIL_FORMAT_COLORSPACE_ZS,
   NULL, /* unpack_rgba_8unorm */
   NULL, /* pack_rgba_8unorm */
   NULL, /* fetch_rgba_8unorm */
   NULL, /* unpack_rgba_float */
   NULL, /* pack_rgba_float */
   NULL, /* fetch_rgba_float */
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   &util_format_s8x24_uscaled_unpack_s_8uscaled,
   &util_format_s8x24_uscaled_pack_s_8uscaled
};

const struct util_format_description
util_format_z24x8_unorm_description = {
   PIPE_FORMAT_Z24X8_UNORM,
   "PIPE_FORMAT_Z24X8_UNORM",
   "z24x8_unorm",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   FALSE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 24},	/* x = z */
      {UTIL_FORMAT_TYPE_VOID, FALSE, 8},	/* y = x */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* z */
      UTIL_FORMAT_SWIZZLE_NONE,	/* s */
      UTIL_FORMAT_SWIZZLE_NONE,	/* ignored */
      UTIL_FORMAT_SWIZZLE_NONE	/* ignored */
   },
   UTIL_FORMAT_COLORSPACE_ZS,
   NULL, /* unpack_rgba_8unorm */
   NULL, /* pack_rgba_8unorm */
   NULL, /* fetch_rgba_8unorm */
   NULL, /* unpack_rgba_float */
   NULL, /* pack_rgba_float */
   NULL, /* fetch_rgba_float */
   &util_format_z24x8_unorm_unpack_z_32unorm,
   &util_format_z24x8_unorm_pack_z_32unorm,
   &util_format_z24x8_unorm_unpack_z_float,
   &util_format_z24x8_unorm_pack_z_float,
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_x8z24_unorm_description = {
   PIPE_FORMAT_X8Z24_UNORM,
   "PIPE_FORMAT_X8Z24_UNORM",
   "x8z24_unorm",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   FALSE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 8},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 24},	/* y = z */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_Y,	/* z */
      UTIL_FORMAT_SWIZZLE_NONE,	/* s */
      UTIL_FORMAT_SWIZZLE_NONE,	/* ignored */
      UTIL_FORMAT_SWIZZLE_NONE	/* ignored */
   },
   UTIL_FORMAT_COLORSPACE_ZS,
   NULL, /* unpack_rgba_8unorm */
   NULL, /* pack_rgba_8unorm */
   NULL, /* fetch_rgba_8unorm */
   NULL, /* unpack_rgba_float */
   NULL, /* pack_rgba_float */
   NULL, /* fetch_rgba_float */
   &util_format_x8z24_unorm_unpack_z_32unorm,
   &util_format_x8z24_unorm_pack_z_32unorm,
   &util_format_x8z24_unorm_unpack_z_float,
   &util_format_x8z24_unorm_pack_z_float,
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_z32_float_s8x24_uscaled_description = {
   PIPE_FORMAT_Z32_FLOAT_S8X24_USCALED,
   "PIPE_FORMAT_Z32_FLOAT_S8X24_USCALED",
   "z32_float_s8x24_uscaled",
   {1, 1, 64},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   3,	/* nr_channels */
   FALSE,	/* is_array */
   FALSE,	/* is_bitmask */
   TRUE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 32},	/* x = z */
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 8},	/* y = s */
      {UTIL_FORMAT_TYPE_VOID, FALSE, 24},	/* z = x */
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* z */
      UTIL_FORMAT_SWIZZLE_Y,	/* s */
      UTIL_FORMAT_SWIZZLE_NONE,	/* ignored */
      UTIL_FORMAT_SWIZZLE_NONE	/* ignored */
   },
   UTIL_FORMAT_COLORSPACE_ZS,
   NULL, /* unpack_rgba_8unorm */
   NULL, /* pack_rgba_8unorm */
   NULL, /* fetch_rgba_8unorm */
   NULL, /* unpack_rgba_float */
   NULL, /* pack_rgba_float */
   NULL, /* fetch_rgba_float */
   &util_format_z32_float_s8x24_uscaled_unpack_z_32unorm,
   &util_format_z32_float_s8x24_uscaled_pack_z_32unorm,
   &util_format_z32_float_s8x24_uscaled_unpack_z_float,
   &util_format_z32_float_s8x24_uscaled_pack_z_float,
   &util_format_z32_float_s8x24_uscaled_unpack_s_8uscaled,
   &util_format_z32_float_s8x24_uscaled_pack_s_8uscaled
};

const struct util_format_description
util_format_x32_s8x24_uscaled_description = {
   PIPE_FORMAT_X32_S8X24_USCALED,
   "PIPE_FORMAT_X32_S8X24_USCALED",
   "x32_s8x24_uscaled",
   {1, 1, 64},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   3,	/* nr_channels */
   FALSE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 32},	/* x = x */
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 8},	/* y = s */
      {UTIL_FORMAT_TYPE_VOID, FALSE, 24},	/* z = x */
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_NONE,	/* z */
      UTIL_FORMAT_SWIZZLE_Y,	/* s */
      UTIL_FORMAT_SWIZZLE_NONE,	/* ignored */
      UTIL_FORMAT_SWIZZLE_NONE	/* ignored */
   },
   UTIL_FORMAT_COLORSPACE_ZS,
   NULL, /* unpack_rgba_8unorm */
   NULL, /* pack_rgba_8unorm */
   NULL, /* fetch_rgba_8unorm */
   NULL, /* unpack_rgba_float */
   NULL, /* pack_rgba_float */
   NULL, /* fetch_rgba_float */
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   &util_format_x32_s8x24_uscaled_unpack_s_8uscaled,
   &util_format_x32_s8x24_uscaled_pack_s_8uscaled
};

const struct util_format_description
util_format_uyvy_description = {
   PIPE_FORMAT_UYVY,
   "PIPE_FORMAT_UYVY",
   "uyvy",
   {2, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_SUBSAMPLED,
   1,	/* nr_channels */
   FALSE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 32},	/* x = x */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* y */
      UTIL_FORMAT_SWIZZLE_Y,	/* u */
      UTIL_FORMAT_SWIZZLE_Z,	/* v */
      UTIL_FORMAT_SWIZZLE_1	/* ignored */
   },
   UTIL_FORMAT_COLORSPACE_YUV,
   &util_format_uyvy_unpack_rgba_8unorm,
   &util_format_uyvy_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_uyvy_unpack_rgba_float,
   &util_format_uyvy_pack_rgba_float,
   &util_format_uyvy_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_yuyv_description = {
   PIPE_FORMAT_YUYV,
   "PIPE_FORMAT_YUYV",
   "yuyv",
   {2, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_SUBSAMPLED,
   1,	/* nr_channels */
   FALSE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 32},	/* x = x */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* y */
      UTIL_FORMAT_SWIZZLE_Y,	/* u */
      UTIL_FORMAT_SWIZZLE_Z,	/* v */
      UTIL_FORMAT_SWIZZLE_1	/* ignored */
   },
   UTIL_FORMAT_COLORSPACE_YUV,
   &util_format_yuyv_unpack_rgba_8unorm,
   &util_format_yuyv_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_yuyv_unpack_rgba_float,
   &util_format_yuyv_pack_rgba_float,
   &util_format_yuyv_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r8g8_b8g8_unorm_description = {
   PIPE_FORMAT_R8G8_B8G8_UNORM,
   "PIPE_FORMAT_R8G8_B8G8_UNORM",
   "r8g8_b8g8_unorm",
   {2, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_SUBSAMPLED,
   1,	/* nr_channels */
   FALSE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 32},	/* x = x */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r8g8_b8g8_unorm_unpack_rgba_8unorm,
   &util_format_r8g8_b8g8_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r8g8_b8g8_unorm_unpack_rgba_float,
   &util_format_r8g8_b8g8_unorm_pack_rgba_float,
   &util_format_r8g8_b8g8_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_g8r8_g8b8_unorm_description = {
   PIPE_FORMAT_G8R8_G8B8_UNORM,
   "PIPE_FORMAT_G8R8_G8B8_UNORM",
   "g8r8_g8b8_unorm",
   {2, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_SUBSAMPLED,
   1,	/* nr_channels */
   FALSE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 32},	/* x = x */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_g8r8_g8b8_unorm_unpack_rgba_8unorm,
   &util_format_g8r8_g8b8_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_g8r8_g8b8_unorm_unpack_rgba_float,
   &util_format_g8r8_g8b8_unorm_pack_rgba_float,
   &util_format_g8r8_g8b8_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r10g10b10a2_uscaled_description = {
   PIPE_FORMAT_R10G10B10A2_USCALED,
   "PIPE_FORMAT_R10G10B10A2_USCALED",
   "r10g10b10a2_uscaled",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   FALSE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 10},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 10},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 10},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 2}	/* w = a */
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r10g10b10a2_uscaled_unpack_rgba_8unorm,
   &util_format_r10g10b10a2_uscaled_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r10g10b10a2_uscaled_unpack_rgba_float,
   &util_format_r10g10b10a2_uscaled_pack_rgba_float,
   &util_format_r10g10b10a2_uscaled_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r11g11b10_float_description = {
   PIPE_FORMAT_R11G11B10_FLOAT,
   "PIPE_FORMAT_R11G11B10_FLOAT",
   "r11g11b10_float",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_OTHER,
   1,	/* nr_channels */
   FALSE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 32},	/* x = x */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r11g11b10_float_unpack_rgba_8unorm,
   &util_format_r11g11b10_float_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r11g11b10_float_unpack_rgba_float,
   &util_format_r11g11b10_float_pack_rgba_float,
   &util_format_r11g11b10_float_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r9g9b9e5_float_description = {
   PIPE_FORMAT_R9G9B9E5_FLOAT,
   "PIPE_FORMAT_R9G9B9E5_FLOAT",
   "r9g9b9e5_float",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_OTHER,
   1,	/* nr_channels */
   FALSE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 32},	/* x = x */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r9g9b9e5_float_unpack_rgba_8unorm,
   &util_format_r9g9b9e5_float_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r9g9b9e5_float_unpack_rgba_float,
   &util_format_r9g9b9e5_float_pack_rgba_float,
   &util_format_r9g9b9e5_float_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r1_unorm_description = {
   PIPE_FORMAT_R1_UNORM,
   "PIPE_FORMAT_R1_UNORM",
   "r1_unorm",
   {8, 1, 8},	/* block */
   UTIL_FORMAT_LAYOUT_OTHER,
   1,	/* nr_channels */
   FALSE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 8},	/* x = x */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_0,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r1_unorm_unpack_rgba_8unorm,
   &util_format_r1_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r1_unorm_unpack_rgba_float,
   &util_format_r1_unorm_pack_rgba_float,
   &util_format_r1_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r8g8bx_snorm_description = {
   PIPE_FORMAT_R8G8Bx_SNORM,
   "PIPE_FORMAT_R8G8Bx_SNORM",
   "r8g8bx_snorm",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_OTHER,
   2,	/* nr_channels */
   FALSE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 8},	/* x = x */
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 8},	/* y = y */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r8g8bx_snorm_unpack_rgba_8unorm,
   &util_format_r8g8bx_snorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r8g8bx_snorm_unpack_rgba_float,
   &util_format_r8g8bx_snorm_pack_rgba_float,
   &util_format_r8g8bx_snorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_dxt1_rgb_description = {
   PIPE_FORMAT_DXT1_RGB,
   "PIPE_FORMAT_DXT1_RGB",
   "dxt1_rgb",
   {4, 4, 64},	/* block */
   UTIL_FORMAT_LAYOUT_S3TC,
   1,	/* nr_channels */
   FALSE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 64},	/* x = x */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_dxt1_rgb_unpack_rgba_8unorm,
   &util_format_dxt1_rgb_pack_rgba_8unorm,
   &util_format_dxt1_rgb_fetch_rgba_8unorm,
   &util_format_dxt1_rgb_unpack_rgba_float,
   &util_format_dxt1_rgb_pack_rgba_float,
   &util_format_dxt1_rgb_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_dxt1_rgba_description = {
   PIPE_FORMAT_DXT1_RGBA,
   "PIPE_FORMAT_DXT1_RGBA",
   "dxt1_rgba",
   {4, 4, 64},	/* block */
   UTIL_FORMAT_LAYOUT_S3TC,
   1,	/* nr_channels */
   FALSE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 64},	/* x = x */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_dxt1_rgba_unpack_rgba_8unorm,
   &util_format_dxt1_rgba_pack_rgba_8unorm,
   &util_format_dxt1_rgba_fetch_rgba_8unorm,
   &util_format_dxt1_rgba_unpack_rgba_float,
   &util_format_dxt1_rgba_pack_rgba_float,
   &util_format_dxt1_rgba_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_dxt3_rgba_description = {
   PIPE_FORMAT_DXT3_RGBA,
   "PIPE_FORMAT_DXT3_RGBA",
   "dxt3_rgba",
   {4, 4, 128},	/* block */
   UTIL_FORMAT_LAYOUT_S3TC,
   1,	/* nr_channels */
   FALSE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 128},	/* x = x */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_dxt3_rgba_unpack_rgba_8unorm,
   &util_format_dxt3_rgba_pack_rgba_8unorm,
   &util_format_dxt3_rgba_fetch_rgba_8unorm,
   &util_format_dxt3_rgba_unpack_rgba_float,
   &util_format_dxt3_rgba_pack_rgba_float,
   &util_format_dxt3_rgba_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_dxt5_rgba_description = {
   PIPE_FORMAT_DXT5_RGBA,
   "PIPE_FORMAT_DXT5_RGBA",
   "dxt5_rgba",
   {4, 4, 128},	/* block */
   UTIL_FORMAT_LAYOUT_S3TC,
   1,	/* nr_channels */
   FALSE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 128},	/* x = x */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_dxt5_rgba_unpack_rgba_8unorm,
   &util_format_dxt5_rgba_pack_rgba_8unorm,
   &util_format_dxt5_rgba_fetch_rgba_8unorm,
   &util_format_dxt5_rgba_unpack_rgba_float,
   &util_format_dxt5_rgba_pack_rgba_float,
   &util_format_dxt5_rgba_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_dxt1_srgb_description = {
   PIPE_FORMAT_DXT1_SRGB,
   "PIPE_FORMAT_DXT1_SRGB",
   "dxt1_srgb",
   {4, 4, 64},	/* block */
   UTIL_FORMAT_LAYOUT_S3TC,
   1,	/* nr_channels */
   FALSE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 64},	/* x = x */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* sr */
      UTIL_FORMAT_SWIZZLE_Y,	/* sg */
      UTIL_FORMAT_SWIZZLE_Z,	/* sb */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_SRGB,
   &util_format_dxt1_srgb_unpack_rgba_8unorm,
   &util_format_dxt1_srgb_pack_rgba_8unorm,
   &util_format_dxt1_srgb_fetch_rgba_8unorm,
   &util_format_dxt1_srgb_unpack_rgba_float,
   &util_format_dxt1_srgb_pack_rgba_float,
   &util_format_dxt1_srgb_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_dxt1_srgba_description = {
   PIPE_FORMAT_DXT1_SRGBA,
   "PIPE_FORMAT_DXT1_SRGBA",
   "dxt1_srgba",
   {4, 4, 64},	/* block */
   UTIL_FORMAT_LAYOUT_S3TC,
   1,	/* nr_channels */
   FALSE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 64},	/* x = x */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* sr */
      UTIL_FORMAT_SWIZZLE_Y,	/* sg */
      UTIL_FORMAT_SWIZZLE_Z,	/* sb */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_SRGB,
   &util_format_dxt1_srgba_unpack_rgba_8unorm,
   &util_format_dxt1_srgba_pack_rgba_8unorm,
   &util_format_dxt1_srgba_fetch_rgba_8unorm,
   &util_format_dxt1_srgba_unpack_rgba_float,
   &util_format_dxt1_srgba_pack_rgba_float,
   &util_format_dxt1_srgba_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_dxt3_srgba_description = {
   PIPE_FORMAT_DXT3_SRGBA,
   "PIPE_FORMAT_DXT3_SRGBA",
   "dxt3_srgba",
   {4, 4, 128},	/* block */
   UTIL_FORMAT_LAYOUT_S3TC,
   1,	/* nr_channels */
   FALSE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 128},	/* x = x */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* sr */
      UTIL_FORMAT_SWIZZLE_Y,	/* sg */
      UTIL_FORMAT_SWIZZLE_Z,	/* sb */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_SRGB,
   &util_format_dxt3_srgba_unpack_rgba_8unorm,
   &util_format_dxt3_srgba_pack_rgba_8unorm,
   &util_format_dxt3_srgba_fetch_rgba_8unorm,
   &util_format_dxt3_srgba_unpack_rgba_float,
   &util_format_dxt3_srgba_pack_rgba_float,
   &util_format_dxt3_srgba_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_dxt5_srgba_description = {
   PIPE_FORMAT_DXT5_SRGBA,
   "PIPE_FORMAT_DXT5_SRGBA",
   "dxt5_srgba",
   {4, 4, 128},	/* block */
   UTIL_FORMAT_LAYOUT_S3TC,
   1,	/* nr_channels */
   FALSE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 128},	/* x = x */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* sr */
      UTIL_FORMAT_SWIZZLE_Y,	/* sg */
      UTIL_FORMAT_SWIZZLE_Z,	/* sb */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_SRGB,
   &util_format_dxt5_srgba_unpack_rgba_8unorm,
   &util_format_dxt5_srgba_pack_rgba_8unorm,
   &util_format_dxt5_srgba_fetch_rgba_8unorm,
   &util_format_dxt5_srgba_unpack_rgba_float,
   &util_format_dxt5_srgba_pack_rgba_float,
   &util_format_dxt5_srgba_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_rgtc1_unorm_description = {
   PIPE_FORMAT_RGTC1_UNORM,
   "PIPE_FORMAT_RGTC1_UNORM",
   "rgtc1_unorm",
   {4, 4, 64},	/* block */
   UTIL_FORMAT_LAYOUT_RGTC,
   1,	/* nr_channels */
   FALSE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 64},	/* x = x */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_0,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_rgtc1_unorm_unpack_rgba_8unorm,
   &util_format_rgtc1_unorm_pack_rgba_8unorm,
   &util_format_rgtc1_unorm_fetch_rgba_8unorm,
   &util_format_rgtc1_unorm_unpack_rgba_float,
   &util_format_rgtc1_unorm_pack_rgba_float,
   &util_format_rgtc1_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_rgtc1_snorm_description = {
   PIPE_FORMAT_RGTC1_SNORM,
   "PIPE_FORMAT_RGTC1_SNORM",
   "rgtc1_snorm",
   {4, 4, 64},	/* block */
   UTIL_FORMAT_LAYOUT_RGTC,
   1,	/* nr_channels */
   FALSE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 64},	/* x = x */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_0,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_rgtc1_snorm_unpack_rgba_8unorm,
   &util_format_rgtc1_snorm_pack_rgba_8unorm,
   &util_format_rgtc1_snorm_fetch_rgba_8unorm,
   &util_format_rgtc1_snorm_unpack_rgba_float,
   &util_format_rgtc1_snorm_pack_rgba_float,
   &util_format_rgtc1_snorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_rgtc2_unorm_description = {
   PIPE_FORMAT_RGTC2_UNORM,
   "PIPE_FORMAT_RGTC2_UNORM",
   "rgtc2_unorm",
   {4, 4, 128},	/* block */
   UTIL_FORMAT_LAYOUT_RGTC,
   1,	/* nr_channels */
   FALSE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 128},	/* x = x */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_rgtc2_unorm_unpack_rgba_8unorm,
   &util_format_rgtc2_unorm_pack_rgba_8unorm,
   &util_format_rgtc2_unorm_fetch_rgba_8unorm,
   &util_format_rgtc2_unorm_unpack_rgba_float,
   &util_format_rgtc2_unorm_pack_rgba_float,
   &util_format_rgtc2_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_rgtc2_snorm_description = {
   PIPE_FORMAT_RGTC2_SNORM,
   "PIPE_FORMAT_RGTC2_SNORM",
   "rgtc2_snorm",
   {4, 4, 128},	/* block */
   UTIL_FORMAT_LAYOUT_RGTC,
   1,	/* nr_channels */
   FALSE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 128},	/* x = x */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_rgtc2_snorm_unpack_rgba_8unorm,
   &util_format_rgtc2_snorm_pack_rgba_8unorm,
   &util_format_rgtc2_snorm_fetch_rgba_8unorm,
   &util_format_rgtc2_snorm_unpack_rgba_float,
   &util_format_rgtc2_snorm_pack_rgba_float,
   &util_format_rgtc2_snorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_latc1_unorm_description = {
   PIPE_FORMAT_LATC1_UNORM,
   "PIPE_FORMAT_LATC1_UNORM",
   "latc1_unorm",
   {4, 4, 64},	/* block */
   UTIL_FORMAT_LAYOUT_RGTC,
   1,	/* nr_channels */
   FALSE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 64},	/* x = x */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_X,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_latc1_unorm_unpack_rgba_8unorm,
   &util_format_latc1_unorm_pack_rgba_8unorm,
   &util_format_latc1_unorm_fetch_rgba_8unorm,
   &util_format_latc1_unorm_unpack_rgba_float,
   &util_format_latc1_unorm_pack_rgba_float,
   &util_format_latc1_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_latc1_snorm_description = {
   PIPE_FORMAT_LATC1_SNORM,
   "PIPE_FORMAT_LATC1_SNORM",
   "latc1_snorm",
   {4, 4, 64},	/* block */
   UTIL_FORMAT_LAYOUT_RGTC,
   1,	/* nr_channels */
   FALSE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 64},	/* x = x */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_X,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_latc1_snorm_unpack_rgba_8unorm,
   &util_format_latc1_snorm_pack_rgba_8unorm,
   &util_format_latc1_snorm_fetch_rgba_8unorm,
   &util_format_latc1_snorm_unpack_rgba_float,
   &util_format_latc1_snorm_pack_rgba_float,
   &util_format_latc1_snorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_latc2_unorm_description = {
   PIPE_FORMAT_LATC2_UNORM,
   "PIPE_FORMAT_LATC2_UNORM",
   "latc2_unorm",
   {4, 4, 128},	/* block */
   UTIL_FORMAT_LAYOUT_RGTC,
   1,	/* nr_channels */
   FALSE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 128},	/* x = x */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_X,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_Y	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_latc2_unorm_unpack_rgba_8unorm,
   &util_format_latc2_unorm_pack_rgba_8unorm,
   &util_format_latc2_unorm_fetch_rgba_8unorm,
   &util_format_latc2_unorm_unpack_rgba_float,
   &util_format_latc2_unorm_pack_rgba_float,
   &util_format_latc2_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_latc2_snorm_description = {
   PIPE_FORMAT_LATC2_SNORM,
   "PIPE_FORMAT_LATC2_SNORM",
   "latc2_snorm",
   {4, 4, 128},	/* block */
   UTIL_FORMAT_LAYOUT_RGTC,
   1,	/* nr_channels */
   FALSE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_VOID, FALSE, 128},	/* x = x */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_X,	/* g */
      UTIL_FORMAT_SWIZZLE_X,	/* b */
      UTIL_FORMAT_SWIZZLE_Y	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_latc2_snorm_unpack_rgba_8unorm,
   &util_format_latc2_snorm_pack_rgba_8unorm,
   &util_format_latc2_snorm_fetch_rgba_8unorm,
   &util_format_latc2_snorm_unpack_rgba_float,
   &util_format_latc2_snorm_pack_rgba_float,
   &util_format_latc2_snorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r64_float_description = {
   PIPE_FORMAT_R64_FLOAT,
   "PIPE_FORMAT_R64_FLOAT",
   "r64_float",
   {1, 1, 64},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 64},	/* x = r */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_0,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r64_float_unpack_rgba_8unorm,
   &util_format_r64_float_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r64_float_unpack_rgba_float,
   &util_format_r64_float_pack_rgba_float,
   &util_format_r64_float_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r64g64_float_description = {
   PIPE_FORMAT_R64G64_FLOAT,
   "PIPE_FORMAT_R64G64_FLOAT",
   "r64g64_float",
   {1, 1, 128},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 64},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 64},	/* y = g */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r64g64_float_unpack_rgba_8unorm,
   &util_format_r64g64_float_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r64g64_float_unpack_rgba_float,
   &util_format_r64g64_float_pack_rgba_float,
   &util_format_r64g64_float_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r64g64b64_float_description = {
   PIPE_FORMAT_R64G64B64_FLOAT,
   "PIPE_FORMAT_R64G64B64_FLOAT",
   "r64g64b64_float",
   {1, 1, 192},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   3,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 64},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 64},	/* y = g */
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 64},	/* z = b */
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r64g64b64_float_unpack_rgba_8unorm,
   &util_format_r64g64b64_float_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r64g64b64_float_unpack_rgba_float,
   &util_format_r64g64b64_float_pack_rgba_float,
   &util_format_r64g64b64_float_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r64g64b64a64_float_description = {
   PIPE_FORMAT_R64G64B64A64_FLOAT,
   "PIPE_FORMAT_R64G64B64A64_FLOAT",
   "r64g64b64a64_float",
   {1, 1, 256},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 64},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 64},	/* y = g */
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 64},	/* z = b */
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 64}	/* w = a */
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r64g64b64a64_float_unpack_rgba_8unorm,
   &util_format_r64g64b64a64_float_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r64g64b64a64_float_unpack_rgba_float,
   &util_format_r64g64b64a64_float_pack_rgba_float,
   &util_format_r64g64b64a64_float_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r32_float_description = {
   PIPE_FORMAT_R32_FLOAT,
   "PIPE_FORMAT_R32_FLOAT",
   "r32_float",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 32},	/* x = r */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_0,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r32_float_unpack_rgba_8unorm,
   &util_format_r32_float_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r32_float_unpack_rgba_float,
   &util_format_r32_float_pack_rgba_float,
   &util_format_r32_float_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r32g32_float_description = {
   PIPE_FORMAT_R32G32_FLOAT,
   "PIPE_FORMAT_R32G32_FLOAT",
   "r32g32_float",
   {1, 1, 64},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 32},	/* y = g */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r32g32_float_unpack_rgba_8unorm,
   &util_format_r32g32_float_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r32g32_float_unpack_rgba_float,
   &util_format_r32g32_float_pack_rgba_float,
   &util_format_r32g32_float_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r32g32b32_float_description = {
   PIPE_FORMAT_R32G32B32_FLOAT,
   "PIPE_FORMAT_R32G32B32_FLOAT",
   "r32g32b32_float",
   {1, 1, 96},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   3,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 32},	/* z = b */
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r32g32b32_float_unpack_rgba_8unorm,
   &util_format_r32g32b32_float_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r32g32b32_float_unpack_rgba_float,
   &util_format_r32g32b32_float_pack_rgba_float,
   &util_format_r32g32b32_float_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r32g32b32a32_float_description = {
   PIPE_FORMAT_R32G32B32A32_FLOAT,
   "PIPE_FORMAT_R32G32B32A32_FLOAT",
   "r32g32b32a32_float",
   {1, 1, 128},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 32}	/* w = a */
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r32g32b32a32_float_unpack_rgba_8unorm,
   &util_format_r32g32b32a32_float_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r32g32b32a32_float_unpack_rgba_float,
   &util_format_r32g32b32a32_float_pack_rgba_float,
   &util_format_r32g32b32a32_float_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r32_unorm_description = {
   PIPE_FORMAT_R32_UNORM,
   "PIPE_FORMAT_R32_UNORM",
   "r32_unorm",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 32},	/* x = r */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_0,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r32_unorm_unpack_rgba_8unorm,
   &util_format_r32_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r32_unorm_unpack_rgba_float,
   &util_format_r32_unorm_pack_rgba_float,
   &util_format_r32_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r32g32_unorm_description = {
   PIPE_FORMAT_R32G32_UNORM,
   "PIPE_FORMAT_R32G32_UNORM",
   "r32g32_unorm",
   {1, 1, 64},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 32},	/* y = g */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r32g32_unorm_unpack_rgba_8unorm,
   &util_format_r32g32_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r32g32_unorm_unpack_rgba_float,
   &util_format_r32g32_unorm_pack_rgba_float,
   &util_format_r32g32_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r32g32b32_unorm_description = {
   PIPE_FORMAT_R32G32B32_UNORM,
   "PIPE_FORMAT_R32G32B32_UNORM",
   "r32g32b32_unorm",
   {1, 1, 96},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   3,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 32},	/* z = b */
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r32g32b32_unorm_unpack_rgba_8unorm,
   &util_format_r32g32b32_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r32g32b32_unorm_unpack_rgba_float,
   &util_format_r32g32b32_unorm_pack_rgba_float,
   &util_format_r32g32b32_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r32g32b32a32_unorm_description = {
   PIPE_FORMAT_R32G32B32A32_UNORM,
   "PIPE_FORMAT_R32G32B32A32_UNORM",
   "r32g32b32a32_unorm",
   {1, 1, 128},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 32}	/* w = a */
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r32g32b32a32_unorm_unpack_rgba_8unorm,
   &util_format_r32g32b32a32_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r32g32b32a32_unorm_unpack_rgba_float,
   &util_format_r32g32b32a32_unorm_pack_rgba_float,
   &util_format_r32g32b32a32_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r32_uscaled_description = {
   PIPE_FORMAT_R32_USCALED,
   "PIPE_FORMAT_R32_USCALED",
   "r32_uscaled",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 32},	/* x = r */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_0,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r32_uscaled_unpack_rgba_8unorm,
   &util_format_r32_uscaled_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r32_uscaled_unpack_rgba_float,
   &util_format_r32_uscaled_pack_rgba_float,
   &util_format_r32_uscaled_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r32g32_uscaled_description = {
   PIPE_FORMAT_R32G32_USCALED,
   "PIPE_FORMAT_R32G32_USCALED",
   "r32g32_uscaled",
   {1, 1, 64},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 32},	/* y = g */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r32g32_uscaled_unpack_rgba_8unorm,
   &util_format_r32g32_uscaled_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r32g32_uscaled_unpack_rgba_float,
   &util_format_r32g32_uscaled_pack_rgba_float,
   &util_format_r32g32_uscaled_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r32g32b32_uscaled_description = {
   PIPE_FORMAT_R32G32B32_USCALED,
   "PIPE_FORMAT_R32G32B32_USCALED",
   "r32g32b32_uscaled",
   {1, 1, 96},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   3,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 32},	/* z = b */
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r32g32b32_uscaled_unpack_rgba_8unorm,
   &util_format_r32g32b32_uscaled_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r32g32b32_uscaled_unpack_rgba_float,
   &util_format_r32g32b32_uscaled_pack_rgba_float,
   &util_format_r32g32b32_uscaled_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r32g32b32a32_uscaled_description = {
   PIPE_FORMAT_R32G32B32A32_USCALED,
   "PIPE_FORMAT_R32G32B32A32_USCALED",
   "r32g32b32a32_uscaled",
   {1, 1, 128},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 32}	/* w = a */
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r32g32b32a32_uscaled_unpack_rgba_8unorm,
   &util_format_r32g32b32a32_uscaled_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r32g32b32a32_uscaled_unpack_rgba_float,
   &util_format_r32g32b32a32_uscaled_pack_rgba_float,
   &util_format_r32g32b32a32_uscaled_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r32_snorm_description = {
   PIPE_FORMAT_R32_SNORM,
   "PIPE_FORMAT_R32_SNORM",
   "r32_snorm",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 32},	/* x = r */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_0,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r32_snorm_unpack_rgba_8unorm,
   &util_format_r32_snorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r32_snorm_unpack_rgba_float,
   &util_format_r32_snorm_pack_rgba_float,
   &util_format_r32_snorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r32g32_snorm_description = {
   PIPE_FORMAT_R32G32_SNORM,
   "PIPE_FORMAT_R32G32_SNORM",
   "r32g32_snorm",
   {1, 1, 64},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 32},	/* y = g */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r32g32_snorm_unpack_rgba_8unorm,
   &util_format_r32g32_snorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r32g32_snorm_unpack_rgba_float,
   &util_format_r32g32_snorm_pack_rgba_float,
   &util_format_r32g32_snorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r32g32b32_snorm_description = {
   PIPE_FORMAT_R32G32B32_SNORM,
   "PIPE_FORMAT_R32G32B32_SNORM",
   "r32g32b32_snorm",
   {1, 1, 96},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   3,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 32},	/* z = b */
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r32g32b32_snorm_unpack_rgba_8unorm,
   &util_format_r32g32b32_snorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r32g32b32_snorm_unpack_rgba_float,
   &util_format_r32g32b32_snorm_pack_rgba_float,
   &util_format_r32g32b32_snorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r32g32b32a32_snorm_description = {
   PIPE_FORMAT_R32G32B32A32_SNORM,
   "PIPE_FORMAT_R32G32B32A32_SNORM",
   "r32g32b32a32_snorm",
   {1, 1, 128},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 32}	/* w = a */
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r32g32b32a32_snorm_unpack_rgba_8unorm,
   &util_format_r32g32b32a32_snorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r32g32b32a32_snorm_unpack_rgba_float,
   &util_format_r32g32b32a32_snorm_pack_rgba_float,
   &util_format_r32g32b32a32_snorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r32_sscaled_description = {
   PIPE_FORMAT_R32_SSCALED,
   "PIPE_FORMAT_R32_SSCALED",
   "r32_sscaled",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 32},	/* x = r */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_0,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r32_sscaled_unpack_rgba_8unorm,
   &util_format_r32_sscaled_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r32_sscaled_unpack_rgba_float,
   &util_format_r32_sscaled_pack_rgba_float,
   &util_format_r32_sscaled_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r32g32_sscaled_description = {
   PIPE_FORMAT_R32G32_SSCALED,
   "PIPE_FORMAT_R32G32_SSCALED",
   "r32g32_sscaled",
   {1, 1, 64},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 32},	/* y = g */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r32g32_sscaled_unpack_rgba_8unorm,
   &util_format_r32g32_sscaled_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r32g32_sscaled_unpack_rgba_float,
   &util_format_r32g32_sscaled_pack_rgba_float,
   &util_format_r32g32_sscaled_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r32g32b32_sscaled_description = {
   PIPE_FORMAT_R32G32B32_SSCALED,
   "PIPE_FORMAT_R32G32B32_SSCALED",
   "r32g32b32_sscaled",
   {1, 1, 96},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   3,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 32},	/* z = b */
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r32g32b32_sscaled_unpack_rgba_8unorm,
   &util_format_r32g32b32_sscaled_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r32g32b32_sscaled_unpack_rgba_float,
   &util_format_r32g32b32_sscaled_pack_rgba_float,
   &util_format_r32g32b32_sscaled_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r32g32b32a32_sscaled_description = {
   PIPE_FORMAT_R32G32B32A32_SSCALED,
   "PIPE_FORMAT_R32G32B32A32_SSCALED",
   "r32g32b32a32_sscaled",
   {1, 1, 128},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 32}	/* w = a */
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r32g32b32a32_sscaled_unpack_rgba_8unorm,
   &util_format_r32g32b32a32_sscaled_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r32g32b32a32_sscaled_unpack_rgba_float,
   &util_format_r32g32b32a32_sscaled_pack_rgba_float,
   &util_format_r32g32b32a32_sscaled_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r16_float_description = {
   PIPE_FORMAT_R16_FLOAT,
   "PIPE_FORMAT_R16_FLOAT",
   "r16_float",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 16},	/* x = r */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_0,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r16_float_unpack_rgba_8unorm,
   &util_format_r16_float_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r16_float_unpack_rgba_float,
   &util_format_r16_float_pack_rgba_float,
   &util_format_r16_float_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r16g16_float_description = {
   PIPE_FORMAT_R16G16_FLOAT,
   "PIPE_FORMAT_R16G16_FLOAT",
   "r16g16_float",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 16},	/* y = g */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r16g16_float_unpack_rgba_8unorm,
   &util_format_r16g16_float_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r16g16_float_unpack_rgba_float,
   &util_format_r16g16_float_pack_rgba_float,
   &util_format_r16g16_float_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r16g16b16_float_description = {
   PIPE_FORMAT_R16G16B16_FLOAT,
   "PIPE_FORMAT_R16G16B16_FLOAT",
   "r16g16b16_float",
   {1, 1, 48},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   3,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 16},	/* z = b */
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r16g16b16_float_unpack_rgba_8unorm,
   &util_format_r16g16b16_float_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r16g16b16_float_unpack_rgba_float,
   &util_format_r16g16b16_float_pack_rgba_float,
   &util_format_r16g16b16_float_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r16g16b16a16_float_description = {
   PIPE_FORMAT_R16G16B16A16_FLOAT,
   "PIPE_FORMAT_R16G16B16A16_FLOAT",
   "r16g16b16a16_float",
   {1, 1, 64},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_FLOAT, FALSE, 16}	/* w = a */
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r16g16b16a16_float_unpack_rgba_8unorm,
   &util_format_r16g16b16a16_float_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r16g16b16a16_float_unpack_rgba_float,
   &util_format_r16g16b16a16_float_pack_rgba_float,
   &util_format_r16g16b16a16_float_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r16_unorm_description = {
   PIPE_FORMAT_R16_UNORM,
   "PIPE_FORMAT_R16_UNORM",
   "r16_unorm",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 16},	/* x = r */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_0,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r16_unorm_unpack_rgba_8unorm,
   &util_format_r16_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r16_unorm_unpack_rgba_float,
   &util_format_r16_unorm_pack_rgba_float,
   &util_format_r16_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r16g16_unorm_description = {
   PIPE_FORMAT_R16G16_UNORM,
   "PIPE_FORMAT_R16G16_UNORM",
   "r16g16_unorm",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 16},	/* y = g */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r16g16_unorm_unpack_rgba_8unorm,
   &util_format_r16g16_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r16g16_unorm_unpack_rgba_float,
   &util_format_r16g16_unorm_pack_rgba_float,
   &util_format_r16g16_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r16g16b16_unorm_description = {
   PIPE_FORMAT_R16G16B16_UNORM,
   "PIPE_FORMAT_R16G16B16_UNORM",
   "r16g16b16_unorm",
   {1, 1, 48},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   3,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 16},	/* z = b */
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r16g16b16_unorm_unpack_rgba_8unorm,
   &util_format_r16g16b16_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r16g16b16_unorm_unpack_rgba_float,
   &util_format_r16g16b16_unorm_pack_rgba_float,
   &util_format_r16g16b16_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r16g16b16a16_unorm_description = {
   PIPE_FORMAT_R16G16B16A16_UNORM,
   "PIPE_FORMAT_R16G16B16A16_UNORM",
   "r16g16b16a16_unorm",
   {1, 1, 64},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 16}	/* w = a */
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r16g16b16a16_unorm_unpack_rgba_8unorm,
   &util_format_r16g16b16a16_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r16g16b16a16_unorm_unpack_rgba_float,
   &util_format_r16g16b16a16_unorm_pack_rgba_float,
   &util_format_r16g16b16a16_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r16_uscaled_description = {
   PIPE_FORMAT_R16_USCALED,
   "PIPE_FORMAT_R16_USCALED",
   "r16_uscaled",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 16},	/* x = r */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_0,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r16_uscaled_unpack_rgba_8unorm,
   &util_format_r16_uscaled_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r16_uscaled_unpack_rgba_float,
   &util_format_r16_uscaled_pack_rgba_float,
   &util_format_r16_uscaled_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r16g16_uscaled_description = {
   PIPE_FORMAT_R16G16_USCALED,
   "PIPE_FORMAT_R16G16_USCALED",
   "r16g16_uscaled",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 16},	/* y = g */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r16g16_uscaled_unpack_rgba_8unorm,
   &util_format_r16g16_uscaled_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r16g16_uscaled_unpack_rgba_float,
   &util_format_r16g16_uscaled_pack_rgba_float,
   &util_format_r16g16_uscaled_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r16g16b16_uscaled_description = {
   PIPE_FORMAT_R16G16B16_USCALED,
   "PIPE_FORMAT_R16G16B16_USCALED",
   "r16g16b16_uscaled",
   {1, 1, 48},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   3,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 16},	/* z = b */
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r16g16b16_uscaled_unpack_rgba_8unorm,
   &util_format_r16g16b16_uscaled_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r16g16b16_uscaled_unpack_rgba_float,
   &util_format_r16g16b16_uscaled_pack_rgba_float,
   &util_format_r16g16b16_uscaled_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r16g16b16a16_uscaled_description = {
   PIPE_FORMAT_R16G16B16A16_USCALED,
   "PIPE_FORMAT_R16G16B16A16_USCALED",
   "r16g16b16a16_uscaled",
   {1, 1, 64},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 16}	/* w = a */
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r16g16b16a16_uscaled_unpack_rgba_8unorm,
   &util_format_r16g16b16a16_uscaled_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r16g16b16a16_uscaled_unpack_rgba_float,
   &util_format_r16g16b16a16_uscaled_pack_rgba_float,
   &util_format_r16g16b16a16_uscaled_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r16_snorm_description = {
   PIPE_FORMAT_R16_SNORM,
   "PIPE_FORMAT_R16_SNORM",
   "r16_snorm",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 16},	/* x = r */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_0,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r16_snorm_unpack_rgba_8unorm,
   &util_format_r16_snorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r16_snorm_unpack_rgba_float,
   &util_format_r16_snorm_pack_rgba_float,
   &util_format_r16_snorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r16g16_snorm_description = {
   PIPE_FORMAT_R16G16_SNORM,
   "PIPE_FORMAT_R16G16_SNORM",
   "r16g16_snorm",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 16},	/* y = g */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r16g16_snorm_unpack_rgba_8unorm,
   &util_format_r16g16_snorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r16g16_snorm_unpack_rgba_float,
   &util_format_r16g16_snorm_pack_rgba_float,
   &util_format_r16g16_snorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r16g16b16_snorm_description = {
   PIPE_FORMAT_R16G16B16_SNORM,
   "PIPE_FORMAT_R16G16B16_SNORM",
   "r16g16b16_snorm",
   {1, 1, 48},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   3,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 16},	/* z = b */
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r16g16b16_snorm_unpack_rgba_8unorm,
   &util_format_r16g16b16_snorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r16g16b16_snorm_unpack_rgba_float,
   &util_format_r16g16b16_snorm_pack_rgba_float,
   &util_format_r16g16b16_snorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r16g16b16a16_snorm_description = {
   PIPE_FORMAT_R16G16B16A16_SNORM,
   "PIPE_FORMAT_R16G16B16A16_SNORM",
   "r16g16b16a16_snorm",
   {1, 1, 64},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 16}	/* w = a */
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r16g16b16a16_snorm_unpack_rgba_8unorm,
   &util_format_r16g16b16a16_snorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r16g16b16a16_snorm_unpack_rgba_float,
   &util_format_r16g16b16a16_snorm_pack_rgba_float,
   &util_format_r16g16b16a16_snorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r16_sscaled_description = {
   PIPE_FORMAT_R16_SSCALED,
   "PIPE_FORMAT_R16_SSCALED",
   "r16_sscaled",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 16},	/* x = r */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_0,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r16_sscaled_unpack_rgba_8unorm,
   &util_format_r16_sscaled_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r16_sscaled_unpack_rgba_float,
   &util_format_r16_sscaled_pack_rgba_float,
   &util_format_r16_sscaled_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r16g16_sscaled_description = {
   PIPE_FORMAT_R16G16_SSCALED,
   "PIPE_FORMAT_R16G16_SSCALED",
   "r16g16_sscaled",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 16},	/* y = g */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r16g16_sscaled_unpack_rgba_8unorm,
   &util_format_r16g16_sscaled_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r16g16_sscaled_unpack_rgba_float,
   &util_format_r16g16_sscaled_pack_rgba_float,
   &util_format_r16g16_sscaled_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r16g16b16_sscaled_description = {
   PIPE_FORMAT_R16G16B16_SSCALED,
   "PIPE_FORMAT_R16G16B16_SSCALED",
   "r16g16b16_sscaled",
   {1, 1, 48},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   3,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 16},	/* z = b */
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r16g16b16_sscaled_unpack_rgba_8unorm,
   &util_format_r16g16b16_sscaled_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r16g16b16_sscaled_unpack_rgba_float,
   &util_format_r16g16b16_sscaled_pack_rgba_float,
   &util_format_r16g16b16_sscaled_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r16g16b16a16_sscaled_description = {
   PIPE_FORMAT_R16G16B16A16_SSCALED,
   "PIPE_FORMAT_R16G16B16A16_SSCALED",
   "r16g16b16a16_sscaled",
   {1, 1, 64},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 16},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 16},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 16},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 16}	/* w = a */
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r16g16b16a16_sscaled_unpack_rgba_8unorm,
   &util_format_r16g16b16a16_sscaled_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r16g16b16a16_sscaled_unpack_rgba_float,
   &util_format_r16g16b16a16_sscaled_pack_rgba_float,
   &util_format_r16g16b16a16_sscaled_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r8_unorm_description = {
   PIPE_FORMAT_R8_UNORM,
   "PIPE_FORMAT_R8_UNORM",
   "r8_unorm",
   {1, 1, 8},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* x = r */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_0,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r8_unorm_unpack_rgba_8unorm,
   &util_format_r8_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r8_unorm_unpack_rgba_float,
   &util_format_r8_unorm_pack_rgba_float,
   &util_format_r8_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r8g8_unorm_description = {
   PIPE_FORMAT_R8G8_UNORM,
   "PIPE_FORMAT_R8G8_UNORM",
   "r8g8_unorm",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* y = g */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r8g8_unorm_unpack_rgba_8unorm,
   &util_format_r8g8_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r8g8_unorm_unpack_rgba_float,
   &util_format_r8g8_unorm_pack_rgba_float,
   &util_format_r8g8_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r8g8b8_unorm_description = {
   PIPE_FORMAT_R8G8B8_UNORM,
   "PIPE_FORMAT_R8G8B8_UNORM",
   "r8g8b8_unorm",
   {1, 1, 24},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   3,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* z = b */
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r8g8b8_unorm_unpack_rgba_8unorm,
   &util_format_r8g8b8_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r8g8b8_unorm_unpack_rgba_float,
   &util_format_r8g8b8_unorm_pack_rgba_float,
   &util_format_r8g8b8_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r8g8b8a8_unorm_description = {
   PIPE_FORMAT_R8G8B8A8_UNORM,
   "PIPE_FORMAT_R8G8B8A8_UNORM",
   "r8g8b8a8_unorm",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, TRUE, 8}	/* w = a */
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r8g8b8a8_unorm_unpack_rgba_8unorm,
   &util_format_r8g8b8a8_unorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r8g8b8a8_unorm_unpack_rgba_float,
   &util_format_r8g8b8a8_unorm_pack_rgba_float,
   &util_format_r8g8b8a8_unorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r8_uscaled_description = {
   PIPE_FORMAT_R8_USCALED,
   "PIPE_FORMAT_R8_USCALED",
   "r8_uscaled",
   {1, 1, 8},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 8},	/* x = r */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_0,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r8_uscaled_unpack_rgba_8unorm,
   &util_format_r8_uscaled_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r8_uscaled_unpack_rgba_float,
   &util_format_r8_uscaled_pack_rgba_float,
   &util_format_r8_uscaled_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r8g8_uscaled_description = {
   PIPE_FORMAT_R8G8_USCALED,
   "PIPE_FORMAT_R8G8_USCALED",
   "r8g8_uscaled",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 8},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 8},	/* y = g */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r8g8_uscaled_unpack_rgba_8unorm,
   &util_format_r8g8_uscaled_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r8g8_uscaled_unpack_rgba_float,
   &util_format_r8g8_uscaled_pack_rgba_float,
   &util_format_r8g8_uscaled_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r8g8b8_uscaled_description = {
   PIPE_FORMAT_R8G8B8_USCALED,
   "PIPE_FORMAT_R8G8B8_USCALED",
   "r8g8b8_uscaled",
   {1, 1, 24},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   3,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 8},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 8},	/* z = b */
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r8g8b8_uscaled_unpack_rgba_8unorm,
   &util_format_r8g8b8_uscaled_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r8g8b8_uscaled_unpack_rgba_float,
   &util_format_r8g8b8_uscaled_pack_rgba_float,
   &util_format_r8g8b8_uscaled_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r8g8b8a8_uscaled_description = {
   PIPE_FORMAT_R8G8B8A8_USCALED,
   "PIPE_FORMAT_R8G8B8A8_USCALED",
   "r8g8b8a8_uscaled",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 8},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 8},	/* z = b */
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 8}	/* w = a */
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r8g8b8a8_uscaled_unpack_rgba_8unorm,
   &util_format_r8g8b8a8_uscaled_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r8g8b8a8_uscaled_unpack_rgba_float,
   &util_format_r8g8b8a8_uscaled_pack_rgba_float,
   &util_format_r8g8b8a8_uscaled_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r8_snorm_description = {
   PIPE_FORMAT_R8_SNORM,
   "PIPE_FORMAT_R8_SNORM",
   "r8_snorm",
   {1, 1, 8},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 8},	/* x = r */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_0,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r8_snorm_unpack_rgba_8unorm,
   &util_format_r8_snorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r8_snorm_unpack_rgba_float,
   &util_format_r8_snorm_pack_rgba_float,
   &util_format_r8_snorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r8g8_snorm_description = {
   PIPE_FORMAT_R8G8_SNORM,
   "PIPE_FORMAT_R8G8_SNORM",
   "r8g8_snorm",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 8},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 8},	/* y = g */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r8g8_snorm_unpack_rgba_8unorm,
   &util_format_r8g8_snorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r8g8_snorm_unpack_rgba_float,
   &util_format_r8g8_snorm_pack_rgba_float,
   &util_format_r8g8_snorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r8g8b8_snorm_description = {
   PIPE_FORMAT_R8G8B8_SNORM,
   "PIPE_FORMAT_R8G8B8_SNORM",
   "r8g8b8_snorm",
   {1, 1, 24},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   3,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 8},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 8},	/* z = b */
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r8g8b8_snorm_unpack_rgba_8unorm,
   &util_format_r8g8b8_snorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r8g8b8_snorm_unpack_rgba_float,
   &util_format_r8g8b8_snorm_pack_rgba_float,
   &util_format_r8g8b8_snorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r8g8b8a8_snorm_description = {
   PIPE_FORMAT_R8G8B8A8_SNORM,
   "PIPE_FORMAT_R8G8B8A8_SNORM",
   "r8g8b8a8_snorm",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 8},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 8},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 8}	/* w = a */
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r8g8b8a8_snorm_unpack_rgba_8unorm,
   &util_format_r8g8b8a8_snorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r8g8b8a8_snorm_unpack_rgba_float,
   &util_format_r8g8b8a8_snorm_pack_rgba_float,
   &util_format_r8g8b8a8_snorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r8_sscaled_description = {
   PIPE_FORMAT_R8_SSCALED,
   "PIPE_FORMAT_R8_SSCALED",
   "r8_sscaled",
   {1, 1, 8},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 8},	/* x = r */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_0,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r8_sscaled_unpack_rgba_8unorm,
   &util_format_r8_sscaled_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r8_sscaled_unpack_rgba_float,
   &util_format_r8_sscaled_pack_rgba_float,
   &util_format_r8_sscaled_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r8g8_sscaled_description = {
   PIPE_FORMAT_R8G8_SSCALED,
   "PIPE_FORMAT_R8G8_SSCALED",
   "r8g8_sscaled",
   {1, 1, 16},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 8},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 8},	/* y = g */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r8g8_sscaled_unpack_rgba_8unorm,
   &util_format_r8g8_sscaled_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r8g8_sscaled_unpack_rgba_float,
   &util_format_r8g8_sscaled_pack_rgba_float,
   &util_format_r8g8_sscaled_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r8g8b8_sscaled_description = {
   PIPE_FORMAT_R8G8B8_SSCALED,
   "PIPE_FORMAT_R8G8B8_SSCALED",
   "r8g8b8_sscaled",
   {1, 1, 24},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   3,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 8},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 8},	/* z = b */
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r8g8b8_sscaled_unpack_rgba_8unorm,
   &util_format_r8g8b8_sscaled_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r8g8b8_sscaled_unpack_rgba_float,
   &util_format_r8g8b8_sscaled_pack_rgba_float,
   &util_format_r8g8b8_sscaled_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r8g8b8a8_sscaled_description = {
   PIPE_FORMAT_R8G8B8A8_SSCALED,
   "PIPE_FORMAT_R8G8B8A8_SSCALED",
   "r8g8b8a8_sscaled",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 8},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 8},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 8},	/* z = b */
      {UTIL_FORMAT_TYPE_SIGNED, FALSE, 8}	/* w = a */
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r8g8b8a8_sscaled_unpack_rgba_8unorm,
   &util_format_r8g8b8a8_sscaled_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r8g8b8a8_sscaled_unpack_rgba_float,
   &util_format_r8g8b8a8_sscaled_pack_rgba_float,
   &util_format_r8g8b8a8_sscaled_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r32_fixed_description = {
   PIPE_FORMAT_R32_FIXED,
   "PIPE_FORMAT_R32_FIXED",
   "r32_fixed",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   1,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_FIXED, FALSE, 32},	/* x = r */
      {0, 0, 0},
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_0,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r32_fixed_unpack_rgba_8unorm,
   &util_format_r32_fixed_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r32_fixed_unpack_rgba_float,
   &util_format_r32_fixed_pack_rgba_float,
   &util_format_r32_fixed_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r32g32_fixed_description = {
   PIPE_FORMAT_R32G32_FIXED,
   "PIPE_FORMAT_R32G32_FIXED",
   "r32g32_fixed",
   {1, 1, 64},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   2,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_FIXED, FALSE, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_FIXED, FALSE, 32},	/* y = g */
      {0, 0, 0},
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_0,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r32g32_fixed_unpack_rgba_8unorm,
   &util_format_r32g32_fixed_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r32g32_fixed_unpack_rgba_float,
   &util_format_r32g32_fixed_pack_rgba_float,
   &util_format_r32g32_fixed_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r32g32b32_fixed_description = {
   PIPE_FORMAT_R32G32B32_FIXED,
   "PIPE_FORMAT_R32G32B32_FIXED",
   "r32g32b32_fixed",
   {1, 1, 96},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   3,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_FIXED, FALSE, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_FIXED, FALSE, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_FIXED, FALSE, 32},	/* z = b */
      {0, 0, 0}
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r32g32b32_fixed_unpack_rgba_8unorm,
   &util_format_r32g32b32_fixed_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r32g32b32_fixed_unpack_rgba_float,
   &util_format_r32g32b32_fixed_pack_rgba_float,
   &util_format_r32g32b32_fixed_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r32g32b32a32_fixed_description = {
   PIPE_FORMAT_R32G32B32A32_FIXED,
   "PIPE_FORMAT_R32G32B32A32_FIXED",
   "r32g32b32a32_fixed",
   {1, 1, 128},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   TRUE,	/* is_array */
   FALSE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_FIXED, FALSE, 32},	/* x = r */
      {UTIL_FORMAT_TYPE_FIXED, FALSE, 32},	/* y = g */
      {UTIL_FORMAT_TYPE_FIXED, FALSE, 32},	/* z = b */
      {UTIL_FORMAT_TYPE_FIXED, FALSE, 32}	/* w = a */
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_W	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r32g32b32a32_fixed_unpack_rgba_8unorm,
   &util_format_r32g32b32a32_fixed_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r32g32b32a32_fixed_unpack_rgba_float,
   &util_format_r32g32b32a32_fixed_pack_rgba_float,
   &util_format_r32g32b32a32_fixed_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r10g10b10x2_uscaled_description = {
   PIPE_FORMAT_R10G10B10X2_USCALED,
   "PIPE_FORMAT_R10G10B10X2_USCALED",
   "r10g10b10x2_uscaled",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   FALSE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 10},	/* x = r */
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 10},	/* y = g */
      {UTIL_FORMAT_TYPE_UNSIGNED, FALSE, 10},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, FALSE, 2}	/* w = x */
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r10g10b10x2_uscaled_unpack_rgba_8unorm,
   &util_format_r10g10b10x2_uscaled_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r10g10b10x2_uscaled_unpack_rgba_float,
   &util_format_r10g10b10x2_uscaled_pack_rgba_float,
   &util_format_r10g10b10x2_uscaled_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description
util_format_r10g10b10x2_snorm_description = {
   PIPE_FORMAT_R10G10B10X2_SNORM,
   "PIPE_FORMAT_R10G10B10X2_SNORM",
   "r10g10b10x2_snorm",
   {1, 1, 32},	/* block */
   UTIL_FORMAT_LAYOUT_PLAIN,
   4,	/* nr_channels */
   FALSE,	/* is_array */
   TRUE,	/* is_bitmask */
   FALSE,	/* is_mixed */
   {
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 10},	/* x = r */
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 10},	/* y = g */
      {UTIL_FORMAT_TYPE_SIGNED, TRUE, 10},	/* z = b */
      {UTIL_FORMAT_TYPE_VOID, FALSE, 2}	/* w = x */
   },
   {
      UTIL_FORMAT_SWIZZLE_X,	/* r */
      UTIL_FORMAT_SWIZZLE_Y,	/* g */
      UTIL_FORMAT_SWIZZLE_Z,	/* b */
      UTIL_FORMAT_SWIZZLE_1	/* a */
   },
   UTIL_FORMAT_COLORSPACE_RGB,
   &util_format_r10g10b10x2_snorm_unpack_rgba_8unorm,
   &util_format_r10g10b10x2_snorm_pack_rgba_8unorm,
   NULL, /* fetch_rgba_8unorm */
   &util_format_r10g10b10x2_snorm_unpack_rgba_float,
   &util_format_r10g10b10x2_snorm_pack_rgba_float,
   &util_format_r10g10b10x2_snorm_fetch_rgba_float,
   NULL, /* unpack_z_32unorm */
   NULL, /* pack_z_32unorm */
   NULL, /* unpack_z_float */
   NULL, /* pack_z_float */
   NULL, /* unpack_s_8uscaled */
   NULL /* pack_s_8uscaled */
};

const struct util_format_description *
util_format_description(enum pipe_format format)
{
   if (format >= PIPE_FORMAT_COUNT) {
      return NULL;
   }

   switch (format) {
   case PIPE_FORMAT_NONE:
      return &util_format_none_description;
   case PIPE_FORMAT_B8G8R8A8_UNORM:
      return &util_format_b8g8r8a8_unorm_description;
   case PIPE_FORMAT_B8G8R8X8_UNORM:
      return &util_format_b8g8r8x8_unorm_description;
   case PIPE_FORMAT_A8R8G8B8_UNORM:
      return &util_format_a8r8g8b8_unorm_description;
   case PIPE_FORMAT_X8R8G8B8_UNORM:
      return &util_format_x8r8g8b8_unorm_description;
   case PIPE_FORMAT_A8B8G8R8_UNORM:
      return &util_format_a8b8g8r8_unorm_description;
   case PIPE_FORMAT_X8B8G8R8_UNORM:
      return &util_format_x8b8g8r8_unorm_description;
   case PIPE_FORMAT_R8G8B8X8_UNORM:
      return &util_format_r8g8b8x8_unorm_description;
   case PIPE_FORMAT_B5G5R5X1_UNORM:
      return &util_format_b5g5r5x1_unorm_description;
   case PIPE_FORMAT_B5G5R5A1_UNORM:
      return &util_format_b5g5r5a1_unorm_description;
   case PIPE_FORMAT_B4G4R4A4_UNORM:
      return &util_format_b4g4r4a4_unorm_description;
   case PIPE_FORMAT_B4G4R4X4_UNORM:
      return &util_format_b4g4r4x4_unorm_description;
   case PIPE_FORMAT_B5G6R5_UNORM:
      return &util_format_b5g6r5_unorm_description;
   case PIPE_FORMAT_R10G10B10A2_UNORM:
      return &util_format_r10g10b10a2_unorm_description;
   case PIPE_FORMAT_B10G10R10A2_UNORM:
      return &util_format_b10g10r10a2_unorm_description;
   case PIPE_FORMAT_B2G3R3_UNORM:
      return &util_format_b2g3r3_unorm_description;
   case PIPE_FORMAT_L8_UNORM:
      return &util_format_l8_unorm_description;
   case PIPE_FORMAT_A8_UNORM:
      return &util_format_a8_unorm_description;
   case PIPE_FORMAT_I8_UNORM:
      return &util_format_i8_unorm_description;
   case PIPE_FORMAT_L4A4_UNORM:
      return &util_format_l4a4_unorm_description;
   case PIPE_FORMAT_L8A8_UNORM:
      return &util_format_l8a8_unorm_description;
   case PIPE_FORMAT_L16_UNORM:
      return &util_format_l16_unorm_description;
   case PIPE_FORMAT_A16_UNORM:
      return &util_format_a16_unorm_description;
   case PIPE_FORMAT_I16_UNORM:
      return &util_format_i16_unorm_description;
   case PIPE_FORMAT_L16A16_UNORM:
      return &util_format_l16a16_unorm_description;
   case PIPE_FORMAT_A8_SNORM:
      return &util_format_a8_snorm_description;
   case PIPE_FORMAT_L8_SNORM:
      return &util_format_l8_snorm_description;
   case PIPE_FORMAT_L8A8_SNORM:
      return &util_format_l8a8_snorm_description;
   case PIPE_FORMAT_I8_SNORM:
      return &util_format_i8_snorm_description;
   case PIPE_FORMAT_A16_SNORM:
      return &util_format_a16_snorm_description;
   case PIPE_FORMAT_L16_SNORM:
      return &util_format_l16_snorm_description;
   case PIPE_FORMAT_L16A16_SNORM:
      return &util_format_l16a16_snorm_description;
   case PIPE_FORMAT_I16_SNORM:
      return &util_format_i16_snorm_description;
   case PIPE_FORMAT_A16_FLOAT:
      return &util_format_a16_float_description;
   case PIPE_FORMAT_L16_FLOAT:
      return &util_format_l16_float_description;
   case PIPE_FORMAT_L16A16_FLOAT:
      return &util_format_l16a16_float_description;
   case PIPE_FORMAT_I16_FLOAT:
      return &util_format_i16_float_description;
   case PIPE_FORMAT_A32_FLOAT:
      return &util_format_a32_float_description;
   case PIPE_FORMAT_L32_FLOAT:
      return &util_format_l32_float_description;
   case PIPE_FORMAT_L32A32_FLOAT:
      return &util_format_l32a32_float_description;
   case PIPE_FORMAT_I32_FLOAT:
      return &util_format_i32_float_description;
   case PIPE_FORMAT_L8_SRGB:
      return &util_format_l8_srgb_description;
   case PIPE_FORMAT_L8A8_SRGB:
      return &util_format_l8a8_srgb_description;
   case PIPE_FORMAT_R8G8B8_SRGB:
      return &util_format_r8g8b8_srgb_description;
   case PIPE_FORMAT_R8G8B8A8_SRGB:
      return &util_format_r8g8b8a8_srgb_description;
   case PIPE_FORMAT_A8B8G8R8_SRGB:
      return &util_format_a8b8g8r8_srgb_description;
   case PIPE_FORMAT_X8B8G8R8_SRGB:
      return &util_format_x8b8g8r8_srgb_description;
   case PIPE_FORMAT_B8G8R8A8_SRGB:
      return &util_format_b8g8r8a8_srgb_description;
   case PIPE_FORMAT_B8G8R8X8_SRGB:
      return &util_format_b8g8r8x8_srgb_description;
   case PIPE_FORMAT_A8R8G8B8_SRGB:
      return &util_format_a8r8g8b8_srgb_description;
   case PIPE_FORMAT_X8R8G8B8_SRGB:
      return &util_format_x8r8g8b8_srgb_description;
   case PIPE_FORMAT_R8SG8SB8UX8U_NORM:
      return &util_format_r8sg8sb8ux8u_norm_description;
   case PIPE_FORMAT_R10SG10SB10SA2U_NORM:
      return &util_format_r10sg10sb10sa2u_norm_description;
   case PIPE_FORMAT_R5SG5SB6U_NORM:
      return &util_format_r5sg5sb6u_norm_description;
   case PIPE_FORMAT_S8_USCALED:
      return &util_format_s8_uscaled_description;
   case PIPE_FORMAT_Z16_UNORM:
      return &util_format_z16_unorm_description;
   case PIPE_FORMAT_Z32_UNORM:
      return &util_format_z32_unorm_description;
   case PIPE_FORMAT_Z32_FLOAT:
      return &util_format_z32_float_description;
   case PIPE_FORMAT_Z24_UNORM_S8_USCALED:
      return &util_format_z24_unorm_s8_uscaled_description;
   case PIPE_FORMAT_S8_USCALED_Z24_UNORM:
      return &util_format_s8_uscaled_z24_unorm_description;
   case PIPE_FORMAT_X24S8_USCALED:
      return &util_format_x24s8_uscaled_description;
   case PIPE_FORMAT_S8X24_USCALED:
      return &util_format_s8x24_uscaled_description;
   case PIPE_FORMAT_Z24X8_UNORM:
      return &util_format_z24x8_unorm_description;
   case PIPE_FORMAT_X8Z24_UNORM:
      return &util_format_x8z24_unorm_description;
   case PIPE_FORMAT_Z32_FLOAT_S8X24_USCALED:
      return &util_format_z32_float_s8x24_uscaled_description;
   case PIPE_FORMAT_X32_S8X24_USCALED:
      return &util_format_x32_s8x24_uscaled_description;
   case PIPE_FORMAT_UYVY:
      return &util_format_uyvy_description;
   case PIPE_FORMAT_YUYV:
      return &util_format_yuyv_description;
   case PIPE_FORMAT_R8G8_B8G8_UNORM:
      return &util_format_r8g8_b8g8_unorm_description;
   case PIPE_FORMAT_G8R8_G8B8_UNORM:
      return &util_format_g8r8_g8b8_unorm_description;
   case PIPE_FORMAT_R10G10B10A2_USCALED:
      return &util_format_r10g10b10a2_uscaled_description;
   case PIPE_FORMAT_R11G11B10_FLOAT:
      return &util_format_r11g11b10_float_description;
   case PIPE_FORMAT_R9G9B9E5_FLOAT:
      return &util_format_r9g9b9e5_float_description;
   case PIPE_FORMAT_R1_UNORM:
      return &util_format_r1_unorm_description;
   case PIPE_FORMAT_R8G8Bx_SNORM:
      return &util_format_r8g8bx_snorm_description;
   case PIPE_FORMAT_DXT1_RGB:
      return &util_format_dxt1_rgb_description;
   case PIPE_FORMAT_DXT1_RGBA:
      return &util_format_dxt1_rgba_description;
   case PIPE_FORMAT_DXT3_RGBA:
      return &util_format_dxt3_rgba_description;
   case PIPE_FORMAT_DXT5_RGBA:
      return &util_format_dxt5_rgba_description;
   case PIPE_FORMAT_DXT1_SRGB:
      return &util_format_dxt1_srgb_description;
   case PIPE_FORMAT_DXT1_SRGBA:
      return &util_format_dxt1_srgba_description;
   case PIPE_FORMAT_DXT3_SRGBA:
      return &util_format_dxt3_srgba_description;
   case PIPE_FORMAT_DXT5_SRGBA:
      return &util_format_dxt5_srgba_description;
   case PIPE_FORMAT_RGTC1_UNORM:
      return &util_format_rgtc1_unorm_description;
   case PIPE_FORMAT_RGTC1_SNORM:
      return &util_format_rgtc1_snorm_description;
   case PIPE_FORMAT_RGTC2_UNORM:
      return &util_format_rgtc2_unorm_description;
   case PIPE_FORMAT_RGTC2_SNORM:
      return &util_format_rgtc2_snorm_description;
   case PIPE_FORMAT_LATC1_UNORM:
      return &util_format_latc1_unorm_description;
   case PIPE_FORMAT_LATC1_SNORM:
      return &util_format_latc1_snorm_description;
   case PIPE_FORMAT_LATC2_UNORM:
      return &util_format_latc2_unorm_description;
   case PIPE_FORMAT_LATC2_SNORM:
      return &util_format_latc2_snorm_description;
   case PIPE_FORMAT_R64_FLOAT:
      return &util_format_r64_float_description;
   case PIPE_FORMAT_R64G64_FLOAT:
      return &util_format_r64g64_float_description;
   case PIPE_FORMAT_R64G64B64_FLOAT:
      return &util_format_r64g64b64_float_description;
   case PIPE_FORMAT_R64G64B64A64_FLOAT:
      return &util_format_r64g64b64a64_float_description;
   case PIPE_FORMAT_R32_FLOAT:
      return &util_format_r32_float_description;
   case PIPE_FORMAT_R32G32_FLOAT:
      return &util_format_r32g32_float_description;
   case PIPE_FORMAT_R32G32B32_FLOAT:
      return &util_format_r32g32b32_float_description;
   case PIPE_FORMAT_R32G32B32A32_FLOAT:
      return &util_format_r32g32b32a32_float_description;
   case PIPE_FORMAT_R32_UNORM:
      return &util_format_r32_unorm_description;
   case PIPE_FORMAT_R32G32_UNORM:
      return &util_format_r32g32_unorm_description;
   case PIPE_FORMAT_R32G32B32_UNORM:
      return &util_format_r32g32b32_unorm_description;
   case PIPE_FORMAT_R32G32B32A32_UNORM:
      return &util_format_r32g32b32a32_unorm_description;
   case PIPE_FORMAT_R32_USCALED:
      return &util_format_r32_uscaled_description;
   case PIPE_FORMAT_R32G32_USCALED:
      return &util_format_r32g32_uscaled_description;
   case PIPE_FORMAT_R32G32B32_USCALED:
      return &util_format_r32g32b32_uscaled_description;
   case PIPE_FORMAT_R32G32B32A32_USCALED:
      return &util_format_r32g32b32a32_uscaled_description;
   case PIPE_FORMAT_R32_SNORM:
      return &util_format_r32_snorm_description;
   case PIPE_FORMAT_R32G32_SNORM:
      return &util_format_r32g32_snorm_description;
   case PIPE_FORMAT_R32G32B32_SNORM:
      return &util_format_r32g32b32_snorm_description;
   case PIPE_FORMAT_R32G32B32A32_SNORM:
      return &util_format_r32g32b32a32_snorm_description;
   case PIPE_FORMAT_R32_SSCALED:
      return &util_format_r32_sscaled_description;
   case PIPE_FORMAT_R32G32_SSCALED:
      return &util_format_r32g32_sscaled_description;
   case PIPE_FORMAT_R32G32B32_SSCALED:
      return &util_format_r32g32b32_sscaled_description;
   case PIPE_FORMAT_R32G32B32A32_SSCALED:
      return &util_format_r32g32b32a32_sscaled_description;
   case PIPE_FORMAT_R16_FLOAT:
      return &util_format_r16_float_description;
   case PIPE_FORMAT_R16G16_FLOAT:
      return &util_format_r16g16_float_description;
   case PIPE_FORMAT_R16G16B16_FLOAT:
      return &util_format_r16g16b16_float_description;
   case PIPE_FORMAT_R16G16B16A16_FLOAT:
      return &util_format_r16g16b16a16_float_description;
   case PIPE_FORMAT_R16_UNORM:
      return &util_format_r16_unorm_description;
   case PIPE_FORMAT_R16G16_UNORM:
      return &util_format_r16g16_unorm_description;
   case PIPE_FORMAT_R16G16B16_UNORM:
      return &util_format_r16g16b16_unorm_description;
   case PIPE_FORMAT_R16G16B16A16_UNORM:
      return &util_format_r16g16b16a16_unorm_description;
   case PIPE_FORMAT_R16_USCALED:
      return &util_format_r16_uscaled_description;
   case PIPE_FORMAT_R16G16_USCALED:
      return &util_format_r16g16_uscaled_description;
   case PIPE_FORMAT_R16G16B16_USCALED:
      return &util_format_r16g16b16_uscaled_description;
   case PIPE_FORMAT_R16G16B16A16_USCALED:
      return &util_format_r16g16b16a16_uscaled_description;
   case PIPE_FORMAT_R16_SNORM:
      return &util_format_r16_snorm_description;
   case PIPE_FORMAT_R16G16_SNORM:
      return &util_format_r16g16_snorm_description;
   case PIPE_FORMAT_R16G16B16_SNORM:
      return &util_format_r16g16b16_snorm_description;
   case PIPE_FORMAT_R16G16B16A16_SNORM:
      return &util_format_r16g16b16a16_snorm_description;
   case PIPE_FORMAT_R16_SSCALED:
      return &util_format_r16_sscaled_description;
   case PIPE_FORMAT_R16G16_SSCALED:
      return &util_format_r16g16_sscaled_description;
   case PIPE_FORMAT_R16G16B16_SSCALED:
      return &util_format_r16g16b16_sscaled_description;
   case PIPE_FORMAT_R16G16B16A16_SSCALED:
      return &util_format_r16g16b16a16_sscaled_description;
   case PIPE_FORMAT_R8_UNORM:
      return &util_format_r8_unorm_description;
   case PIPE_FORMAT_R8G8_UNORM:
      return &util_format_r8g8_unorm_description;
   case PIPE_FORMAT_R8G8B8_UNORM:
      return &util_format_r8g8b8_unorm_description;
   case PIPE_FORMAT_R8G8B8A8_UNORM:
      return &util_format_r8g8b8a8_unorm_description;
   case PIPE_FORMAT_R8_USCALED:
      return &util_format_r8_uscaled_description;
   case PIPE_FORMAT_R8G8_USCALED:
      return &util_format_r8g8_uscaled_description;
   case PIPE_FORMAT_R8G8B8_USCALED:
      return &util_format_r8g8b8_uscaled_description;
   case PIPE_FORMAT_R8G8B8A8_USCALED:
      return &util_format_r8g8b8a8_uscaled_description;
   case PIPE_FORMAT_R8_SNORM:
      return &util_format_r8_snorm_description;
   case PIPE_FORMAT_R8G8_SNORM:
      return &util_format_r8g8_snorm_description;
   case PIPE_FORMAT_R8G8B8_SNORM:
      return &util_format_r8g8b8_snorm_description;
   case PIPE_FORMAT_R8G8B8A8_SNORM:
      return &util_format_r8g8b8a8_snorm_description;
   case PIPE_FORMAT_R8_SSCALED:
      return &util_format_r8_sscaled_description;
   case PIPE_FORMAT_R8G8_SSCALED:
      return &util_format_r8g8_sscaled_description;
   case PIPE_FORMAT_R8G8B8_SSCALED:
      return &util_format_r8g8b8_sscaled_description;
   case PIPE_FORMAT_R8G8B8A8_SSCALED:
      return &util_format_r8g8b8a8_sscaled_description;
   case PIPE_FORMAT_R32_FIXED:
      return &util_format_r32_fixed_description;
   case PIPE_FORMAT_R32G32_FIXED:
      return &util_format_r32g32_fixed_description;
   case PIPE_FORMAT_R32G32B32_FIXED:
      return &util_format_r32g32b32_fixed_description;
   case PIPE_FORMAT_R32G32B32A32_FIXED:
      return &util_format_r32g32b32a32_fixed_description;
   case PIPE_FORMAT_R10G10B10X2_USCALED:
      return &util_format_r10g10b10x2_uscaled_description;
   case PIPE_FORMAT_R10G10B10X2_SNORM:
      return &util_format_r10g10b10x2_snorm_description;
   default:
      return NULL;
   }
}

