-- Valyria Tear map editor begin. Do not edit this line or put anything before this line. --

-- Set the namespace according to the map name.
local ns = {};
setmetatable(ns, {__index = _G});
layna_village_south_entrance = ns;
setfenv(1, ns);

-- The map name, subname and location image
map_name = "Mountain Village of Layna"
map_image_filename = "img/menus/locations/mountain_village.png"
map_subname = "Village entrance"

-- The number of rows, and columns that compose the map
num_tile_cols = 32
num_tile_rows = 24

-- The contexts names and inheritance definition
-- Tells the context id the current context inherit from
-- This means that the parent context will be used as a base, and the current
-- context will only have its own differences from it.
-- At least, the base context (id:0) can't a parent context, thus it should be equal to -1.
-- Note that a context cannot inherit from itself or a context with a higher id
-- since it would lead to nasty and useless loading use cases.
contexts = {}
contexts[0] = {}
contexts[0].name = "Base"
contexts[0].inherit_from = -1

-- The music file used as default background music on this map.
-- Other musics will have to handled through scripting.
music_filename = "mus/Caketown_1-OGA-mat-pablo.ogg"

-- The names of the tilesets used, with the path and file extension omitted
tileset_filenames = {}
tileset_filenames[1] = "mountain_house_exterior"
tileset_filenames[2] = "mountain_house_exterior2"
tileset_filenames[3] = "mountain_landscape"
tileset_filenames[4] = "water_tileset"
tileset_filenames[5] = "harrvah_house_exterior"
tileset_filenames[6] = "village_exterior"

-- The map grid to indicate walkability. The size of the grid is 4x the size of the tile layer tables
-- Walkability status of tiles for 32 contexts. Zero indicates walkable for all contexts. Valid range: [0:2^32-1]
-- Example: 1 (BIN 001) = wall for first context only, 2 (BIN 010) means wall for second context only, 5 (BIN 101) means Wall for first and third context.
map_grid = {}
map_grid[0] = { 1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1 }
map_grid[1] = { 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0 }
map_grid[2] = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_grid[3] = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_grid[4] = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_grid[5] = { 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_grid[6] = { 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_grid[7] = { 1, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_grid[8] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_grid[9] = { 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_grid[10] = { 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_grid[11] = { 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1 }
map_grid[12] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1 }
map_grid[13] = { 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 }
map_grid[14] = { 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1 }
map_grid[15] = { 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1 }
map_grid[16] = { 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1 }
map_grid[17] = { 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1 }
map_grid[18] = { 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1 }
map_grid[19] = { 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1 }
map_grid[20] = { 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1 }
map_grid[21] = { 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1 }
map_grid[22] = { 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1 }
map_grid[23] = { 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 1, 1 }
map_grid[24] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1 }
map_grid[25] = { 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1 }
map_grid[26] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 1, 1 }
map_grid[27] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, 0 }
map_grid[28] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0 }
map_grid[29] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 0, 0 }
map_grid[30] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0 }
map_grid[31] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0 }
map_grid[32] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 1, 0, 0 }
map_grid[33] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_grid[34] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_grid[35] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_grid[36] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1 }
map_grid[37] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1 }
map_grid[38] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 }
map_grid[39] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 }
map_grid[40] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1 }
map_grid[41] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0 }
map_grid[42] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_grid[43] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_grid[44] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_grid[45] = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0 }
map_grid[46] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0 }
map_grid[47] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }

-- The tile layers. The numbers are indeces to the tile_mappings table.
layers = {}
layers[0] = {}
layers[0].type = "ground"
layers[0].name = "Background"
layers[0][0] = { 591, 590, 591, 606, 590, 607, 591, 606, 606, 591, 607, 590, 606, 606, 607, 591, 607, 606, 591, 591, 607, 591, 607, 591, 607, 606, 590, 607, 606, 606, 607, 607 }
layers[0][1] = { 607, 607, 591, 607, 591, 606, 591, 590, 607, 590, 591, 606, 606, 523, 524, 525, 591, 607, 591, 607, 607, 590, 590, 590, 607, 591, 590, 591, 606, 590, 606, 607 }
layers[0][2] = { 591, 591, 607, 606, 591, 607, 590, 590, 590, 606, 606, 591, 591, 555, 638, 623, 525, 591, 590, 590, 607, 590, 606, 607, 607, 606, 607, 590, 590, 591, 591, 607 }
layers[0][3] = { 590, 606, 591, 591, 607, 607, 590, 606, 591, 590, 606, 591, 591, 591, 539, 540, 541, 606, 591, 607, 590, 607, 590, 590, 606, 590, 607, 590, 591, 590, 607, 590 }
layers[0][4] = { 591, 590, 591, 591, 590, 590, 607, 606, 590, 606, 607, 606, 607, 607, 555, 556, 557, 606, 591, 607, 591, 590, 590, 590, 591, 607, 590, 606, 591, 607, 591, 606 }
layers[0][5] = { 606, 606, 591, 591, 607, 591, 607, 591, 606, 607, 590, 590, 607, 607, 590, 606, 607, 607, 607, 590, 590, 591, 606, 590, 607, 607, 590, 606, 590, 591, 607, 590 }
layers[0][6] = { 607, 591, 590, 590, 607, 606, 606, 591, 606, 607, 590, 607, 606, 607, 590, 607, 607, 607, 607, 591, 606, 607, 590, 607, 590, 606, 606, 606, 606, 606, 590, 591 }
layers[0][7] = { 590, 591, 591, 591, 591, 607, 606, 591, 606, 590, 590, 607, 606, 607, 524, 525, 606, 607, 606, 591, 607, 606, 591, 590, 590, 590, 591, 607, 591, 590, 590, 607 }
layers[0][8] = { 607, 591, 607, 591, 523, 524, 607, 607, 591, 606, 606, 607, 591, 606, 607, 590, 591, 607, 590, 590, 606, 590, 606, 607, 607, 590, 590, 0, 590, 590, 591, 606 }
layers[0][9] = { 590, 591, 591, 591, 539, 571, 590, 607, 591, 591, 607, 591, 607, 591, 607, 607, 639, 557, 523, 524, 607, 606, 591, 607, 590, 591, 606, 607, 524, 525, 607, 591 }
layers[0][10] = { 590, 591, 607, 591, 539, 587, 607, 607, 591, 606, 590, 591, 607, 591, 590, 591, 541, 591, 539, 571, 591, 606, 607, 591, 606, 606, 606, 590, 573, 541, 607, 590 }
layers[0][11] = { 591, 607, 590, 590, 539, 587, 607, 591, 590, 590, 590, 590, 591, 606, 590, 607, 541, 606, 539, 587, 607, 591, 590, 607, 606, 606, 607, 606, 589, 623, 524, 525 }
layers[0][12] = { 607, 590, 591, 606, 539, 587, 607, 607, 590, 591, 606, 591, 606, 607, 606, 606, 541, 590, 539, 587, 607, 591, 607, 607, 591, 590, 607, 591, 589, 540, 554, 554 }
layers[0][13] = { 591, 606, 591, 590, 539, 587, 591, 591, 591, 606, 590, 590, 606, 606, 607, 607, 623, 525, 539, 587, 607, 606, 606, 607, 606, 606, 591, 591, 589, 540, 639, 557 }
layers[0][14] = { 591, 591, 607, 591, 539, 587, 543, 606, 590, 591, 607, 591, 607, 526, 526, 589, 522, 623, 622, 587, 543, 606, 606, 607, 606, 606, 591, 588, 589, 639, 557, 607 }
layers[0][15] = { 606, 607, 591, 590, 622, 587, 543, 606, 591, 606, 591, 607, 606, 543, 575, 605, 538, 538, 522, 587, 588, 606, 607, 606, 606, 607, 607, 527, 589, 541, 607, 590 }
layers[0][16] = { 606, 590, 606, 590, 538, 603, 574, 543, 606, 607, 607, 591, 526, 542, 605, 639, 638, 538, 522, 587, 588, 526, 606, 590, 607, 590, 526, 543, 589, 541, 591, 590 }
layers[0][17] = { 591, 606, 591, 591, 556, 638, 603, 574, 542, 542, 526, 542, 575, 605, 639, 557, 555, 638, 538, 603, 604, 604, 604, 604, 604, 604, 604, 604, 605, 541, 607, 607 }
layers[0][18] = { 606, 606, 590, 590, 606, 555, 638, 603, 604, 604, 604, 604, 605, 639, 557, 606, 591, 539, 554, 540, 639, 556, 556, 556, 556, 556, 556, 556, 556, 557, 590, 606 }
layers[0][19] = { 590, 606, 590, 607, 606, 591, 555, 556, 556, 556, 556, 556, 556, 557, 607, 590, 607, 539, 554, 554, 541, 606, 607, 590, 591, 590, 590, 606, 590, 590, 590, 606 }
layers[0][20] = { 591, 591, 606, 591, 606, 590, 606, 590, 590, 591, 606, 606, 539, 522, 541, 591, 606, 539, 522, 554, 541, 606, 606, 539, 554, 541, 607, 525, 591, 591, 590, 607 }
layers[0][21] = { 525, 590, 523, 524, 524, 524, 524, 524, 524, 524, 525, 606, 555, 556, 557, 590, 590, 590, 606, 607, 590, 606, 607, 555, 556, 557, 555, 557, 523, 524, 525, 606 }
layers[0][22] = { 541, 607, 539, 606, 591, 606, 606, 590, 606, 591, 590, 590, 607, 590, 590, 607, 607, 606, 591, 606, 591, 590, 606, 606, 606, 590, 607, 523, 622, 554, 623, 606 }
layers[0][23] = { 557, 591, 555, 638, 538, 522, 522, 522, 639, 556, 557, 590, 590, 607, 590, 607, 590, 591, 590, 590, 606, 590, 607, 606, 590, 590, 591, 554, 522, 522, 554, 606 }

layers[1] = {}
layers[1].type = "ground"
layers[1].name = "Background 2"
layers[1][0] = { 529, 530, 531, 532, 533, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 528, 529 }
layers[1][1] = { 545, 546, 547, 548, 549, 1350, 1350, -1, 1333, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1333, -1, 1335, -1, -1, -1, -1, -1, -1, -1, 1333, -1, 576, 577 }
layers[1][2] = { 561, 562, 563, 564, 565, -1, 1350, 1350, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1335, 1334, 1334, 1335, -1, -1, 523, 524, 525, -1, -1, 560, 561 }
layers[1][3] = { 577, 578, 579, 580, 581, -1, 1335, -1, 1350, -1, 1334, -1, -1, -1, -1, -1, -1, -1, -1, 1333, 1333, 1335, -1, -1, -1, 539, 540, 541, -1, 1334, 576, 577 }
layers[1][4] = { 593, 594, 595, 596, 597, -1, -1, -1, -1, -1, -1, 1350, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 555, 556, 557, -1, -1, 592, 593 }
layers[1][5] = { 609, 610, 611, 612, 613, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1351, -1, -1, -1, -1, -1, 1350, 1350, -1, -1, -1, -1, -1, -1, 608, 609 }
layers[1][6] = { 515, 516, 1351, -1, -1, -1, 33, 34, 35, 36, 37, 38, 39, 40, -1, -1, 523, 524, 525, -1, -1, -1, -1, -1, 1350, -1, -1, -1, -1, -1, -1, 756 }
layers[1][7] = { 531, 532, 533, -1, -1, -1, 49, 50, 51, 52, 53, 54, 55, 56, -1, -1, 539, 540, 541, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 740 }
layers[1][8] = { 547, 548, 549, -1, -1, -1, 33, 34, 35, 36, 37, 38, 39, 40, 589, 623, 622, 639, 557, -1, 33, 34, 35, 36, 37, 38, 39, 40, -1, -1, -1, 756 }
layers[1][9] = { 563, 564, 565, -1, -1, -1, 49, 50, 51, 52, 53, 54, 55, 56, 559, 573, -1, -1, -1, -1, 49, 50, 51, 52, 53, 54, 55, 56, -1, -1, -1, 740 }
layers[1][10] = { 584, 585, 581, -1, -1, -1, 65, 66, 67, 68, 69, 70, 71, 72, 526, 589, -1, -1, -1, -1, 65, 66, 67, 68, 69, 70, 71, 72, -1, -1, -1, 756 }
layers[1][11] = { 600, 601, 597, -1, -1, -1, 161, 162, 163, 14, 15, 166, 167, 168, 526, 589, -1, -1, -1, -1, 161, 162, 163, 164, 165, 166, 167, 168, -1, -1, -1, 740 }
layers[1][12] = { 616, 617, 1350, -1, -1, -1, 177, 178, 179, 180, 181, 182, 183, 184, 588, 589, -1, 1335, -1, -1, 177, 178, 179, 180, 181, 182, 183, 184, 1299, -1, 512, 756 }
layers[1][13] = { -1, 1350, -1, -1, -1, -1, 193, 194, 195, 46, 47, 198, 199, 200, 527, 589, -1, -1, -1, -1, 193, 194, 195, 46, 47, 198, 199, 200, 1299, -1, 528, 529 }
layers[1][14] = { -1, -1, -1, 1350, -1, -1, 209, 210, 211, 62, 63, 214, 215, 216, 1299, -1, -1, -1, -1, -1, 209, 210, 211, 62, 63, 214, 215, 216, 1299, -1, 544, 545 }
layers[1][15] = { 1337, 523, 524, 524, -1, -1, 225, 226, 227, 78, 79, 230, 231, 232, -1, -1, -1, -1, -1, -1, 225, 226, 227, 78, 79, 230, 231, 232, -1, -1, 560, 561 }
layers[1][16] = { 523, 622, 540, 540, -1, -1, 241, 242, 243, 94, 95, 246, 247, 248, -1, -1, -1, -1, -1, -1, 241, 242, 243, 94, 95, 246, 247, 248, -1, -1, 576, 577 }
layers[1][17] = { 539, 540, 540, 639, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 592, 593 }
layers[1][18] = { 555, 638, 540, 541, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 608, 609 }
layers[1][19] = { -1, 555, 556, 557, 1337, -1, -1, -1, -1, -1, -1, 317, -1, -1, -1, -1, 480, -1, -1, -1, -1, 485, -1, -1, -1, -1, 286, -1, -1, -1, 1335, 513 }
layers[1][20] = { -1, 1337, -1, 1337, -1, 316, 1337, 1337, -1, -1, 1340, 333, 398, 347, 398, 302, 496, 539, 554, 538, 541, 501, 302, 398, 347, 398, 302, -1, -1, -1, 528, 529 }
layers[1][21] = { -1, -1, 364, 332, 364, 332, 364, 331, 364, 382, -1, 380, -1, -1, -1, -1, 523, 622, 554, 522, 623, 525, -1, -1, -1, -1, -1, -1, -1, -1, 544, 545 }
layers[1][22] = { 379, 442, 380, 348, 380, 348, 380, 347, 380, 398, 443, -1, 1336, 1353, 1354, 523, 622, 571, 572, 572, 573, 623, 525, -1, 1352, 1370, 380, -1, -1, -1, 427, 561 }
layers[1][23] = { -1, 1370, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1336, -1, 539, 571, 558, 527, 526, 559, 573, 541, 1369, 1370, -1, 302, 380, 398, 380, 398, 577 }

layers[2] = {}
layers[2].type = "ground"
layers[2].name = "Background 3"
layers[2][0] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][1] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 544, 545 }
layers[2][2] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][3] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][4] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 708 }
layers[2][5] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 724 }
layers[2][6] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 724 }
layers[2][7] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 708 }
layers[2][8] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 724 }
layers[2][9] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 708 }
layers[2][10] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 724 }
layers[2][11] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][12] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1299, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][13] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 1299, 1300, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][14] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, 110, 111, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 110, 111, -1, -1, -1, -1, -1, -1, -1 }
layers[2][15] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, 126, 127, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 126, 127, -1, -1, -1, -1, -1, -1, -1 }
layers[2][16] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, 142, 143, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 142, 143, -1, -1, -1, -1, -1, -1, -1 }
layers[2][17] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][18] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][19] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[2][20] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 763, 763, 763, 763, -1, -1, -1, -1, -1, 429, -1, -1, -1, -1, -1 }
layers[2][21] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 287, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 428, -1, -1, -1, -1, -1 }
layers[2][22] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 303, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 560, -1 }
layers[2][23] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 576, -1 }

layers[3] = {}
layers[3].type = "sky"
layers[3].name = "Sky"
layers[3][0] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][1] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][2] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][3] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][4] = { -1, -1, -1, -1, -1, -1, 1, 2, 3, 4, 5, 6, 7, 8, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][5] = { -1, -1, -1, -1, -1, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][6] = { -1, -1, -1, -1, -1, 32, -1, -1, -1, -1, -1, -1, -1, -1, 41, -1, -1, -1, -1, -1, 1, 2, 3, 4, 5, 6, 7, 8, -1, -1, -1, -1 }
layers[3][7] = { -1, -1, -1, -1, -1, 48, -1, -1, -1, -1, -1, -1, -1, -1, 57, -1, -1, -1, -1, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1 }
layers[3][8] = { -1, -1, -1, -1, -1, 64, -1, -1, -1, -1, -1, -1, -1, -1, 73, -1, -1, -1, -1, 32, -1, -1, -1, -1, -1, -1, -1, -1, 41, -1, -1, -1 }
layers[3][9] = { -1, -1, -1, -1, -1, 80, -1, -1, -1, -1, -1, -1, -1, -1, 89, -1, -1, -1, -1, 48, -1, -1, -1, -1, -1, -1, -1, -1, 57, -1, -1, -1 }
layers[3][10] = { -1, -1, -1, -1, -1, 96, -1, -1, -1, -1, -1, -1, -1, -1, 89, -1, -1, -1, -1, 64, -1, -1, -1, -1, -1, -1, -1, -1, 73, -1, -1, -1 }
layers[3][11] = { -1, -1, -1, -1, -1, 160, -1, -1, -1, -1, -1, -1, -1, -1, 169, -1, -1, -1, -1, 80, -1, -1, -1, -1, -1, -1, -1, -1, 89, -1, -1, -1 }
layers[3][12] = { -1, -1, -1, -1, -1, 176, -1, -1, -1, -1, -1, -1, -1, -1, 185, -1, -1, -1, -1, 96, -1, -1, -1, -1, -1, -1, -1, -1, 185, -1, -1, -1 }
layers[3][13] = { -1, -1, -1, -1, -1, 192, -1, -1, -1, -1, -1, -1, -1, -1, 201, -1, -1, -1, -1, 192, -1, -1, -1, -1, -1, -1, -1, -1, 201, -1, -1, -1 }
layers[3][14] = { -1, -1, -1, -1, -1, 208, -1, -1, -1, -1, -1, -1, -1, -1, 217, -1, -1, -1, -1, 208, -1, -1, -1, -1, -1, -1, -1, -1, 217, -1, -1, -1 }
layers[3][15] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][16] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 432, -1, -1, -1, -1, 437, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][17] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 448, 449, 450, 451, 452, 453, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[3][18] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 366, 315, 366, -1, 464, -1, -1, -1, -1, 469, -1, 366, 316, 366, -1, -1, -1, -1, -1, -1 }
layers[3][19] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 317, 382, 331, 382, 286, -1, 747, 747, 747, 747, -1, 286, 382, 332, 382, 286, -1, -1, -1, -1, -1 }
layers[3][20] = { -1, 458, -1, 316, -1, 316, -1, 315, -1, 366, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 412, -1, -1, -1, -1, -1 }
layers[3][21] = { 363, 426, 364, 332, 364, 332, 364, 331, 364, 382, 427, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 366, -1, -1, -1 }
layers[3][22] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 286, 364, 382, 364, 427, -1 }
layers[3][23] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 443, -1 }

layers[4] = {}
layers[4].type = "sky"
layers[4].name = "sky2"
layers[4][0] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][1] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][2] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][3] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][4] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][5] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][6] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][7] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][8] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][9] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][10] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][11] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][12] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][13] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][14] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][15] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 236, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][16] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 236, 237, 238, 239, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][17] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 252, 253, 254, 255, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][18] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][19] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 413, -1, -1, -1, -1, -1 }
layers[4][20] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][21] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1 }
layers[4][22] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 560, -1 }
layers[4][23] = { -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 576, -1 }


-- Valyria Tear map editor end. Do not edit this line. Place your scripts after this line. --

-- c++ objects instances
local Map = {};
local ObjectManager = {};
local DialogueManager = {};
local EventManager = {};
local GlobalEvents = {};

local bronann = {};
local orlinn = {};

-- the main map loading code
function Load(m)

	Map = m;
	ObjectManager = Map.object_supervisor;
	DialogueManager = Map.dialogue_supervisor;
	EventManager = Map.event_supervisor;

	Map.unlimited_stamina = true;

	_CreateCharacters();
	-- Set the camera focus on Bronann
	Map:SetCamera(bronann);

	_CreateNPCs();
	_CreateObjects();

	_CreateEvents();
	_CreateZones();

	-- Add clouds overlay
	Map:GetEffectSupervisor():EnableAmbientOverlay("img/ambient/clouds.png", 5.0, 5.0, true);

	_HandleCredits();
end

-- Handle the display of the new game credits
function _HandleCredits()
    -- Handle small credits triggering
    if (GlobalManager:DoesEventExist("game", "Start_Credits") == false) then
        -- Triggers the small credits display
        GlobalManager:SetEventValue("game", "Start_Credits", 1);
    end
    if (GlobalManager:DoesEventExist("game", "Credits_shown") == false) then
        Map:GetScriptSupervisor():AddScript("dat/credits/episode1_credits.lua");
    end
end

function Update()
	-- Check whether the character is in one of the zones
	_CheckZones();
end


-- Character creation
function _CreateCharacters()
	bronann = CreateSprite(Map, "Bronann", 32, 4);
	bronann:SetDirection(hoa_map.MapMode.SOUTH);
	bronann:SetMovementSpeed(hoa_map.MapMode.NORMAL_SPEED);

	-- set up the position according to the previous map
	if (GlobalManager:GetPreviousLocation() == "from_riverbank") then
		bronann:SetPosition(3, 34);
		bronann:SetDirection(hoa_map.MapMode.EAST);

	elseif (GlobalManager:GetPreviousLocation() == "from right house") then
		bronann:SetPosition(48, 34);
		bronann:SetDirection(hoa_map.MapMode.SOUTH);
		AudioManager:PlaySound("snd/door_close.wav");

	elseif (GlobalManager:GetPreviousLocation() == "from left house") then
		bronann:SetPosition(20, 34);
		bronann:SetDirection(hoa_map.MapMode.SOUTH);
		AudioManager:PlaySound("snd/door_close.wav");
	end

	Map:AddGroundObject(bronann);
end

function _CreateNPCs()
	local npc = {}
	local text = {}
	local dialogue = {}
	local event = {}

	npc = CreateSprite(Map, "Herth", 45, 39);
	Map:AddGroundObject(npc);
	if (GlobalManager:DoesEventExist("story", "Quest2_forest_event_done") == true) then
		-- At that moment, Herth isn't there anymore.
		npc:SetVisible(false);
		npc:SetCollisionMask(hoa_map.MapMode.NO_COLLISION);
	else
		npc:SetDirection(hoa_map.MapMode.SOUTH);
		dialogue = hoa_map.SpriteDialogue();
		text = hoa_system.Translate("Hi Bronann.");
		dialogue:AddLine(text, npc);
		text = hoa_system.Translate("Hi Herth. I see you've blocked the gate, why so?");
		dialogue:AddLine(text, bronann);
		text = hoa_system.Translate("Don't worry too much. I'm just preventing strangers from being able to sneak in at night.");
		dialogue:AddLine(text, npc);
		text = hoa_system.Translate("There have been some reports of theft in the villages nearby recently.");
		dialogue:AddLine(text, npc);
		text = hoa_system.Translate("Wow, do you think that they would come here?");
		dialogue:AddLine(text, bronann);
		text = hoa_system.Translate("It's a possibility. But don't worry too much, ok?");
		dialogue:AddLine(text, npc);
		DialogueManager:AddDialogue(dialogue);
		npc:AddDialogueReference(dialogue);
		-- The second time, just repeat the sentence
		dialogue = hoa_map.SpriteDialogue();
		text = hoa_system.Translate("It's a possibility. But don't worry too much, ok?");
		dialogue:AddLine(text, npc);
		DialogueManager:AddDialogue(dialogue);
		npc:AddDialogueReference(dialogue);
	end

	orlinn = CreateSprite(Map, "Orlinn", 29, 22);
	orlinn:SetDirection(hoa_map.MapMode.EAST);
	orlinn:SetMovementSpeed(hoa_map.MapMode.VERY_FAST_SPEED);
	Map:AddGroundObject(orlinn);
	_UpdateOrlinnState();
end

function _CreateObjects()
	local object = {}

	object = CreateObject(Map, "Tree Big1", 42, 10);
	if (object ~= nil) then Map:AddGroundObject(object) end;

	-- Small door lights
	Map:AddLight("img/misc/lights/sun_flare_light_small_main.lua",
		    "img/misc/lights/sun_flare_light_small_secondary.lua",
	    20.0, 29.5,
	    hoa_video.Color(1.0, 1.0, 1.0, 0.6),
	    hoa_video.Color(1.0, 1.0, 0.85, 0.3),
	    hoa_map.MapMode.CONTEXT_01);
	Map:AddLight("img/misc/lights/sun_flare_light_small_main.lua",
		    "img/misc/lights/sun_flare_light_small_secondary.lua",
	    48.0, 29.5,
	    hoa_video.Color(1.0, 1.0, 1.0, 0.6),
	    hoa_video.Color(1.0, 1.0, 0.85, 0.3),
	    hoa_map.MapMode.CONTEXT_01);
end

-- Creates all events and sets up the entire event sequence chain
function _CreateEvents()
	local event = {};

	-- Triggered Events
	event = hoa_map.MapTransitionEvent("to Village center", "dat/maps/layna_village/layna_village_center.lua", "from_village_south");
	EventManager:RegisterEvent(event);

	event = hoa_map.MapTransitionEvent("to Village riverbank", "dat/maps/layna_village/layna_village_riverbank.lua", "from_village_south");
	EventManager:RegisterEvent(event);

	event = hoa_map.MapTransitionEvent("to left house", "dat/maps/layna_village/layna_village_south_entrance_left_house.lua", "from_village_south");
	EventManager:RegisterEvent(event);

	event = hoa_map.MapTransitionEvent("to right house", "dat/maps/layna_village/layna_village_south_entrance_right_house.lua", "from_village_south");
	EventManager:RegisterEvent(event);

    -- Orlinn events
    event = hoa_map.ScriptedEvent("Quest1: Start Orlinn Hide n Seek2", "Quest1_Orlinn_Start_Hide_N_Seek2", "");
    event:AddEventLinkAtEnd("Quest1: Make Orlinn run");
    EventManager:RegisterEvent(event);

    event = hoa_map.PathMoveSpriteEvent("Quest1: Make Orlinn run", orlinn, 30, 2, true);
    event:AddEventLinkAtEnd("Quest1: Make Orlinn disappear");
    EventManager:RegisterEvent(event);

    event = hoa_map.ScriptedSpriteEvent("Quest1: Make Orlinn disappear", orlinn, "MakeInvisible", "");
    EventManager:RegisterEvent(event);
end

-- zones
local village_center_zone = {};
local to_village_riverbank_zone = {};
local to_left_house_zone = {};
local to_right_house_zone = {};

function _CreateZones()
	-- N.B.: left, right, top, bottom
	village_center_zone = hoa_map.CameraZone(8, 62, 0, 2, hoa_map.MapMode.CONTEXT_01);
	Map:AddZone(village_center_zone);

	to_village_riverbank_zone = hoa_map.CameraZone(0, 1, 26, 43, hoa_map.MapMode.CONTEXT_01);
	Map:AddZone(to_village_riverbank_zone);

	to_left_house_zone = hoa_map.CameraZone(18, 22, 32, 33, hoa_map.MapMode.CONTEXT_01);
	Map:AddZone(to_left_house_zone);

	to_right_house_zone = hoa_map.CameraZone(46, 50, 32, 33, hoa_map.MapMode.CONTEXT_01);
	Map:AddZone(to_right_house_zone);
end

function _CheckZones()
	if (village_center_zone:IsCameraEntering() == true) then
		-- Stop the character as it may walk in diagonal, which is looking strange
		-- when entering
		bronann:SetMoving(false);
		EventManager:StartEvent("to Village center");
	end

	if (to_village_riverbank_zone:IsCameraEntering() == true) then
		-- Stop the character as it may walk in diagonal, which is looking strange
		-- when entering
		bronann:SetMoving(false);
		EventManager:StartEvent("to Village riverbank");
	end

	if (to_left_house_zone:IsCameraEntering() == true) then
		-- Stop the character as it may walk in diagonal, which is looking strange
		-- when entering
		bronann:SetMoving(false);
		AudioManager:PlaySound("snd/door_open2.wav");
		EventManager:StartEvent("to left house");
	end

	if (to_right_house_zone:IsCameraEntering() == true) then
		-- Stop the character as it may walk in diagonal, which is looking strange
		-- when entering
		bronann:SetMoving(false);
		AudioManager:PlaySound("snd/door_open2.wav");
		EventManager:StartEvent("to right house");
	end
end

-- Custom inner map functions

function _UpdateOrlinnState()
	local text = {}
	local dialogue = {}
	local event = {}

    event = hoa_map.PathMoveSpriteEvent("Hide n Seek1: Orlinn goes right", orlinn, 31, 22, false);
	event:AddEventLinkAtEnd("Hide n Seek1: Orlinn looks south");
	EventManager:RegisterEvent(event);
    event = hoa_map.ChangeDirectionSpriteEvent("Hide n Seek1: Orlinn looks south", orlinn, hoa_map.MapMode.SOUTH);
	event:AddEventLinkAtEnd("Hide n Seek1: Orlinn goes left", 800);
    EventManager:RegisterEvent(event);
    event = hoa_map.PathMoveSpriteEvent("Hide n Seek1: Orlinn goes left", orlinn, 29, 22, false);
	event:AddEventLinkAtEnd("Hide n Seek1: Orlinn goes right", 8000); -- finish the event loop.
	EventManager:RegisterEvent(event);

    if (GlobalManager:DoesEventExist("layna_south_entrance", "quest1_orlinn_hide_n_seek1_done") == true) then
        -- Orlinn shouldn't be here, so we make him invisible
        orlinn:SetCollisionMask(hoa_map.MapMode.NO_COLLISION);
        orlinn:SetVisible(false);
        return;
	elseif (GlobalManager:DoesEventExist("layna_center", "quest1_orlinn_dialogue1_done") == true) then
        -- Start the hide and seek 1 position when it has to happen
        EventManager:StartEvent("Hide n Seek1: Orlinn goes right", 8000);

        -- Set up the dialogue.
        dialogue = hoa_map.SpriteDialogue();
        text = hoa_system.Translate("Yiek!!! Hey, you scared me.");
        dialogue:AddLineEmote(text, orlinn, "exclamation");
        text = hoa_system.Translate("But You'll never find me hiding on top of the cliffs!");
        dialogue:AddLineEvent(text, orlinn, "", "Quest1: Start Orlinn Hide n Seek2");
        DialogueManager:AddDialogue(dialogue);
        orlinn:AddDialogueReference(dialogue);
        return;
    end

    -- Orlinn default behaviour
    orlinn:SetCollisionMask(hoa_map.MapMode.NO_COLLISION);
    orlinn:SetVisible(false);
end


-- Map Custom functions
map_functions = {

    Quest1_Orlinn_Start_Hide_N_Seek2 = function()
        orlinn:SetMoving(false); -- in case he's moving
        orlinn:SetMovementSpeed(hoa_map.MapMode.VERY_FAST_SPEED);
        orlinn:ClearDialogueReferences();
		EventManager:TerminateAllEvents(orlinn);

        -- Updates Orlinn's state
		GlobalManager:SetEventValue("layna_south_entrance", "quest1_orlinn_hide_n_seek1_done", 1);
    end,

    MakeInvisible = function(sprite)
        if (sprite ~= nil) then
            sprite:SetVisible(false);
            sprite:SetCollisionMask(hoa_map.MapMode.NO_COLLISION);
        end
    end
}

