/* Generated from Telepathy D-Bus Interface Specification, TelepathyQt copy, version 0.17.7
 */
 
#ifndef IN_TP_QT_HEADER
#error IN_TP_QT_HEADER
#endif

#include <QFlags>

/**
 * \addtogroup typesconstants Types and constants
 *
 * Enumerated, flag, structure, list and mapping types and utility constants.
 */

/**
 * \defgroup flagtypeconsts Flag type constants
 * \ingroup typesconstants
 *
 * Types generated from the specification representing bit flag constants and
 * combinations of them (bitfields).
 */

/**
 * \defgroup enumtypeconsts Enumerated type constants
 * \ingroup typesconstants
 *
 * Types generated from the specification representing enumerated types ie.
 * types the values of which are mutually exclusive integral constants.
 */

/**
 * \defgroup ifacestrconsts Interface string constants
 * \ingroup typesconstants
 *
 * D-Bus interface names of the interfaces in the specification.
 */

/**
 * \defgroup errorstrconsts Error string constants
 * \ingroup typesconstants
 *
 * Names of the D-Bus errors in the specification.
 */

namespace Tp
{
/**
 * \ingroup flagtypeconsts
 *
 * Flag type generated from the specification.
 */
enum ConnMgrParamFlag
{
    /**
     * This parameter is required for connecting to the server.
     */
    ConnMgrParamFlagRequired = 1,

    /**
     * This parameter is required for registering an account on the server.
     */
    ConnMgrParamFlagRegister = 2,

    /**
     * This parameter has a default value, which is returned in GetParameters; 
     * not providing this parameter is equivalent to providing the default.
     */
    ConnMgrParamFlagHasDefault = 4,

    /**
     * \htmlonly
     * <p>This parameter should be considered private or secret; for
     *   instance, clients should store it in a &quot;password safe&quot; like
     *   gnome-keyring or kwallet, omit it from debug logs, and use a
     *   text input widget that hides the value of the parameter.</p>
     * 
     * <p>(Clients that support older connection managers may also treat
     *   any parameter whose name contains &quot;password&quot; as though it had this
     *   flag.)</p>
     * \endhtmlonly
     */
    ConnMgrParamFlagSecret = 8,

    /**
     * \htmlonly
     * <p>This parameter is also a D-Bus property on the resulting
     *    \endhtmlonly ConnectionInterface \htmlonly ; a
     *   parameter named <code>com.example.Duck.Macaroni</code> with this
     *   flag corresponds to the <code>Macaroni</code> property on the
     *   <code>com.example.Duck</code> interface.  Its value can be queried
     *   and possibly changed on an existing Connection using methods on the
     *   <code>org.freedesktop.DBus.Properties</code> interface.</p>
     * 
     * <p>When a new value for a parameter with this flag is passed to
     *    \endhtmlonly AccountInterface::UpdateParameters() \htmlonly ,
     *   the account manager will attempt to update its value on any running
     *   connections. Similarly, if the parameter also has the
     *   <code>Has_Default</code> flag, and is passed in the second argument
     *   to <code>UpdateParameters</code>, the default value will be applied
     *   to any running
     *   connections. Thus, clients generally do not need to directly access
     *   or update the connection property; instead, they SHOULD manipulate
     *    \endhtmlonly \link AccountInterface::requestPropertyParameters() AccountInterface::Parameters \endlink \htmlonly .</p>
     * 
     * <div class="rationale">
     *   <p>This allows runtime-configurable options to be stored and
     *     maintained by the  \endhtmlonly AccountManagerInterface \htmlonly , without needing to
     *     invent a separate account preference for “properties that should
     *     be set on the connection as soon as it is created”. It was
     *     originally invented to manage  \endhtmlonly ConnectionInterfaceCellularInterface \htmlonly 
     *     preferences.</p>
     * </div>
     * \endhtmlonly
     */
    ConnMgrParamFlagDBusProperty = 16,

    _ConnMgrParamFlagPadding = 0xffffffffU
};

/**
 * \typedef QFlags<ConnMgrParamFlag> ConnMgrParamFlags
 * \ingroup flagtypeconsts
 *
 * Type representing combinations of #ConnMgrParamFlag values.
 */
typedef QFlags<ConnMgrParamFlag> ConnMgrParamFlags;
Q_DECLARE_OPERATORS_FOR_FLAGS(ConnMgrParamFlags)

/**
 * \ingroup flagtypeconsts
 *
 * Flag type generated from the specification.
 */
enum ConnectionAliasFlag
{
    /**
     * \htmlonly
     * <p>The aliases of contacts on this connection may be changed by the
     *   user of the service, not just by the contacts themselves. This is
     *   the case on Jabber, for instance.</p>
     * <p>It is possible that aliases can be changed by the contacts too -
     *   which alias takes precedence is not defined by this
     *   specification, and depends on the server and/or connection manager
     *   implementation.</p>
     * <p>This flag only applies to the aliases of &quot;globally valid&quot; contact
     *   handles. At this time, clients should not expect to be able to
     *   change the aliases corresponding to any channel-specific
     *   handles. If this becomes possible in future, a new flag will
     *   be defined.</p>
     * \endhtmlonly
     */
    ConnectionAliasFlagUserSet = 1,

    _ConnectionAliasFlagPadding = 0xffffffffU
};

/**
 * \typedef QFlags<ConnectionAliasFlag> ConnectionAliasFlags
 * \ingroup flagtypeconsts
 *
 * Type representing combinations of #ConnectionAliasFlag values.
 */
typedef QFlags<ConnectionAliasFlag> ConnectionAliasFlags;
Q_DECLARE_OPERATORS_FOR_FLAGS(ConnectionAliasFlags)

/**
 * \ingroup flagtypeconsts
 *
 * Flag type generated from the specification.
 */
enum AnonymityMode
{
    /**
     * Obscure any information that provides user identification, user-agent 
     * identification or personal details. Examples of this information might 
     * be GSM CallerID, SIP from address, various informational email headers, 
     * etc. The CM should scrub/replace any of this information before passing 
     * messages or data onto the network. Note that a CM which has the option 
     * of obscuring the information at the CM or privacy service level would 
     * choose both (anonymity services are opaque to clients of this 
     * interface). Clients SHOULD NOT set both Client_Info and 
     * Show_Client_Info modes. If they are set, the CM MUST respect 
     * Client_Info and ignore Show_Client_Info.
     */
    AnonymityModeClientInfo = 1,

    /**
     * Explicitly request showing of client information. In connection 
     * context, this can be used to override service default. In channel 
     * context, this overrides connection anonymity modes. In GSM, it&apos;s 
     * possible to have CLIR enabled by default, and explicitly suppress CLIR 
     * for a single phone call. Clients SHOULD NOT set both Client_Info and 
     * Show_Client_Info modes. If they are set, the CM MUST respect 
     * Client_Info and ignore Show_Client_Info. The CM MAY set both 
     * Client_Info and Show_Client_Info in SupportedAnonymityModes to indicate 
     * its support for explicitly hiding and publicising client information.
     */
    AnonymityModeShowClientInfo = 2,

    /**
     * Obscure any originating IP address information, contact URIs, and 
     * anonymize all traffic involved with sending/receiving any media streams 
     * or call content. Examples of this include the &quot;headers&quot; 
     * portions of RFC 3323 as well as the History-Info (described in RFC 
     * 4244) for a SIP CM. This SHOULD have the effect of hiding address 
     * information from the remote contact (ie, the contact cannot know what 
     * IP address the session is originated from). Obviously the network still 
     * needs to be able to route information between contacts, so this 
     * provides no guarantees of what can be seen by intermediaries.
     */
    AnonymityModeNetworkInfo = 4,

    _AnonymityModePadding = 0xffffffffU
};

/**
 * \typedef QFlags<AnonymityMode> AnonymityModeFlags
 * \ingroup flagtypeconsts
 *
 * Type representing combinations of #AnonymityMode values.
 * 
 * Flags for the various types of anonymity modes. These modes are solely to 
 * inform the CM of the desired anonymous settings. It is up to the CM to 
 * determine whether the anonymity modes should be handled within the CM 
 * itself, or whether the network that a CM might be talking to should be 
 * enforcing anonymity. CMs MAY support only a subset of these modes, and 
 * specific connections MAY support none at all.
 */
typedef QFlags<AnonymityMode> AnonymityModeFlags;
Q_DECLARE_OPERATORS_FOR_FLAGS(AnonymityModeFlags)

/**
 * \ingroup flagtypeconsts
 *
 * Flag type generated from the specification.
 */
enum ConnectionCapabilityFlag
{
    /**
     * The given channel type and handle can be given to RequestChannel to 
     * create a new channel of this type.
     */
    ConnectionCapabilityFlagCreate = 1,

    /**
     * The given contact can be invited to an existing channel of this type.
     */
    ConnectionCapabilityFlagInvite = 2,

    _ConnectionCapabilityFlagPadding = 0xffffffffU
};

/**
 * \typedef QFlags<ConnectionCapabilityFlag> ConnectionCapabilityFlags
 * \ingroup flagtypeconsts
 *
 * Type representing combinations of #ConnectionCapabilityFlag values.
 */
typedef QFlags<ConnectionCapabilityFlag> ConnectionCapabilityFlags;
Q_DECLARE_OPERATORS_FOR_FLAGS(ConnectionCapabilityFlags)

/**
 * \ingroup flagtypeconsts
 *
 * Flag type generated from the specification.
 */
enum ContactBlockingCapability
{
    /**
     * \htmlonly
     * When calling  \endhtmlonly BlockContacts() \htmlonly , the
     * contacts may be reporting as abusive to the server administrators by
     * setting <var>Report_Abusive</var> to <code>True</code>.
     * \endhtmlonly
     */
    ContactBlockingCapabilityCanReportAbusive = 1,

    _ContactBlockingCapabilityPadding = 0xffffffffU
};

/**
 * \typedef QFlags<ContactBlockingCapability> ContactBlockingCapabilities
 * \ingroup flagtypeconsts
 *
 * Type representing combinations of #ContactBlockingCapability values.
 */
typedef QFlags<ContactBlockingCapability> ContactBlockingCapabilities;
Q_DECLARE_OPERATORS_FOR_FLAGS(ContactBlockingCapabilities)

/**
 * \ingroup flagtypeconsts
 *
 * Flag type generated from the specification.
 */
enum ContactInfoFlag
{
    /**
     * Indicates that SetContactInfo is supported on this connection.
     */
    ContactInfoFlagCanSet = 1,

    /**
     * Indicates that the protocol pushes all contacts&apos; information to 
     * the connection manager without prompting. If set, ContactInfoChanged 
     * will be emitted whenever contacts&apos; information changes.
     */
    ContactInfoFlagPush = 2,

    _ContactInfoFlagPadding = 0xffffffffU
};

/**
 * \typedef QFlags<ContactInfoFlag> ContactInfoFlags
 * \ingroup flagtypeconsts
 *
 * Type representing combinations of #ContactInfoFlag values.
 * 
 * Flags defining the behaviour of contact information on this protocol. Some 
 * protocols provide no information on contacts without an explicit request; 
 * others always push information to the connection manager as and when it 
 * changes.
 */
typedef QFlags<ContactInfoFlag> ContactInfoFlags;
Q_DECLARE_OPERATORS_FOR_FLAGS(ContactInfoFlags)

/**
 * \ingroup flagtypeconsts
 *
 * Flag type generated from the specification.
 */
enum ContactInfoFieldFlag
{
    /**
     * \htmlonly
     * <p>If present, exactly the parameters indicated must be set on this
     *   field; in the case of an empty list of parameters, this implies that
     *   parameters may not be used.</p>
     * 
     * <p>If absent, and the list of allowed parameters is non-empty,
     *   any (possibly empty) subset of that list may be
     *   used.</p>
     * 
     * <p>If absent, and the list of allowed parameters is empty,
     *   any parameters may be used.</p>
     * \endhtmlonly
     */
    ContactInfoFieldFlagParametersExact = 1,

    /**
     * \htmlonly
     * <p>Indicates that this field will be overwritten when the user's alias
     *   is changed with  \endhtmlonly ConnectionInterfaceAliasingInterface::SetAliases() \htmlonly 
     *   or when the Account's  \endhtmlonly \link AccountInterface::requestPropertyNickname() AccountInterface::Nickname \endlink \htmlonly 
     *   is updated.  Clients that allow the editing of the Alias and the
     *   ContactInfo in the same location should hide fields with this flag.</p>
     * <div class="rationale">
     *   <p>If a client allowed the user to edit both the nickname and the
     *     ContactInfo field at the same time, the user could set them to two
     *     different values even though they map to the same property.  This
     *     would result in surprising behavior where the second value would
     *     win over the first.</p>
     * </div>
     * <p>In addition to hiding this field when editing ContactInfo together
     *   with the user's nickname, it is recommended that clients call
     *    \endhtmlonly SetContactInfo() \htmlonly  before setting the
     *   user's nickname.</p>
     * <div class="rationale">
     *   <p>This ensures that if the user changes the nickname, the correct
     *     value will get set even if the stale nickname is mistakenly sent
     *     along with  \endhtmlonly SetContactInfo() \htmlonly .</p>
     * </div>
     * <p>If used, this flag typically appears on either the 'nickname' or
     *   'fn' field.</p>
     * \endhtmlonly
     */
    ContactInfoFieldFlagOverwrittenByNickname = 2,

    _ContactInfoFieldFlagPadding = 0xffffffffU
};

/**
 * \typedef QFlags<ContactInfoFieldFlag> ContactInfoFieldFlags
 * \ingroup flagtypeconsts
 *
 * Type representing combinations of #ContactInfoFieldFlag values.
 * 
 * \htmlonly
 * Flags describing the behaviour of a vCard field.
 * \endhtmlonly
 */
typedef QFlags<ContactInfoFieldFlag> ContactInfoFieldFlags;
Q_DECLARE_OPERATORS_FOR_FLAGS(ContactInfoFieldFlags)

/**
 * \ingroup flagtypeconsts
 *
 * Flag type generated from the specification.
 */
enum LocationFeature
{
    /**
     * Indicates that setting your own location with SetLocation is supported 
     * on this connection.
     */
    LocationFeatureCanSet = 1,

    _LocationFeaturePadding = 0xffffffffU
};

/**
 * \typedef QFlags<LocationFeature> LocationFeatures
 * \ingroup flagtypeconsts
 *
 * Type representing combinations of #LocationFeature values.
 * 
 * \htmlonly
 * Flags describing the Location features which may be supported on any
 * given connection.
 * \endhtmlonly
 */
typedef QFlags<LocationFeature> LocationFeatures;
Q_DECLARE_OPERATORS_FOR_FLAGS(LocationFeatures)

/**
 * \ingroup flagtypeconsts
 *
 * Flag type generated from the specification.
 */
enum MailNotificationFlag
{
    /**
     * This Connection provides the number of unread e-mails (or e-mail 
     * threads) in the main folder of your e-mail account, as the 
     * UnreadMailCount property. The connection manager will update this value 
     * by emitting the UnreadMailsChanged signal.
     */
    MailNotificationFlagSupportsUnreadMailCount = 1,

    /**
     * This Connection provides a detailed list of unread e-mails, as the 
     * UnreadMails property. If this flag is set, Supports_Unread_Mail_Count 
     * MUST be set, and Emits_Mails_Received MUST NOT be set. The Connection 
     * will update the list by emitting the UnreadMailsChanged signals.
     */
    MailNotificationFlagSupportsUnreadMails = 2,

    /**
     * This Connection emits the MailsReceived signal, which provides details 
     * about newly arrived e-mails but does not maintain their read/unread 
     * status afterwards. This flag MUST NOT be combined with 
     * Supports_Unread_Mails.
     */
    MailNotificationFlagEmitsMailsReceived = 4,

    /**
     * This Connection can provide a URL (with optional POST data) to open the 
     * the inbox of the e-mail account in a web-based client, via the 
     * RequestInboxURL method.
     */
    MailNotificationFlagSupportsRequestInboxURL = 8,

    /**
     * \htmlonly
     * <p>This Connection can provide a URL (with optional POST data) to open
     *   a specific mail in a web-based client, via the
     *    \endhtmlonly RequestMailURL() \htmlonly  method. This feature
     *   is not useful unless either Emits_Mails_Received or
     *   Supports_Unread_Mails is set.</p>
     * 
     * <p>If this flag is not set, clients SHOULD fall back to using
     *    \endhtmlonly RequestInboxURL() \htmlonly  if available.</p>
     * \endhtmlonly
     */
    MailNotificationFlagSupportsRequestMailURL = 16,

    /**
     * \htmlonly
     * <p>Each <tp:type>Mail</tp:type> represents a thread of e-mails, which
     *   MAY have more than one sender.</p>
     * 
     * <div class="rationale">
     *   <p>Google Talk notifies users about new mail in terms of unread
     *     threads, rather than unread e-mails.</p>
     * </div>
     * \endhtmlonly
     */
    MailNotificationFlagThreadBased = 32,

    _MailNotificationFlagPadding = 0xffffffffU
};

/**
 * \typedef QFlags<MailNotificationFlag> MailNotificationFlags
 * \ingroup flagtypeconsts
 *
 * Type representing combinations of #MailNotificationFlag values.
 * 
 * Flags representing capabilities provided by a connection manager. Those 
 * values can be used as bitfield. Some flags depend on, or conflict with, 
 * each other. Connections SHOULD implement as many of these features as the 
 * underlying protocol allows, preferring to implement Supports_Unread_Mails 
 * instead of Emits_Mails_Received if both are possible.
 */
typedef QFlags<MailNotificationFlag> MailNotificationFlags;
Q_DECLARE_OPERATORS_FOR_FLAGS(MailNotificationFlags)

/**
 * \ingroup flagtypeconsts
 *
 * Flag type generated from the specification.
 */
enum CallFlag
{
    /**
     * The call has been put on hold by the local user, e.g. using the Hold 
     * interface. This flag SHOULD only be set if there is at least one 
     * Content, and all Contents are locally held. Otherwise, in transient 
     * situations where some but not all contents are on hold, UIs would 
     * falsely indicate that the call as a whole is on hold, which could lead 
     * to the user saying something they&apos;ll regret, while under the 
     * impression that the other contacts can&apos;t hear them! This flag 
     * exists as a simplified proxy for HoldStateChanged, to reduce the number 
     * of signals that need to be listened to by a simple UI.
     */
    CallFlagLocallyHeld = 1,

    /**
     * This flag exists for observability of the SetRinging method (e.g. so 
     * that loggers can tell whether the call got as far as alerting the user, 
     * or whether something went wrong before then). It should be set when the 
     * SetRinging is called, and unset when the call leaves Initialised.
     */
    CallFlagLocallyRinging = 2,

    /**
     * This flag exists for observability of the SetQueued method. It should 
     * be set when the SetQueued is called, and unset when the call leaves 
     * Initialising or Initialised.
     */
    CallFlagLocallyQueued = 4,

    /**
     * The initiator of the call originally called a contact other than the 
     * current recipient of the call, but the call was then forwarded or 
     * diverted. This flag only makes sense on outgoing calls. It SHOULD be 
     * set or unset according to informational messages from other contacts.
     */
    CallFlagForwarded = 8,

    /**
     * This flag only occurs when the CallState is Ended. The call with this 
     * flag set has ended, but not all resources corresponding to the call 
     * have been freed yet. Depending on the protocol there might be some 
     * audible feedback while the clearing flag is set. In calls following the 
     * ITU-T Q.931 standard there is a period of time between the call ending 
     * and the underlying channel being completely free for re-use.
     */
    CallFlagClearing = 16,

    _CallFlagPadding = 0xffffffffU
};

/**
 * \typedef QFlags<CallFlag> CallFlags
 * \ingroup flagtypeconsts
 *
 * Type representing combinations of #CallFlag values.
 * 
 * A set of flags representing additional information than is available in 
 * CallState. Many of these flags only make sense in a particular (or may 
 * explain why a call is in a specific state).
 */
typedef QFlags<CallFlag> CallFlags;
Q_DECLARE_OPERATORS_FOR_FLAGS(CallFlags)

/**
 * \ingroup flagtypeconsts
 *
 * Flag type generated from the specification.
 */
enum CallMemberFlag
{
    /**
     * \htmlonly
     * <p>The remote contact's client has told us that the contact has been
     *   alerted about the call but has not responded.</p>
     * 
     * <div class="rationale">
     *   <p>This is a flag per member, not a flag for the call as a whole,
     *     because in Muji conference calls, you could invite someone and
     *     have their state be &quot;ringing&quot; for a while.</p>
     * </div>
     * \endhtmlonly
     */
    CallMemberFlagRinging = 1,

    /**
     * \htmlonly
     * <p>The call member has put this call on hold.</p>
     * 
     * <div class="rationale">
     *   <p>This is a flag per member, not a flag for the call as a whole,
     *     because in conference calls, any member could put the conference
     *     on hold.</p>
     * </div>
     * \endhtmlonly
     */
    CallMemberFlagHeld = 2,

    /**
     * \htmlonly
     * This contact has merged this call into a conference. Note that GSM
     * provides a notification when the remote party merges a call into a
     * conference, but not when it is split out again; thus, this flag can
     * only indicate that the call has been part of a conference at some
     * point. If a GSM connection manager receives a notification that a
     * call has been merged into a conference a second time, it SHOULD
     * represent this by clearing and immediately re-setting this flag on
     * the remote contact.
     * \endhtmlonly
     */
    CallMemberFlagConferenceHost = 4,

    _CallMemberFlagPadding = 0xffffffffU
};

/**
 * \typedef QFlags<CallMemberFlag> CallMemberFlags
 * \ingroup flagtypeconsts
 *
 * Type representing combinations of #CallMemberFlag values.
 * 
 * \htmlonly
 * <p>A set of flags representing the status of a remote contact in a
 *   call.</p>
 * 
 * <p>It is protocol- and client-specific whether a particular contact
 *   will ever have a particular flag set on them, and Telepathy clients
 *   SHOULD NOT assume that a flag will ever be set.</p>
 * 
 * <div class="rationale">
 *   <p>180 Ringing in SIP, and its equivalent in XMPP, are optional
 *     informational messages, and implementations are not required
 *     to send them. The same applies to the messages used to indicate
 *     hold state.</p>
 * </div>
 * \endhtmlonly
 */
typedef QFlags<CallMemberFlag> CallMemberFlags;
Q_DECLARE_OPERATORS_FOR_FLAGS(CallMemberFlags)

/**
 * \ingroup flagtypeconsts
 *
 * Flag type generated from the specification.
 */
enum MediaStreamPending
{
    /**
     * The local user has been asked to send media by the remote user. Call 
     * RequestStreamDirection to indicate whether or not this is acceptable.
     */
    MediaStreamPendingLocalSend = 1,

    /**
     * The remote user has been asked to send media by the local user. The 
     * StreamDirectionChanged signal will be emitted when the remote user 
     * accepts or rejects this change.
     */
    MediaStreamPendingRemoteSend = 2,

    _MediaStreamPendingPadding = 0xffffffffU
};

/**
 * \typedef QFlags<MediaStreamPending> MediaStreamPendingSend
 * \ingroup flagtypeconsts
 *
 * Type representing combinations of #MediaStreamPending values.
 */
typedef QFlags<MediaStreamPending> MediaStreamPendingSend;
Q_DECLARE_OPERATORS_FOR_FLAGS(MediaStreamPendingSend)

/**
 * \ingroup flagtypeconsts
 *
 * Flag type generated from the specification.
 */
enum ChannelMediaCapability
{
    /**
     * The handle is capable of using audio streams within a media channel.
     */
    ChannelMediaCapabilityAudio = 1,

    /**
     * The handle is capable of using video streams within a media channel.
     */
    ChannelMediaCapabilityVideo = 2,

    /**
     * The handle is capable of performing STUN to traverse NATs.
     */
    ChannelMediaCapabilityNATTraversalSTUN = 4,

    /**
     * The handle is capable of establishing Google Talk peer-to-peer 
     * connections (as implemented in libjingle 0.3) to traverse NATs.
     */
    ChannelMediaCapabilityNATTraversalGTalkP2P = 8,

    /**
     * The handle is capable of establishing ICE UDP peer-to-peer connections 
     * (as defined by the IETF MMUSIC working group) to traverse NATs.
     */
    ChannelMediaCapabilityNATTraversalICEUDP = 16,

    /**
     * Channels whose target handle is this contact will have ImmutableStreams 
     * = True.
     */
    ChannelMediaCapabilityImmutableStreams = 32,

    _ChannelMediaCapabilityPadding = 0xffffffffU
};

/**
 * \typedef QFlags<ChannelMediaCapability> ChannelMediaCapabilities
 * \ingroup flagtypeconsts
 *
 * Type representing combinations of #ChannelMediaCapability values.
 * 
 * The channel-type-specific capability flags used for 
 * Channel.Type.StreamedMedia in the Connection.Interface.Capabilities 
 * interface. See the InitialAudio property for details of the mechanisms that 
 * will replace this.
 */
typedef QFlags<ChannelMediaCapability> ChannelMediaCapabilities;
Q_DECLARE_OPERATORS_FOR_FLAGS(ChannelMediaCapabilities)

/**
 * \ingroup flagtypeconsts
 *
 * Flag type generated from the specification.
 */
enum ChannelTextMessageFlag
{
    /**
     * The incoming message was truncated to a shorter length by the server or 
     * the connection manager.
     */
    ChannelTextMessageFlagTruncated = 1,

    /**
     * \htmlonly
     * <p>The incoming message contained non-text content which cannot be
     *   represented by this interface, but has been signalled
     *   in the  \endhtmlonly ChannelInterfaceMessagesInterface \htmlonly 
     *   interface.</p>
     * 
     * <p>Connection managers SHOULD only set this flag if the non-text
     *   content appears to be relatively significant (exactly how
     *   significant is up to the implementor). The intention is that
     *   if this flag is set, clients using this interface SHOULD inform
     *   the user that part of the message was not understood.</p>
     * \endhtmlonly
     */
    ChannelTextMessageFlagNonTextContent = 2,

    /**
     * \htmlonly
     * <p>The incoming message was part of a replay of message history.</p>
     * 
     * <div class="rationale">
     *   <p>In XMPP multi-user chat, a few past messages are replayed
     *     when you join a chatroom. A sufficiently capable IRC connection
     *     manager could also set this flag on historical messages when
     *     connected to a proxy like bip or irssi-proxy. The existence
     *     of this flag allows loggers and UIs to use better heuristics
     *     when eliminating duplicates (a simple implementation made
     *     possible by this flag would be to avoid logging scrollback
     *     at all).</p>
     * </div>
     * \endhtmlonly
     */
    ChannelTextMessageFlagScrollback = 4,

    /**
     * \htmlonly
     * <p>The incoming message has been seen in a previous channel during
     *   the lifetime of the  \endhtmlonly ConnectionInterface \htmlonly , but
     *   had not been acknowledged
     *   when that channel closed, causing an identical channel (the
     *   channel in which the message now appears) to open.</p>
     * 
     * <div class="rationale">
     *   <p>This means that a logger (which should already have seen the
     *     message in the previous channel) is able to recognise and ignore
     *     these replayed messages.</p>
     * </div>
     * \endhtmlonly
     */
    ChannelTextMessageFlagRescued = 8,

    _ChannelTextMessageFlagPadding = 0xffffffffU
};

/**
 * \typedef QFlags<ChannelTextMessageFlag> ChannelTextMessageFlags
 * \ingroup flagtypeconsts
 *
 * Type representing combinations of #ChannelTextMessageFlag values.
 */
typedef QFlags<ChannelTextMessageFlag> ChannelTextMessageFlags;
Q_DECLARE_OPERATORS_FOR_FLAGS(ChannelTextMessageFlags)

/**
 * \ingroup flagtypeconsts
 *
 * Flag type generated from the specification.
 */
enum CaptchaFlag
{
    /**
     * This captcha mechanism is required to be successfully answered in order 
     * to pass this captcha challenge.
     */
    CaptchaFlagRequired = 1,

    _CaptchaFlagPadding = 0xffffffffU
};

/**
 * \typedef QFlags<CaptchaFlag> CaptchaFlags
 * \ingroup flagtypeconsts
 *
 * Type representing combinations of #CaptchaFlag values.
 * 
 * \htmlonly
 * <p>Extra flags to include with Captcha information</p>
 * \endhtmlonly
 */
typedef QFlags<CaptchaFlag> CaptchaFlags;
Q_DECLARE_OPERATORS_FOR_FLAGS(CaptchaFlags)

/**
 * \ingroup flagtypeconsts
 *
 * Flag type generated from the specification.
 */
enum ChannelCallState
{
    /**
     * The contact has been alerted about the call but has not responded (e.g. 
     * 180 Ringing in SIP).
     */
    ChannelCallStateRinging = 1,

    /**
     * The contact is temporarily unavailable, and the call has been placed in 
     * a queue (e.g. 182 Queued in SIP, or call-waiting in telephony).
     */
    ChannelCallStateQueued = 2,

    /**
     * The contact has placed the call on hold, and will not receive media 
     * from the local user or any other participants until they unhold the 
     * call again.
     */
    ChannelCallStateHeld = 4,

    /**
     * The initiator of the call originally called a contact other than the 
     * current recipient of the call, but the call was then forwarded or 
     * diverted.
     */
    ChannelCallStateForwarded = 8,

    /**
     * Progress has been made in placing the outgoing call, but the 
     * destination contact may not have been made aware of the call yet (so 
     * the Ringing state is not appropriate). This corresponds to SIP&apos;s 
     * status code 183 Session Progress, and could be used when the outgoing 
     * call has reached a gateway, for instance.
     */
    ChannelCallStateInProgress = 16,

    /**
     * \htmlonly
     * This contact has merged this call into a conference. Note that GSM
     * provides a notification when the remote party merges a call into a
     * conference, but not when it is split out again; thus, this flag can
     * only indicate that the call has been part of a conference at some
     * point. If a GSM connection manager receives a notification that a
     * call has been merged into a conference a second time, it SHOULD
     * represent this by clearing and immediately re-setting this flag on
     * the remote contact.
     * \endhtmlonly
     */
    ChannelCallStateConferenceHost = 32,

    _ChannelCallStatePadding = 0xffffffffU
};

/**
 * \typedef QFlags<ChannelCallState> ChannelCallStateFlags
 * \ingroup flagtypeconsts
 *
 * Type representing combinations of #ChannelCallState values.
 * 
 * A set of flags representing call states.
 */
typedef QFlags<ChannelCallState> ChannelCallStateFlags;
Q_DECLARE_OPERATORS_FOR_FLAGS(ChannelCallStateFlags)

/**
 * \ingroup flagtypeconsts
 *
 * Flag type generated from the specification.
 */
enum ChannelGroupFlag
{
    /**
     * The AddMembers method can be used to add or invite members who are not 
     * already in the local pending list (which is always valid).
     */
    ChannelGroupFlagCanAdd = 1,

    /**
     * The RemoveMembers method can be used to remove channel members 
     * (removing those on the pending local list is always valid).
     */
    ChannelGroupFlagCanRemove = 2,

    /**
     * The RemoveMembers method can be used on people on the remote pending 
     * list.
     */
    ChannelGroupFlagCanRescind = 4,

    /**
     * A message may be sent to the server when calling AddMembers on contacts 
     * who are not currently pending members.
     */
    ChannelGroupFlagMessageAdd = 8,

    /**
     * A message may be sent to the server when calling RemoveMembers on 
     * contacts who are currently channel members.
     */
    ChannelGroupFlagMessageRemove = 16,

    /**
     * A message may be sent to the server when calling AddMembers on contacts 
     * who are locally pending.
     */
    ChannelGroupFlagMessageAccept = 32,

    /**
     * A message may be sent to the server when calling RemoveMembers on 
     * contacts who are locally pending.
     */
    ChannelGroupFlagMessageReject = 64,

    /**
     * A message may be sent to the server when calling RemoveMembers on 
     * contacts who are remote pending.
     */
    ChannelGroupFlagMessageRescind = 128,

    /**
     * \htmlonly
     * <p>
     *   The members of this group have handles which are specific to
     *   this channel, and are not valid as general-purpose handles on
     *   the connection. Depending on the channel, it may be possible to
     *   check the  \endhtmlonly \link requestPropertyHandleOwners() HandleOwners \endlink \htmlonly  property or
     *   call  \endhtmlonly GetHandleOwners() \htmlonly  to find the
     *   owners of these handles, which should be done if you wish to (e.g.)
     *   subscribe to the contact's presence.
     * </p>
     * 
     * <p>
     *   Connection managers must ensure that any given handle is not
     *   simultaneously a general-purpose handle and a channel-specific
     *   handle.
     * </p>
     * \endhtmlonly
     */
    ChannelGroupFlagChannelSpecificHandles = 256,

    /**
     * Placing a contact in multiple groups of this type is not allowed and 
     * will raise NotAvailable (on services where contacts may only be in one 
     * user-defined group, user-defined groups will have this flag).
     */
    ChannelGroupFlagOnlyOneGroup = 512,

    /**
     * In rooms with channel specific handles (ie Channel_Specific_Handles 
     * flag is set), this flag indicates that no handle owners are available, 
     * apart from the owner of the SelfHandle. This used to be an important 
     * optimization to avoid repeated GetHandleOwners calls, before we 
     * introduced the HandleOwners property and HandleOwnersChanged signal.
     */
    ChannelGroupFlagHandleOwnersNotAvailable = 1024,

    /**
     * This flag indicates that all the properties introduced in specification 
     * 0.17.6 are fully supported.
     */
    ChannelGroupFlagProperties = 2048,

    /**
     * Indicates that MembersChangedDetailed will be emitted for changes to 
     * this group&apos;s members in addition to MembersChanged. Clients can 
     * then connect to the former and ignore emission of the latter. This 
     * flag&apos;s state MUST NOT change over the lifetime of a channel. If it 
     * were allowed to change, client bindings would have to always connect to 
     * MembersChanged just in case the flag ever went away (and generally be 
     * unnecessarily complicated), which would mostly negate the point of 
     * having this flag in the first place.
     */
    ChannelGroupFlagMembersChangedDetailed = 4096,

    /**
     * A message may be sent to the server when calling RemoveMembers on the 
     * SelfHandle. This would be set for XMPP Multi-User Chat or IRC channels, 
     * but not for a typical implementation of streamed media calls.
     */
    ChannelGroupFlagMessageDepart = 8192,

    _ChannelGroupFlagPadding = 0xffffffffU
};

/**
 * \typedef QFlags<ChannelGroupFlag> ChannelGroupFlags
 * \ingroup flagtypeconsts
 *
 * Type representing combinations of #ChannelGroupFlag values.
 */
typedef QFlags<ChannelGroupFlag> ChannelGroupFlags;
Q_DECLARE_OPERATORS_FOR_FLAGS(ChannelGroupFlags)

/**
 * \ingroup flagtypeconsts
 *
 * Flag type generated from the specification.
 */
enum MessagePartSupportFlag
{
    /**
     * SendMessage will accept messages containing a textual message body, 
     * plus a single attachment of any type listed in the 
     * SupportedContentTypes property. It does not make sense for this flag to 
     * be set if Message_Part_Support_Flag_Data_Only is not also set (because 
     * the connection manager can trivially provide an empty text part if 
     * necessary).
     */
    MessagePartSupportFlagOneAttachment = 1,

    /**
     * SendMessage will accept messages containing a textual message body, 
     * plus an arbitrary number of attachments of any type listed in the 
     * SupportedContentTypes property. It does not make sense for this flag to 
     * be set if Message_Part_Support_Flag_One_Attachment is not also set.
     */
    MessagePartSupportFlagMultipleAttachments = 2,

    _MessagePartSupportFlagPadding = 0xffffffffU
};

/**
 * \typedef QFlags<MessagePartSupportFlag> MessagePartSupportFlags
 * \ingroup flagtypeconsts
 *
 * Type representing combinations of #MessagePartSupportFlag values.
 * 
 * \htmlonly
 * <p>Flags indicating the level of support for message parts on this
 *   channel. They are designed such that setting more flags always
 *   implies that the channel has more capabilities.</p>
 * 
 * <p>If no flags are set, this indicates that messages may contain
 *   a single message part whose content-type is any of the types
 *   from SupportedContentTypes, possibly with some alternatives.</p>
 * 
 * <p>There is no flag indicating support for alternatives. This is
 *   because the SendMessage implementation can always accept messages
 *   containing alternatives, even if the underlying protocol does not,
 *   by deleting all alternatives except the first (most preferred)
 *   that is supported.</p>
 * 
 * <div class="rationale">
 *   Each of the flags so far implies the previous flag, so we could
 *   have used a simple enumeration here; however, we've defined
 *   the message-part support indicator as a flag set for future
 *   expansion.
 * </div>
 * 
 * <p>See  \endhtmlonly \link requestPropertySupportedContentTypes() SupportedContentTypes \endlink \htmlonly  for some
 *   examples.</p>
 * \endhtmlonly
 */
typedef QFlags<MessagePartSupportFlag> MessagePartSupportFlags;
Q_DECLARE_OPERATORS_FOR_FLAGS(MessagePartSupportFlags)

/**
 * \ingroup flagtypeconsts
 *
 * Flag type generated from the specification.
 */
enum MessageSendingFlag
{
    /**
     * \htmlonly
     * <p>Provide a successful delivery report if possible, even if this is
     *   not the default for this protocol. Ignored if delivery reports are
     *   not possible on this protocol.</p>
     * 
     * <div class="rationale">
     *   <p>In some protocols, like XMPP, it is not conventional to request
     *     or send positive delivery notifications.</p>
     * </div>
     * 
     * <p>Delivery failure reports SHOULD always be sent, but if this flag
     *   is present, the connection manager MAY also try harder to obtain
     *   failed delivery reports or allow them to be matched to outgoing
     *   messages.</p>
     * \endhtmlonly
     */
    MessageSendingFlagReportDelivery = 1,

    /**
     * \htmlonly
     * <p>Provide a delivery report when the message is read by the
     *   recipient, even if this is not the default for this protocol.
     *   Ignored if read reports are not possible on this protocol.</p>
     * \endhtmlonly
     */
    MessageSendingFlagReportRead = 2,

    /**
     * \htmlonly
     * <p>Provide a delivery report when the message is deleted by the
     *   recipient, even if this is not the default for this protocol.
     *   Ignored if such reports are not possible on this protocol.</p>
     * \endhtmlonly
     */
    MessageSendingFlagReportDeleted = 4,

    _MessageSendingFlagPadding = 0xffffffffU
};

/**
 * \typedef QFlags<MessageSendingFlag> MessageSendingFlags
 * \ingroup flagtypeconsts
 *
 * Type representing combinations of #MessageSendingFlag values.
 * 
 * Flags altering the way a message is sent. The &quot;most usual&quot; action 
 * should always be to have these flags unset. Some indication of which flags 
 * are supported is provided by the DeliveryReportingSupport property.
 */
typedef QFlags<MessageSendingFlag> MessageSendingFlags;
Q_DECLARE_OPERATORS_FOR_FLAGS(MessageSendingFlags)

/**
 * \ingroup flagtypeconsts
 *
 * Flag type generated from the specification.
 */
enum DeliveryReportingSupportFlag
{
    /**
     * Clients MAY expect to receive negative delivery reports if 
     * Message_Sending_Flag_Report_Delivery is specified when sending.
     */
    DeliveryReportingSupportFlagReceiveFailures = 1,

    /**
     * Clients MAY expect to receive positive delivery reports if 
     * Message_Sending_Flag_Report_Delivery is specified when sending.
     */
    DeliveryReportingSupportFlagReceiveSuccesses = 2,

    /**
     * Clients MAY expect to receive Delivery_Status Read reports if 
     * Message_Sending_Flag_Report_Read is specified when sending.
     */
    DeliveryReportingSupportFlagReceiveRead = 4,

    /**
     * Clients MAY expect to receive Delivery_Status Deleted reports if 
     * Message_Sending_Flag_Report_Deleted is specified when sending.
     */
    DeliveryReportingSupportFlagReceiveDeleted = 8,

    _DeliveryReportingSupportFlagPadding = 0xffffffffU
};

/**
 * \typedef QFlags<DeliveryReportingSupportFlag> DeliveryReportingSupportFlags
 * \ingroup flagtypeconsts
 *
 * Type representing combinations of #DeliveryReportingSupportFlag values.
 * 
 * Flags indicating the level of support for delivery reporting on this 
 * channel, as found on the DeliveryReportingSupport property. Any future 
 * flags added to this set will conform to the convention that the presence of 
 * an extra flag implies that more operations will succeed. Note that CMs may 
 * always provide more reports than are requested in the Message_Sending_Flags 
 * passed to SendMessage. If senders want delivery reports, they should ask 
 * for them. If they don&apos;t want delivery reports, they can just ignore 
 * them, so there&apos;s no need to have capability discovery for what will 
 * happen if a delivery report isn&apos;t requested.
 */
typedef QFlags<DeliveryReportingSupportFlag> DeliveryReportingSupportFlags;
Q_DECLARE_OPERATORS_FOR_FLAGS(DeliveryReportingSupportFlags)

/**
 * \ingroup flagtypeconsts
 *
 * Flag type generated from the specification.
 */
enum ChannelPasswordFlag
{
    /**
     * The ProvidePassword method must be called now for the user to join the 
     * channel
     */
    ChannelPasswordFlagProvide = 8,

    /**
     * The RoomConfig1.PasswordHint contains a hint for the password.
     */
    ChannelPasswordFlagHint = 4,

    _ChannelPasswordFlagPadding = 0xffffffffU
};

/**
 * \typedef QFlags<ChannelPasswordFlag> ChannelPasswordFlags
 * \ingroup flagtypeconsts
 *
 * Type representing combinations of #ChannelPasswordFlag values.
 */
typedef QFlags<ChannelPasswordFlag> ChannelPasswordFlags;
Q_DECLARE_OPERATORS_FOR_FLAGS(ChannelPasswordFlags)

/**
 * \ingroup flagtypeconsts
 *
 * Flag type generated from the specification.
 */
enum PropertyFlag
{
    /**
     * The property can be read
     */
    PropertyFlagRead = 1,

    /**
     * The property can be written
     */
    PropertyFlagWrite = 2,

    _PropertyFlagPadding = 0xffffffffU
};

/**
 * \typedef QFlags<PropertyFlag> PropertyFlags
 * \ingroup flagtypeconsts
 *
 * Type representing combinations of #PropertyFlag values.
 */
typedef QFlags<PropertyFlag> PropertyFlags;
Q_DECLARE_OPERATORS_FOR_FLAGS(PropertyFlags)

/**
 * \ingroup flagtypeconsts
 *
 * Flag type generated from the specification.
 */
enum StorageRestrictionFlag
{
    /**
     * The account&apos;s Parameters property can&apos;t be changed by calling 
     * UpdateParameters.
     */
    StorageRestrictionFlagCannotSetParameters = 1,

    /**
     * The account can&apos;t be enabled/disabled by setting the Enabled 
     * property.
     */
    StorageRestrictionFlagCannotSetEnabled = 2,

    /**
     * The account&apos;s presence can&apos;t be changed by setting the 
     * RequestedPresence and AutomaticPresence properties.
     */
    StorageRestrictionFlagCannotSetPresence = 4,

    /**
     * The account&apos;s Service property cannot be changed.
     */
    StorageRestrictionFlagCannotSetService = 8,

    _StorageRestrictionFlagPadding = 0xffffffffU
};

/**
 * \typedef QFlags<StorageRestrictionFlag> StorageRestrictionFlags
 * \ingroup flagtypeconsts
 *
 * Type representing combinations of #StorageRestrictionFlag values.
 * 
 * Flags indicating restrictions imposed on an Account by its storage method.
 */
typedef QFlags<StorageRestrictionFlag> StorageRestrictionFlags;
Q_DECLARE_OPERATORS_FOR_FLAGS(StorageRestrictionFlags)

/**
 * \ingroup flagtypeconsts
 *
 * Flag type generated from the specification.
 */
enum RTCPXRStatisticsFlag
{
    /**
     * Loss report flag, as defined in RFC3611 section 4.6.
     */
    RTCPXRStatisticsFlagLoss = 1,

    /**
     * Duplicate report flag, as defined in RFC3611 section 4.6.
     */
    RTCPXRStatisticsFlagDuplicate = 2,

    /**
     * Jitter flag, as defined in RFC3611 section 4.6.
     */
    RTCPXRStatisticsFlagJitter = 4,

    /**
     * First bit of TTL or Hop Limit flag, as defined in RFC3611 section 4.6.
     */
    RTCPXRStatisticsFlagTTL = 8,

    /**
     * Second bit of TTL or Hop Limit flag, as defined in RFC3611 section 4.6.
     */
    RTCPXRStatisticsFlagHL = 16,

    _RTCPXRStatisticsFlagPadding = 0xffffffffU
};

/**
 * \typedef QFlags<RTCPXRStatisticsFlag> RTCPXRStatisticsFlags
 * \ingroup flagtypeconsts
 *
 * Type representing combinations of #RTCPXRStatisticsFlag values.
 */
typedef QFlags<RTCPXRStatisticsFlag> RTCPXRStatisticsFlags;
Q_DECLARE_OPERATORS_FOR_FLAGS(RTCPXRStatisticsFlags)

/**
 * \enum HandleType
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 */
enum HandleType
{
    /**
     * A &quot;null&quot; handle type used to indicate the absence of a 
     * handle. When a handle type and a handle appear as a pair, if the handle 
     * type is zero, the handle must also be zero.
     */
    HandleTypeNone = 0,

    /**
     * A contact
     */
    HandleTypeContact = 1,

    /**
     * A chat room
     */
    HandleTypeRoom = 2,

    /**
     * A server-generated contact list (see Channel.Interface.Group)
     */
    HandleTypeList = 3,

    /**
     * A user-defined contact list (see Channel.Interface.Group)
     */
    HandleTypeGroup = 4,

    _HandleTypePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of HandleType.
 */
const int NUM_HANDLE_TYPES = (4+1);

/**
 * \enum ConnectionStatus
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 */
enum ConnectionStatus
{
    /**
     * The connection is fully connected and all methods are available.
     */
    ConnectionStatusConnected = 0,

    /**
     * Connect has been called but the connection has not yet been 
     * established. Some methods may fail until the connection has been 
     * established.
     */
    ConnectionStatusConnecting = 1,

    /**
     * If this is retrieved from GetStatus or Status, it indicates that 
     * connection has not yet been attempted. If seen in a StatusChanged 
     * signal, it indicates that the connection has failed; the Connection 
     * object SHOULD be removed from D-Bus immediately, and all subsequent 
     * method calls SHOULD fail.
     */
    ConnectionStatusDisconnected = 2,

    _ConnectionStatusPadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of ConnectionStatus.
 */
const int NUM_CONNECTION_STATUSES = (2+1);

/**
 * \enum ConnectionStatusReason
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 * 
 * \htmlonly
 * <p>A reason why the status of the connection changed. Apart from
 *   Requested, the values of this enumeration only make sense as
 *   reasons why the status changed to Disconnected.</p>
 * \endhtmlonly
 */
enum ConnectionStatusReason
{
    /**
     * \htmlonly
     * <p>There is no reason set for this state change. Unknown status
     *   reasons SHOULD be treated like this reason.</p>
     * 
     * <p>When disconnected for this reason, the equivalent D-Bus error is
     *   <code>org.freedesktop.Telepathy.Error.<tp:error-ref>Disconnected</tp:error-ref></code>.</p>
     * \endhtmlonly
     */
    ConnectionStatusReasonNoneSpecified = 0,

    /**
     * \htmlonly
     * <p>The change is in response to a user request. Changes to the
     *   Connecting or Connected status SHOULD always indicate this reason;
     *   changes to the Disconnected status SHOULD indicate this reason
     *   if and only if the disconnection was requested by the user.</p>
     * 
     * <p>When disconnected for this reason, the equivalent D-Bus error is
     *   <code>org.freedesktop.Telepathy.Error.Cancelled</code>.</p>
     * \endhtmlonly
     */
    ConnectionStatusReasonRequested = 1,

    /**
     * \htmlonly
     * <p>There was an error sending or receiving on the network socket.</p>
     * 
     * <p>When the status changes from Connecting to Disconnected for this
     *   reason, the equivalent D-Bus error is either
     *   <code>org.freedesktop.Telepathy.Error.NetworkError</code>,
     *   <code>org.freedesktop.Telepathy.Error.ConnectionRefused</code>,
     *   <code>org.freedesktop.Telepathy.Error.ConnectionFailed</code>
     *   or some more specific error.</p>
     * 
     * <p>When the status changes from Connected to Disconnected for this
     *   reason, the equivalent D-Bus error is either
     *   <code>org.freedesktop.Telepathy.Error.NetworkError</code>,
     *   <code>org.freedesktop.Telepathy.Error.ConnectionLost</code>
     *   or some more specific error.</p>
     * \endhtmlonly
     */
    ConnectionStatusReasonNetworkError = 2,

    /**
     * \htmlonly
     * <p>The username or password was invalid.</p>
     * 
     * <p>When disconnected for this reason, the equivalent D-Bus error is
     *   <code>org.freedesktop.Telepathy.Error.AuthenticationFailed</code>.
     * </p>
     * \endhtmlonly
     */
    ConnectionStatusReasonAuthenticationFailed = 3,

    /**
     * \htmlonly
     * <p>There was an error negotiating SSL on this connection, or
     *   encryption was unavailable and require-encryption was set when the
     *   connection was created.</p>
     * 
     * <p>When disconnected for this reason, the equivalent D-Bus error is
     *   <code>org.freedesktop.Telepathy.Error.EncryptionNotAvailable</code>
     *   if encryption was not available at all, or
     *   <code>org.freedesktop.Telepathy.Error.EncryptionError</code>
     *   if encryption failed.</p>
     * \endhtmlonly
     */
    ConnectionStatusReasonEncryptionError = 4,

    /**
     * \htmlonly
     * <p>In general, this reason indicates that the requested account
     *   name or other identification could not be used due to conflict
     *   with another connection. It can be divided into three cases:</p>
     * 
     * <ul>
     *   <li>If the status change is from Connecting to Disconnected
     *     and the 'register' parameter to RequestConnection was present
     *     and true, the requested account could not be created on the
     *     server because it already exists.
     *     The equivalent D-Bus error is
     *     <code>org.freedesktop.Telepathy.Error.RegistrationExists</code>.
     *   </li>
     * 
     *   <li>If the status change is from Connecting to Disconnected
     *     but the 'register' parameter is absent or false, the connection
     *     manager could not connect to the specified account because
     *     a connection to that account already exists.
     *     The equivalent D-Bus error is
     *     <code>org.freedesktop.Telepathy.Error.AlreadyConnected</code>.
     * 
     *     <div class="rationale">
     *       In some protocols, like XMPP (when connecting with the same
     *       JID and resource as an existing connection), the existing
     *       connection &quot;wins&quot; and the new one fails to connect.
     *     </div>
     *   </li>
     * 
     *   <li>If the status change is from Connected to Disconnected,
     *     the existing connection was automatically disconnected because
     *     a new connection to the same account (perhaps from a different
     *     client or location) was established.
     *     The equivalent D-Bus error is
     *     <code>org.freedesktop.Telepathy.Error.ConnectionReplaced</code>.
     * 
     *     <div class="rationale">
     *       In some protocols, like MSNP (when connecting twice with the
     *       same Passport), the new connection &quot;wins&quot; and the
     *       existing one is automatically disconnected.
     *     </div>
     *   </li>
     * </ul>
     * \endhtmlonly
     */
    ConnectionStatusReasonNameInUse = 5,

    /**
     * \htmlonly
     * <p>The server did not provide a SSL certificate.</p>
     * 
     * <p>When disconnected for this reason, the equivalent D-Bus error is
     *   <code>org.freedesktop.Telepathy.Error.Cert.NotProvided</code>.
     * </p>
     * \endhtmlonly
     */
    ConnectionStatusReasonCertNotProvided = 6,

    /**
     * \htmlonly
     * <p>The server's SSL certificate is signed by an untrusted certifying
     *   authority. This error SHOULD NOT be used to represent a self-signed
     *   certificate: use the more specific Cert_Self_Signed reason for
     *   that.</p>
     * 
     * <p>When disconnected for this reason, the equivalent D-Bus error is
     *   <code>org.freedesktop.Telepathy.Error.Cert.Untrusted</code>.
     * </p>
     * \endhtmlonly
     */
    ConnectionStatusReasonCertUntrusted = 7,

    /**
     * \htmlonly
     * <p>The server's SSL certificate has expired.</p>
     * 
     * <p>When disconnected for this reason, the equivalent D-Bus error is
     *   <code>org.freedesktop.Telepathy.Error.Cert.Expired</code>.
     * </p>
     * \endhtmlonly
     */
    ConnectionStatusReasonCertExpired = 8,

    /**
     * \htmlonly
     * <p>The server's SSL certificate is not yet valid.</p>
     * 
     * <p>When disconnected for this reason, the equivalent D-Bus error is
     *   <code>org.freedesktop.Telepathy.Error.Cert.NotActivated</code>.
     * </p>
     * \endhtmlonly
     */
    ConnectionStatusReasonCertNotActivated = 9,

    /**
     * \htmlonly
     * <p>The server's SSL certificate did not match its hostname.</p>
     * 
     * <p>When disconnected for this reason, the equivalent D-Bus error is
     *   <code>org.freedesktop.Telepathy.Error.Cert.HostnameMismatch</code>.
     * </p>
     * \endhtmlonly
     */
    ConnectionStatusReasonCertHostnameMismatch = 10,

    /**
     * \htmlonly
     * <p>The server's SSL certificate does not have the expected
     *   fingerprint.</p>
     * 
     * <p>When disconnected for this reason, the equivalent D-Bus error is
     *   <code>org.freedesktop.Telepathy.Error.Cert.FingerprintMismatch</code>.
     * </p>
     * \endhtmlonly
     */
    ConnectionStatusReasonCertFingerprintMismatch = 11,

    /**
     * \htmlonly
     * <p>The server's SSL certificate is self-signed.</p>
     * 
     * <p>When disconnected for this reason, the equivalent D-Bus error is
     *   <code>org.freedesktop.Telepathy.Error.Cert.SelfSigned</code>.
     * </p>
     * \endhtmlonly
     */
    ConnectionStatusReasonCertSelfSigned = 12,

    /**
     * \htmlonly
     * <p>There was some other error validating the server's SSL
     *   certificate.</p>
     * 
     * <p>When disconnected for this reason, the equivalent D-Bus error is
     *   <code>org.freedesktop.Telepathy.Error.Cert.Invalid</code>.
     * </p>
     * \endhtmlonly
     */
    ConnectionStatusReasonCertOtherError = 13,

    /**
     * \htmlonly
     * <p>The server's SSL certificate has been revoked.</p>
     * 
     * <p>When disconnected for this reason, the equivalent D-Bus error is
     *   <code>org.freedesktop.Telepathy.Error.Cert.Revoked</code>.
     * </p>
     * \endhtmlonly
     */
    ConnectionStatusReasonCertRevoked = 14,

    /**
     * \htmlonly
     *           <p>The server's SSL certificate uses an insecure algorithm,
     * 	  or is cryptographically weak.</p>
     * 
     *           <p>When disconnected for this reason, the equivalent D-Bus error is
     *             <code>org.freedesktop.Telepathy.Error.Cert.Insecure</code>.
     *           </p>
     * \endhtmlonly
     */
    ConnectionStatusReasonCertInsecure = 15,

    /**
     * \htmlonly
     * 	  <p>The length in bytes of the server certificate, or the depth of the
     * 	  sever certificate chain exceed the limits imposed by the crypto
     * 	  library.</p>
     * 
     * 	  <p>When disconnected for this reason, the equivalent D-Bus error is
     * 	    <code>org.freedesktop.Telepathy.Error.Cert.LimitExceeded</code>
     * 	  </p>
     * 	
     * \endhtmlonly
     */
    ConnectionStatusReasonCertLimitExceeded = 16,

    _ConnectionStatusReasonPadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of ConnectionStatusReason.
 */
const int NUM_CONNECTION_STATUS_REASONS = (16+1);

/**
 * \enum ContactListState
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 * 
 * The progress made in retrieving the contact list.
 */
enum ContactListState
{
    /**
     * The connection has not started to retrieve the contact list. If 
     * GetContactListAttributes is called in this state, it will raise NotYet.
     */
    ContactListStateNone = 0,

    /**
     * The connection has started to retrieve the contact list, but has not 
     * yet succeeded or failed. If GetContactListAttributes is called in this 
     * state, it will raise NotYet.
     */
    ContactListStateWaiting = 1,

    /**
     * The connection has tried and failed to retrieve the contact list. If 
     * GetContactListAttributes is called in this state, it will immediately 
     * raise an error indicating the reason for failure. The connection 
     * manager SHOULD try again to obtain the contact list, if appropriate for 
     * the protocol. If it succeeds later, the ContactListState MUST advance 
     * to Success.
     */
    ContactListStateFailure = 2,

    /**
     * The connection has successfully retrieved the contact list. If 
     * GetContactListAttributes is called in this state, it will return 
     * successfully.
     */
    ContactListStateSuccess = 3,

    _ContactListStatePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of ContactListState.
 */
const int NUM_CONTACT_LIST_STATES = (3+1);

/**
 * \enum SubscriptionState
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 * 
 * \htmlonly
 * <p>An enumeration indicating whether presence subscription is denied,
 *   denied but pending permission, or allowed. The exact semantics
 *   vary according to where this type is used: see the
 *   <tp:token-ref>subscribe</tp:token-ref> and
 *   <tp:token-ref>publish</tp:token-ref> contact attributes for
 *   details.</p>
 * \endhtmlonly
 */
enum SubscriptionState
{
    /**
     * The presence subscription state is unknown.
     */
    SubscriptionStateUnknown = 0,

    /**
     * Presence information cannot be seen, and either the subscription state 
     * Removed_Remotely does not apply, or it is not known whether that state 
     * applies.
     */
    SubscriptionStateNo = 1,

    /**
     * Presence information cannot be seen because the remote contact took 
     * action: either the local user&apos;s request to see the remote 
     * contact&apos;s presence was denied, or the remote contact requested to 
     * see the local user&apos;s presence but then cancelled their request.
     */
    SubscriptionStateRemovedRemotely = 2,

    /**
     * Presence information cannot be seen. Permission to see presence 
     * information has been requested, and the request has not yet been 
     * declined or accepted.
     */
    SubscriptionStateAsk = 3,

    /**
     * Presence information can be seen.
     */
    SubscriptionStateYes = 4,

    _SubscriptionStatePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of SubscriptionState.
 */
const int NUM_SUBSCRIPTION_STATES = (4+1);

/**
 * \enum ContactMetadataStorageType
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 * 
 * \htmlonly
 * <p>Values of this enumeration indicate the extent to which metadata
 *   such as aliases and group memberships can be stored for the contacts
 *   on a particular connection.</p>
 * 
 * <p>On some protocols, certain metadata (for instance, contact aliases)
 *   can only be stored for contacts on the contact list, or contacts
 *   with a particular contact list state.</p>
 * 
 * <p>To make it easier to deal with such protocols, if clients set
 *   metadata on a contact who is not in the required state, the
 *   Connection MUST cache the metadata for the duration of the session.
 *   If clients request the attributes of that contact after the
 *   appropriate &quot;set&quot; method has returned successfully, the Connection
 *   MUST return the new (cached) value.</p>
 * 
 * <p>If the contact is later placed in the required state to store
 *   metadata (for instance, if subscription to the contact's presence
 *   is requested, on a protocol like MSN where the alias has storage type
 *   Subscribed_Or_Pending), the connection MUST store the cached
 *   metadata at that time.</p>
 * 
 * <div class="rationale">
 *   <p>If the Connection didn't cache changes in this way, a client
 *     intending to change the alias on MSN would have to wait until
 *     the server acknowledged the subscription request; in the meantime,
 *     other clients would still display the old alias.</p>
 * </div>
 * 
 * <p>The only exception to that general rule is that if the Connection
 *   cannot store particular metadata at all (i.e. the
 *   storage type is None), it MUST reject attempts to set it.</p>
 * 
 * <div class="rationale">
 *   <p>If the implementation knows that metadata can't be stored at
 *     all, it's useful to report that, which can be done
 *     synchronously. In general, user interfaces should detect
 *     storage type None and not display editing controls at all.</p>
 * </div>
 * \endhtmlonly
 */
enum ContactMetadataStorageType
{
    /**
     * \htmlonly
     * <p>This connection cannot store this type of metadata at all, and
     *   attempting to do so will fail with NotImplemented.</p>
     * 
     * <div class="rationale">
     *   <p>Link-local XMPP can't store aliases or group memberships at
     *     all, and subscription and presence states are implicit (all
     *     contacts on the local network have subscribe = publish = Yes
     *     and no other contacts exist).</p>
     * 
     *   <p>As of April 2010, the XMPP server for Facebook Chat provides a
     *     read-only view of the user's Facebook contacts, so it could also
     *     usefully have this storage type.</p>
     * </div>
     * \endhtmlonly
     */
    ContactMetadataStorageTypeNone = 0,

    /**
     * \htmlonly
     * <p>This type of metadata can only be stored permanently for contacts
     *   whose subscribe attribute is Ask or Yes.</p>
     * 
     * <div class="rationale">
     *   <p>Contact aliases and groups on MSN have this behaviour.</p>
     * </div>
     * \endhtmlonly
     */
    ContactMetadataStorageTypeSubscribedOrPending = 1,

    /**
     * \htmlonly
     * <p>This type of metadata can only be stored permanently for contacts
     *   whose subscribe attribute is Yes.</p>
     * 
     * <div class="rationale">
     *   <p>No service with this behaviour is currently known, but it's a
     *     stricter form of Subscribed_Or_Pending.</p>
     * </div>
     * \endhtmlonly
     */
    ContactMetadataStorageTypeSubscribed = 2,

    /**
     * \htmlonly
     * <p>The user can set this metadata for any valid contact identifier,
     *   whether or not they have any presence subscription relationship
     *   to it, and it will be stored on their contact list.</p>
     * 
     * <div class="rationale">
     *   <p>Contact aliases and groups on XMPP have this behaviour; it
     *     is possible to put a contact in a group, or assign an alias
     *     to them, without requesting that presence be shared.</p>
     * </div>
     * \endhtmlonly
     */
    ContactMetadataStorageTypeAnyone = 3,

    _ContactMetadataStorageTypePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of ContactMetadataStorageType.
 */
const int NUM_CONTACT_METADATA_STORAGE_TYPES = (3+1);

/**
 * \enum HTTPMethod
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 * 
 * The HTTP Method with which to request a URL.
 */
enum HTTPMethod
{
    /**
     * Use the GET method when opening the URL.
     */
    HTTPMethodGet = 0,

    /**
     * Use the POST method when opening the URL. Refer to HTTP_Post_Data for 
     * more details.
     */
    HTTPMethodPost = 1,

    _HTTPMethodPadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of HTTPMethod.
 */
const int NUM_HTTP_METHODS = (1+1);

/**
 * \enum ServicePointType
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 * 
 * The various types of service points a channel might connect to.
 */
enum ServicePointType
{
    /**
     * The channel is not communicating with a service point, or it is not 
     * known whether it is communicating with a service point (e.g. an 
     * ordinary call).
     */
    ServicePointTypeNone = 0,

    /**
     * The service point is a generic emergency point.
     */
    ServicePointTypeEmergency = 1,

    /**
     * The service point is some kind of counseling service (ie, mental health 
     * or child-services counseling).
     */
    ServicePointTypeCounseling = 2,

    _ServicePointTypePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of ServicePointType.
 */
const int NUM_SERVICE_POINT_TYPES = (2+1);

/**
 * \enum ConnectionPresenceType
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 */
enum ConnectionPresenceType
{
    /**
     * An invalid presence type used as a null value. This value MUST NOT 
     * appear in the Statuses property, or in the result of GetStatuses on the 
     * deprecated Presence interface.
     */
    ConnectionPresenceTypeUnset = 0,

    /**
     * Offline
     */
    ConnectionPresenceTypeOffline = 1,

    /**
     * Available
     */
    ConnectionPresenceTypeAvailable = 2,

    /**
     * Away
     */
    ConnectionPresenceTypeAway = 3,

    /**
     * Away for an extended time
     */
    ConnectionPresenceTypeExtendedAway = 4,

    /**
     * Hidden (invisible)
     */
    ConnectionPresenceTypeHidden = 5,

    /**
     * Busy, Do Not Disturb.
     */
    ConnectionPresenceTypeBusy = 6,

    /**
     * Unknown, unable to determine presence for this contact, for example if 
     * the protocol only allows presence of subscribed contacts.
     */
    ConnectionPresenceTypeUnknown = 7,

    /**
     * Error, an error occurred while trying to determine presence. The 
     * message, if set, is an error from the server.
     */
    ConnectionPresenceTypeError = 8,

    _ConnectionPresenceTypePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of ConnectionPresenceType.
 */
const int NUM_CONNECTION_PRESENCE_TYPES = (8+1);

/**
 * \enum AccessControlType
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 * 
 * \htmlonly
 * <p>A type for communication access control. These control
 *   policies are used in
 *    \endhtmlonly org.freedesktop.Telepathy.Connection.Interface.CommunicationPolicy.DRAFT \htmlonly 
 *   as well as most rich presence interfaces.</p>
 * 
 * <p>New interfaces should use this type, and NOT
 *   <tp:type>Rich_Presence_Access_Control_Type</tp:type>.</p>
 * \endhtmlonly
 */
enum AccessControlType
{
    /**
     * \htmlonly
     * <p>Only allow contacts that are in a certain whitelist.</p>
     * 
     * <p>The associated variant
     *   in <tp:type>Access_Control</tp:type> is a list of
     *   <tp:type>Contact_Handle</tp:type> representing
     *   the whitelist, with signature <code>au</code>.</p>
     * \endhtmlonly
     */
    AccessControlTypeWhitelist = 0,

    /**
     * Allow contacts in the user&apos;s &apos;publish&apos; list. The 
     * associated variant in Access_Control is ignored.
     */
    AccessControlTypePublishList = 1,

    /**
     * \htmlonly
     * <p>Only allow contacts that are in a certain group.</p>
     * 
     * <p>The associated variant in <tp:type>Access_Control</tp:type> is a
     *   <tp:type>Group_Handle</tp:type> representing the permitted
     *   group.</p>
     * \endhtmlonly
     */
    AccessControlTypeGroup = 2,

    /**
     * Allow all contacts. The associated variant in Access_Control is ignored.
     */
    AccessControlTypeOpen = 3,

    /**
     * Allow all contacts in the user&apos;s &apos;subscribe&apos; or 
     * &apos;publish&apos; list. The associated variant in Access_Control is 
     * ignored.
     */
    AccessControlTypeSubscribeOrPublishList = 4,

    /**
     * Forbid all contacts. The associated variant in Access_Control is 
     * ignored.
     */
    AccessControlTypeClosed = 5,

    /**
     * \htmlonly
     * <p>The access control rule is too complex to be represented
     *   in the current Telepathy API. The associated variant is
     *   meaningless. Setting this mode is never valid; the
     *   connection manager MUST raise an error if this is attempted.</p>
     * 
     * <div class="rationale">
     *   XEP-0016 Privacy Lists can easily produce access control
     *   mechanisms that can't be expressed in a simpler API. We
     *   need to be able to at least indicate that fact.
     * </div>
     * 
     * <p>The associated variant in <tp:type>Access_Control</tp:type> is
     *   ignored.</p>
     * \endhtmlonly
     */
    AccessControlTypeNotUnderstood = 6,

    _AccessControlTypePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of AccessControlType.
 */
const int NUM_ACCESS_CONTROL_TYPES = (6+1);

/**
 * \enum RichPresenceAccessControlType
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 * 
 * \htmlonly
 * <p>A type of access control for Rich_Presence_Access_Control.
 *   For most types, the exact access control is given by an associated
 *   variant.</p>
 * 
 * <div class="rationale">
 *   <p>These are the access control types from XMPP publish/subscribe
 *   (XEP-0060).</p>
 * </div>
 * 
 * <p> \endhtmlonly ConnectionInterfaceLocationInterface \htmlonly 
 *   uses this for historical reasons, new interfaces will use
 *   <tp:type>Access_Control_Type</tp:type>.</p>
 * \endhtmlonly
 */
enum RichPresenceAccessControlType
{
    /**
     * The associated variant is a list of contacts (signature &apos;au&apos;, 
     * Contact_Handle[]) who can see the extended presence information.
     */
    RichPresenceAccessControlTypeWhitelist = 0,

    /**
     * All contacts in the user&apos;s &apos;publish&apos; contact list can 
     * see the extended presence information. The associated variant is 
     * ignored.
     */
    RichPresenceAccessControlTypePublishList = 1,

    /**
     * The associated variant is a handle of type Group (signature 
     * &apos;u&apos;, Group_Handle) representing a group of contacts who can 
     * see the extended presence information.
     */
    RichPresenceAccessControlTypeGroup = 2,

    /**
     * Anyone with access to the service can see the extended presence 
     * information.
     */
    RichPresenceAccessControlTypeOpen = 3,

    _RichPresenceAccessControlTypePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of RichPresenceAccessControlType.
 */
const int NUM_RICH_PRESENCE_ACCESS_CONTROL_TYPES = (3+1);

/**
 * \enum CallState
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 * 
 * \htmlonly
 * <p>The state of a call, as a whole.</p>
 * 
 * <p>The allowed transitions are:</p>
 * 
 * <ul>
 *   <li>Pending_Initiator → Initialising (for outgoing calls,
 *     when  \endhtmlonly Accept() \htmlonly  is called)</li>
 *   <li>Initialising → Initialised (for outgoing calls, when
 *     the remote client indicates that the user has been notified about
 *     the call. If the network is known not to provide feedback about whether
 *     the remote side is ringing, then the call should immediately be
 *     set to Ringing.</li>
 *   <li>Initialising → Initialised (for incoming calls, when e.g. the
 *     implementation has been initialised far enough that it is sensible
 *     to notify the user about the call (to reduce the probability that
 *     the user will pick up the call and have it immediately fail).
 *     The UI should then alert the user about the call, and call
 *      \endhtmlonly SetRinging() \htmlonly )</li>
 *   <li>Initialised → Accepted (for outgoing calls to a contact,
 *     when the remote contact accepts the call; for incoming calls, when
 *      \endhtmlonly Accept() \htmlonly  is called.)</li>
 *   <li>Accepted → Active (when the local user successfully
 *     joins the call/conference, and media is known to be flowing
 *     successfully; also, when temporary connection problems are
 *     resolved (See below)). If the network is known not to provide
 *     feedback about when the call is properly connected, the call
 *     should immediately be set to Active.</li>
 *   <li>Active → Accepted (when there are temporary connection problems
 *     that the CM is aware of and able to recover from)</li>
 *   <li>any state → Ended (when the call is terminated
 *     normally, or when an error occurs that the CM is unable to recover
 *     from)</li>
 * </ul>
 * 
 * <p>Clients MAY consider unknown values from this enum to be an
 *   error - additional values will not be defined after the Call
 *   specification is declared to be stable.</p>
 * \endhtmlonly
 */
enum CallState
{
    /**
     * The call state is not known. This call state MUST NOT appear as a value 
     * of the CallState property, but MAY be used by client code to represent 
     * calls whose state is as yet unknown.
     */
    CallStateUnknown = 0,

    /**
     * The initiator of the call hasn&apos;t accepted the call yet. This state 
     * only makes sense for outgoing calls, where it means that the local user 
     * has not yet sent any signalling messages to the remote user(s), and 
     * will not do so until Accept is called.
     */
    CallStatePendingInitiator = 1,

    /**
     * Progress has been made in placing the call, but the contact has not 
     * been made aware of the call yet. This corresponds to SIP&apos;s status 
     * code 183 Session Progress, and should be used for the period where the 
     * CM is waiting for the streaming implementation to initialise (before 
     * sending the initial INVITE or equivalent) and when the outgoing call 
     * has reached a gateway or ICE negotiation is pending. UIs should not 
     * produce a dialtone or start ringing if the call is in this state.
     */
    CallStateInitialising = 2,

    /**
     * In the outgoing case: at least one called user has been alerted about 
     * the call (a SIP 180 (Ringing) packet or equivalent has been received) 
     * but none have answered, so the call cannot go to Accepted (use Ringing 
     * to determine which members have been informed and which haven&apos;t, 
     * if you care). UIs SHOULD produce a dialtone for outgoing calls in this 
     * state. In the incoming case, the local user should be informed of the 
     * call as soon as the call reaches this state (and SetRinging should be 
     * called to inform the CM that this has happened, so that it can relay 
     * this fact to the caller using a SIP 180 (Ringing) packet or equivalent).
     */
    CallStateInitialised = 3,

    /**
     * The contact being called has accepted the call, but the call is not in 
     * the Active state (The most common reason for this is that the streaming 
     * implementation hasn&apos;t connected yet).
     */
    CallStateAccepted = 4,

    /**
     * The contact being called has accepted the call, and discourse between 
     * at least two parties should now be possible.
     */
    CallStateActive = 5,

    /**
     * The call has ended, either via normal termination or an error.
     */
    CallStateEnded = 6,

    _CallStatePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of CallState.
 */
const int NUM_CALL_STATES = (6+1);

/**
 * \enum CallStateChangeReason
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 * 
 * A simple representation of the reason for a change in the call&apos;s 
 * state, which may be used by simple clients, or used as a fallback when the 
 * DBus_Reason member of a Call_State_Reason struct is not understood.
 */
enum CallStateChangeReason
{
    /**
     * \htmlonly
     * We just don't know. Unknown values of this enum SHOULD also be
     * treated like this.
     * \endhtmlonly
     */
    CallStateChangeReasonUnknown = 0,

    /**
     * \htmlonly
     * Situation normal. Progress has been made in the setup/teardown of
     * the call (and it didn't require any user interaction).
     * \endhtmlonly
     */
    CallStateChangeReasonProgressMade = 1,

    /**
     * \htmlonly
     * <p>The change was requested by the contact indicated by the Actor
     *   member of a <tp:type>Call_State_Reason</tp:type> struct.</p>
     * 
     * <p>If the Actor is the local user, the DBus_Reason SHOULD be the
     *   empty string.</p>
     * 
     * <p>If the Actor is a remote user, the DBus_Reason SHOULD be the empty
     *   string if the call was terminated normally, but MAY be a non-empty
     *   error name to indicate error-like call termination reasons (call
     *   rejected as busy, kicked from a conference by a moderator, etc.).</p>
     * \endhtmlonly
     */
    CallStateChangeReasonUserRequested = 2,

    /**
     * \htmlonly
     * <p>The call was forwarded. If known, the handle of the
     * contact the call was forwarded to will be indicated by the
     * &quot;forwarded-to&quot; member of a
     *  \endhtmlonly \link requestPropertyCallStateDetails() CallStateDetails \endlink \htmlonly  dictionnary
     * in the  \endhtmlonly CallStateChanged() \htmlonly 
     * signal.</p>
     * \endhtmlonly
     */
    CallStateChangeReasonForwarded = 3,

    /**
     * \htmlonly
     * <p>The  \endhtmlonly \link requestPropertyCallState() CallState \endlink \htmlonly  changed from
     *   <tp:value-ref type="Call_State">Initialised</tp:value-ref> or
     *   <tp:value-ref type="Call_State">Ended</tp:value-ref> (or a content's direction
     *   changed) because it was rejected by the remote user.</p>
     * <p>Corresponds to <tp:error-ref>Rejected</tp:error-ref></p>
     * \endhtmlonly
     */
    CallStateChangeReasonRejected = 4,

    /**
     * \htmlonly
     * <p>The  \endhtmlonly \link requestPropertyCallState() CallState \endlink \htmlonly  changed from
     *   <tp:value-ref type="Call_State">Initialised</tp:value-ref> or
     *   <tp:value-ref type="Call_State">Ended</tp:value-ref> because the initiator
     *   ended the call before the receiver accepted it. With an
     *   incoming call this state change reason signifies a missed
     *   call, or one that was picked up elsewhere before it was
     *   picked up here.</p>
     * <p>Corresponds to <tp:error-ref>NoAnswer</tp:error-ref> or
     *   <tp:error-ref>PickedUpElsewhere</tp:error-ref></p>
     * \endhtmlonly
     */
    CallStateChangeReasonNoAnswer = 5,

    /**
     * \htmlonly
     * <p>The  \endhtmlonly \link requestPropertyCallState() CallState \endlink \htmlonly  changed because one
     *   of the addresses does not exist on the network.</p>
     * <p>Corresponds to <tp:error-ref>DoesNotExist</tp:error-ref></p>
     * \endhtmlonly
     */
    CallStateChangeReasonInvalidContact = 6,

    /**
     * \htmlonly
     * <p>The  \endhtmlonly \link requestPropertyCallState() CallState \endlink \htmlonly  changed because the
     * local user is not authorised.</p>
     * <p>Corresponds to <tp:error-ref>PermissionDenied</tp:error-ref> or
     *   <tp:error-ref>InsufficientBalance</tp:error-ref>
     *   </p>
     * \endhtmlonly
     */
    CallStateChangeReasonPermissionDenied = 7,

    /**
     * \htmlonly
     * <p>The  \endhtmlonly \link requestPropertyCallState() CallState \endlink \htmlonly  changed from
     *   <tp:value-ref type="Call_State">Initialised</tp:value-ref>
     *   <tp:value-ref type="Call_State">Ended</tp:value-ref> because the receiver is busy
     *   (e.g. is already engaged in another call, and has not placed the
     *   initiator in a call-waiting queue).</p>
     * <p>Corresponds to <tp:error-ref>Busy</tp:error-ref></p>
     * \endhtmlonly
     */
    CallStateChangeReasonBusy = 8,

    /**
     * \htmlonly
     * <p>There has been an unexpected error in either the CM or some other
     *   local component.</p>
     * <p>Corresponds to <tp:error-ref>Confused</tp:error-ref> or
     * <tp:error-ref>Media.StreamingError</tp:error-ref>
     * </p>
     * \endhtmlonly
     */
    CallStateChangeReasonInternalError = 9,

    /**
     * \htmlonly
     * <p>There has been an unexpected error in the server or some other
     *   remote component.</p>
     * <p>Corresponds to
     *   <tp:error-ref>ServiceConfused</tp:error-ref>
     * </p>
     * \endhtmlonly
     */
    CallStateChangeReasonServiceError = 10,

    /**
     * \htmlonly
     * <p>There has been a network error related to the CM or the
     *   signalling part of the call (compare and contrast:
     *   Streaming_Error).</p>
     * <p>Corresponds to
     *   <tp:error-ref>NetworkError</tp:error-ref></p>
     * \endhtmlonly
     */
    CallStateChangeReasonNetworkError = 11,

    /**
     * \htmlonly
     * <p>Some aspect of the content is unsupported so has to be
     *   removed from the call.</p>
     * <p>Corresponds to <tp:error-ref>Media.UnsupportedType</tp:error-ref>
     *   or <tp:error-ref>Media.CodecsIncompatible</tp:error-ref>
     * </p>
     * \endhtmlonly
     */
    CallStateChangeReasonMediaError = 12,

    /**
     * It was not possible for the streaming implementation to connect to any 
     * of the users participating in this call or content. Corresponds to 
     * ConnectionFailed or ConnectionLost
     */
    CallStateChangeReasonConnectivityError = 13,

    _CallStateChangeReasonPadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of CallStateChangeReason.
 */
const int NUM_CALL_STATE_CHANGE_REASONS = (13+1);

/**
 * \enum ChannelContactSearchState
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 */
enum ChannelContactSearchState
{
    /**
     * The search has not started
     */
    ChannelContactSearchStateNotStarted = 0,

    /**
     * The search is in progress
     */
    ChannelContactSearchStateInProgress = 1,

    /**
     * The search has paused, but more results can be retrieved by calling 
     * More.
     */
    ChannelContactSearchStateMoreAvailable = 2,

    /**
     * The search has been completed
     */
    ChannelContactSearchStateCompleted = 3,

    /**
     * The search has failed
     */
    ChannelContactSearchStateFailed = 4,

    _ChannelContactSearchStatePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of ChannelContactSearchState.
 */
const int NUM_CHANNEL_CONTACT_SEARCH_STATES = (4+1);

/**
 * \enum FileTransferState
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 */
enum FileTransferState
{
    /**
     * An invalid state type used as a null value. This value MUST NOT appear 
     * in the State property.
     */
    FileTransferStateNone = 0,

    /**
     * The file transfer is waiting to be accepted/closed by the receiver. The 
     * receiver has to call AcceptFile, then wait for the state to change to 
     * Open and check the offset value.
     */
    FileTransferStatePending = 1,

    /**
     * The receiver has accepted the transfer. The sender now has to call 
     * ProvideFile to actually start the transfer. The receiver should now 
     * wait for the state to change to Open and check the offset value.
     */
    FileTransferStateAccepted = 2,

    /**
     * The file transfer is open for traffic.
     */
    FileTransferStateOpen = 3,

    /**
     * The file transfer has been completed successfully.
     */
    FileTransferStateCompleted = 4,

    /**
     * The file transfer has been cancelled.
     */
    FileTransferStateCancelled = 5,

    _FileTransferStatePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of FileTransferState.
 */
const int NUM_FILE_TRANSFER_STATES = (5+1);

/**
 * \enum FileTransferStateChangeReason
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 */
enum FileTransferStateChangeReason
{
    /**
     * No reason was specified.
     */
    FileTransferStateChangeReasonNone = 0,

    /**
     * The change in state was requested.
     */
    FileTransferStateChangeReasonRequested = 1,

    /**
     * The file transfer was cancelled by the local user.
     */
    FileTransferStateChangeReasonLocalStopped = 2,

    /**
     * The file transfer was cancelled by the remote user.
     */
    FileTransferStateChangeReasonRemoteStopped = 3,

    /**
     * The file transfer was cancelled because of a local error.
     */
    FileTransferStateChangeReasonLocalError = 4,

    /**
     * The file transfer was cancelled because of a remote error.
     */
    FileTransferStateChangeReasonRemoteError = 5,

    _FileTransferStateChangeReasonPadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of FileTransferStateChangeReason.
 */
const int NUM_FILE_TRANSFER_STATE_CHANGE_REASONS = (5+1);

/**
 * \enum FileHashType
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 */
enum FileHashType
{
    /**
     * No hash.
     */
    FileHashTypeNone = 0,

    /**
     * MD5 digest as a string of 32 ASCII hex digits.
     */
    FileHashTypeMD5 = 1,

    /**
     * SHA1 digest as a string of ASCII hex digits.
     */
    FileHashTypeSHA1 = 2,

    /**
     * SHA256 digest as a string of ASCII hex digits.
     */
    FileHashTypeSHA256 = 3,

    _FileHashTypePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of FileHashType.
 */
const int NUM_FILE_HASH_TYPES = (3+1);

/**
 * \enum MediaStreamType
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 */
enum MediaStreamType
{
    /**
     * An audio stream
     */
    MediaStreamTypeAudio = 0,

    /**
     * A video stream
     */
    MediaStreamTypeVideo = 1,

    _MediaStreamTypePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of MediaStreamType.
 */
const int NUM_MEDIA_STREAM_TYPES = (1+1);

/**
 * \enum MediaStreamState
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 */
enum MediaStreamState
{
    /**
     * The stream is disconnected.
     */
    MediaStreamStateDisconnected = 0,

    /**
     * The stream is trying to connect.
     */
    MediaStreamStateConnecting = 1,

    /**
     * The stream is connected.
     */
    MediaStreamStateConnected = 2,

    _MediaStreamStatePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of MediaStreamState.
 */
const int NUM_MEDIA_STREAM_STATES = (2+1);

/**
 * \enum MediaStreamDirection
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 */
enum MediaStreamDirection
{
    /**
     * Media are not being sent or received
     */
    MediaStreamDirectionNone = 0,

    /**
     * Media are being sent, but not received
     */
    MediaStreamDirectionSend = 1,

    /**
     * Media are being received, but not sent
     */
    MediaStreamDirectionReceive = 2,

    /**
     * Media are being sent and received
     */
    MediaStreamDirectionBidirectional = 3,

    _MediaStreamDirectionPadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of MediaStreamDirection.
 */
const int NUM_MEDIA_STREAM_DIRECTIONS = (3+1);

/**
 * \enum ChannelTextSendError
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 */
enum ChannelTextSendError
{
    /**
     * An unknown error occurred
     */
    ChannelTextSendErrorUnknown = 0,

    /**
     * The requested contact was offline
     */
    ChannelTextSendErrorOffline = 1,

    /**
     * The requested contact is not valid
     */
    ChannelTextSendErrorInvalidContact = 2,

    /**
     * The user does not have permission to speak on this channel
     */
    ChannelTextSendErrorPermissionDenied = 3,

    /**
     * The outgoing message was too long and was rejected by the server
     */
    ChannelTextSendErrorTooLong = 4,

    /**
     * The channel doesn&apos;t support sending text messages to the requested 
     * contact
     */
    ChannelTextSendErrorNotImplemented = 5,

    _ChannelTextSendErrorPadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of ChannelTextSendError.
 */
const int NUM_CHANNEL_TEXT_SEND_ERRORS = (5+1);

/**
 * \enum ChannelTextMessageType
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 * 
 * The type of message.
 */
enum ChannelTextMessageType
{
    /**
     * An ordinary chat message. Unknown types SHOULD be treated like this.
     */
    ChannelTextMessageTypeNormal = 0,

    /**
     * An action which might be presented to the user as &quot;* 
     * &lt;sender&gt; &lt;action&gt;&quot;, such as an IRC CTCP ACTION 
     * (typically selected by the &quot;/me&quot; command). For example, the 
     * text of the message might be &quot;drinks more coffee&quot;.
     */
    ChannelTextMessageTypeAction = 1,

    /**
     * A one-off or automated message not necessarily expecting a reply
     */
    ChannelTextMessageTypeNotice = 2,

    /**
     * An automatically-generated reply message.
     */
    ChannelTextMessageTypeAutoReply = 3,

    /**
     * A delivery report. This message type MUST NOT appear unless the channel 
     * supports the Messages interface; see Message_Part for the format that 
     * delivery reports must take.
     */
    ChannelTextMessageTypeDeliveryReport = 4,

    _ChannelTextMessageTypePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of ChannelTextMessageType.
 */
const int NUM_CHANNEL_TEXT_MESSAGE_TYPES = (4+1);

/**
 * \enum TubeType
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 */
enum TubeType
{
    /**
     * \htmlonly
     * <p>The tube is D-Bus tube as described by the
     *   org.freedesktop.Telepathy.Channel.Type.DBusTube interface.</p>
     * \endhtmlonly
     */
    TubeTypeDBus = 0,

    /**
     * \htmlonly
     * <p>The tube is stream tube as described by the
     *   org.freedesktop.Telepathy.Channel.Type.StreamTube interface.</p>
     * \endhtmlonly
     */
    TubeTypeStream = 1,

    _TubeTypePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of TubeType.
 */
const int NUM_TUBE_TYPES = (1+1);

/**
 * \enum TubeState
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 */
enum TubeState
{
    /**
     * The tube is waiting to be accepted/closed locally.
     */
    TubeStateLocalPending = 0,

    /**
     * The tube is waiting to be accepted/closed remotely.
     */
    TubeStateRemotePending = 1,

    /**
     * The tube is open for traffic.
     */
    TubeStateOpen = 2,

    _TubeStatePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of TubeState.
 */
const int NUM_TUBE_STATES = (2+1);

/**
 * \enum CaptchaCancelReason
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 * 
 * \htmlonly
 * <p>A reason why captcha authentication was aborted by the client.</p>
 * \endhtmlonly
 */
enum CaptchaCancelReason
{
    /**
     * The user aborted the authentication. If this is used, the CaptchaError 
     * SHOULD be set to Cancelled
     */
    CaptchaCancelReasonUserCancelled = 0,

    /**
     * The Handler doesn&apos;t support the given/required captcha types. If 
     * this is used, the CaptchaError SHOULD be set to CaptchaNotSupported. 
     * This SHOULD also be used if Close is called before CancelCaptcha. If no 
     * Handler supports captcha channels, the ChannelDispatcher will just call 
     * Close, because it has no knowledge of specific channel types.
     */
    CaptchaCancelReasonNotSupported = 1,

    /**
     * The Handler doesn&apos;t understand the captcha data received. The 
     * challenger may be sending gibberish. If this is used, the CaptchaError 
     * SHOULD be set to ServiceConfused.
     */
    CaptchaCancelReasonServiceConfused = 2,

    _CaptchaCancelReasonPadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of CaptchaCancelReason.
 */
const int NUM_CAPTCHA_CANCEL_REASONS = (2+1);

/**
 * \enum CaptchaStatus
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 */
enum CaptchaStatus
{
    /**
     * The challenge/response exchange is in progress and waiting for a local 
     * action. Call AnswerCaptchas to go to the Remote_Pending state, or call 
     * CancelCaptcha followed by Close to give up.
     */
    CaptchaStatusLocalPending = 0,

    /**
     * The challenge/response exchange is in progress and waiting for a 
     * response from the server. Wait for a reply from the server, which will 
     * result in the Succeeded, Try_Again, or Failed state, or call 
     * CancelCaptcha followed by Close to give up.
     */
    CaptchaStatusRemotePending = 1,

    /**
     * Everyone is happy. Connection to the server will proceed as soon as 
     * this state is reached. There is nothing useful to do in this state 
     * except to call Close to close the channel.
     */
    CaptchaStatusSucceeded = 2,

    /**
     * The server has indicated an authentication failure. Call GetCaptchas 
     * again to get a new captcha, or CancelCaptcha followed by Close to give 
     * up.
     */
    CaptchaStatusTryAgain = 3,

    /**
     * Authentication has failed in some way. There is nothing useful to do in 
     * this state except to close the channel with Close.
     */
    CaptchaStatusFailed = 4,

    _CaptchaStatusPadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of CaptchaStatus.
 */
const int NUM_CAPTCHA_STATUSES = (4+1);

/**
 * \enum ChannelChatState
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 */
enum ChannelChatState
{
    /**
     * The contact has effectively ceased participating in the chat.
     */
    ChannelChatStateGone = 0,

    /**
     * The contact has not been active for some time.
     */
    ChannelChatStateInactive = 1,

    /**
     * The contact is actively participating in the chat.
     */
    ChannelChatStateActive = 2,

    /**
     * The contact has paused composing a message.
     */
    ChannelChatStatePaused = 3,

    /**
     * The contact is composing a message to be sent to the chat.
     */
    ChannelChatStateComposing = 4,

    _ChannelChatStatePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of ChannelChatState.
 */
const int NUM_CHANNEL_CHAT_STATES = (4+1);

/**
 * \enum DTMFEvent
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 */
enum DTMFEvent
{
    /**
     * 0
     */
    DTMFEventDigit0 = 0,

    /**
     * 1
     */
    DTMFEventDigit1 = 1,

    /**
     * 2
     */
    DTMFEventDigit2 = 2,

    /**
     * 3
     */
    DTMFEventDigit3 = 3,

    /**
     * 4
     */
    DTMFEventDigit4 = 4,

    /**
     * 5
     */
    DTMFEventDigit5 = 5,

    /**
     * 6
     */
    DTMFEventDigit6 = 6,

    /**
     * 7
     */
    DTMFEventDigit7 = 7,

    /**
     * 8
     */
    DTMFEventDigit8 = 8,

    /**
     * 9
     */
    DTMFEventDigit9 = 9,

    /**
     * *
     */
    DTMFEventAsterisk = 10,

    /**
     * #
     */
    DTMFEventHash = 11,

    /**
     * A
     */
    DTMFEventLetterA = 12,

    /**
     * B
     */
    DTMFEventLetterB = 13,

    /**
     * C
     */
    DTMFEventLetterC = 14,

    /**
     * D
     */
    DTMFEventLetterD = 15,

    _DTMFEventPadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of DTMFEvent.
 */
const int NUM_DTMF_EVENTS = (15+1);

/**
 * \enum ChannelGroupChangeReason
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 * 
 * \htmlonly
 * <p>The reason for a set of handles to move to one of
 *    \endhtmlonly \link requestPropertyMembers() Members \endlink \htmlonly ,
 *    \endhtmlonly \link requestPropertyLocalPendingMembers() LocalPendingMembers \endlink \htmlonly  or
 *    \endhtmlonly \link requestPropertyRemotePendingMembers() RemotePendingMembers \endlink \htmlonly , or to be removed
 *   from the group. A client may supply a reason when attempting to
 *   remove members from a group with
 *    \endhtmlonly RemoveMembersWithReason() \htmlonly , and reasons
 *   are supplied by the CM when emitting
 *    \endhtmlonly MembersChanged() \htmlonly  and
 *    \endhtmlonly MembersChangedDetailed() \htmlonly . Some reason
 *   codes have different meanings depending on the <var>Actor</var> in a
 *   MembersChanged signal.</p>
 * \endhtmlonly
 */
enum ChannelGroupChangeReason
{
    /**
     * \htmlonly
     * <p>No reason was provided for this change.</p>
     * 
     * <p>In particular, this reason SHOULD be used when representing
     *   users joining a named chatroom in the usual way, users leaving
     *   a chatroom by their own request, and normal termination of a
     *   StreamedMedia call by the remote user.</p>
     * 
     * <p>If the  \endhtmlonly \link requestPropertySelfHandle() SelfHandle \endlink \htmlonly  is removed from
     *   a group for this reason and the actor is not the SelfHandle, the
     *   equivalent D-Bus error is
     *   <code>org.freedesktop.Telepathy.Error.Terminated</code>.</p>
     * 
     * <p>If the SelfHandle is removed from a group for this reason and
     *   the actor is also the SelfHandle, the equivalent D-Bus error is
     *   <code>org.freedesktop.Telepathy.Error.Cancelled</code>.</p>
     * \endhtmlonly
     */
    ChannelGroupChangeReasonNone = 0,

    /**
     * \htmlonly
     * <p>The change is due to a user going offline. Also used when
     *   user is already offline, but this wasn't known previously.</p>
     * 
     * <p>If a one-to-one  \endhtmlonly ChannelTypeStreamedMediaInterface \htmlonly 
     *   call fails because the contact being called is offline, the
     *   connection manager SHOULD indicate this by removing both the
     *    \endhtmlonly \link requestPropertySelfHandle() SelfHandle \endlink \htmlonly  and the other contact's
     *   handle from the Group interface with reason Offline.</p>
     * 
     * <div class="rationale">
     *   For 1-1 calls, the call terminates as a result of removing the
     *   remote contact, so the SelfHandle should be removed at the same
     *   time as the remote contact and for the same reason.
     * </div>
     * 
     * <p>If a handle is removed from a group for this reason, the
     *   equivalent D-Bus error is
     *   <code>org.freedesktop.Telepathy.Error.Offline</code>.</p>
     * \endhtmlonly
     */
    ChannelGroupChangeReasonOffline = 1,

    /**
     * \htmlonly
     * <p>The change is due to a kick operation.</p>
     * 
     * <p>If the  \endhtmlonly \link requestPropertySelfHandle() SelfHandle \endlink \htmlonly  is removed
     *   from a group for this reason, the equivalent D-Bus error is
     *   <code>org.freedesktop.Telepathy.Error.Channel.Kicked</code>.
     * </p>
     * \endhtmlonly
     */
    ChannelGroupChangeReasonKicked = 2,

    /**
     * \htmlonly
     * <p>The change is due to a busy indication.</p>
     * 
     * <p>If a one-to-one  \endhtmlonly ChannelTypeStreamedMediaInterface \htmlonly 
     *   call fails because the contact being called is busy, the
     *   connection manager SHOULD indicate this by removing both the
     *    \endhtmlonly \link requestPropertySelfHandle() SelfHandle \endlink \htmlonly  and the other contact's
     *   handle from the Group interface with reason Busy.</p>
     * 
     * <div class="rationale">
     *   For 1-1 calls, the call terminates as a result of removing the
     *   remote contact, so the SelfHandle should be removed at the same
     *   time as the remote contact and for the same reason.
     * </div>
     * 
     * <p>If the  \endhtmlonly \link requestPropertySelfHandle() SelfHandle \endlink \htmlonly  is removed
     *   from a group for this reason, the equivalent D-Bus error is
     *   <code>org.freedesktop.Telepathy.Error.Busy</code>.
     * </p>
     * \endhtmlonly
     */
    ChannelGroupChangeReasonBusy = 3,

    /**
     * The change is due to an invitation. This reason SHOULD only be used 
     * when contacts are added to the remote-pending set (to indicate that the 
     * contact has been invited) or to the members (to indicate that the 
     * contact has accepted the invitation). Otherwise, what would it mean?
     */
    ChannelGroupChangeReasonInvited = 4,

    /**
     * \htmlonly
     * <p>The change is due to a kick+ban operation.</p>
     * 
     * <p>If the  \endhtmlonly \link requestPropertySelfHandle() SelfHandle \endlink \htmlonly  is removed
     *   from a group for this reason, the equivalent D-Bus error is
     *   <code>org.freedesktop.Telepathy.Error.Channel.Banned</code>.
     * </p>
     * \endhtmlonly
     */
    ChannelGroupChangeReasonBanned = 5,

    /**
     * The change is due to an error occurring.
     */
    ChannelGroupChangeReasonError = 6,

    /**
     * \htmlonly
     * <p>The change is because the requested contact does not exist.</p>
     * 
     * <p>For instance, if the user invites a nonexistent contact to a
     *   chatroom or attempts to call a nonexistent contact, this could
     *   be indicated by the CM adding that contact's handle to
     *   remote-pending for reason None or Invited, then removing it for
     *   reason Invalid_Contact. In the case of a 1-1 StreamedMedia
     *   call, the CM SHOULD remove the self handle from the Group
     *   in the same signal.</p>
     * 
     * <div class="rationale">
     *   For 1-1 calls, the call terminates as a result of removing the
     *   remote contact, so the SelfHandle should be removed at the same
     *   time as the remote contact and for the same reason.
     * </div>
     * 
     * <p>If a contact is removed from a group for this reason, the
     *   equivalent D-Bus error is
     *   <code>org.freedesktop.Telepathy.Error.DoesNotExist</code>.
     * </p>
     * \endhtmlonly
     */
    ChannelGroupChangeReasonInvalidContact = 7,

    /**
     * \htmlonly
     * <p>The change is because the requested contact did not respond.</p>
     * 
     * <p>If a one-to-one  \endhtmlonly ChannelTypeStreamedMediaInterface \htmlonly 
     *   call fails because the contact being called did not respond, or the
     *   local user did not respond to an incoming call, the
     *   connection manager SHOULD indicate this by removing both the
     *    \endhtmlonly \link requestPropertySelfHandle() SelfHandle \endlink \htmlonly  and the other contact's
     *   handle from the Group interface with reason No_Answer.</p>
     * 
     * <div class="rationale">
     *   Documenting existing practice.
     * </div>
     * 
     * <p>If a contact is removed from a group for this reason, the
     *   equivalent D-Bus error is
     *   <code>org.freedesktop.Telepathy.Error.NoAnswer</code>.
     * </p>
     * \endhtmlonly
     */
    ChannelGroupChangeReasonNoAnswer = 8,

    /**
     * \htmlonly
     * <p>The change is because a contact's unique identifier changed.
     * There must be exactly one handle in the removed set and exactly
     * one handle in one of the added sets. The  \endhtmlonly org.freedesktop.Telepathy.Connection.Interface.Renaming.Renamed \htmlonly 
     * signal on the
     *  \endhtmlonly org.freedesktop.Telepathy.Connection.Interface.Renaming \htmlonly 
     * interface will have been emitted for the same handles,
     * shortly before this  \endhtmlonly MembersChanged() \htmlonly  signal is emitted.</p>
     * \endhtmlonly
     */
    ChannelGroupChangeReasonRenamed = 9,

    /**
     * \htmlonly
     * <p>The change is because there was no permission to contact the
     *   requested handle.</p>
     * 
     * <p>If a contact is removed from a group for this reason, the
     *   equivalent D-Bus error is
     *   <code>org.freedesktop.Telepathy.Error.PermissionDenied</code>.
     * </p>
     * \endhtmlonly
     */
    ChannelGroupChangeReasonPermissionDenied = 10,

    /**
     * \htmlonly
     * <p>If members are removed with this reason code, the change is
     *   because the group has split into unconnected parts which can only
     *   communicate within themselves (e.g. netsplits on IRC use this
     *   reason code).
     * </p>
     * <p>
     *   If members are added with this reason code, the change is because
     *   unconnected parts of the group have rejoined. If this channel
     *   carries messages (e.g.  \endhtmlonly ChannelTypeTextInterface \htmlonly 
     *   or  \endhtmlonly ChannelTypeTubesInterface \htmlonly 
     *   channels) applications must
     *   assume that the contacts being added are likely to have missed some
     *   messages as a result of the separation, and that the contacts
     *   in the group are likely to have missed some messages from the
     *   contacts being added.
     * </p>
     * <p>Note that from the added contacts' perspective, they have been
     *   in the group all along, and the contacts we indicate to be in
     *   the group (including the local user) have just rejoined
     *   the group with reason Separated. Application protocols in Tubes
     *   should be prepared to cope with this situation.
     * </p>
     * 
     * <p>The  \endhtmlonly \link requestPropertySelfHandle() SelfHandle \endlink \htmlonly  SHOULD NOT be
     *   removed from channels with this reason.</p>
     * \endhtmlonly
     */
    ChannelGroupChangeReasonSeparated = 11,

    _ChannelGroupChangeReasonPadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of ChannelGroupChangeReason.
 */
const int NUM_CHANNEL_GROUP_CHANGE_REASONS = (11+1);

/**
 * \enum LocalHoldState
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 * 
 * The hold state of a channel.
 */
enum LocalHoldState
{
    /**
     * All streams are unheld (the call is active). New channels SHOULD have 
     * this hold state.
     */
    LocalHoldStateUnheld = 0,

    /**
     * All streams are held (the call is on hold)
     */
    LocalHoldStateHeld = 1,

    /**
     * The connection manager is attempting to move to state Held, but has not 
     * yet completed that operation. It is unspecified whether any, all or 
     * none of the streams making up the channel are on hold. Examining the 
     * Hold state of Call Contents (if applicable) may provide more useful 
     * information.
     */
    LocalHoldStatePendingHold = 2,

    /**
     * The connection manager is attempting to move to state Unheld, but has 
     * not yet completed that operation. It is unspecified whether any, all or 
     * none of the streams making up the channel are on hold. Examining the 
     * Hold state of Call Contents (if applicable) may provide more useful 
     * information.
     */
    LocalHoldStatePendingUnhold = 3,

    _LocalHoldStatePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of LocalHoldState.
 */
const int NUM_LOCAL_HOLD_STATES = (3+1);

/**
 * \enum LocalHoldStateReason
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 * 
 * The reason for a change to the Local_Hold_State. Clients MUST treat unknown 
 * values as equivalent to Local_Hold_State_Reason_None.
 */
enum LocalHoldStateReason
{
    /**
     * The reason cannot be described by any of the predefined values 
     * (connection managers SHOULD avoid this reason, but clients MUST handle 
     * it gracefully)
     */
    LocalHoldStateReasonNone = 0,

    /**
     * The change is in response to a user request
     */
    LocalHoldStateReasonRequested = 1,

    /**
     * The change is because some resource was not available
     */
    LocalHoldStateReasonResourceNotAvailable = 2,

    _LocalHoldStateReasonPadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of LocalHoldStateReason.
 */
const int NUM_LOCAL_HOLD_STATE_REASONS = (2+1);

/**
 * \enum DeliveryStatus
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 * 
 * The status of a message as indicated by a delivery report. If this enum is 
 * extended in future specifications, this should only be to add new, 
 * non-overlapping conditions (i.e. all failures should still be signalled as 
 * either Temporarily_Failed or Permanently_Failed). If additional detail is 
 * required (e.g. distinguishing between the various types of permanent 
 * failure) this will be done using additional Delivery_Report_Header_Keys.
 */
enum DeliveryStatus
{
    /**
     * The message&apos;s disposition is unknown. Clients SHOULD consider all 
     * messages to have status Delivery_Status_Unknown unless otherwise 
     * specified; connection managers SHOULD NOT signal this delivery status 
     * explicitly.
     */
    DeliveryStatusUnknown = 0,

    /**
     * The message has been delivered to the intended recipient.
     */
    DeliveryStatusDelivered = 1,

    /**
     * Delivery of the message has failed. Clients SHOULD notify the user, but 
     * MAY automatically try sending another copy of the message. Similar to 
     * errors with type=&quot;wait&quot; in XMPP; analogous to 4xx errors in 
     * SMTP.
     */
    DeliveryStatusTemporarilyFailed = 2,

    /**
     * Delivery of the message has failed. Clients SHOULD NOT try again unless 
     * by specific user action. If the user does not modify the message or 
     * alter configuration before re-sending, this error is likely to happen 
     * again. Similar to errors with type=&quot;cancel&quot;, 
     * type=&quot;modify&quot; or type=&quot;auth&quot; in XMPP; analogous to 
     * 5xx errors in SMTP.
     */
    DeliveryStatusPermanentlyFailed = 3,

    /**
     * An intermediate server has accepted the message but the message has not 
     * been yet delivered to the ultimate recipient. The connection manager 
     * might send a Failed report or Delivered report later. Similar to 
     * &quot;202 Accepted&quot; success code in SIP; analogous to 251 and 252 
     * responses in SMTP.
     */
    DeliveryStatusAccepted = 4,

    /**
     * The message has been read by the intended recipient.
     */
    DeliveryStatusRead = 5,

    /**
     * The message has been deleted by the intended recipient. This MAY be 
     * signalled on its own if the message is deleted without being read, or 
     * after Read if the message was read before being deleted.
     */
    DeliveryStatusDeleted = 6,

    _DeliveryStatusPadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of DeliveryStatus.
 */
const int NUM_DELIVERY_STATUSES = (6+1);

/**
 * \enum SASLAbortReason
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 * 
 * \htmlonly
 * <p>A reason why SASL authentication was aborted by the client.</p>
 * \endhtmlonly
 */
enum SASLAbortReason
{
    /**
     * The server sent an invalid challenge or data.
     */
    SASLAbortReasonInvalidChallenge = 0,

    /**
     * The user aborted the authentication.
     */
    SASLAbortReasonUserAbort = 1,

    _SASLAbortReasonPadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of SASLAbortReason.
 */
const int NUM_SASL_ABORT_REASONS = (1+1);

/**
 * \enum SASLStatus
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 */
enum SASLStatus
{
    /**
     * The initial state. The Handler SHOULD either call AbortSASL, or connect 
     * to the NewChallenge signal then call StartMechanism or 
     * StartMechanismWithData.
     */
    SASLStatusNotStarted = 0,

    /**
     * The challenge/response exchange is in progress. The Handler SHOULD call 
     * either Respond or AcceptSASL exactly once per emission of NewChallenge, 
     * or call AbortSASL at any time.
     */
    SASLStatusInProgress = 1,

    /**
     * The server has indicated successful authentication, and the connection 
     * manager is waiting for confirmation from the Handler. The Handler must 
     * call either AcceptSASL or AbortSASL to indicate whether it considers 
     * authentication to have been successful.
     */
    SASLStatusServerSucceeded = 2,

    /**
     * The Handler has indicated successful authentication, and the connection 
     * manager is waiting for confirmation from the server. The state will 
     * progress to either Succeeded or Server_Failed when confirmation is 
     * received.
     */
    SASLStatusClientAccepted = 3,

    /**
     * Everyone is happy (the server sent success, and the client has called 
     * AcceptSASL). Connection to the server will proceed as soon as this 
     * state is reached. The Handler SHOULD call Close to close the channel.
     */
    SASLStatusSucceeded = 4,

    /**
     * The server has indicated an authentication failure. If CanTryAgain is 
     * true, the client may try to authenticate again, by calling 
     * StartMechanism or StartMechanismWithData again. Otherwise, it should 
     * give up completely, by calling Close on the channel.
     */
    SASLStatusServerFailed = 5,

    /**
     * The client has indicated an authentication failure. The possible 
     * actions are the same as for Server_Failed.
     */
    SASLStatusClientFailed = 6,

    _SASLStatusPadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of SASLStatus.
 */
const int NUM_SASL_STATUSES = (6+1);

/**
 * \enum TubeChannelState
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 */
enum TubeChannelState
{
    /**
     * The initiator offered the tube. The tube is waiting to be 
     * accepted/closed locally. If the client accepts the tube, the 
     * tube&apos;s state will be Open.
     */
    TubeChannelStateLocalPending = 0,

    /**
     * The tube is waiting to be accepted/closed remotely. If the recipient 
     * accepts the tube, the tube&apos;s state will be Open.
     */
    TubeChannelStateRemotePending = 1,

    /**
     * The initiator offered the tube and the recipient accepted it. The tube 
     * is open for traffic. The tube&apos;s state stays in this state until it 
     * is closed.
     */
    TubeChannelStateOpen = 2,

    /**
     * The tube channel has been requested but the tube is not yet offered. 
     * The client should offer the tube to the recipient and the tube&apos;s 
     * state will be Remote_Pending. The method used to offer the tube depends 
     * on the tube type.
     */
    TubeChannelStateNotOffered = 3,

    _TubeChannelStatePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of TubeChannelState.
 */
const int NUM_TUBE_CHANNEL_STATES = (3+1);

/**
 * \enum SocketAddressType
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 */
enum SocketAddressType
{
    /**
     * A Unix socket. The address variant contains a byte-array, signature 
     * &apos;ay&apos;, containing the path of the socket.
     */
    SocketAddressTypeUnix = 0,

    /**
     * An abstract Unix socket. The address variant contains a byte-array, 
     * signature &apos;ay&apos;, containing the path of the socket including 
     * the leading null byte.
     */
    SocketAddressTypeAbstractUnix = 1,

    /**
     * An IPv4 socket. The address variant contains a Socket_Address_IPv4, 
     * i.e. a structure with signature (sq) in which the string is an IPv4 
     * dotted-quad address literal (and must not be a DNS name), while the 
     * 16-bit unsigned integer is the port number.
     */
    SocketAddressTypeIPv4 = 2,

    /**
     * An IPv6 socket. The address variant contains a Socket_Address_IPv6, 
     * i.e. a structure with signature (sq) in which the string is an IPv6 
     * address literal as specified in RFC2373 (and must not be a DNS name), 
     * while the 16-bit unsigned integer is the port number.
     */
    SocketAddressTypeIPv6 = 3,

    _SocketAddressTypePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of SocketAddressType.
 */
const int NUM_SOCKET_ADDRESS_TYPES = (3+1);

/**
 * \enum SocketAccessControl
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 */
enum SocketAccessControl
{
    /**
     * The IP or Unix socket can be accessed by any local user (e.g. a Unix 
     * socket that accepts all local connections, or an IP socket listening on 
     * 127.0.0.1 (or ::1) or rejecting connections not from that address). The 
     * associated variant must be ignored. For a D-Bus tube, this means that 
     * the &quot;same user&quot; access control typically provided by default 
     * in D-Bus implementations SHOULD be disabled. If the socket is only 
     * available to local users (e.g. a Unix socket, an IPv4 socket bound to 
     * 127.0.0.1, or an IPv6 socket bound to ::1), the ANONYMOUS 
     * authentication mechanism MAY be enabled.
     */
    SocketAccessControlLocalhost = 0,

    /**
     * May only be used on IP sockets, and only for Stream tubes. The 
     * associated variant must contain a struct Socket_Address_IPv4 (or 
     * Socket_Address_IPv6) containing the string form of an IP address of the 
     * appropriate version, and a port number. The socket can only be accessed 
     * if the connecting process has that address and port number; all other 
     * connections will be rejected.
     */
    SocketAccessControlPort = 1,

    /**
     * May only be used on IP sockets. The associated variant must contain a 
     * struct Socket_Netmask_IPv4 (or Socket_Netmask_IPv6) with signature 
     * (sy), containing the string form of an IP address of the appropriate 
     * version, and a prefix length &quot;n&quot;. The socket can only be 
     * accessed if the first n bits of the connecting address match the first 
     * n bits of the given address.
     */
    SocketAccessControlNetmask = 2,

    /**
     * \htmlonly
     * <p>The high-level meaning of this access control type is that
     *   only the same user (e.g. same numeric Unix uid) is allowed to
     *   interact with the tube. Exactly how this is achieved varies by
     *   channel type.</p>
     * 
     * <p>For  \endhtmlonly ChannelTypeStreamTubeInterface \htmlonly  channels, this access control type
     *   may only be used on UNIX sockets.
     *   The connecting process must send a byte when
     *   it first connects, which is not considered to be part of the data
     *   stream. If the operating system uses sendmsg() with SCM_CREDS or
     *   SCM_CREDENTIALS to pass credentials over sockets, the connecting
     *   process must do so if possible; if not, it must still send the
     *   byte, without any attached credentials. (This mechanism is
     *   very similar to the first byte of a D-Bus connection, except that
     *   in D-Bus the byte is always zero, whereas in Tubes it can be
     *   nonzero.)</p>
     * 
     * <p>For  \endhtmlonly ChannelTypeDBusTubeInterface \htmlonly  channels, this access control type
     *   may be used on any type of socket, and there is no extra byte
     *   added by Telepathy at the beginning of the stream: all bytes in
     *   the stream are part of the D-Bus tube connection. The connecting
     *   process should prove its identity via any of the SASL
     *   authentication mechanisms usually used for D-Bus (in typical
     *   D-Bus implementations this involves either sending and receiving
     *   credentials as above, or demonstrating the ability to write to a
     *   file in the user's home directory).</p>
     * 
     * <p>In either case, the listening process will disconnect the
     *   connection unless it can determine by OS-specific means that
     *   the connecting process has the same user ID as the listening
     *   process.</p>
     * 
     * <p>In either tube type, the associated variant must be ignored.</p>
     * \endhtmlonly
     */
    SocketAccessControlCredentials = 3,

    _SocketAccessControlPadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of SocketAccessControl.
 */
const int NUM_SOCKET_ACCESS_CONTROLS = (3+1);

/**
 * \enum MediaStreamError
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 */
enum MediaStreamError
{
    /**
     * An unknown error occured.
     */
    MediaStreamErrorUnknown = 0,

    /**
     * The end of the stream was reached.
     */
    MediaStreamErrorEOS = 1,

    /**
     * There are no common codecs between the local side and the other 
     * particpants in the call. The possible codecs are not signalled here: 
     * the streaming implementation is assumed to report them in an 
     * implementation-dependent way, e.g. Farsight should use 
     * GstMissingElement.
     */
    MediaStreamErrorCodecNegotiationFailed = 2,

    /**
     * A network connection for the Media could not be established or was lost.
     */
    MediaStreamErrorConnectionFailed = 3,

    /**
     * There was an error in the networking stack (other than the connection 
     * failure).
     */
    MediaStreamErrorNetworkError = 4,

    /**
     * There are no installed codecs for this media type.
     */
    MediaStreamErrorNoCodecs = 5,

    /**
     * The CM is doing something wrong.
     */
    MediaStreamErrorInvalidCMBehavior = 6,

    /**
     * There was an error in the media processing stack.
     */
    MediaStreamErrorMediaError = 7,

    _MediaStreamErrorPadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of MediaStreamError.
 */
const int NUM_MEDIA_STREAM_ERRORS = (7+1);

/**
 * \enum MediaStreamBaseProto
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 */
enum MediaStreamBaseProto
{
    /**
     * UDP (User Datagram Protocol)
     */
    MediaStreamBaseProtoUDP = 0,

    /**
     * TCP (Transmission Control Protocol)
     */
    MediaStreamBaseProtoTCP = 1,

    _MediaStreamBaseProtoPadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of MediaStreamBaseProto.
 */
const int NUM_MEDIA_STREAM_BASE_PROTOS = (1+1);

/**
 * \enum MediaStreamTransportType
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 */
enum MediaStreamTransportType
{
    /**
     * A local address
     */
    MediaStreamTransportTypeLocal = 0,

    /**
     * An external address derived by a method such as STUN
     */
    MediaStreamTransportTypeDerived = 1,

    /**
     * An external stream relay
     */
    MediaStreamTransportTypeRelay = 2,

    _MediaStreamTransportTypePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of MediaStreamTransportType.
 */
const int NUM_MEDIA_STREAM_TRANSPORT_TYPES = (2+1);

/**
 * \enum DebugLevel
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 */
enum DebugLevel
{
    /**
     * Log level for errors. Error messages are always fatal, resulting in the 
     * service terminating after something completely unexpected occurred.
     */
    DebugLevelError = 0,

    /**
     * Log level for critical messages. Critical messages are messages that 
     * the service might predict and it is up to the service itself to decide 
     * whether to terminate following a critical message.
     */
    DebugLevelCritical = 1,

    /**
     * Log level for warnings.
     */
    DebugLevelWarning = 2,

    /**
     * Log level for messages.
     */
    DebugLevelMessage = 3,

    /**
     * Log level for information messages.
     */
    DebugLevelInfo = 4,

    /**
     * Log level for debug messages.
     */
    DebugLevelDebug = 5,

    _DebugLevelPadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of DebugLevel.
 */
const int NUM_DEBUG_LEVELS = (5+1);

/**
 * \enum TLSCertificateState
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 * 
 * The possible states for a TLSCertificate object.
 */
enum TLSCertificateState
{
    /**
     * The certificate is currently waiting to be accepted or rejected.
     */
    TLSCertificateStatePending = 0,

    /**
     * The certificate has been verified.
     */
    TLSCertificateStateAccepted = 1,

    /**
     * The certificate has been rejected.
     */
    TLSCertificateStateRejected = 2,

    _TLSCertificateStatePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of TLSCertificateState.
 */
const int NUM_TLS_CERTIFICATE_STATES = (2+1);

/**
 * \enum TLSCertificateRejectReason
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 * 
 * Possible reasons to reject a TLS certificate.
 */
enum TLSCertificateRejectReason
{
    /**
     * The certificate has been rejected for another reason not listed in this 
     * enumeration.
     */
    TLSCertificateRejectReasonUnknown = 0,

    /**
     * The certificate is not trusted.
     */
    TLSCertificateRejectReasonUntrusted = 1,

    /**
     * The certificate is expired.
     */
    TLSCertificateRejectReasonExpired = 2,

    /**
     * The certificate is not active yet.
     */
    TLSCertificateRejectReasonNotActivated = 3,

    /**
     * The certificate provided does not have the expected fingerprint.
     */
    TLSCertificateRejectReasonFingerprintMismatch = 4,

    /**
     * The hostname certified does not match the provided one.
     */
    TLSCertificateRejectReasonHostnameMismatch = 5,

    /**
     * The certificate is self-signed.
     */
    TLSCertificateRejectReasonSelfSigned = 6,

    /**
     * The certificate has been revoked.
     */
    TLSCertificateRejectReasonRevoked = 7,

    /**
     * The certificate uses an insecure cipher algorithm, or is 
     * cryptographically weak.
     */
    TLSCertificateRejectReasonInsecure = 8,

    /**
     * The length in bytes of the certificate, or the depth of the certificate 
     * chain exceed the limits imposed by the crypto library.
     */
    TLSCertificateRejectReasonLimitExceeded = 9,

    _TLSCertificateRejectReasonPadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of TLSCertificateRejectReason.
 */
const int NUM_TLS_CERTIFICATE_REJECT_REASONS = (9+1);

/**
 * \enum CallContentPacketizationType
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 * 
 * A packetization method that can be used for a content.
 */
enum CallContentPacketizationType
{
    /**
     * \htmlonly
     * Real-time Transport Protocol, as documented by RFC 3550.
     * \endhtmlonly
     */
    CallContentPacketizationTypeRTP = 0,

    /**
     * \htmlonly
     * Raw media.
     * \endhtmlonly
     */
    CallContentPacketizationTypeRaw = 1,

    /**
     * \htmlonly
     * MSN webcam. This is the video-only one-way type which was
     * used in earlier versions of WLM. Although no longer used,
     * modern WLM clients still support the MSN webcam protocol.
     * \endhtmlonly
     */
    CallContentPacketizationTypeMSNWebcam = 2,

    _CallContentPacketizationTypePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of CallContentPacketizationType.
 */
const int NUM_CALL_CONTENT_PACKETIZATION_TYPES = (2+1);

/**
 * \enum CallContentDisposition
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 * 
 * The disposition of this content, which defines whether to automatically 
 * start sending data on the streams when Accept is called on the channel.
 */
enum CallContentDisposition
{
    /**
     * \htmlonly
     * The content has no specific disposition.
     * \endhtmlonly
     */
    CallContentDispositionNone = 0,

    /**
     * \htmlonly
     * <p>The content was initially part of the call. When
     *  \endhtmlonly ChannelTypeCallInterface::Accept() \htmlonly 
     * is called on the channel, all streams of this content with
     *  \endhtmlonly \link CallStreamInterface::requestPropertyLocalSendingState() CallStreamInterface::LocalSendingState \endlink \htmlonly 
     * set to <tp:value-ref type="Sending_State">Pending_Send</tp:value-ref> will be
     * moved to <tp:value-ref type="Sending_State">Sending</tp:value-ref> as if
     *  \endhtmlonly CallStreamInterface::SetSending() \htmlonly 
     * (True) had been called.</p>
     * \endhtmlonly
     */
    CallContentDispositionInitial = 1,

    _CallContentDispositionPadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of CallContentDisposition.
 */
const int NUM_CALL_CONTENT_DISPOSITIONS = (1+1);

/**
 * \enum RCPTXRRTTMode
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 */
enum RCPTXRRTTMode
{
    /**
     * Both RTP data senders and data receivers MAY send DLRR blocks.
     */
    RCPTXRRTTModeAll = 0,

    /**
     * Only active RTP senders MAY send DLRR blocks, i.e., non RTP senders 
     * SHALL NOT send DLRR blocks.
     */
    RCPTXRRTTModeSender = 1,

    _RCPTXRRTTModePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of RCPTXRRTTMode.
 */
const int NUM_RCPT_XR_RTT_MODES = (1+1);

/**
 * \enum StreamFlowState
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 * 
 * \htmlonly
 * The type of  \endhtmlonly \link requestPropertySendingState() SendingState \endlink \htmlonly 
 * and  \endhtmlonly \link requestPropertyReceivingState() ReceivingState \endlink \htmlonly .
 * \endhtmlonly
 */
enum StreamFlowState
{
    /**
     * No data is flowing (or expected to be flowing) at this time.
     */
    StreamFlowStateStopped = 0,

    /**
     * The streaming implementation has been told to start or receiving, but 
     * has not yet indicated that it is doing so.
     */
    StreamFlowStatePendingStart = 1,

    /**
     * The streaming implementation has been told to stop sending or receiving 
     * data, but it has not yet indicated that it has done so.
     */
    StreamFlowStatePendingStop = 2,

    /**
     * The streaming implementation is successfully sending or receiving data, 
     * and everything is going swimmingly.
     */
    StreamFlowStateStarted = 3,

    _StreamFlowStatePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of StreamFlowState.
 */
const int NUM_STREAM_FLOW_STATES = (3+1);

/**
 * \enum CallStreamCandidateType
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 * 
 * The network topology that an IP candidate represents. This can sometimes be 
 * used to infer what kind of performance characteristics (latency, bandwith, 
 * etc) can be expected of connections made to this candidate.
 */
enum CallStreamCandidateType
{
    /**
     * This is not an IP candidate. This is a reserved value, and should not 
     * be seen on the bus.
     */
    CallStreamCandidateTypeNone = 0,

    /**
     * This candidate represents a direct connection to the host, as its 
     * address is taken directly the host&apos;s IP stack.
     */
    CallStreamCandidateTypeHost = 1,

    /**
     * This candidate probably represents a connection to the host through a 
     * NAT device, as its address was discovered by sending a binding request 
     * to a STUN server or similar.
     */
    CallStreamCandidateTypeServerReflexive = 2,

    /**
     * This candidate probably represents a good route between the host and 
     * its peer, as its address was discovered by sending a STUN binding 
     * request to one of the candidates advertised by the peer.
     */
    CallStreamCandidateTypePeerReflexive = 3,

    /**
     * This candidate represents the address of a relay server (usually 
     * somewhere on the public internet). This candidate is the most likely to 
     * work, but all media will go via a relay server, so latency is likely to 
     * be higher than other types of candidate.
     */
    CallStreamCandidateTypeRelay = 4,

    /**
     * This candidate represents a Multicast group. This value should only 
     * appear if the Stream&apos;s Transport is set to Multicast.
     */
    CallStreamCandidateTypeMulticast = 5,

    _CallStreamCandidateTypePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of CallStreamCandidateType.
 */
const int NUM_CALL_STREAM_CANDIDATE_TYPES = (5+1);

/**
 * \enum StreamComponent
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 * 
 * \htmlonly
 * Media streams can use more than one UDP socket: one for RTP (data)
 * and one for RTCP (control). Most of the time, they are adjacent
 * to each other, but some protocols (xmpp) signal each port separately.
 * \endhtmlonly
 */
enum StreamComponent
{
    /**
     * The stream transport type is unknown or not applicable (should not 
     * appear over dbus).
     */
    StreamComponentUnknown = 0,

    /**
     * This is the high-traffic data socket, containing the audio/video data 
     * for the stream.
     */
    StreamComponentData = 1,

    /**
     * This is the low-traffic control socket, usually containing feedback 
     * about packet loss etc.
     */
    StreamComponentControl = 2,

    _StreamComponentPadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of StreamComponent.
 */
const int NUM_STREAM_COMPONENTS = (2+1);

/**
 * \enum StreamTransportType
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 * 
 * \htmlonly
 * A transport that can be used for streaming.
 * \endhtmlonly
 */
enum StreamTransportType
{
    /**
     * The stream transport type is unknown or not applicable (for streams 
     * that do not have a configurable transport).
     */
    StreamTransportTypeUnknown = 0,

    /**
     * Raw UDP, with or without STUN. All streaming clients are assumed to 
     * support this transport, so there is no handler capability token for it 
     * in the Call1 interface. [This corresponds to &quot;none&quot; or 
     * &quot;stun&quot; in the old Media.StreamHandler interface.]
     */
    StreamTransportTypeRawUDP = 1,

    /**
     * Interactive Connectivity Establishment, as defined by RFC 5245. Note 
     * that this value covers ICE-UDP only. [This corresponds to 
     * &quot;ice-udp&quot; in the old Media.StreamHandler interface.]
     */
    StreamTransportTypeICE = 2,

    /**
     * Google Talk peer-to-peer connectivity establishment, as implemented by 
     * libjingle 0.3. [This corresponds to &quot;gtalk-p2p&quot; in the old 
     * Media.StreamHandler interface.]
     */
    StreamTransportTypeGTalkP2P = 3,

    /**
     * The transport used by Windows Live Messenger 2009 or later, which 
     * resembles ICE draft 19. [This corresponds to &quot;wlm-2009&quot; in 
     * the old Media.StreamHandler interface.]
     */
    StreamTransportTypeWLM2009 = 4,

    /**
     * Shared memory transport, as implemented by the GStreamer shmsrc and 
     * shmsink plugins.
     */
    StreamTransportTypeSHM = 5,

    /**
     * Multicast transport.
     */
    StreamTransportTypeMulticast = 6,

    _StreamTransportTypePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of StreamTransportType.
 */
const int NUM_STREAM_TRANSPORT_TYPES = (6+1);

/**
 * \enum SendingState
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 * 
 * Enum indicating whether a contact is sending media.
 */
enum SendingState
{
    /**
     * The contact is not sending media and has not been asked to do so.
     */
    SendingStateNone = 0,

    /**
     * The contact has been asked to start sending media.
     */
    SendingStatePendingSend = 1,

    /**
     * The contact is sending media.
     */
    SendingStateSending = 2,

    /**
     * The contact has been asked to stop sending media.
     */
    SendingStatePendingStopSending = 3,

    _SendingStatePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of SendingState.
 */
const int NUM_SENDING_STATES = (3+1);

/**
 * \enum StreamEndpointState
 * \ingroup enumtypeconsts
 *
 * Enumerated type generated from the specification.
 * 
 * Represents the state of ICE negotiation for a single component of a stream 
 * to an endpoint.
 */
enum StreamEndpointState
{
    /**
     * Candidate gathering and connectivity checks are in progress.
     */
    StreamEndpointStateConnecting = 0,

    /**
     * The streaming implementation has found at least one working candidate 
     * pair. It is possible to send media at this point, but the controlling 
     * side has yet to negotiate the final candidates for use in this call.
     */
    StreamEndpointStateProvisionallyConnected = 1,

    /**
     * This component of the stream is connected, and an updated offer has 
     * been sent and accepted (finalising the candidates to be used for the 
     * call). This should be set by the CM in response to 
     * AcceptSelectedCandidatePair.
     */
    StreamEndpointStateFullyConnected = 2,

    /**
     * The streaming implementation has tried connecting to all of the 
     * available candidates and none of them have connected. This is distinct 
     * from Failed, because the CM might be able to provide more candidates 
     * later (more likely in XMPP than SIP).
     */
    StreamEndpointStateExhaustedCandidates = 3,

    /**
     * The CM and streaming implementation are in agreement that it is 
     * impossible to connect to this endpoint. This value should only be set 
     * by the CM.
     */
    StreamEndpointStateFailed = 4,

    _StreamEndpointStatePadding = 0xffffffffU
};

/**
 * \ingroup enumtypeconsts
 *
 * 1 higher than the highest valid value of StreamEndpointState.
 */
const int NUM_STREAM_ENDPOINT_STATES = (4+1);

}

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.ConnectionManager" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CONNECTION_MANAGER (QLatin1String("org.freedesktop.Telepathy.ConnectionManager"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Protocol" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_PROTOCOL (QLatin1String("org.freedesktop.Telepathy.Protocol"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Protocol.Interface.Addressing" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_PROTOCOL_INTERFACE_ADDRESSING (QLatin1String("org.freedesktop.Telepathy.Protocol.Interface.Addressing"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Protocol.Interface.Avatars" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_PROTOCOL_INTERFACE_AVATARS (QLatin1String("org.freedesktop.Telepathy.Protocol.Interface.Avatars"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Protocol.Interface.Presence" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_PROTOCOL_INTERFACE_PRESENCE (QLatin1String("org.freedesktop.Telepathy.Protocol.Interface.Presence"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Connection" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CONNECTION (QLatin1String("org.freedesktop.Telepathy.Connection"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Connection.Interface.Addressing1" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CONNECTION_INTERFACE_ADDRESSING (QLatin1String("org.freedesktop.Telepathy.Connection.Interface.Addressing1"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Connection.Interface.Aliasing" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CONNECTION_INTERFACE_ALIASING (QLatin1String("org.freedesktop.Telepathy.Connection.Interface.Aliasing"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Connection.Interface.Anonymity" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CONNECTION_INTERFACE_ANONYMITY (QLatin1String("org.freedesktop.Telepathy.Connection.Interface.Anonymity"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Connection.Interface.Avatars" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CONNECTION_INTERFACE_AVATARS (QLatin1String("org.freedesktop.Telepathy.Connection.Interface.Avatars"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Connection.Interface.Balance" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CONNECTION_INTERFACE_BALANCE (QLatin1String("org.freedesktop.Telepathy.Connection.Interface.Balance"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Connection.Interface.Capabilities" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CONNECTION_INTERFACE_CAPABILITIES (QLatin1String("org.freedesktop.Telepathy.Connection.Interface.Capabilities"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Connection.Interface.Cellular" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CONNECTION_INTERFACE_CELLULAR (QLatin1String("org.freedesktop.Telepathy.Connection.Interface.Cellular"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Connection.Interface.ClientTypes" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CONNECTION_INTERFACE_CLIENT_TYPES (QLatin1String("org.freedesktop.Telepathy.Connection.Interface.ClientTypes"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Connection.Interface.Contacts" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CONNECTION_INTERFACE_CONTACTS (QLatin1String("org.freedesktop.Telepathy.Connection.Interface.Contacts"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Connection.Interface.ContactBlocking" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CONNECTION_INTERFACE_CONTACT_BLOCKING (QLatin1String("org.freedesktop.Telepathy.Connection.Interface.ContactBlocking"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Connection.Interface.ContactCapabilities" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CONNECTION_INTERFACE_CONTACT_CAPABILITIES (QLatin1String("org.freedesktop.Telepathy.Connection.Interface.ContactCapabilities"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Connection.Interface.ContactGroups" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CONNECTION_INTERFACE_CONTACT_GROUPS (QLatin1String("org.freedesktop.Telepathy.Connection.Interface.ContactGroups"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Connection.Interface.ContactInfo" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CONNECTION_INTERFACE_CONTACT_INFO (QLatin1String("org.freedesktop.Telepathy.Connection.Interface.ContactInfo"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Connection.Interface.ContactList" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CONNECTION_INTERFACE_CONTACT_LIST (QLatin1String("org.freedesktop.Telepathy.Connection.Interface.ContactList"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Connection.Interface.Location" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CONNECTION_INTERFACE_LOCATION (QLatin1String("org.freedesktop.Telepathy.Connection.Interface.Location"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Connection.Interface.MailNotification" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CONNECTION_INTERFACE_MAIL_NOTIFICATION (QLatin1String("org.freedesktop.Telepathy.Connection.Interface.MailNotification"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Connection.Interface.PowerSaving" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CONNECTION_INTERFACE_POWER_SAVING (QLatin1String("org.freedesktop.Telepathy.Connection.Interface.PowerSaving"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Connection.Interface.Presence" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CONNECTION_INTERFACE_PRESENCE (QLatin1String("org.freedesktop.Telepathy.Connection.Interface.Presence"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Connection.Interface.Requests" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CONNECTION_INTERFACE_REQUESTS (QLatin1String("org.freedesktop.Telepathy.Connection.Interface.Requests"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Connection.Interface.ServicePoint" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CONNECTION_INTERFACE_SERVICE_POINT (QLatin1String("org.freedesktop.Telepathy.Connection.Interface.ServicePoint"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Connection.Interface.SimplePresence" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CONNECTION_INTERFACE_SIMPLE_PRESENCE (QLatin1String("org.freedesktop.Telepathy.Connection.Interface.SimplePresence"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL (QLatin1String("org.freedesktop.Telepathy.Channel"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Type.Call1" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_TYPE_CALL (QLatin1String("org.freedesktop.Telepathy.Channel.Type.Call1"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Type.ContactList" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_TYPE_CONTACT_LIST (QLatin1String("org.freedesktop.Telepathy.Channel.Type.ContactList"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Type.ContactSearch" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_TYPE_CONTACT_SEARCH (QLatin1String("org.freedesktop.Telepathy.Channel.Type.ContactSearch"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Type.DBusTube" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_TYPE_DBUS_TUBE (QLatin1String("org.freedesktop.Telepathy.Channel.Type.DBusTube"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Type.FileTransfer" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_TYPE_FILE_TRANSFER (QLatin1String("org.freedesktop.Telepathy.Channel.Type.FileTransfer"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Type.RoomList" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_TYPE_ROOM_LIST (QLatin1String("org.freedesktop.Telepathy.Channel.Type.RoomList"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Type.ServerAuthentication" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_TYPE_SERVER_AUTHENTICATION (QLatin1String("org.freedesktop.Telepathy.Channel.Type.ServerAuthentication"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Type.ServerTLSConnection" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_TYPE_SERVER_TLS_CONNECTION (QLatin1String("org.freedesktop.Telepathy.Channel.Type.ServerTLSConnection"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Type.StreamedMedia" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_TYPE_STREAMED_MEDIA (QLatin1String("org.freedesktop.Telepathy.Channel.Type.StreamedMedia"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Type.StreamTube" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_TYPE_STREAM_TUBE (QLatin1String("org.freedesktop.Telepathy.Channel.Type.StreamTube"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Type.Text" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_TYPE_TEXT (QLatin1String("org.freedesktop.Telepathy.Channel.Type.Text"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Type.Tubes" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_TYPE_TUBES (QLatin1String("org.freedesktop.Telepathy.Channel.Type.Tubes"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Interface.Anonymity" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_INTERFACE_ANONYMITY (QLatin1String("org.freedesktop.Telepathy.Channel.Interface.Anonymity"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Interface.CaptchaAuthentication1" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_INTERFACE_CAPTCHA_AUTHENTICATION (QLatin1String("org.freedesktop.Telepathy.Channel.Interface.CaptchaAuthentication1"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Interface.CallState" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_INTERFACE_CALL_STATE (QLatin1String("org.freedesktop.Telepathy.Channel.Interface.CallState"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Interface.ChatState" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_INTERFACE_CHAT_STATE (QLatin1String("org.freedesktop.Telepathy.Channel.Interface.ChatState"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Interface.Conference" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_INTERFACE_CONFERENCE (QLatin1String("org.freedesktop.Telepathy.Channel.Interface.Conference"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Interface.Destroyable" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_INTERFACE_DESTROYABLE (QLatin1String("org.freedesktop.Telepathy.Channel.Interface.Destroyable"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Interface.DTMF" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_INTERFACE_DTMF (QLatin1String("org.freedesktop.Telepathy.Channel.Interface.DTMF"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Interface.FileTransfer.Metadata" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_INTERFACE_FILE_TRANSFER_METADATA (QLatin1String("org.freedesktop.Telepathy.Channel.Interface.FileTransfer.Metadata"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Interface.Group" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_INTERFACE_GROUP (QLatin1String("org.freedesktop.Telepathy.Channel.Interface.Group"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Interface.Hold" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_INTERFACE_HOLD (QLatin1String("org.freedesktop.Telepathy.Channel.Interface.Hold"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Interface.MediaSignalling" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_INTERFACE_MEDIA_SIGNALLING (QLatin1String("org.freedesktop.Telepathy.Channel.Interface.MediaSignalling"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Interface.Messages" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_INTERFACE_MESSAGES (QLatin1String("org.freedesktop.Telepathy.Channel.Interface.Messages"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Interface.Password" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_INTERFACE_PASSWORD (QLatin1String("org.freedesktop.Telepathy.Channel.Interface.Password"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Interface.SASLAuthentication" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_INTERFACE_SASL_AUTHENTICATION (QLatin1String("org.freedesktop.Telepathy.Channel.Interface.SASLAuthentication"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Interface.Securable" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_INTERFACE_SECURABLE (QLatin1String("org.freedesktop.Telepathy.Channel.Interface.Securable"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Interface.ServicePoint" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_INTERFACE_SERVICE_POINT (QLatin1String("org.freedesktop.Telepathy.Channel.Interface.ServicePoint"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Interface.SMS" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_INTERFACE_SMS (QLatin1String("org.freedesktop.Telepathy.Channel.Interface.SMS"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Channel.Interface.Tube" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_INTERFACE_TUBE (QLatin1String("org.freedesktop.Telepathy.Channel.Interface.Tube"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.ChannelDispatcher" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_DISPATCHER (QLatin1String("org.freedesktop.Telepathy.ChannelDispatcher"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.ChannelDispatchOperation" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_DISPATCH_OPERATION (QLatin1String("org.freedesktop.Telepathy.ChannelDispatchOperation"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.ChannelRequest" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CHANNEL_REQUEST (QLatin1String("org.freedesktop.Telepathy.ChannelRequest"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Media.SessionHandler" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_MEDIA_SESSION_HANDLER (QLatin1String("org.freedesktop.Telepathy.Media.SessionHandler"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Media.StreamHandler" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_MEDIA_STREAM_HANDLER (QLatin1String("org.freedesktop.Telepathy.Media.StreamHandler"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.DBus" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_DBUS_DAEMON (QLatin1String("org.freedesktop.DBus"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.DBus.Introspectable" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_INTROSPECTABLE (QLatin1String("org.freedesktop.DBus.Introspectable"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.DBus.Peer" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_PEER (QLatin1String("org.freedesktop.DBus.Peer"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.DBus.Properties" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_PROPERTIES (QLatin1String("org.freedesktop.DBus.Properties"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Debug" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_DEBUG (QLatin1String("org.freedesktop.Telepathy.Debug"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Properties" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_PROPERTIES_INTERFACE (QLatin1String("org.freedesktop.Telepathy.Properties"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.AccountManager" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_ACCOUNT_MANAGER (QLatin1String("org.freedesktop.Telepathy.AccountManager"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Account" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_ACCOUNT (QLatin1String("org.freedesktop.Telepathy.Account"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Account.Interface.Addressing" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_ACCOUNT_INTERFACE_ADDRESSING (QLatin1String("org.freedesktop.Telepathy.Account.Interface.Addressing"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Account.Interface.Avatar" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_ACCOUNT_INTERFACE_AVATAR (QLatin1String("org.freedesktop.Telepathy.Account.Interface.Avatar"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Account.Interface.Storage" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_ACCOUNT_INTERFACE_STORAGE (QLatin1String("org.freedesktop.Telepathy.Account.Interface.Storage"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Client" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CLIENT (QLatin1String("org.freedesktop.Telepathy.Client"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Client.Observer" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CLIENT_OBSERVER (QLatin1String("org.freedesktop.Telepathy.Client.Observer"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Client.Approver" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CLIENT_APPROVER (QLatin1String("org.freedesktop.Telepathy.Client.Approver"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Client.Handler" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CLIENT_HANDLER (QLatin1String("org.freedesktop.Telepathy.Client.Handler"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Client.Interface.Requests" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CLIENT_INTERFACE_REQUESTS (QLatin1String("org.freedesktop.Telepathy.Client.Interface.Requests"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Authentication.TLSCertificate" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_AUTHENTICATION_TLS_CERTIFICATE (QLatin1String("org.freedesktop.Telepathy.Authentication.TLSCertificate"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Call1.Content.Interface.Media" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CALL_CONTENT_INTERFACE_MEDIA (QLatin1String("org.freedesktop.Telepathy.Call1.Content.Interface.Media"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Call1.Content.Interface.DTMF" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CALL_CONTENT_INTERFACE_DTMF (QLatin1String("org.freedesktop.Telepathy.Call1.Content.Interface.DTMF"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Call1.Content.Interface.VideoControl" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CALL_CONTENT_INTERFACE_VIDEO_CONTROL (QLatin1String("org.freedesktop.Telepathy.Call1.Content.Interface.VideoControl"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Call1.Content.Interface.AudioControl" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CALL_CONTENT_INTERFACE_AUDIO_CONTROL (QLatin1String("org.freedesktop.Telepathy.Call1.Content.Interface.AudioControl"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Call1.Content" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CALL_CONTENT (QLatin1String("org.freedesktop.Telepathy.Call1.Content"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Call1.Content.MediaDescription.Interface.RTCPExtendedReports" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CALL_CONTENT_MEDIA_DESCRIPTION_INTERFACE_RTCP_EXTENDED_REPORTS (QLatin1String("org.freedesktop.Telepathy.Call1.Content.MediaDescription.Interface.RTCPExtendedReports"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Call1.Content.MediaDescription.Interface.RTCPFeedback" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CALL_CONTENT_MEDIA_DESCRIPTION_INTERFACE_RTCP_FEEDBACK (QLatin1String("org.freedesktop.Telepathy.Call1.Content.MediaDescription.Interface.RTCPFeedback"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Call1.Content.MediaDescription.Interface.RTPHeaderExtensions" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CALL_CONTENT_MEDIA_DESCRIPTION_INTERFACE_RTP_HEADER_EXTENSIONS (QLatin1String("org.freedesktop.Telepathy.Call1.Content.MediaDescription.Interface.RTPHeaderExtensions"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Call1.Content.MediaDescription" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CALL_CONTENT_MEDIA_DESCRIPTION (QLatin1String("org.freedesktop.Telepathy.Call1.Content.MediaDescription"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Call1.Stream.Interface.Media" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CALL_STREAM_INTERFACE_MEDIA (QLatin1String("org.freedesktop.Telepathy.Call1.Stream.Interface.Media"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Call1.Stream" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CALL_STREAM (QLatin1String("org.freedesktop.Telepathy.Call1.Stream"))

/**
 * \ingroup ifacestrconsts
 *
 * The interface name "org.freedesktop.Telepathy.Call1.Stream.Endpoint" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 */
#define TP_QT_IFACE_CALL_STREAM_ENDPOINT (QLatin1String("org.freedesktop.Telepathy.Call1.Stream.Endpoint"))

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.NetworkError" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised when there is an error reading from or writing to the network.
 */
#define TP_QT_ERROR_NETWORK_ERROR QLatin1String("org.freedesktop.Telepathy.Error.NetworkError")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.NotImplemented" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised when the requested method, channel, etc is not available on this 
 * connection.
 */
#define TP_QT_ERROR_NOT_IMPLEMENTED QLatin1String("org.freedesktop.Telepathy.Error.NotImplemented")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.InvalidArgument" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised when one of the provided arguments is invalid.
 */
#define TP_QT_ERROR_INVALID_ARGUMENT QLatin1String("org.freedesktop.Telepathy.Error.InvalidArgument")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.NotAvailable" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised when the requested functionality is temporarily unavailable.
 */
#define TP_QT_ERROR_NOT_AVAILABLE QLatin1String("org.freedesktop.Telepathy.Error.NotAvailable")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.PermissionDenied" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * The user is not permitted to perform the requested operation.
 */
#define TP_QT_ERROR_PERMISSION_DENIED QLatin1String("org.freedesktop.Telepathy.Error.PermissionDenied")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.Disconnected" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * The connection is not currently connected and cannot be used. This error 
 * may also be raised when operations are performed on a Connection for which 
 * StatusChanged has signalled status Disconnected for reason None. The second 
 * usage corresponds to None in the Connection_Status_Reason enum; if a better 
 * reason is available, the corresponding error should be used instead.
 */
#define TP_QT_ERROR_DISCONNECTED QLatin1String("org.freedesktop.Telepathy.Error.Disconnected")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.InvalidHandle" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * The handle specified is unknown on this channel or connection.
 */
#define TP_QT_ERROR_INVALID_HANDLE QLatin1String("org.freedesktop.Telepathy.Error.InvalidHandle")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.Channel.Banned" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * You are banned from the channel.
 */
#define TP_QT_ERROR_CHANNEL_BANNED QLatin1String("org.freedesktop.Telepathy.Error.Channel.Banned")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.Channel.Full" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * The channel is full.
 */
#define TP_QT_ERROR_CHANNEL_FULL QLatin1String("org.freedesktop.Telepathy.Error.Channel.Full")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.Channel.InviteOnly" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * The requested channel is invite-only.
 */
#define TP_QT_ERROR_CHANNEL_INVITE_ONLY QLatin1String("org.freedesktop.Telepathy.Error.Channel.InviteOnly")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.NotYours" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * \htmlonly
 * <p>The requested channel or other resource already exists, and another
 *   user interface in this session is responsible for it.</p>
 * 
 * <p>User interfaces SHOULD handle this error unobtrusively, since it
 *   indicates that some other user interface is already processing the
 *   channel.</p>
 * \endhtmlonly
 */
#define TP_QT_ERROR_NOT_YOURS QLatin1String("org.freedesktop.Telepathy.Error.NotYours")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.Cancelled" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised by an ongoing request if it is cancelled by user request before it 
 * has completed, or when operations are performed on an object which the user 
 * has asked to close (for instance, a Connection where the user has called 
 * Disconnect, or a Channel where the user has called Close). The second form 
 * can be used to correspond to the Requested member in the 
 * Connection_Status_Reason enum, or to to represent the situation where 
 * disconnecting a Connection, closing a Channel, etc. has been requested by 
 * the user but this request has not yet been acted on, for instance because 
 * the service will only act on the request when it has finished processing an 
 * event queue.
 */
#define TP_QT_ERROR_CANCELLED QLatin1String("org.freedesktop.Telepathy.Error.Cancelled")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.AuthenticationFailed" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised when authentication with a service was unsuccessful. This 
 * corresponds to Authentication_Failed in the Connection_Status_Reason enum.
 */
#define TP_QT_ERROR_AUTHENTICATION_FAILED QLatin1String("org.freedesktop.Telepathy.Error.AuthenticationFailed")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.EncryptionNotAvailable" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised if a user request insisted that encryption should be used, but 
 * encryption was not actually available. This corresponds to part of 
 * Encryption_Error in the Connection_Status_Reason enum. It&apos;s been 
 * separated into a distinct error here because the two concepts that were 
 * part of EncryptionError seem to be things that could reasonably appear 
 * differently in the UI.
 */
#define TP_QT_ERROR_ENCRYPTION_NOT_AVAILABLE QLatin1String("org.freedesktop.Telepathy.Error.EncryptionNotAvailable")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.EncryptionError" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised if encryption appears to be available, but could not actually be 
 * used (for instance if SSL/TLS negotiation fails). This corresponds to part 
 * of Encryption_Error in the Connection_Status_Reason enum.
 */
#define TP_QT_ERROR_ENCRYPTION_ERROR QLatin1String("org.freedesktop.Telepathy.Error.EncryptionError")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.Cert.NotProvided" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised if the server did not provide a SSL/TLS certificate. This error MUST 
 * NOT be used to represent the absence of a client certificate provided by 
 * the Telepathy connection manager. This corresponds to Cert_Not_Provided in 
 * the Connection_Status_Reason enum. That error explicitly applied only to 
 * server SSL certificates, so this one is similarly limited; having the CM 
 * present a client certificate is a possible future feature, but it should 
 * have its own error handling.
 */
#define TP_QT_ERROR_CERT_NOT_PROVIDED QLatin1String("org.freedesktop.Telepathy.Error.Cert.NotProvided")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.Cert.Untrusted" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised if the server provided a SSL/TLS certificate signed by an untrusted 
 * certifying authority. This error SHOULD NOT be used to represent a 
 * self-signed certificate: see the Self Signed error for that. This 
 * corresponds to Cert_Untrusted in the Connection_Status_Reason enum and to 
 * Untrusted in the TLS_Certificate_Reject_Reason enum, with a clarification 
 * to avoid ambiguity.
 */
#define TP_QT_ERROR_CERT_UNTRUSTED QLatin1String("org.freedesktop.Telepathy.Error.Cert.Untrusted")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.Cert.Expired" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised if the server provided an expired SSL/TLS certificate. This 
 * corresponds to Cert_Expired in the Connection_Status_Reason enum and to 
 * Expired in the TLS_Certificate_Reject_Reason enum.
 */
#define TP_QT_ERROR_CERT_EXPIRED QLatin1String("org.freedesktop.Telepathy.Error.Cert.Expired")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.Cert.NotActivated" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised if the server provided an SSL/TLS certificate that will become valid 
 * at some point in the future. This corresponds to Cert_Not_Activated in the 
 * Connection_Status_Reason enum and to Not_Activated in the 
 * TLS_Certificate_Reject_Reason enum.
 */
#define TP_QT_ERROR_CERT_NOT_ACTIVATED QLatin1String("org.freedesktop.Telepathy.Error.Cert.NotActivated")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.Cert.FingerprintMismatch" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised if the server provided an SSL/TLS certificate that did not have the 
 * expected fingerprint. This corresponds to Cert_Fingerprint_Mismatch in the 
 * Connection_Status_Reason enum and to Fingerprint_Mismatch in the 
 * TLS_Certificate_Reject_Reason enum.
 */
#define TP_QT_ERROR_CERT_FINGERPRINT_MISMATCH QLatin1String("org.freedesktop.Telepathy.Error.Cert.FingerprintMismatch")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.Cert.HostnameMismatch" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * \htmlonly
 * <p>Raised if the server provided an SSL/TLS certificate that did not match
 * its hostname.</p>
 * <p>You MAY be able to get more details about the expected and certified
 * hostnames by looking up the 'expected-hostname' and 'certificate-hostname'
 * keys in the details map that came together with this error.</p>
 * <div class="rationale">
 *   This corresponds to Cert_Hostname_Mismatch in the
 *   <tp:type>Connection_Status_Reason</tp:type> enum and to Hostname_Mismatch
 *   in the <tp:type>TLS_Certificate_Reject_Reason</tp:type> enum.
 * </div>
 * \endhtmlonly
 */
#define TP_QT_ERROR_CERT_HOSTNAME_MISMATCH QLatin1String("org.freedesktop.Telepathy.Error.Cert.HostnameMismatch")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.Cert.SelfSigned" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised if the server provided an SSL/TLS certificate that is self-signed 
 * and untrusted. This corresponds to Cert_Self_Signed in the 
 * Connection_Status_Reason enum and to Self_Signed in the 
 * TLS_Certificate_Reject_Reason enum.
 */
#define TP_QT_ERROR_CERT_SELF_SIGNED QLatin1String("org.freedesktop.Telepathy.Error.Cert.SelfSigned")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.Cert.Revoked" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised if the server provided an SSL/TLS certificate that has been revoked. 
 * This corresponds to Cert_Revoked in the Connection_Status_Reason enum and 
 * to Revoked in the TLS_Certificate_Reject_Reason enum.
 */
#define TP_QT_ERROR_CERT_REVOKED QLatin1String("org.freedesktop.Telepathy.Error.Cert.Revoked")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.Cert.Insecure" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised if the server provided an SSL/TLS certificate that uses an insecure 
 * cipher algorithm or is cryptographically weak. This corresponds to 
 * Cert_Insecure in the Connection_Status_Reason enum and to Insecure in the 
 * TLS_Certificate_Reject_Reason enum.
 */
#define TP_QT_ERROR_CERT_INSECURE QLatin1String("org.freedesktop.Telepathy.Error.Cert.Insecure")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.Cert.Invalid" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised if the server provided an SSL/TLS certificate that is unacceptable 
 * in some way that does not have a more specific error. This corresponds to 
 * Cert_Other_Error in the Connection_Status_Reason enum and to Unknown in the 
 * TLS_Certificate_Reject_Reason enum.
 */
#define TP_QT_ERROR_CERT_INVALID QLatin1String("org.freedesktop.Telepathy.Error.Cert.Invalid")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.Cert.LimitExceeded" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised if the length in bytes of the server certificate, or the depth of 
 * the server certificate chain exceeds the limits imposed by the crypto 
 * library. This corresponds to Cert_Limit_Exceeded in the 
 * Connection_Status_Reason enum and to Limit_Exceeded in the 
 * TLS_Certificate_Reject_Reason enum.
 */
#define TP_QT_ERROR_CERT_LIMIT_EXCEEDED QLatin1String("org.freedesktop.Telepathy.Error.Cert.LimitExceeded")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.NotCapable" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised when requested functionality is unavailable due to contact not 
 * having required capabilities.
 */
#define TP_QT_ERROR_NOT_CAPABLE QLatin1String("org.freedesktop.Telepathy.Error.NotCapable")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.Offline" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised when requested functionality is unavailable because a contact is 
 * offline. This corresponds to Offline in the Channel_Group_Change_Reason 
 * enum.
 */
#define TP_QT_ERROR_OFFLINE QLatin1String("org.freedesktop.Telepathy.Error.Offline")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.Channel.Kicked" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Used to represent a user being ejected from a channel by another user, for 
 * instance being kicked from a chatroom. This corresponds to Kicked in the 
 * Channel_Group_Change_Reason enum.
 */
#define TP_QT_ERROR_CHANNEL_KICKED QLatin1String("org.freedesktop.Telepathy.Error.Channel.Kicked")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.Busy" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Used to represent a user being removed from a channel because of a 
 * &quot;busy&quot; indication. This error SHOULD NOT be used to represent a 
 * server or other infrastructure being too busy to process a request - for 
 * that, see ServerBusy. This corresponds to Busy in the 
 * Channel_Group_Change_Reason enum.
 */
#define TP_QT_ERROR_BUSY QLatin1String("org.freedesktop.Telepathy.Error.Busy")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.NoAnswer" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Used to represent a user being removed from a channel because they did not 
 * respond, e.g. to a StreamedMedia call. This corresponds to No_Answer in the 
 * Channel_Group_Change_Reason enum.
 */
#define TP_QT_ERROR_NO_ANSWER QLatin1String("org.freedesktop.Telepathy.Error.NoAnswer")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.DoesNotExist" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised when the requested user does not, in fact, exist. This corresponds 
 * to Invalid_Contact in the Channel_Group_Change_Reason enum, but can also be 
 * used to represent other things not existing (like chatrooms, perhaps).
 */
#define TP_QT_ERROR_DOES_NOT_EXIST QLatin1String("org.freedesktop.Telepathy.Error.DoesNotExist")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.Terminated" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised when a channel is terminated for an unspecified reason. In 
 * particular, this error SHOULD be used whenever normal termination of a 1-1 
 * StreamedMedia call by the remote user is represented as a D-Bus error name. 
 * This corresponds to None in the Channel_Group_Change_Reason enum.
 */
#define TP_QT_ERROR_TERMINATED QLatin1String("org.freedesktop.Telepathy.Error.Terminated")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.Media.CodecsIncompatible" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised when the local streaming implementation has no codecs in common with 
 * the remote side. This corresponds to Media_Error.
 */
#define TP_QT_ERROR_MEDIA_CODECS_INCOMPATIBLE QLatin1String("org.freedesktop.Telepathy.Error.Media.CodecsIncompatible")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.Media.UnsupportedType" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * The media stream type requested is not supported by either the local or 
 * remote side. This corresponds to Media_Error.
 */
#define TP_QT_ERROR_MEDIA_UNSUPPORTED_TYPE QLatin1String("org.freedesktop.Telepathy.Error.Media.UnsupportedType")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.Media.StreamingError" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised when the call&apos;s streaming implementation has some kind of 
 * internal error. This corresponds to Internal_Error.
 */
#define TP_QT_ERROR_MEDIA_STREAMING_ERROR QLatin1String("org.freedesktop.Telepathy.Error.Media.StreamingError")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.ConnectionRefused" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised when a connection is refused.
 */
#define TP_QT_ERROR_CONNECTION_REFUSED QLatin1String("org.freedesktop.Telepathy.Error.ConnectionRefused")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.ConnectionFailed" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised when a connection can&apos;t be established.
 */
#define TP_QT_ERROR_CONNECTION_FAILED QLatin1String("org.freedesktop.Telepathy.Error.ConnectionFailed")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.ConnectionLost" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised when a connection is broken.
 */
#define TP_QT_ERROR_CONNECTION_LOST QLatin1String("org.freedesktop.Telepathy.Error.ConnectionLost")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.AlreadyConnected" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised when the user attempts to connect to an account but they are already 
 * connected (perhaps from another client or computer), and the protocol or 
 * account settings do not allow this. XMPP can have this behaviour if the 
 * user chooses the same resource in both clients (it is server-dependent 
 * whether the result is AlreadyConnected on the new connection, 
 * ConnectionReplaced on the old connection, or two successful connections).
 */
#define TP_QT_ERROR_ALREADY_CONNECTED QLatin1String("org.freedesktop.Telepathy.Error.AlreadyConnected")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.ConnectionReplaced" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised by an existing connection to an account if it is replaced by a new 
 * connection (perhaps from another client or computer). In MSNP, when 
 * connecting twice with the same Passport, the new connection 
 * &quot;wins&quot; and the old one is automatically disconnected. XMPP can 
 * also have this behaviour if the user chooses the same resource in two 
 * clients (it is server-dependent whether the result is AlreadyConnected on 
 * the new connection, ConnectionReplaced on the old connection, or two 
 * successful connections).
 */
#define TP_QT_ERROR_CONNECTION_REPLACED QLatin1String("org.freedesktop.Telepathy.Error.ConnectionReplaced")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.RegistrationExists" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised during in-band registration if the server indicates that the 
 * requested account already exists.
 */
#define TP_QT_ERROR_REGISTRATION_EXISTS QLatin1String("org.freedesktop.Telepathy.Error.RegistrationExists")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.ServiceBusy" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * \htmlonly
 * Raised if a server or some other piece of infrastructure cannot process
 * the request, e.g. due to resource limitations. Clients MAY try again
 * later.
 * 
 * <div class="rationale">
 *   This is not the same error as Busy, which indicates that a
 *   <em>user</em> is busy.
 * </div>
 * \endhtmlonly
 */
#define TP_QT_ERROR_SERVICE_BUSY QLatin1String("org.freedesktop.Telepathy.Error.ServiceBusy")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.ResourceUnavailable" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised if a request cannot be satisfied because a process local to the user 
 * has insufficient resources. Clients MAY try again later. For instance, the 
 * ChannelDispatcher might raise this error for some or all channel requests 
 * if it has detected that there is not enough free memory.
 */
#define TP_QT_ERROR_RESOURCE_UNAVAILABLE QLatin1String("org.freedesktop.Telepathy.Error.ResourceUnavailable")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.WouldBreakAnonymity" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised if a request cannot be satisfied without violating an earlier 
 * request for anonymity, and the earlier request specified that raising an 
 * error is preferable to disclosing the user&apos;s identity (for instance 
 * via Connection.Interface.Anonymity.AnonymityMandatory or 
 * Channel.Interface.Anonymity.AnonymityMandatory).
 */
#define TP_QT_ERROR_WOULD_BREAK_ANONYMITY QLatin1String("org.freedesktop.Telepathy.Error.WouldBreakAnonymity")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.NotYet" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised when the requested functionality is not yet available, but is likely 
 * to become available after some time has passed.
 */
#define TP_QT_ERROR_NOT_YET QLatin1String("org.freedesktop.Telepathy.Error.NotYet")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.Rejected" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised when an incoming or outgoing Call1 is rejected by the the receiver.
 */
#define TP_QT_ERROR_REJECTED QLatin1String("org.freedesktop.Telepathy.Error.Rejected")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.PickedUpElsewhere" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised when a call was terminated as a result of the local user picking up 
 * the call on a different resource.
 */
#define TP_QT_ERROR_PICKED_UP_ELSEWHERE QLatin1String("org.freedesktop.Telepathy.Error.PickedUpElsewhere")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.ServiceConfused" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised when a server or other piece of infrastructure indicates an internal 
 * error, or when a message that makes no sense is received from a server or 
 * other piece of infrastructure. For instance, this is appropriate for 
 * XMPP&apos;s internal-server-error, and is also appropriate if you receive 
 * sufficiently inconsistent information from a server that you cannot 
 * continue.
 */
#define TP_QT_ERROR_SERVICE_CONFUSED QLatin1String("org.freedesktop.Telepathy.Error.ServiceConfused")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.Confused" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised if a server rejects protocol messages from a connection manager 
 * claiming that they do not make sense, two local processes fail to 
 * understand each other, or an apparently impossible situation is reached. 
 * For instance, this would be an appropriate mapping for XMPP&apos;s errors 
 * bad-format, invalid-xml, etc., which can&apos;t happen unless the local (or 
 * remote) XMPP implementation is faulty. This is also analogous to 
 * Invalid_CM_Behavior, TP_DBUS_ERROR_INCONSISTENT in telepathy-glib, and 
 * TP_QT_ERROR_INCONSISTENT in telepathy-qt.
 */
#define TP_QT_ERROR_CONFUSED QLatin1String("org.freedesktop.Telepathy.Error.Confused")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.SoftwareUpgradeRequired" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * \htmlonly
 * <p>Raised as a
 *    \endhtmlonly ConnectionInterface::ConnectionError() \htmlonly 
 *   when a Connection cannot be established because either the Connection
 *   Manager or its support library (e.g. wocky, papyon, sofiasip) requires
 *   upgrading to support a newer protocol version.</p>
 * 
 * <p>This error corresponds to the
 *   <tp:type>Connection_Status_Reason</tp:type> of Network_Error.</p>
 * 
 * <div class="rationale">
 *   Some protocols transmit a protocol or library version number to the
 *   server, which will disconnect them if the version isn't appropriate.
 *   This way we can report the error to the user, and if appropriate, the
 *   user's client can check for updates.
 * </div>
 * \endhtmlonly
 */
#define TP_QT_ERROR_SOFTWARE_UPGRADE_REQUIRED QLatin1String("org.freedesktop.Telepathy.Error.SoftwareUpgradeRequired")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.EmergencyCallsNotSupported" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * Raised if a client attempts to dial a number that is recognized as an 
 * emergency number (e.g. &apos;911&apos; in the USA), but the Connection 
 * Manager or provider does not support dialling emergency numbers. Many VOIP 
 * providers have the ability to dial traditional (PSTN) telephone numbers, 
 * but do not provide the ability to dial emergency numbers (for instance, 
 * Google Voice). This error provides additional information about why such a 
 * call was unsuccessful.
 */
#define TP_QT_ERROR_EMERGENCY_CALLS_NOT_SUPPORTED QLatin1String("org.freedesktop.Telepathy.Error.EmergencyCallsNotSupported")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.InsufficientBalance" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * \htmlonly
 * <p>Raised if the user has insufficient
 *    \endhtmlonly ConnectionInterfaceBalanceInterface \htmlonly 
 *   to place a call or send a message.</p>
 * 
 * <p>The key 'balance-required' MAY be included in
 *    \endhtmlonly \link ChannelTypeCallInterface::requestPropertyCallStateDetails() ChannelTypeCallInterface::CallStateDetails \endlink \htmlonly 
 *   or a delivery report's <tp:type>Message_Part</tp:type>
 *   (with the same units and scale as
 *    \endhtmlonly \link ConnectionInterfaceBalanceInterface::requestPropertyAccountBalance() ConnectionInterfaceBalanceInterface::AccountBalance \endlink \htmlonly )
 *   to indicate how much credit is required to make this call or send
 *   this message.</p>
 * \endhtmlonly
 */
#define TP_QT_ERROR_INSUFFICIENT_BALANCE QLatin1String("org.freedesktop.Telepathy.Error.InsufficientBalance")

/**
 * \ingroup errorstrconsts
 *
 * The error name "org.freedesktop.Telepathy.Error.CaptchaNotSupported" as a QLatin1String, usable in QString requiring contexts even when
 * building with Q_NO_CAST_FROM_ASCII defined.
 * 
 * \htmlonly
 * <p>Raised if the  \endhtmlonly ChannelInterfaceCaptchaAuthenticationInterface \htmlonly  
 *   Handler either has no UI to present captchas, or it does, but wasn't 
 *   able to answer any of the captchas given.</p>
 * \endhtmlonly
 */
#define TP_QT_ERROR_CAPTCHA_NOT_SUPPORTED QLatin1String("org.freedesktop.Telepathy.Error.CaptchaNotSupported")

