/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import gnu.java.lang.management.MemoryMXBeanImpl;
import java.lang.management.MemoryUsage;
import java.lang.management.ThreadInfo;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.SimpleType;

public class MemoryNotificationInfo {
    public static final String MEMORY_THRESHOLD_EXCEEDED = "java.management.memory.threshold.exceeded";
    public static final String MEMORY_COLLECTION_THRESHOLD_EXCEEDED = "java.management.memory.collection.threshold.exceeded";
    private String poolName;
    private MemoryUsage usage;
    private long count;

    public MemoryNotificationInfo(String poolName, MemoryUsage usage, long count) {
        this.poolName = poolName;
        this.usage = usage;
        this.count = count;
    }

    public static MemoryNotificationInfo from(CompositeData data) {
        if (data == null) {
            return null;
        }
        CompositeType type = data.getCompositeType();
        ThreadInfo.checkAttribute(type, "poolName", SimpleType.STRING);
        ThreadInfo.checkAttribute(type, "usage", MemoryMXBeanImpl.usageType);
        ThreadInfo.checkAttribute(type, "count", SimpleType.LONG);
        MemoryUsage usage = MemoryUsage.from((CompositeData)data.get("usage"));
        return new MemoryNotificationInfo((String)data.get("poolName"), usage, (Long)data.get("count"));
    }

    public long getCount() {
        return this.count;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public MemoryUsage getUsage() {
        return this.usage;
    }
}

