/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.java.lang.CPStringBuilder;
import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplateNode;
import gnu.xml.xpath.Expr;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

final class ValueOfNode
extends TemplateNode {
    final Expr select;
    final boolean disableOutputEscaping;

    ValueOfNode(Expr select, boolean disableOutputEscaping) {
        this.select = select;
        this.disableOutputEscaping = disableOutputEscaping;
    }

    TemplateNode clone(Stylesheet stylesheet) {
        ValueOfNode ret = new ValueOfNode(this.select.clone(stylesheet), this.disableOutputEscaping);
        if (this.children != null) {
            ret.children = this.children.clone(stylesheet);
        }
        if (this.next != null) {
            ret.next = this.next.clone(stylesheet);
        }
        return ret;
    }

    void doApply(Stylesheet stylesheet, QName mode, Node context, int pos, int len, Node parent, Node nextSibling) throws TransformerException {
        String value;
        Object ret = this.select.evaluate(context, pos, len);
        if (ret instanceof Collection) {
            CPStringBuilder buf = new CPStringBuilder();
            for (Node node2 : (Collection)ret) {
                buf.append(Expr.stringValue(node2));
            }
            value = buf.toString();
        } else {
            value = ret == null ? "" : Expr._string(context, ret);
        }
        if (stylesheet.debug) {
            System.err.println("value-of: " + context + " " + this.select + " -> " + value);
        }
        if (value != null && value.length() > 0) {
            Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
            Text textNode = doc.createTextNode(value);
            if (this.disableOutputEscaping) {
                textNode.setUserData("disable-output-escaping", "yes", stylesheet);
            }
            if (nextSibling != null) {
                parent.insertBefore(textNode, nextSibling);
            } else {
                parent.appendChild(textNode);
            }
        }
        if (this.next != null) {
            this.next.apply(stylesheet, mode, context, pos, len, parent, nextSibling);
        }
    }

    public boolean references(QName var) {
        if (this.select != null && this.select.references(var)) {
            return true;
        }
        return super.references(var);
    }

    public String toString() {
        CPStringBuilder buf = new CPStringBuilder("value-of");
        buf.append('[');
        buf.append("select=");
        buf.append(this.select);
        if (this.disableOutputEscaping) {
            buf.append(",disableOutputEscaping");
        }
        buf.append(']');
        return buf.toString();
    }
}

