/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.sig.dss;

import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import gnu.java.security.sig.ISignatureCodec;
import gnu.java.security.util.DerUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.util.ArrayList;

public class DSSSignatureX509Codec
implements ISignatureCodec {
    public int getFormatID() {
        return 2;
    }

    public byte[] encodeSignature(Object signature) {
        byte[] result;
        BigInteger[] rs = (BigInteger[])signature;
        DERValue derR = new DERValue(2, rs[0]);
        DERValue derS = new DERValue(2, rs[1]);
        ArrayList<DERValue> dssSigValue = new ArrayList<DERValue>(2);
        dssSigValue.add(derR);
        dssSigValue.add(derS);
        DERValue derDssSigValue = new DERValue(48, dssSigValue);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            DERWriter.write(baos, derDssSigValue);
            result = baos.toByteArray();
        }
        catch (IOException x) {
            InvalidParameterException y = new InvalidParameterException();
            y.initCause(x);
            throw y;
        }
        return result;
    }

    public Object decodeSignature(byte[] input) {
        BigInteger s;
        BigInteger r;
        if (input == null) {
            throw new InvalidParameterException("Input bytes MUST NOT be null");
        }
        DERReader der = new DERReader(input);
        try {
            DERValue derDssSigValue = der.read();
            DerUtil.checkIsConstructed(derDssSigValue, "Wrong Dss-Sig-Value field");
            DERValue val = der.read();
            DerUtil.checkIsBigInteger(val, "Wrong R field");
            r = (BigInteger)val.getValue();
            val = der.read();
            DerUtil.checkIsBigInteger(val, "Wrong S field");
            s = (BigInteger)val.getValue();
        }
        catch (IOException x) {
            InvalidParameterException y = new InvalidParameterException();
            y.initCause(x);
            throw y;
        }
        return new BigInteger[]{r, s};
    }
}

