<?php
// $Id: comment-wrapper.tpl.php,v 1.1 2008/10/01 03:26:19 jwolf Exp $

/**
 * @file comment-wrapper.tpl.php
 * Default theme implementation to wrap comments.
 *
 * Available variables:
 * - $content: All comments for a given page. Also contains sorting controls
 *   and comment forms if the site is configured for it.
 *
 * The following variables are provided for contextual information.
 * - $node: Node object the comments are attached to.
 * The constants below the variables show the possible values and should be
 * used for comparison.
 * - $display_mode
 *   - COMMENT_MODE_FLAT_COLLAPSED
 *   - COMMENT_MODE_FLAT_EXPANDED
 *   - COMMENT_MODE_THREADED_COLLAPSED
 *   - COMMENT_MODE_THREADED_EXPANDED
 * - $display_order
 *   - COMMENT_ORDER_NEWEST_FIRST
 *   - COMMENT_ORDER_OLDEST_FIRST
 * - $comment_controls_state
 *   - COMMENT_CONTROLS_ABOVE
 *   - COMMENT_CONTROLS_BELOW
 *   - COMMENT_CONTROLS_ABOVE_BELOW
 *   - COMMENT_CONTROLS_HIDDEN
 *
 * @see template_preprocess_comment_wrapper()
 * @see theme_comment_wrapper()
 */
?>

<?php if ($content) : ?>
<div id="comments" class="block rounded-block">
  <div class="rounded-block-top-left"></div>
  <div class="rounded-block-top-right"></div>
  <div class="rounded-outside">
    <div class="rounded-inside">
      <p class="rounded-topspace"></p>
      <div class="comments-block-icon pngfix"></div>
      <h2 class="comments"><?php print t('Comments'); ?></h2>
      <?php print $content; ?>
      <p class="rounded-bottomspace"></p>
    </div>
  </div>
  <div class="rounded-block-bottom-left"></div>
  <div class="rounded-block-bottom-right"></div>
</div>
<?php endif; ?>
