<?php
#################################################################
#  Copyright notice
#
#  (c) 2012 Jérôme Schneider <mail@jeromeschneider.fr>
#  All rights reserved
#
#  http://baikal.codr.fr
#
#  This script is part of the Baïkal Server project. The Baïkal
#  Server project is free software; you can redistribute it
#  and/or modify it under the terms of the GNU General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
#
#  The GNU General Public License can be found at
#  http://www.gnu.org/copyleft/gpl.html.
#
#  This script is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  This copyright notice MUST APPEAR in all copies of the script!
#################################################################

namespace BaikalAdmin\Route\User;

class AddressBooks extends \Flake\Core\Route {
	
	public static function layout(\Flake\Core\Render\Container &$oRenderContainer) {
		$oRenderContainer->zone("Payload")->addBlock(new \BaikalAdmin\Controller\User\AddressBooks(
			self::getParams()
		));
	}
	
	public static function parametersMap() {
		return array(
			"user" => array(
				"required" => TRUE,
			),
			"new" => array(
				"required" => FALSE,
			),
			"edit" => array(
				"required" => FALSE,
			),
			"delete" => array(
				"required" => FALSE,
			),
			"confirm" => array(
				"required" => FALSE,
			),
		);
	}
}