/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.util;

import java.util.HashMap;

public class ColorUtil {
    private static final int[] defaultColors = new int[]{0xF0F8FF, 16444375, 65535, 8388564, 0xF0FFFF, 16119260, 16770244, 0, 16772045, 255, 9055202, 0xA52A2A, 14596231, 6266528, 0x7FFF00, 13789470, 16744272, 6591981, 16775388, 14423100, 65535, 139, 35723, 12092939, 0xA9A9A9, 25600, 0xA9A9A9, 12433259, 0x8B008B, 5597999, 16747520, 10040012, 0x8B0000, 15308410, 9419919, 4734347, 0x2F4F4F, 0x2F4F4F, 52945, 9699539, 16716947, 49151, 0x696969, 0x696969, 2003199, 0xB22222, 0xFFFAF0, 0x228B22, 0xFF00FF, 0xDCDCDC, 0xF8F8FF, 16766720, 14329120, 0x808080, 0x808080, 32768, 11403055, 0xF0FFF0, 16738740, 0xCD5C5C, 4915330, 0xFFFFF0, 15787660, 15132410, 0xFFF0F5, 8190976, 16775885, 11393254, 0xF08080, 0xE0FFFF, 16448210, 0xD3D3D3, 0x90EE90, 0xD3D3D3, 16758465, 16752762, 2142890, 8900346, 0x778899, 0x778899, 11584734, 0xFFFFE0, 65280, 3329330, 16445670, 0xFF00FF, 0x800000, 6737322, 205, 12211667, 9662683, 3978097, 8087790, 64154, 4772300, 13047173, 1644912, 0xF5FFFA, 16770273, 16770229, 16768685, 128, 16643558, 0x808000, 7048739, 16753920, 16729344, 14315734, 0xEEE8AA, 10025880, 0xAFEEEE, 14381203, 16773077, 16767673, 13468991, 16761035, 0xDDA0DD, 11591910, 0x800080, 0xFF0000, 12357519, 4286945, 9127187, 16416882, 16032864, 3050327, 0xFFF5EE, 10506797, 0xC0C0C0, 8900331, 6970061, 7372944, 7372944, 0xFFFAFA, 65407, 4620980, 13808780, 32896, 14204888, 16737095, 4251856, 0xEE82EE, 16113331, 0xFFFFFF, 0xF5F5F5, 0xFFFF00, 10145074};
    private static final HashMap colors = new HashMap();

    public static final String convertColorNameToRGB(String string) {
        int n = ColorUtil.convertNamedColor(string.toLowerCase());
        if (n >= 0) {
            char[] cArray = new char[7];
            cArray[0] = 35;
            int n2 = 1;
            for (int i = 20; i >= 0; i -= 4) {
                int n3 = 0xF & n >> i;
                cArray[n2] = (char)(n3 < 10 ? n3 + 48 : n3 + 65 - 10);
                ++n2;
            }
            string = new String(cArray, 0, 7);
        }
        return string;
    }

    public static int convertColor(String string) {
        try {
            if (string.startsWith("#")) {
                string = string.substring(1);
            }
            return Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            return ColorUtil.convertNamedColor(string);
        }
    }

    public static final int convertNamedColor(String string) {
        int n = ColorUtil.getDefaultColorIndex(string);
        if (n >= 0) {
            return defaultColors[n];
        }
        Integer n2 = (Integer)colors.get(string);
        if (n2 != null) {
            return n2;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final int getDefaultColorIndex(String string) {
        int n = 0;
        String string2 = null;
        block0 : switch (string.length()) {
            case 3: {
                char c = string.charAt(0);
                if (c == 'r') {
                    if (string.charAt(2) != 'd' || string.charAt(1) != 'e') break;
                    return 119;
                }
                if (c != 't' || string.charAt(2) != 'n' || string.charAt(1) != 'a') break;
                return 136;
            }
            case 4: {
                switch (string.charAt(3)) {
                    case 'a': {
                        string2 = "aqua";
                        n = 3;
                        break;
                    }
                    case 'd': {
                        string2 = "gold";
                        n = 52;
                        break;
                    }
                    case 'e': {
                        char c = string.charAt(0);
                        if (c == 'b') {
                            if (string.charAt(2) != 'u' || string.charAt(1) != 'l') break;
                            return 9;
                        }
                        if (c != 'l' || string.charAt(2) != 'm' || string.charAt(1) != 'i') break;
                        return 82;
                    }
                    case 'k': {
                        string2 = "pink";
                        n = 116;
                        break;
                    }
                    case 'l': {
                        string2 = "teal";
                        n = 138;
                        break;
                    }
                    case 'm': {
                        string2 = "plum";
                        n = 117;
                        break;
                    }
                    case 'n': {
                        string2 = "cyan";
                        n = 21;
                        break;
                    }
                    case 'u': {
                        string2 = "peru";
                        n = 115;
                        break;
                    }
                    case 'w': {
                        string2 = "snow";
                        n = 134;
                        break;
                    }
                    case 'y': {
                        char c = string.charAt(2);
                        if (c == 'a') {
                            if (string.charAt(0) != 'g' || string.charAt(1) != 'r') break;
                            return 53;
                        }
                        if (c == 'e') {
                            if (string.charAt(0) != 'g' || string.charAt(1) != 'r') break;
                            return 54;
                        }
                        if (c != 'v' || string.charAt(0) != 'n' || string.charAt(1) != 'a') break;
                        return 101;
                    }
                }
                break;
            }
            case 5: {
                switch (string.charAt(0)) {
                    case 'a': {
                        string2 = "azure";
                        n = 5;
                        break;
                    }
                    case 'b': {
                        char c = string.charAt(4);
                        if (c == 'e') {
                            string2 = "beige";
                            n = 6;
                            break;
                        }
                        if (c == 'k') {
                            string2 = "black";
                            n = 8;
                            break;
                        }
                        if (c != 'n') break;
                        string2 = "brown";
                        n = 12;
                        break;
                    }
                    case 'c': {
                        string2 = "coral";
                        n = 17;
                        break;
                    }
                    case 'g': {
                        string2 = "green";
                        n = 56;
                        break;
                    }
                    case 'i': {
                        string2 = "ivory";
                        n = 62;
                        break;
                    }
                    case 'k': {
                        string2 = "khaki";
                        n = 63;
                        break;
                    }
                    case 'l': {
                        string2 = "linen";
                        n = 85;
                        break;
                    }
                    case 'o': {
                        string2 = "olive";
                        n = 104;
                        break;
                    }
                    case 'w': {
                        char c = string.charAt(4);
                        if (c == 'e') {
                            string2 = "white";
                            n = 144;
                            break;
                        }
                        if (c != 't') break;
                        string2 = "wheat";
                        n = 143;
                        break;
                    }
                }
                break;
            }
            case 6: {
                switch (string.charAt(3)) {
                    case 'a': {
                        string2 = "tomato";
                        n = 140;
                        break;
                    }
                    case 'h': {
                        string2 = "orchid";
                        n = 108;
                        break;
                    }
                    case 'i': {
                        string2 = "indigo";
                        n = 61;
                        break;
                    }
                    case 'l': {
                        char c = string.charAt(0);
                        if (c == 'v') {
                            string2 = "violet";
                            n = 142;
                            break;
                        }
                        if (c != 'y') break;
                        string2 = "yellow";
                        n = 146;
                        break;
                    }
                    case 'm': {
                        string2 = "salmon";
                        n = 124;
                        break;
                    }
                    case 'n': {
                        char c = string.charAt(0);
                        if (c == 'o') {
                            string2 = "orange";
                            n = 106;
                            break;
                        }
                        if (c != 's') break;
                        string2 = "sienna";
                        n = 128;
                        break;
                    }
                    case 'o': {
                        string2 = "maroon";
                        n = 87;
                        break;
                    }
                    case 'p': {
                        string2 = "purple";
                        n = 119;
                        break;
                    }
                    case 'q': {
                        string2 = "bisque";
                        n = 7;
                        break;
                    }
                    case 'v': {
                        string2 = "silver";
                        n = 129;
                        break;
                    }
                }
                break;
            }
            case 7: {
                switch (string.charAt(3)) {
                    case 'b': {
                        string2 = "skyblue";
                        n = 130;
                        break;
                    }
                    case 'e': {
                        string2 = "magenta";
                        n = 86;
                        break;
                    }
                    case 'g': {
                        char c = string.charAt(5);
                        if (c == 'a') {
                            string2 = "dimgray";
                            n = 43;
                            break;
                        }
                        if (c != 'e') break;
                        string2 = "dimgrey";
                        n = 44;
                        break;
                    }
                    case 'h': {
                        string2 = "fuchsia";
                        n = 49;
                        break;
                    }
                    case 'k': {
                        string2 = "darkred";
                        n = 33;
                        break;
                    }
                    case 'l': {
                        string2 = "oldlace";
                        n = 103;
                        break;
                    }
                    case 'm': {
                        string2 = "crimson";
                        n = 20;
                        break;
                    }
                    case 'p': {
                        string2 = "hotpink";
                        n = 59;
                        break;
                    }
                    case 's': {
                        string2 = "thistle";
                        n = 139;
                        break;
                    }
                }
                break;
            }
            case 8: {
                switch (string.charAt(4)) {
                    case 'a': {
                        string2 = "moccasin";
                        n = 100;
                        break;
                    }
                    case 'b': {
                        string2 = "darkblue";
                        n = 22;
                        break;
                    }
                    case 'c': {
                        string2 = "darkcyan";
                        n = 23;
                        break;
                    }
                    case 'g': {
                        char c = string.charAt(6);
                        if (c == 'a') {
                            string2 = "darkgray";
                            n = 25;
                            break;
                        }
                        if (c != 'e') break;
                        string2 = "darkgrey";
                        n = 27;
                        break;
                    }
                    case 'h': {
                        string2 = "seashell";
                        n = 127;
                        break;
                    }
                    case 'n': {
                        string2 = "lavender";
                        n = 64;
                        break;
                    }
                    case 'p': {
                        string2 = "deeppink";
                        n = 41;
                        break;
                    }
                    case 'r': {
                        string2 = "seagreen";
                        n = 126;
                        break;
                    }
                    case 's': {
                        string2 = "cornsilk";
                        n = 19;
                        break;
                    }
                    case 'y': {
                        string2 = "honeydew";
                        n = 58;
                        break;
                    }
                }
                break;
            }
            case 9: {
                switch (string.charAt(0)) {
                    case 'a': {
                        string2 = "aliceblue";
                        n = 1;
                        break;
                    }
                    case 'b': {
                        string2 = "burlywood";
                        n = 13;
                        break;
                    }
                    case 'c': {
                        char c = string.charAt(1);
                        if (c == 'a') {
                            string2 = "cadetblue";
                            n = 14;
                            break;
                        }
                        if (c != 'h') break;
                        string2 = "chocolate";
                        n = 16;
                        break;
                    }
                    case 'd': {
                        char c = string.charAt(8);
                        if (c == 'i') {
                            string2 = "darkkhaki";
                            n = 28;
                            break;
                        }
                        if (c != 'n') break;
                        string2 = "darkgreen";
                        n = 26;
                        break;
                    }
                    case 'f': {
                        string2 = "firebrick";
                        n = 46;
                        break;
                    }
                    case 'g': {
                        char c = string.charAt(8);
                        if (c == 'd') {
                            string2 = "goldenrod";
                            n = 53;
                            break;
                        }
                        if (c != 'o') break;
                        string2 = "gainsboro";
                        n = 50;
                        break;
                    }
                    case 'i': {
                        string2 = "indianred";
                        n = 60;
                        break;
                    }
                    case 'l': {
                        switch (string.charAt(5)) {
                            case 'b': {
                                string2 = "lightblue";
                                n = 68;
                                break;
                            }
                            case 'c': {
                                string2 = "lightcyan";
                                n = 70;
                                break;
                            }
                            case 'g': {
                                char c = string.charAt(7);
                                if (c == 'a') {
                                    string2 = "lightgray";
                                    n = 72;
                                    break;
                                }
                                if (c != 'e') break;
                                string2 = "lightgrey";
                                n = 74;
                                break;
                            }
                            case 'p': {
                                string2 = "lightpink";
                                n = 75;
                                break;
                            }
                            case 'r': {
                                char c = string.charAt(1);
                                if (c == 'a') {
                                    string2 = "lawngreen";
                                    n = 66;
                                    break;
                                }
                                if (c != 'i') break;
                                string2 = "limegreen";
                                n = 84;
                                break;
                            }
                        }
                        break;
                    }
                    case 'm': {
                        char c = string.charAt(8);
                        if (c == 'e') {
                            string2 = "mistyrose";
                            n = 99;
                            break;
                        }
                        if (c != 'm') break;
                        string2 = "mintcream";
                        n = 98;
                        break;
                    }
                    case 'o': {
                        char c = string.charAt(8);
                        if (c == 'b') {
                            string2 = "olivedrab";
                            n = 105;
                            break;
                        }
                        if (c != 'd') break;
                        string2 = "orangered";
                        n = 107;
                        break;
                    }
                    case 'p': {
                        char c = string.charAt(8);
                        if (c == 'f') {
                            string2 = "peachpuff";
                            n = 114;
                            break;
                        }
                        if (c != 'n') break;
                        string2 = "palegreen";
                        n = 110;
                        break;
                    }
                    case 'r': {
                        char c = string.charAt(8);
                        if (c == 'e') {
                            string2 = "royalblue";
                            n = 122;
                            break;
                        }
                        if (c != 'n') break;
                        string2 = "rosybrown";
                        n = 121;
                        break;
                    }
                    case 's': {
                        char c = string.charAt(7);
                        if (c == 'a') {
                            string2 = "slategray";
                            n = 132;
                            break;
                        }
                        if (c == 'e') {
                            string2 = "slategrey";
                            n = 133;
                            break;
                        }
                        if (c != 'u') break;
                        c = string.charAt(1);
                        if (c == 'l') {
                            string2 = "slateblue";
                            n = 131;
                            break;
                        }
                        if (c != 't') break;
                        string2 = "steelblue";
                        n = 136;
                        break;
                    }
                    case 't': {
                        string2 = "turquoise";
                        n = 141;
                        break;
                    }
                }
                break;
            }
            case 10: {
                switch (string.charAt(8)) {
                    case 'a': {
                        string2 = "lightcoral";
                        n = 69;
                        break;
                    }
                    case 'e': {
                        char c = string.charAt(0);
                        if (c == 'b') {
                            string2 = "blueviolet";
                            n = 11;
                            break;
                        }
                        if (c == 'd') {
                            string2 = "darkviolet";
                            n = 40;
                            break;
                        }
                        if (c != 'l') break;
                        string2 = "lightgreen";
                        n = 73;
                        break;
                    }
                    case 'g': {
                        string2 = "darkorange";
                        n = 31;
                        break;
                    }
                    case 'i': {
                        char c = string.charAt(0);
                        if (c == 'd') {
                            string2 = "darkorchid";
                            n = 32;
                            break;
                        }
                        if (c != 'p') break;
                        string2 = "papayawhip";
                        n = 113;
                        break;
                    }
                    case 'k': {
                        string2 = "whitesmoke";
                        n = 145;
                        break;
                    }
                    case 'n': {
                        string2 = "aquamarine";
                        n = 4;
                        break;
                    }
                    case 'o': {
                        string2 = "darksalmon";
                        n = 34;
                        break;
                    }
                    case 's': {
                        string2 = "chartreuse";
                        n = 15;
                        break;
                    }
                    case 't': {
                        string2 = "ghostwhite";
                        n = 51;
                        break;
                    }
                    case 'u': {
                        char c = string.charAt(0);
                        if (c == 'd') {
                            string2 = "dodgerblue";
                            n = 45;
                            break;
                        }
                        if (c == 'm') {
                            string2 = "mediumblue";
                            n = 89;
                            break;
                        }
                        if (c != 'p') break;
                        string2 = "powderblue";
                        n = 118;
                        break;
                    }
                    case 'w': {
                        string2 = "sandybrown";
                        n = 125;
                        break;
                    }
                }
                break;
            }
            case 11: {
                switch (string.charAt(5)) {
                    case 'a': {
                        string2 = "darkmagenta";
                        n = 29;
                        break;
                    }
                    case 'e': {
                        string2 = "saddlebrown";
                        n = 123;
                        break;
                    }
                    case 'g': {
                        string2 = "springgreen";
                        n = 135;
                        break;
                    }
                    case 'k': {
                        string2 = "deepskyblue";
                        n = 42;
                        break;
                    }
                    case 'l': {
                        string2 = "floralwhite";
                        n = 47;
                        break;
                    }
                    case 'o': {
                        string2 = "navajowhite";
                        n = 101;
                        break;
                    }
                    case 's': {
                        string2 = "lightsalmon";
                        n = 76;
                        break;
                    }
                    case 't': {
                        string2 = "forestgreen";
                        n = 48;
                        break;
                    }
                    case 'w': {
                        string2 = "yellowgreen";
                        n = 147;
                        break;
                    }
                    case 'y': {
                        char c = string.charAt(0);
                        if (c == 'g') {
                            string2 = "greenyellow";
                            n = 57;
                            break;
                        }
                        if (c != 'l') break;
                        string2 = "lightyellow";
                        n = 82;
                        break;
                    }
                }
                break;
            }
            case 12: {
                switch (string.charAt(7)) {
                    case 'g': {
                        string2 = "darkseagreen";
                        n = 35;
                        break block0;
                    }
                    case 'i': {
                        string2 = "lemonchiffon";
                        n = 67;
                        break block0;
                    }
                    case 'r': {
                        string2 = "mediumorchid";
                        n = 90;
                        break block0;
                    }
                    case 't': {
                        string2 = "midnightblue";
                        n = 97;
                        break block0;
                    }
                    case 'u': {
                        string2 = "mediumpurple";
                        n = 91;
                        break block0;
                    }
                    case 'w': {
                        string2 = "antiquewhite";
                        n = 2;
                        break block0;
                    }
                    case 'y': {
                        string2 = "lightskyblue";
                        n = 78;
                        break block0;
                    }
                }
                break;
            }
            case 13: {
                switch (string.charAt(9)) {
                    case 'b': {
                        string2 = "darkslateblue";
                        n = 36;
                        break;
                    }
                    case 'g': {
                        char c = string.charAt(11);
                        if (c == 'a') {
                            string2 = "darkslategray";
                            n = 37;
                            break;
                        }
                        if (c != 'e') break;
                        string2 = "darkslategrey";
                        n = 38;
                        break;
                    }
                    case 'l': {
                        string2 = "lavenderblush";
                        n = 65;
                        break;
                    }
                    case 'n': {
                        char c = string.charAt(0);
                        if (c == 'd') {
                            string2 = "darkgoldenrod";
                            n = 24;
                            break;
                        }
                        if (c != 'p') break;
                        string2 = "palegoldenrod";
                        n = 109;
                        break;
                    }
                    case 'o': {
                        char c = string.charAt(0);
                        if (c == 'd') {
                            string2 = "darkturquoise";
                            n = 39;
                            break;
                        }
                        if (c != 'p') break;
                        string2 = "paleturquoise";
                        n = 111;
                        break;
                    }
                    case 'r': {
                        string2 = "lightseagreen";
                        n = 77;
                        break;
                    }
                    case 't': {
                        string2 = "palevioletred";
                        n = 112;
                        break;
                    }
                }
                break;
            }
            case 14: {
                switch (string.charAt(6)) {
                    case 'e': {
                        string2 = "blanchedalmond";
                        n = 9;
                        break;
                    }
                    case 'i': {
                        string2 = "darkolivegreen";
                        n = 30;
                        break;
                    }
                    case 'l': {
                        char c = string.charAt(12);
                        if (c == 'a') {
                            string2 = "lightslategray";
                            n = 79;
                            break;
                        }
                        if (c != 'e') break;
                        string2 = "lightslategrey";
                        n = 80;
                        break;
                    }
                    case 'o': {
                        string2 = "cornflowerblue";
                        n = 18;
                        break;
                    }
                    case 's': {
                        string2 = "mediumseagreen";
                        n = 92;
                        break;
                    }
                    case 't': {
                        string2 = "lightsteelblue";
                        n = 81;
                        break;
                    }
                }
                break;
            }
            case 15: {
                char c = string.charAt(6);
                if (c == 's') {
                    string2 = "mediumslateblue";
                    n = 93;
                    break;
                }
                if (c == 't') {
                    string2 = "mediumturquoise";
                    n = 95;
                    break;
                }
                if (c != 'v') break;
                string2 = "mediumvioletred";
                n = 96;
                break;
            }
            case 16: {
                string2 = "mediumaquamarine";
                n = 88;
                break;
            }
            case 17: {
                string2 = "mediumspringgreen";
                n = 94;
                break;
            }
            case 20: {
                string2 = "lightgoldenrodyellow";
                n = 71;
            }
        }
        if (string2 == null) return n - 1;
        if (string2 == string) return n - 1;
        if (string2.equals(string)) return n - 1;
        return -1;
    }
}

