/*
 * Decompiled with CFR 0.152.
 */
package railo.extension.io.log.sl4j;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import railo.commons.io.log.LogAndSource;
import railo.extension.io.log.sl4j.LoggerAdapterConsole;
import railo.extension.io.log.sl4j.LoggerAdapterImpl;
import railo.loader.engine.CFMLEngine;
import railo.loader.engine.CFMLEngineFactory;
import railo.runtime.PageContext;
import railo.runtime.config.ConfigWeb;

public class LoggerFactoryImpl
implements ILoggerFactory {
    Map<String, Logger> loggerMap = new HashMap<String, Logger>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Logger getLogger(String name) {
        Object logger = null;
        LoggerFactoryImpl loggerFactoryImpl = this;
        synchronized (loggerFactoryImpl) {
            if (name.equalsIgnoreCase("ROOT")) {
                name = "";
            }
            if ((logger = this.loggerMap.get(name)) == null) {
                PageContext pc;
                CFMLEngine engine = LoggerFactoryImpl.getCFMLEngine();
                ConfigWeb config = null;
                if (engine != null && (pc = engine.getThreadPageContext()) != null) {
                    config = pc.getConfig();
                }
                if (config == null) {
                    logger = new LoggerAdapterConsole(name, 3);
                } else if (name != null && name.startsWith("org.hibernate")) {
                    try {
                        Method getORMLogger = config.getClass().getMethod("getORMLogger", new Class[0]);
                        logger = new LoggerAdapterImpl((LogAndSource)getORMLogger.invoke((Object)config, new Object[0]), name);
                    }
                    catch (Throwable t) {
                        logger = new LoggerAdapterConsole(name, 3);
                    }
                } else {
                    logger = new LoggerAdapterImpl(config.getApplicationLogger(), name);
                }
                this.loggerMap.put(name, (Logger)logger);
            }
        }
        return logger;
    }

    public static CFMLEngine getCFMLEngine() {
        try {
            return CFMLEngineFactory.getInstance();
        }
        catch (Throwable t) {
            return null;
        }
    }
}

