/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.generators;

import java.math.BigInteger;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import org.bouncycastle.crypto.params.DHParameters;
import org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.bouncycastle.crypto.params.DHPublicKeyParameters;

public class DHBasicKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
    private DHKeyGenerationParameters param;

    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (DHKeyGenerationParameters)keyGenerationParameters;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHParameters dHParameters = this.param.getParameters();
        BigInteger bigInteger = dHParameters.getP();
        BigInteger bigInteger2 = this.helper.calculatePrivate(bigInteger, this.param.getRandom(), dHParameters.getJ());
        BigInteger bigInteger3 = this.helper.calculatePublic(bigInteger, dHParameters.getG(), bigInteger2);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(bigInteger3, dHParameters), new DHPrivateKeyParameters(bigInteger2, dHParameters));
    }
}

