/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.utils;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class MultiStringFieldEditor
extends StringFieldEditor {
    private int textLimit = UNLIMITED;
    private int validateStrategy = 0;
    Text textField;

    public MultiStringFieldEditor(String name, String labelText, Composite parent) {
        super(name, labelText, parent);
    }

    public Text getTextControl(Composite parent) {
        if (this.textField == null) {
            this.textField = new Text(parent, 2818);
            this.textField.setFont(parent.getFont());
            switch (this.validateStrategy) {
                case 0: {
                    this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyReleased(KeyEvent e) {
                            MultiStringFieldEditor.this.valueChanged();
                        }
                    });
                    break;
                }
                case 1: {
                    this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent e) {
                            MultiStringFieldEditor.this.clearErrorMessage();
                        }
                    });
                    this.textField.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusGained(FocusEvent e) {
                            MultiStringFieldEditor.this.refreshValidState();
                        }

                        public void focusLost(FocusEvent e) {
                            MultiStringFieldEditor.this.valueChanged();
                            MultiStringFieldEditor.this.clearErrorMessage();
                        }
                    });
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"Unknown validate strategy");
                }
            }
            this.textField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    MultiStringFieldEditor.this.textField = null;
                }
            });
            if (this.textLimit > 0) {
                this.textField.setTextLimit(this.textLimit);
            }
        } else {
            this.checkParent((Control)this.textField, parent);
        }
        return this.textField;
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.textField.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns);
        this.adjustForNumColumns(numColumns);
    }
}

