/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.python.pydev.editor.ActionInfo;
import org.python.pydev.editor.actions.OfflineActionTarget;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OfflineActionsManager {
    Map<String, ActionInfo> onOfflineActionListeners = new HashMap<String, ActionInfo>();

    public Collection<ActionInfo> getOfflineActionDescriptions() {
        return this.onOfflineActionListeners.values();
    }

    public void addOfflineActionListener(String key, IAction action) {
        this.onOfflineActionListeners.put(key.toLowerCase(), new ActionInfo(action, "not described", key.toLowerCase(), true));
    }

    public void addOfflineActionListener(String key, IAction action, String description, boolean needsEnter) {
        this.onOfflineActionListeners.put(key.toLowerCase(), new ActionInfo(action, description, key.toLowerCase(), needsEnter));
    }

    public boolean activatesAutomaticallyOn(String key) {
        ActionInfo info = this.onOfflineActionListeners.get(key.toLowerCase());
        return info != null && !info.needsEnter;
    }

    public boolean onOfflineAction(String requestedStr, OfflineActionTarget target) {
        ActionInfo actionInfo = this.onOfflineActionListeners.get(requestedStr.toLowerCase());
        if (actionInfo == null) {
            target.statusError(new StringBuffer("No action was found binded to:").append(requestedStr).toString());
            return false;
        }
        IAction action = actionInfo.action;
        if (action == null) {
            target.statusError(new StringBuffer("No action was found binded to:").append(requestedStr).toString());
            return false;
        }
        try {
            action.run();
        }
        catch (Throwable e) {
            target.statusError(new StringBuffer("Exception raised when executing action:").append(requestedStr).append(" - ").append(e.getMessage()).toString());
            PydevPlugin.log(e);
            return false;
        }
        return true;
    }
}

