/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.core.change;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.python.pydev.refactoring.core.RefactoringInfo;
import org.python.pydev.refactoring.core.change.IChangeProcessor;
import org.python.pydev.refactoring.core.edit.AbstractTextEdit;
import org.python.pydev.refactoring.core.request.IRefactoringRequest;
import org.python.pydev.refactoring.core.request.IRequestProcessor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileChangeProcessor<T extends IRefactoringRequest>
implements IChangeProcessor {
    private TextChange change;
    protected MultiTextEdit multiEdit;
    private String name;
    private IFile file;
    protected IRequestProcessor<T> requestProcessor;

    protected abstract void processEdit();

    public AbstractFileChangeProcessor(String name, RefactoringInfo info, IRequestProcessor<T> requestProcessor) {
        this.name = name;
        this.file = info.getSourceFile();
        this.requestProcessor = requestProcessor;
    }

    @Override
    public Change createChange() {
        this.change = new TextFileChange(this.name, this.file);
        this.multiEdit = new MultiTextEdit();
        this.change.setEdit((TextEdit)this.multiEdit);
        this.processEdit();
        return this.change;
    }

    protected void addEdit(TextEdit edit) {
        this.multiEdit.addChild(edit);
    }

    protected void addGroup(TextEditGroup group) {
        this.change.addTextEditGroup(group);
    }

    protected void registerEdit(AbstractTextEdit edit, String message) {
        TextEditGroup editGroup = new TextEditGroup(message);
        this.addGroup(editGroup);
        this.registerEditInGroup(edit, editGroup);
    }

    protected void registerEdit(List<AbstractTextEdit> edits, String message) {
        TextEditGroup group = new TextEditGroup(message);
        this.addGroup(group);
        for (AbstractTextEdit edit : edits) {
            this.registerEditInGroup(edit, group);
        }
    }

    private void registerEditInGroup(AbstractTextEdit edit, TextEditGroup editGroup) {
        TextEdit textEdit = edit.getEdit();
        editGroup.addTextEdit(textEdit);
        this.addEdit(textEdit);
    }
}

