/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Duration;
import net.sf.mpxj.EarnedValueMethod;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectEntity;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.RecurringTask;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.SubProject;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskMode;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.listener.FieldListener;
import net.sf.mpxj.utility.BooleanUtility;
import net.sf.mpxj.utility.DateUtility;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Task
extends ProjectEntity
implements Comparable<Task>,
FieldContainer {
    private Object[] m_array = new Object[TaskField.MAX_VALUE];
    private Task m_parent;
    private List<Task> m_children = new LinkedList<Task>();
    private List<ResourceAssignment> m_assignments = new LinkedList<ResourceAssignment>();
    private RecurringTask m_recurringTask;
    private static final TaskField[] ENTERPRISE_COST_FIELDS = new TaskField[]{TaskField.ENTERPRISE_COST1, TaskField.ENTERPRISE_COST2, TaskField.ENTERPRISE_COST3, TaskField.ENTERPRISE_COST4, TaskField.ENTERPRISE_COST5, TaskField.ENTERPRISE_COST6, TaskField.ENTERPRISE_COST7, TaskField.ENTERPRISE_COST8, TaskField.ENTERPRISE_COST9, TaskField.ENTERPRISE_COST10};
    private static final TaskField[] ENTERPRISE_DATE_FIELDS = new TaskField[]{TaskField.ENTERPRISE_DATE1, TaskField.ENTERPRISE_DATE2, TaskField.ENTERPRISE_DATE3, TaskField.ENTERPRISE_DATE4, TaskField.ENTERPRISE_DATE5, TaskField.ENTERPRISE_DATE6, TaskField.ENTERPRISE_DATE7, TaskField.ENTERPRISE_DATE8, TaskField.ENTERPRISE_DATE9, TaskField.ENTERPRISE_DATE10, TaskField.ENTERPRISE_DATE11, TaskField.ENTERPRISE_DATE12, TaskField.ENTERPRISE_DATE13, TaskField.ENTERPRISE_DATE14, TaskField.ENTERPRISE_DATE15, TaskField.ENTERPRISE_DATE16, TaskField.ENTERPRISE_DATE17, TaskField.ENTERPRISE_DATE18, TaskField.ENTERPRISE_DATE19, TaskField.ENTERPRISE_DATE20, TaskField.ENTERPRISE_DATE21, TaskField.ENTERPRISE_DATE22, TaskField.ENTERPRISE_DATE23, TaskField.ENTERPRISE_DATE24, TaskField.ENTERPRISE_DATE25, TaskField.ENTERPRISE_DATE26, TaskField.ENTERPRISE_DATE27, TaskField.ENTERPRISE_DATE28, TaskField.ENTERPRISE_DATE29, TaskField.ENTERPRISE_DATE30};
    private static final TaskField[] ENTERPRISE_DURATION_FIELDS = new TaskField[]{TaskField.ENTERPRISE_DURATION1, TaskField.ENTERPRISE_DURATION2, TaskField.ENTERPRISE_DURATION3, TaskField.ENTERPRISE_DURATION4, TaskField.ENTERPRISE_DURATION5, TaskField.ENTERPRISE_DURATION6, TaskField.ENTERPRISE_DURATION7, TaskField.ENTERPRISE_DURATION8, TaskField.ENTERPRISE_DURATION9, TaskField.ENTERPRISE_DURATION10};
    private static final TaskField[] ENTERPRISE_FLAG_FIELDS = new TaskField[]{TaskField.ENTERPRISE_FLAG1, TaskField.ENTERPRISE_FLAG2, TaskField.ENTERPRISE_FLAG3, TaskField.ENTERPRISE_FLAG4, TaskField.ENTERPRISE_FLAG5, TaskField.ENTERPRISE_FLAG6, TaskField.ENTERPRISE_FLAG7, TaskField.ENTERPRISE_FLAG8, TaskField.ENTERPRISE_FLAG9, TaskField.ENTERPRISE_FLAG10, TaskField.ENTERPRISE_FLAG11, TaskField.ENTERPRISE_FLAG12, TaskField.ENTERPRISE_FLAG13, TaskField.ENTERPRISE_FLAG14, TaskField.ENTERPRISE_FLAG15, TaskField.ENTERPRISE_FLAG16, TaskField.ENTERPRISE_FLAG17, TaskField.ENTERPRISE_FLAG18, TaskField.ENTERPRISE_FLAG19, TaskField.ENTERPRISE_FLAG20};
    private static final TaskField[] ENTERPRISE_NUMBER_FIELDS = new TaskField[]{TaskField.ENTERPRISE_NUMBER1, TaskField.ENTERPRISE_NUMBER2, TaskField.ENTERPRISE_NUMBER3, TaskField.ENTERPRISE_NUMBER4, TaskField.ENTERPRISE_NUMBER5, TaskField.ENTERPRISE_NUMBER6, TaskField.ENTERPRISE_NUMBER7, TaskField.ENTERPRISE_NUMBER8, TaskField.ENTERPRISE_NUMBER9, TaskField.ENTERPRISE_NUMBER10, TaskField.ENTERPRISE_NUMBER11, TaskField.ENTERPRISE_NUMBER12, TaskField.ENTERPRISE_NUMBER13, TaskField.ENTERPRISE_NUMBER14, TaskField.ENTERPRISE_NUMBER15, TaskField.ENTERPRISE_NUMBER16, TaskField.ENTERPRISE_NUMBER17, TaskField.ENTERPRISE_NUMBER18, TaskField.ENTERPRISE_NUMBER19, TaskField.ENTERPRISE_NUMBER20, TaskField.ENTERPRISE_NUMBER21, TaskField.ENTERPRISE_NUMBER22, TaskField.ENTERPRISE_NUMBER23, TaskField.ENTERPRISE_NUMBER24, TaskField.ENTERPRISE_NUMBER25, TaskField.ENTERPRISE_NUMBER26, TaskField.ENTERPRISE_NUMBER27, TaskField.ENTERPRISE_NUMBER28, TaskField.ENTERPRISE_NUMBER29, TaskField.ENTERPRISE_NUMBER30, TaskField.ENTERPRISE_NUMBER31, TaskField.ENTERPRISE_NUMBER32, TaskField.ENTERPRISE_NUMBER33, TaskField.ENTERPRISE_NUMBER34, TaskField.ENTERPRISE_NUMBER35, TaskField.ENTERPRISE_NUMBER36, TaskField.ENTERPRISE_NUMBER37, TaskField.ENTERPRISE_NUMBER38, TaskField.ENTERPRISE_NUMBER39, TaskField.ENTERPRISE_NUMBER40};
    private static final TaskField[] ENTERPRISE_TEXT_FIELDS = new TaskField[]{TaskField.ENTERPRISE_TEXT1, TaskField.ENTERPRISE_TEXT2, TaskField.ENTERPRISE_TEXT3, TaskField.ENTERPRISE_TEXT4, TaskField.ENTERPRISE_TEXT5, TaskField.ENTERPRISE_TEXT6, TaskField.ENTERPRISE_TEXT7, TaskField.ENTERPRISE_TEXT8, TaskField.ENTERPRISE_TEXT9, TaskField.ENTERPRISE_TEXT10, TaskField.ENTERPRISE_TEXT11, TaskField.ENTERPRISE_TEXT12, TaskField.ENTERPRISE_TEXT13, TaskField.ENTERPRISE_TEXT14, TaskField.ENTERPRISE_TEXT15, TaskField.ENTERPRISE_TEXT16, TaskField.ENTERPRISE_TEXT17, TaskField.ENTERPRISE_TEXT18, TaskField.ENTERPRISE_TEXT19, TaskField.ENTERPRISE_TEXT20, TaskField.ENTERPRISE_TEXT21, TaskField.ENTERPRISE_TEXT22, TaskField.ENTERPRISE_TEXT23, TaskField.ENTERPRISE_TEXT24, TaskField.ENTERPRISE_TEXT25, TaskField.ENTERPRISE_TEXT26, TaskField.ENTERPRISE_TEXT27, TaskField.ENTERPRISE_TEXT28, TaskField.ENTERPRISE_TEXT29, TaskField.ENTERPRISE_TEXT30, TaskField.ENTERPRISE_TEXT31, TaskField.ENTERPRISE_TEXT32, TaskField.ENTERPRISE_TEXT33, TaskField.ENTERPRISE_TEXT34, TaskField.ENTERPRISE_TEXT35, TaskField.ENTERPRISE_TEXT36, TaskField.ENTERPRISE_TEXT37, TaskField.ENTERPRISE_TEXT38, TaskField.ENTERPRISE_TEXT39, TaskField.ENTERPRISE_TEXT40};
    private static final TaskField[] BASELINE_COSTS = new TaskField[]{TaskField.BASELINE1_COST, TaskField.BASELINE2_COST, TaskField.BASELINE3_COST, TaskField.BASELINE4_COST, TaskField.BASELINE5_COST, TaskField.BASELINE6_COST, TaskField.BASELINE7_COST, TaskField.BASELINE8_COST, TaskField.BASELINE9_COST, TaskField.BASELINE10_COST};
    private static final TaskField[] BASELINE_DURATIONS = new TaskField[]{TaskField.BASELINE1_DURATION, TaskField.BASELINE2_DURATION, TaskField.BASELINE3_DURATION, TaskField.BASELINE4_DURATION, TaskField.BASELINE5_DURATION, TaskField.BASELINE6_DURATION, TaskField.BASELINE7_DURATION, TaskField.BASELINE8_DURATION, TaskField.BASELINE9_DURATION, TaskField.BASELINE10_DURATION};
    private static final TaskField[] BASELINE_ESTIMATED_DURATIONS = new TaskField[]{TaskField.BASELINE1_ESTIMATED_DURATION, TaskField.BASELINE2_ESTIMATED_DURATION, TaskField.BASELINE3_ESTIMATED_DURATION, TaskField.BASELINE4_ESTIMATED_DURATION, TaskField.BASELINE5_ESTIMATED_DURATION, TaskField.BASELINE6_ESTIMATED_DURATION, TaskField.BASELINE7_ESTIMATED_DURATION, TaskField.BASELINE8_ESTIMATED_DURATION, TaskField.BASELINE9_ESTIMATED_DURATION, TaskField.BASELINE10_ESTIMATED_DURATION};
    private static final TaskField[] BASELINE_STARTS = new TaskField[]{TaskField.BASELINE1_START, TaskField.BASELINE2_START, TaskField.BASELINE3_START, TaskField.BASELINE4_START, TaskField.BASELINE5_START, TaskField.BASELINE6_START, TaskField.BASELINE7_START, TaskField.BASELINE8_START, TaskField.BASELINE9_START, TaskField.BASELINE10_START};
    private static final TaskField[] BASELINE_ESTIMATED_STARTS = new TaskField[]{TaskField.BASELINE1_ESTIMATED_START, TaskField.BASELINE2_ESTIMATED_START, TaskField.BASELINE3_ESTIMATED_START, TaskField.BASELINE4_ESTIMATED_START, TaskField.BASELINE5_ESTIMATED_START, TaskField.BASELINE6_ESTIMATED_START, TaskField.BASELINE7_ESTIMATED_START, TaskField.BASELINE8_ESTIMATED_START, TaskField.BASELINE9_ESTIMATED_START, TaskField.BASELINE10_ESTIMATED_START};
    private static final TaskField[] BASELINE_FINISHES = new TaskField[]{TaskField.BASELINE1_FINISH, TaskField.BASELINE2_FINISH, TaskField.BASELINE3_FINISH, TaskField.BASELINE4_FINISH, TaskField.BASELINE5_FINISH, TaskField.BASELINE6_FINISH, TaskField.BASELINE7_FINISH, TaskField.BASELINE8_FINISH, TaskField.BASELINE9_FINISH, TaskField.BASELINE10_FINISH};
    private static final TaskField[] BASELINE_ESTIMATED_FINISHES = new TaskField[]{TaskField.BASELINE1_ESTIMATED_FINISH, TaskField.BASELINE2_ESTIMATED_FINISH, TaskField.BASELINE3_ESTIMATED_FINISH, TaskField.BASELINE4_ESTIMATED_FINISH, TaskField.BASELINE5_ESTIMATED_FINISH, TaskField.BASELINE6_ESTIMATED_FINISH, TaskField.BASELINE7_ESTIMATED_FINISH, TaskField.BASELINE8_ESTIMATED_FINISH, TaskField.BASELINE9_ESTIMATED_FINISH, TaskField.BASELINE10_ESTIMATED_FINISH};
    private static final TaskField[] BASELINE_WORKS = new TaskField[]{TaskField.BASELINE1_WORK, TaskField.BASELINE2_WORK, TaskField.BASELINE3_WORK, TaskField.BASELINE4_WORK, TaskField.BASELINE5_WORK, TaskField.BASELINE6_WORK, TaskField.BASELINE7_WORK, TaskField.BASELINE8_WORK, TaskField.BASELINE9_WORK, TaskField.BASELINE10_WORK};
    private boolean m_eventsEnabled = true;
    private boolean m_null;
    private String m_wbsLevel;
    private boolean m_resumeValid;
    private String m_externalTaskProject;
    private TimeUnit m_levelingDelayFormat;
    private EarnedValueMethod m_earnedValueMethod;
    private Duration m_actualWorkProtected;
    private Duration m_actualOvertimeWorkProtected;
    private boolean m_expanded = true;
    private List<DateRange> m_splits;
    private Date m_splitsComplete;
    private SubProject m_subProject;
    private List<FieldListener> m_listeners;

    Task(ProjectFile projectFile, Task task) {
        super(projectFile);
        this.setType(TaskType.FIXED_UNITS);
        this.setConstraintType(ConstraintType.AS_SOON_AS_POSSIBLE);
        this.setTaskMode(TaskMode.AUTO_SCHEDULED);
        this.setActive(true);
        this.m_parent = task;
        if (projectFile.getAutoTaskUniqueID()) {
            this.setUniqueID(projectFile.getTaskUniqueID());
        }
        if (projectFile.getAutoTaskID()) {
            this.setID(projectFile.getTaskID());
        }
        if (projectFile.getAutoWBS()) {
            this.generateWBS(task);
        }
        if (projectFile.getAutoOutlineNumber()) {
            this.generateOutlineNumber(task);
        }
        if (projectFile.getAutoOutlineLevel()) {
            if (task == null) {
                this.setOutlineLevel(1);
            } else {
                this.setOutlineLevel(NumberUtility.getInt(task.getOutlineLevel()) + 1);
            }
        }
    }

    public void generateWBS(Task task) {
        String string;
        if (task == null) {
            string = NumberUtility.getInt(this.getUniqueID()) == 0 ? "0" : Integer.toString(this.getParentFile().getChildTaskCount() + 1);
        } else {
            string = task.getWBS();
            int n = string.lastIndexOf(".0");
            if (n != -1) {
                string = string.substring(0, n);
            }
            string = string.equals("0") ? Integer.toString(task.getChildTaskCount() + 1) : string + "." + (task.getChildTaskCount() + 1);
        }
        this.setWBS(string);
    }

    public void generateOutlineNumber(Task task) {
        String string;
        if (task == null) {
            string = NumberUtility.getInt(this.getUniqueID()) == 0 ? "0" : Integer.toString(this.getParentFile().getChildTaskCount() + 1);
        } else {
            string = task.getOutlineNumber();
            int n = string.lastIndexOf(".0");
            if (n != -1) {
                string = string.substring(0, n);
            }
            string = string.equals("0") ? Integer.toString(task.getChildTaskCount() + 1) : string + "." + (task.getChildTaskCount() + 1);
        }
        this.setOutlineNumber(string);
    }

    public void setNotes(String string) {
        this.set((FieldType)TaskField.NOTES, string);
    }

    public Task addTask() {
        ProjectFile projectFile = this.getParentFile();
        Task task = new Task(projectFile, this);
        this.m_children.add(task);
        projectFile.addTask(task);
        this.setSummary(true);
        return task;
    }

    public void addChildTask(Task task, int n) {
        int n2 = NumberUtility.getInt(this.getOutlineLevel());
        if (n2 + 1 == n) {
            this.m_children.add(task);
            this.setSummary(true);
        } else if (!this.m_children.isEmpty()) {
            this.m_children.get(this.m_children.size() - 1).addChildTask(task, n);
        }
    }

    public void addChildTask(Task task) {
        task.m_parent = this;
        this.m_children.add(task);
        this.setSummary(true);
        if (this.getParentFile().getAutoOutlineLevel()) {
            task.setOutlineLevel(NumberUtility.getInt(this.getOutlineLevel()) + 1);
        }
    }

    public void removeChildTask(Task task) {
        if (this.m_children.remove(task)) {
            task.m_parent = null;
        }
        this.setSummary(!this.m_children.isEmpty());
    }

    public void clearChildTasks() {
        this.m_children.clear();
        this.setSummary(false);
    }

    public RecurringTask addRecurringTask() {
        if (this.m_recurringTask == null) {
            this.m_recurringTask = new RecurringTask();
        }
        return this.m_recurringTask;
    }

    public RecurringTask getRecurringTask() {
        return this.m_recurringTask;
    }

    public ResourceAssignment addResourceAssignment(Resource resource) {
        ResourceAssignment resourceAssignment = this.getExistingResourceAssignment(resource);
        if (resourceAssignment == null) {
            resourceAssignment = new ResourceAssignment(this.getParentFile(), this);
            this.m_assignments.add(resourceAssignment);
            this.getParentFile().addResourceAssignment(resourceAssignment);
            resourceAssignment.setTaskUniqueID(this.getUniqueID());
            resourceAssignment.setWork(this.getDuration());
            resourceAssignment.setUnits(ResourceAssignment.DEFAULT_UNITS);
            if (resource != null) {
                resourceAssignment.setResourceUniqueID(resource.getUniqueID());
                resource.addResourceAssignment(resourceAssignment);
            }
        }
        return resourceAssignment;
    }

    public void addResourceAssignment(ResourceAssignment resourceAssignment) {
        if (this.getExistingResourceAssignment(resourceAssignment.getResource()) == null) {
            this.m_assignments.add(resourceAssignment);
            this.getParentFile().addResourceAssignment(resourceAssignment);
            Resource resource = resourceAssignment.getResource();
            if (resource != null) {
                resource.addResourceAssignment(resourceAssignment);
            }
        }
    }

    private ResourceAssignment getExistingResourceAssignment(Resource resource) {
        ResourceAssignment resourceAssignment = null;
        Integer n = null;
        if (resource != null) {
            Integer n2;
            Iterator<ResourceAssignment> iterator = this.m_assignments.iterator();
            n = resource.getUniqueID();
            while (iterator.hasNext() && !(n2 = (resourceAssignment = iterator.next()).getResourceUniqueID()).equals(n)) {
                resourceAssignment = null;
            }
        }
        return resourceAssignment;
    }

    public List<ResourceAssignment> getResourceAssignments() {
        return this.m_assignments;
    }

    void removeResourceAssignment(ResourceAssignment resourceAssignment) {
        this.m_assignments.remove(resourceAssignment);
    }

    public Relation addPredecessor(Task task, RelationType relationType, Duration duration) {
        LinkedList<Relation> linkedList;
        LinkedList<Relation> linkedList2;
        if (duration == null) {
            duration = Duration.getInstance(0, TimeUnit.DAYS);
        }
        if ((linkedList2 = (LinkedList<Relation>)this.getCachedValue(TaskField.PREDECESSORS)) == null) {
            linkedList2 = new LinkedList<Relation>();
            this.set((FieldType)TaskField.PREDECESSORS, linkedList2);
        }
        Relation relation2 = null;
        for (Relation relation2 : linkedList2) {
            if (relation2.getTargetTask() == task) {
                if (relation2.getType() == relationType && relation2.getLag().compareTo(duration) == 0) break;
                relation2 = null;
                break;
            }
            relation2 = null;
        }
        if (relation2 == null) {
            relation2 = new Relation(this, task, relationType, duration);
            linkedList2.add(relation2);
        }
        if ((linkedList = (LinkedList<Relation>)task.getCachedValue(TaskField.SUCCESSORS)) == null) {
            linkedList = new LinkedList<Relation>();
            task.set((FieldType)TaskField.SUCCESSORS, linkedList);
        }
        Relation relation32 = null;
        for (Relation relation32 : linkedList) {
            if (relation32.getTargetTask() == this) {
                if (relation32.getType() == relationType && relation32.getLag().compareTo(duration) == 0) break;
                relation32 = null;
                break;
            }
            relation32 = null;
        }
        if (relation32 == null) {
            relation32 = new Relation(task, this, relationType, duration);
            linkedList.add(relation32);
        }
        return relation2;
    }

    public void setPercentageComplete(Number number) {
        this.set((FieldType)TaskField.PERCENT_COMPLETE, number);
    }

    public void setPercentageWorkComplete(Number number) {
        this.set((FieldType)TaskField.PERCENT_WORK_COMPLETE, number);
    }

    public void setActualCost(Number number) {
        this.set((FieldType)TaskField.ACTUAL_COST, number);
    }

    public void setActualDuration(Duration duration) {
        this.set((FieldType)TaskField.ACTUAL_DURATION, duration);
    }

    public void setActualFinish(Date date) {
        this.set((FieldType)TaskField.ACTUAL_FINISH, date);
    }

    public void setActualStart(Date date) {
        this.set((FieldType)TaskField.ACTUAL_START, date);
    }

    public void setActualWork(Duration duration) {
        this.set((FieldType)TaskField.ACTUAL_WORK, duration);
    }

    public void setBaselineCost(Number number) {
        this.set((FieldType)TaskField.BASELINE_COST, number);
    }

    public void setBaselineDuration(Duration duration) {
        this.set((FieldType)TaskField.BASELINE_DURATION, duration);
    }

    public void setBaselineFinish(Date date) {
        this.set((FieldType)TaskField.BASELINE_FINISH, date);
    }

    public void setBaselineStart(Date date) {
        this.set((FieldType)TaskField.BASELINE_START, date);
    }

    public void setBaselineWork(Duration duration) {
        this.set((FieldType)TaskField.BASELINE_WORK, duration);
    }

    public void setBCWP(Number number) {
        this.set((FieldType)TaskField.BCWP, number);
    }

    public void setBCWS(Number number) {
        this.set((FieldType)TaskField.BCWS, number);
    }

    public void setConfirmed(boolean bl) {
        this.set((FieldType)TaskField.CONFIRMED, bl);
    }

    public void setConstraintDate(Date date) {
        this.set((FieldType)TaskField.CONSTRAINT_DATE, date);
    }

    public void setConstraintType(ConstraintType constraintType) {
        this.set((FieldType)TaskField.CONSTRAINT_TYPE, constraintType);
    }

    public void setContact(String string) {
        this.set((FieldType)TaskField.CONTACT, string);
    }

    public void setCost(Number number) {
        this.set((FieldType)TaskField.COST, number);
    }

    public void setCost1(Number number) {
        this.set((FieldType)TaskField.COST1, number);
    }

    public void setCost2(Number number) {
        this.set((FieldType)TaskField.COST2, number);
    }

    public void setCost3(Number number) {
        this.set((FieldType)TaskField.COST3, number);
    }

    public void setCostVariance(Number number) {
        this.set((FieldType)TaskField.COST_VARIANCE, number);
    }

    public void setCreateDate(Date date) {
        this.set((FieldType)TaskField.CREATED, date);
    }

    public void setCritical(boolean bl) {
        this.set((FieldType)TaskField.CRITICAL, bl);
    }

    public void setCV(Number number) {
        this.set((FieldType)TaskField.CV, number);
    }

    public void setLevelingDelay(Duration duration) {
        this.set((FieldType)TaskField.LEVELING_DELAY, duration);
    }

    public void setDuration(Duration duration) {
        this.set((FieldType)TaskField.DURATION, duration);
    }

    public void setDurationText(String string) {
        this.set((FieldType)TaskField.DURATION_TEXT, string);
    }

    public void setManualDuration(Duration duration) {
        this.set((FieldType)TaskField.MANUAL_DURATION, duration);
    }

    public Duration getManualDuration() {
        return (Duration)this.getCachedValue(TaskField.MANUAL_DURATION);
    }

    public void setDuration1(Duration duration) {
        this.set((FieldType)TaskField.DURATION1, duration);
    }

    public void setDuration2(Duration duration) {
        this.set((FieldType)TaskField.DURATION2, duration);
    }

    public void setDuration3(Duration duration) {
        this.set((FieldType)TaskField.DURATION3, duration);
    }

    public void setDurationVariance(Duration duration) {
        this.set((FieldType)TaskField.DURATION_VARIANCE, duration);
    }

    public void setEarlyFinish(Date date) {
        this.set((FieldType)TaskField.EARLY_FINISH, date);
    }

    public void setEarlyStart(Date date) {
        this.set((FieldType)TaskField.EARLY_START, date);
    }

    public void setFinish(Date date) {
        this.set((FieldType)TaskField.FINISH, date);
    }

    public void setFinishText(String string) {
        this.set((FieldType)TaskField.FINISH_TEXT, string);
    }

    public void setFinish1(Date date) {
        this.set((FieldType)TaskField.FINISH1, date);
    }

    public void setFinish2(Date date) {
        this.set((FieldType)TaskField.FINISH2, date);
    }

    public void setFinish3(Date date) {
        this.set((FieldType)TaskField.FINISH3, date);
    }

    public void setFinish4(Date date) {
        this.set((FieldType)TaskField.FINISH4, date);
    }

    public void setFinish5(Date date) {
        this.set((FieldType)TaskField.FINISH5, date);
    }

    public void setFinishVariance(Duration duration) {
        this.set((FieldType)TaskField.FINISH_VARIANCE, duration);
    }

    public void setFixedCost(Number number) {
        this.set((FieldType)TaskField.FIXED_COST, number);
    }

    public void setFlag1(boolean bl) {
        this.set((FieldType)TaskField.FLAG1, bl);
    }

    public void setFlag2(boolean bl) {
        this.set((FieldType)TaskField.FLAG2, bl);
    }

    public void setFlag3(boolean bl) {
        this.set((FieldType)TaskField.FLAG3, bl);
    }

    public void setFlag4(boolean bl) {
        this.set((FieldType)TaskField.FLAG4, bl);
    }

    public void setFlag5(boolean bl) {
        this.set((FieldType)TaskField.FLAG5, bl);
    }

    public void setFlag6(boolean bl) {
        this.set((FieldType)TaskField.FLAG6, bl);
    }

    public void setFlag7(boolean bl) {
        this.set((FieldType)TaskField.FLAG7, bl);
    }

    public void setFlag8(boolean bl) {
        this.set((FieldType)TaskField.FLAG8, bl);
    }

    public void setFlag9(boolean bl) {
        this.set((FieldType)TaskField.FLAG9, bl);
    }

    public void setFlag10(boolean bl) {
        this.set((FieldType)TaskField.FLAG10, bl);
    }

    public void setFreeSlack(Duration duration) {
        this.set((FieldType)TaskField.FREE_SLACK, duration);
    }

    public void setHideBar(boolean bl) {
        this.set((FieldType)TaskField.HIDEBAR, bl);
    }

    public void setID(Integer n) {
        ProjectFile projectFile = this.getParentFile();
        Integer n2 = this.getID();
        if (n2 != null) {
            projectFile.unmapTaskID(n2);
        }
        projectFile.mapTaskID(n, this);
        this.set((FieldType)TaskField.ID, n);
    }

    public void setLateFinish(Date date) {
        this.set((FieldType)TaskField.LATE_FINISH, date);
    }

    public void setLateStart(Date date) {
        this.set((FieldType)TaskField.LATE_START, date);
    }

    public void setLinkedFields(boolean bl) {
        this.set((FieldType)TaskField.LINKED_FIELDS, bl);
    }

    public void setMarked(boolean bl) {
        this.set((FieldType)TaskField.MARKED, bl);
    }

    public void setMilestone(boolean bl) {
        this.set((FieldType)TaskField.MILESTONE, bl);
    }

    public void setName(String string) {
        this.set((FieldType)TaskField.NAME, string);
    }

    public void setNumber1(Number number) {
        this.set((FieldType)TaskField.NUMBER1, number);
    }

    public void setNumber2(Number number) {
        this.set((FieldType)TaskField.NUMBER2, number);
    }

    public void setNumber3(Number number) {
        this.set((FieldType)TaskField.NUMBER3, number);
    }

    public void setNumber4(Number number) {
        this.set((FieldType)TaskField.NUMBER4, number);
    }

    public void setNumber5(Number number) {
        this.set((FieldType)TaskField.NUMBER5, number);
    }

    public void setObjects(Integer n) {
        this.set((FieldType)TaskField.OBJECTS, n);
    }

    public void setOutlineLevel(Integer n) {
        this.set((FieldType)TaskField.OUTLINE_LEVEL, n);
    }

    public void setOutlineNumber(String string) {
        this.set((FieldType)TaskField.OUTLINE_NUMBER, string);
    }

    public void setPriority(Priority priority) {
        this.set((FieldType)TaskField.PRIORITY, priority);
    }

    public void setProject(String string) {
        this.set((FieldType)TaskField.PROJECT, string);
    }

    public void setRemainingCost(Number number) {
        this.set((FieldType)TaskField.REMAINING_COST, number);
    }

    public void setRemainingDuration(Duration duration) {
        this.set((FieldType)TaskField.REMAINING_DURATION, duration);
    }

    public void setRemainingWork(Duration duration) {
        this.set((FieldType)TaskField.REMAINING_WORK, duration);
    }

    public void setResourceGroup(String string) {
        this.set((FieldType)TaskField.RESOURCE_GROUP, string);
    }

    public void setResourceInitials(String string) {
        this.set((FieldType)TaskField.RESOURCE_INITIALS, string);
    }

    public void setResourceNames(String string) {
        this.set((FieldType)TaskField.RESOURCE_NAMES, string);
    }

    public void setResume(Date date) {
        this.set((FieldType)TaskField.RESUME, date);
    }

    public void setRollup(boolean bl) {
        this.set((FieldType)TaskField.ROLLUP, bl);
    }

    public void setStart(Date date) {
        this.set((FieldType)TaskField.START, date);
    }

    public void setStartText(String string) {
        this.set((FieldType)TaskField.START_TEXT, string);
    }

    public void setStart1(Date date) {
        this.set((FieldType)TaskField.START1, date);
    }

    public void setStart2(Date date) {
        this.set((FieldType)TaskField.START2, date);
    }

    public void setStart3(Date date) {
        this.set((FieldType)TaskField.START3, date);
    }

    public void setStart4(Date date) {
        this.set((FieldType)TaskField.START4, date);
    }

    public void setStart5(Date date) {
        this.set((FieldType)TaskField.START5, date);
    }

    public void setStartVariance(Duration duration) {
        this.set((FieldType)TaskField.START_VARIANCE, duration);
    }

    public void setStop(Date date) {
        this.set((FieldType)TaskField.STOP, date);
    }

    public void setSubprojectName(String string) {
        this.set((FieldType)TaskField.SUBPROJECT_FILE, string);
    }

    public void setSummary(boolean bl) {
        this.set((FieldType)TaskField.SUMMARY, bl);
    }

    public void setSV(Number number) {
        this.set((FieldType)TaskField.SV, number);
    }

    public void setText1(String string) {
        this.set((FieldType)TaskField.TEXT1, string);
    }

    public void setText2(String string) {
        this.set((FieldType)TaskField.TEXT2, string);
    }

    public void setText3(String string) {
        this.set((FieldType)TaskField.TEXT3, string);
    }

    public void setText4(String string) {
        this.set((FieldType)TaskField.TEXT4, string);
    }

    public void setText5(String string) {
        this.set((FieldType)TaskField.TEXT5, string);
    }

    public void setText6(String string) {
        this.set((FieldType)TaskField.TEXT6, string);
    }

    public void setText7(String string) {
        this.set((FieldType)TaskField.TEXT7, string);
    }

    public void setText8(String string) {
        this.set((FieldType)TaskField.TEXT8, string);
    }

    public void setText9(String string) {
        this.set((FieldType)TaskField.TEXT9, string);
    }

    public void setText10(String string) {
        this.set((FieldType)TaskField.TEXT10, string);
    }

    public void setTotalSlack(Duration duration) {
        this.set((FieldType)TaskField.TOTAL_SLACK, duration);
    }

    public void setUniqueID(Integer n) {
        ProjectFile projectFile = this.getParentFile();
        Integer n2 = this.getUniqueID();
        if (n2 != null) {
            projectFile.unmapTaskUniqueID(n2);
        }
        projectFile.mapTaskUniqueID(n, this);
        this.set((FieldType)TaskField.UNIQUE_ID, n);
    }

    public void setUpdateNeeded(boolean bl) {
        this.set((FieldType)TaskField.UPDATE_NEEDED, bl);
    }

    public void setWBS(String string) {
        this.set((FieldType)TaskField.WBS, string);
    }

    public void setWork(Duration duration) {
        this.set((FieldType)TaskField.WORK, duration);
    }

    public void setWorkVariance(Duration duration) {
        this.set((FieldType)TaskField.WORK_VARIANCE, duration);
    }

    public Number getPercentageComplete() {
        return (Number)this.getCachedValue(TaskField.PERCENT_COMPLETE);
    }

    public Number getPercentageWorkComplete() {
        return (Number)this.getCachedValue(TaskField.PERCENT_WORK_COMPLETE);
    }

    public Number getActualCost() {
        return (Number)this.getCachedValue(TaskField.ACTUAL_COST);
    }

    public Duration getActualDuration() {
        return (Duration)this.getCachedValue(TaskField.ACTUAL_DURATION);
    }

    public Date getActualFinish() {
        return (Date)this.getCachedValue(TaskField.ACTUAL_FINISH);
    }

    public Date getActualStart() {
        return (Date)this.getCachedValue(TaskField.ACTUAL_START);
    }

    public Duration getActualWork() {
        return (Duration)this.getCachedValue(TaskField.ACTUAL_WORK);
    }

    public Number getBaselineCost() {
        return (Number)this.getCachedValue(TaskField.BASELINE_COST);
    }

    public Duration getBaselineDuration() {
        Object object = this.getCachedValue(TaskField.BASELINE_DURATION);
        if (object == null) {
            object = this.getCachedValue(TaskField.BASELINE_ESTIMATED_DURATION);
        }
        if (!(object instanceof Duration)) {
            object = null;
        }
        return (Duration)object;
    }

    public String getBaselineDurationText() {
        Object object = this.getCachedValue(TaskField.BASELINE_DURATION);
        if (object == null) {
            object = this.getCachedValue(TaskField.BASELINE_ESTIMATED_DURATION);
        }
        if (!(object instanceof String)) {
            object = null;
        }
        return (String)object;
    }

    public void setBaselineDurationText(String string) {
        this.set((FieldType)TaskField.BASELINE_DURATION, string);
    }

    public Date getBaselineFinish() {
        Object object = this.getCachedValue(TaskField.BASELINE_FINISH);
        if (object == null) {
            object = this.getCachedValue(TaskField.BASELINE_ESTIMATED_FINISH);
        }
        if (!(object instanceof Date)) {
            object = null;
        }
        return (Date)object;
    }

    public String getBaselineFinishText() {
        Object object = this.getCachedValue(TaskField.BASELINE_FINISH);
        if (object == null) {
            object = this.getCachedValue(TaskField.BASELINE_ESTIMATED_FINISH);
        }
        if (!(object instanceof String)) {
            object = null;
        }
        return (String)object;
    }

    public void setBaselineFinishText(String string) {
        this.set((FieldType)TaskField.BASELINE_FINISH, string);
    }

    public Date getBaselineStart() {
        Object object = this.getCachedValue(TaskField.BASELINE_START);
        if (object == null) {
            object = this.getCachedValue(TaskField.BASELINE_ESTIMATED_START);
        }
        if (!(object instanceof Date)) {
            object = null;
        }
        return (Date)object;
    }

    public String getBaselineStartText() {
        Object object = this.getCachedValue(TaskField.BASELINE_START);
        if (object == null) {
            object = this.getCachedValue(TaskField.BASELINE_ESTIMATED_START);
        }
        if (!(object instanceof String)) {
            object = null;
        }
        return (String)object;
    }

    public void setBaselineStartText(String string) {
        this.set((FieldType)TaskField.BASELINE_START, string);
    }

    public Duration getBaselineWork() {
        return (Duration)this.getCachedValue(TaskField.BASELINE_WORK);
    }

    public Number getBCWP() {
        return (Number)this.getCachedValue(TaskField.BCWP);
    }

    public Number getBCWS() {
        return (Number)this.getCachedValue(TaskField.BCWS);
    }

    public boolean getConfirmed() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.CONFIRMED));
    }

    public Date getConstraintDate() {
        return (Date)this.getCachedValue(TaskField.CONSTRAINT_DATE);
    }

    public ConstraintType getConstraintType() {
        return (ConstraintType)this.getCachedValue(TaskField.CONSTRAINT_TYPE);
    }

    public String getContact() {
        return (String)this.getCachedValue(TaskField.CONTACT);
    }

    public Number getCost() {
        return (Number)this.getCachedValue(TaskField.COST);
    }

    public Number getCost1() {
        return (Number)this.getCachedValue(TaskField.COST1);
    }

    public Number getCost2() {
        return (Number)this.getCachedValue(TaskField.COST2);
    }

    public Number getCost3() {
        return (Number)this.getCachedValue(TaskField.COST3);
    }

    public Number getCostVariance() {
        Number number = (Number)this.getCachedValue(TaskField.COST_VARIANCE);
        if (number == null) {
            Number number2 = this.getCost();
            Number number3 = this.getBaselineCost();
            if (number2 != null && number3 != null) {
                number = NumberUtility.getDouble(number2.doubleValue() - number3.doubleValue());
                this.set((FieldType)TaskField.COST_VARIANCE, number);
            }
        }
        return number;
    }

    public Date getCreateDate() {
        return (Date)this.getCachedValue(TaskField.CREATED);
    }

    public boolean getCritical() {
        Boolean bl = (Boolean)this.getCachedValue(TaskField.CRITICAL);
        if (bl == null) {
            Duration duration = this.getTotalSlack();
            bl = duration != null && duration.getDuration() <= 0.0 && NumberUtility.getInt(this.getPercentageComplete()) != 100 && (this.getTaskMode() == TaskMode.AUTO_SCHEDULED || this.getDurationText() == null && this.getStartText() == null && this.getFinishText() == null);
            this.set((FieldType)TaskField.CRITICAL, bl);
        }
        return BooleanUtility.getBoolean(bl);
    }

    public Number getCV() {
        Number number = (Number)this.getCachedValue(TaskField.CV);
        if (number == null) {
            number = NumberUtility.getDouble(this.getBCWP()) - NumberUtility.getDouble(this.getACWP());
            this.set((FieldType)TaskField.CV, number);
        }
        return number;
    }

    public Duration getLevelingDelay() {
        return (Duration)this.getCachedValue(TaskField.LEVELING_DELAY);
    }

    public Duration getDuration() {
        return (Duration)this.getCachedValue(TaskField.DURATION);
    }

    public String getDurationText() {
        return (String)this.getCachedValue(TaskField.DURATION_TEXT);
    }

    public Duration getDuration1() {
        return (Duration)this.getCachedValue(TaskField.DURATION1);
    }

    public Duration getDuration2() {
        return (Duration)this.getCachedValue(TaskField.DURATION2);
    }

    public Duration getDuration3() {
        return (Duration)this.getCachedValue(TaskField.DURATION3);
    }

    public Duration getDurationVariance() {
        Duration duration = (Duration)this.getCachedValue(TaskField.DURATION_VARIANCE);
        if (duration == null) {
            Duration duration2 = this.getDuration();
            Duration duration3 = this.getBaselineDuration();
            if (duration2 != null && duration3 != null) {
                duration = Duration.getInstance(duration2.getDuration() - duration3.convertUnits(duration2.getUnits(), this.getParentFile().getProjectHeader()).getDuration(), duration2.getUnits());
                this.set((FieldType)TaskField.DURATION_VARIANCE, duration);
            }
        }
        return duration;
    }

    public Date getEarlyFinish() {
        return (Date)this.getCachedValue(TaskField.EARLY_FINISH);
    }

    public Date getEarlyStart() {
        return (Date)this.getCachedValue(TaskField.EARLY_START);
    }

    public Date getFinish() {
        return (Date)this.getCachedValue(TaskField.FINISH);
    }

    public String getFinishText() {
        return (String)this.getCachedValue(TaskField.FINISH_TEXT);
    }

    public Date getFinish1() {
        return (Date)this.getCachedValue(TaskField.FINISH1);
    }

    public Date getFinish2() {
        return (Date)this.getCachedValue(TaskField.FINISH2);
    }

    public Date getFinish3() {
        return (Date)this.getCachedValue(TaskField.FINISH3);
    }

    public Date getFinish4() {
        return (Date)this.getCachedValue(TaskField.FINISH4);
    }

    public Date getFinish5() {
        return (Date)this.getCachedValue(TaskField.FINISH5);
    }

    public Duration getFinishVariance() {
        Duration duration = (Duration)this.getCachedValue(TaskField.FINISH_VARIANCE);
        if (duration == null) {
            TimeUnit timeUnit = this.getParentFile().getProjectHeader().getDefaultDurationUnits();
            duration = DateUtility.getVariance(this, this.getBaselineFinish(), this.getFinish(), timeUnit);
            this.set((FieldType)TaskField.FINISH_VARIANCE, duration);
        }
        return duration;
    }

    public Number getFixedCost() {
        return (Number)this.getCachedValue(TaskField.FIXED_COST);
    }

    public boolean getFlag1() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG1));
    }

    public boolean getFlag2() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG2));
    }

    public boolean getFlag3() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG3));
    }

    public boolean getFlag4() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG4));
    }

    public boolean getFlag5() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG5));
    }

    public boolean getFlag6() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG6));
    }

    public boolean getFlag7() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG7));
    }

    public boolean getFlag8() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG8));
    }

    public boolean getFlag9() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG9));
    }

    public boolean getFlag10() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG10));
    }

    public Duration getFreeSlack() {
        return (Duration)this.getCachedValue(TaskField.FREE_SLACK);
    }

    public boolean getHideBar() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.HIDEBAR));
    }

    public Integer getID() {
        return (Integer)this.getCachedValue(TaskField.ID);
    }

    public Date getLateFinish() {
        return (Date)this.getCachedValue(TaskField.LATE_FINISH);
    }

    public Date getLateStart() {
        return (Date)this.getCachedValue(TaskField.LATE_START);
    }

    public boolean getLinkedFields() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.LINKED_FIELDS));
    }

    public boolean getMarked() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.MARKED));
    }

    public boolean getMilestone() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.MILESTONE));
    }

    public String getName() {
        return (String)this.getCachedValue(TaskField.NAME);
    }

    public String getNotes() {
        String string = (String)this.getCachedValue(TaskField.NOTES);
        return string == null ? "" : string;
    }

    public Number getNumber1() {
        return (Number)this.getCachedValue(TaskField.NUMBER1);
    }

    public Number getNumber2() {
        return (Number)this.getCachedValue(TaskField.NUMBER2);
    }

    public Number getNumber3() {
        return (Number)this.getCachedValue(TaskField.NUMBER3);
    }

    public Number getNumber4() {
        return (Number)this.getCachedValue(TaskField.NUMBER4);
    }

    public Number getNumber5() {
        return (Number)this.getCachedValue(TaskField.NUMBER5);
    }

    public Integer getObjects() {
        return (Integer)this.getCachedValue(TaskField.OBJECTS);
    }

    public Integer getOutlineLevel() {
        return (Integer)this.getCachedValue(TaskField.OUTLINE_LEVEL);
    }

    public String getOutlineNumber() {
        return (String)this.getCachedValue(TaskField.OUTLINE_NUMBER);
    }

    public List<Relation> getPredecessors() {
        return (List)this.getCachedValue(TaskField.PREDECESSORS);
    }

    public List<Relation> getSuccessors() {
        return (List)this.getCachedValue(TaskField.SUCCESSORS);
    }

    public Priority getPriority() {
        return (Priority)this.getCachedValue(TaskField.PRIORITY);
    }

    public String getProject() {
        return (String)this.getCachedValue(TaskField.PROJECT);
    }

    public Number getRemainingCost() {
        return (Number)this.getCachedValue(TaskField.REMAINING_COST);
    }

    public Duration getRemainingDuration() {
        return (Duration)this.getCachedValue(TaskField.REMAINING_DURATION);
    }

    public Duration getRemainingWork() {
        return (Duration)this.getCachedValue(TaskField.REMAINING_WORK);
    }

    public String getResourceGroup() {
        return (String)this.getCachedValue(TaskField.RESOURCE_GROUP);
    }

    public String getResourceInitials() {
        return (String)this.getCachedValue(TaskField.RESOURCE_INITIALS);
    }

    public String getResourceNames() {
        return (String)this.getCachedValue(TaskField.RESOURCE_NAMES);
    }

    public Date getResume() {
        return (Date)this.getCachedValue(TaskField.RESUME);
    }

    public boolean getRollup() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.ROLLUP));
    }

    public Date getStart() {
        return (Date)this.getCachedValue(TaskField.START);
    }

    public String getStartText() {
        return (String)this.getCachedValue(TaskField.START_TEXT);
    }

    public Date getStart1() {
        return (Date)this.getCachedValue(TaskField.START1);
    }

    public Date getStart2() {
        return (Date)this.getCachedValue(TaskField.START2);
    }

    public Date getStart3() {
        return (Date)this.getCachedValue(TaskField.START3);
    }

    public Date getStart4() {
        return (Date)this.getCachedValue(TaskField.START4);
    }

    public Date getStart5() {
        return (Date)this.getCachedValue(TaskField.START5);
    }

    public Duration getStartVariance() {
        Duration duration = (Duration)this.getCachedValue(TaskField.START_VARIANCE);
        if (duration == null) {
            TimeUnit timeUnit = this.getParentFile().getProjectHeader().getDefaultDurationUnits();
            duration = DateUtility.getVariance(this, this.getBaselineStart(), this.getStart(), timeUnit);
            this.set((FieldType)TaskField.START_VARIANCE, duration);
        }
        return duration;
    }

    public Date getStop() {
        return (Date)this.getCachedValue(TaskField.STOP);
    }

    public String getSubprojectName() {
        return (String)this.getCachedValue(TaskField.SUBPROJECT_FILE);
    }

    public boolean getSummary() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.SUMMARY));
    }

    public Number getSV() {
        Number number = (Number)this.getCachedValue(TaskField.SV);
        if (number == null) {
            Number number2 = this.getBCWP();
            Number number3 = this.getBCWS();
            if (number2 != null && number3 != null) {
                number = NumberUtility.getDouble(number2.doubleValue() - number3.doubleValue());
                this.set((FieldType)TaskField.SV, number);
            }
        }
        return number;
    }

    public String getText1() {
        return (String)this.getCachedValue(TaskField.TEXT1);
    }

    public String getText2() {
        return (String)this.getCachedValue(TaskField.TEXT2);
    }

    public String getText3() {
        return (String)this.getCachedValue(TaskField.TEXT3);
    }

    public String getText4() {
        return (String)this.getCachedValue(TaskField.TEXT4);
    }

    public String getText5() {
        return (String)this.getCachedValue(TaskField.TEXT5);
    }

    public String getText6() {
        return (String)this.getCachedValue(TaskField.TEXT6);
    }

    public String getText7() {
        return (String)this.getCachedValue(TaskField.TEXT7);
    }

    public String getText8() {
        return (String)this.getCachedValue(TaskField.TEXT8);
    }

    public String getText9() {
        return (String)this.getCachedValue(TaskField.TEXT9);
    }

    public String getText10() {
        return (String)this.getCachedValue(TaskField.TEXT10);
    }

    public Duration getTotalSlack() {
        Duration duration = (Duration)this.getCachedValue(TaskField.TOTAL_SLACK);
        if (duration == null) {
            Duration duration2 = this.getDuration();
            if (duration2 == null) {
                duration2 = Duration.getInstance(0, TimeUnit.DAYS);
            }
            TimeUnit timeUnit = duration2.getUnits();
            Duration duration3 = this.getStartSlack();
            if (duration3 == null) {
                duration3 = Duration.getInstance(0, timeUnit);
            } else if (duration3.getUnits() != timeUnit) {
                duration3 = duration3.convertUnits(timeUnit, this.getParentFile().getProjectHeader());
            }
            Duration duration4 = this.getFinishSlack();
            if (duration4 == null) {
                duration4 = Duration.getInstance(0, timeUnit);
            } else if (duration4.getUnits() != timeUnit) {
                duration4 = duration4.convertUnits(timeUnit, this.getParentFile().getProjectHeader());
            }
            double d = duration3.getDuration();
            double d2 = duration4.getDuration();
            duration = d == 0.0 || d2 == 0.0 ? (d != 0.0 ? duration3 : duration4) : (d < d2 ? duration3 : duration4);
            this.set((FieldType)TaskField.TOTAL_SLACK, duration);
        }
        return duration;
    }

    public Integer getUniqueID() {
        return (Integer)this.getCachedValue(TaskField.UNIQUE_ID);
    }

    public boolean getUpdateNeeded() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.UPDATE_NEEDED));
    }

    public String getWBS() {
        return (String)this.getCachedValue(TaskField.WBS);
    }

    public Duration getWork() {
        return (Duration)this.getCachedValue(TaskField.WORK);
    }

    public Duration getWorkVariance() {
        Duration duration = (Duration)this.getCachedValue(TaskField.WORK_VARIANCE);
        if (duration == null) {
            Duration duration2 = this.getWork();
            Duration duration3 = this.getBaselineWork();
            if (duration2 != null && duration3 != null) {
                duration = Duration.getInstance(duration2.getDuration() - duration3.convertUnits(duration2.getUnits(), this.getParentFile().getProjectHeader()).getDuration(), duration2.getUnits());
                this.set((FieldType)TaskField.WORK_VARIANCE, duration);
            }
        }
        return duration;
    }

    int getChildTaskCount() {
        return this.m_children.size();
    }

    public Task getParentTask() {
        return this.m_parent;
    }

    public List<Task> getChildTasks() {
        return this.m_children;
    }

    @Override
    public int compareTo(Task task) {
        int n;
        int n2 = NumberUtility.getInt(this.getID());
        return n2 < (n = NumberUtility.getInt(task.getID())) ? -1 : (n2 == n ? 0 : 1);
    }

    public boolean getEstimated() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.ESTIMATED));
    }

    public void setEstimated(boolean bl) {
        this.set((FieldType)TaskField.ESTIMATED, bl);
    }

    public Date getDeadline() {
        return (Date)this.getCachedValue(TaskField.DEADLINE);
    }

    public void setDeadline(Date date) {
        this.set((FieldType)TaskField.DEADLINE, date);
    }

    public TaskType getType() {
        return (TaskType)this.getCachedValue(TaskField.TYPE);
    }

    public void setType(TaskType taskType) {
        this.set((FieldType)TaskField.TYPE, taskType);
    }

    public boolean getNull() {
        return this.m_null;
    }

    public void setNull(boolean bl) {
        this.m_null = bl;
    }

    public String getWBSLevel() {
        return this.m_wbsLevel;
    }

    public void setWBSLevel(String string) {
        this.m_wbsLevel = string;
    }

    public boolean getResumeValid() {
        return this.m_resumeValid;
    }

    public void setResumeValid(boolean bl) {
        this.m_resumeValid = bl;
    }

    public boolean getRecurring() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.RECURRING));
    }

    public void setRecurring(boolean bl) {
        this.set((FieldType)TaskField.RECURRING, bl);
    }

    public boolean getOverAllocated() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.OVERALLOCATED));
    }

    public void setOverAllocated(boolean bl) {
        this.set((FieldType)TaskField.OVERALLOCATED, bl);
    }

    public Integer getSubprojectTaskUniqueID() {
        return (Integer)this.getCachedValue(TaskField.SUBPROJECT_UNIQUE_TASK_ID);
    }

    public void setSubprojectTaskUniqueID(Integer n) {
        this.set((FieldType)TaskField.SUBPROJECT_UNIQUE_TASK_ID, n);
    }

    public Integer getSubprojectTaskID() {
        return (Integer)this.getCachedValue(TaskField.SUBPROJECT_TASK_ID);
    }

    public void setSubprojectTaskID(Integer n) {
        this.set((FieldType)TaskField.SUBPROJECT_TASK_ID, n);
    }

    public void setSubprojectTasksUniqueIDOffset(Integer n) {
        this.set((FieldType)TaskField.SUBPROJECT_TASKS_UNIQUEID_OFFSET, n);
    }

    public Integer getSubprojectTasksUniqueIDOffset() {
        return (Integer)this.getCachedValue(TaskField.SUBPROJECT_TASKS_UNIQUEID_OFFSET);
    }

    public boolean getSubprojectReadOnly() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.SUBPROJECT_READ_ONLY));
    }

    public void setSubprojectReadOnly(boolean bl) {
        this.set((FieldType)TaskField.SUBPROJECT_READ_ONLY, bl);
    }

    public boolean getExternalTask() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.EXTERNAL_TASK));
    }

    public void setExternalTask(boolean bl) {
        this.set((FieldType)TaskField.EXTERNAL_TASK, bl);
    }

    public String getExternalTaskProject() {
        return this.m_externalTaskProject;
    }

    public void setExternalTaskProject(String string) {
        this.m_externalTaskProject = string;
    }

    public Number getACWP() {
        return (Number)this.getCachedValue(TaskField.ACWP);
    }

    public void setACWP(Number number) {
        this.set((FieldType)TaskField.ACWP, number);
    }

    public TimeUnit getLevelingDelayFormat() {
        return this.m_levelingDelayFormat;
    }

    public void setLevelingDelayFormat(TimeUnit timeUnit) {
        this.m_levelingDelayFormat = timeUnit;
    }

    public boolean getIgnoreResourceCalendar() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.IGNORE_RESOURCE_CALENDAR));
    }

    public void setIgnoreResourceCalendar(boolean bl) {
        this.set((FieldType)TaskField.IGNORE_RESOURCE_CALENDAR, bl);
    }

    public Integer getPhysicalPercentComplete() {
        return (Integer)this.getCachedValue(TaskField.PHYSICAL_PERCENT_COMPLETE);
    }

    public void setPhysicalPercentComplete(Integer n) {
        this.set((FieldType)TaskField.PHYSICAL_PERCENT_COMPLETE, n);
    }

    public EarnedValueMethod getEarnedValueMethod() {
        return this.m_earnedValueMethod;
    }

    public void setEarnedValueMethod(EarnedValueMethod earnedValueMethod) {
        this.m_earnedValueMethod = earnedValueMethod;
    }

    public Duration getActualWorkProtected() {
        return this.m_actualWorkProtected;
    }

    public void setActualWorkProtected(Duration duration) {
        this.m_actualWorkProtected = duration;
    }

    public Duration getActualOvertimeWorkProtected() {
        return this.m_actualOvertimeWorkProtected;
    }

    public void setActualOvertimeWorkProtected(Duration duration) {
        this.m_actualOvertimeWorkProtected = duration;
    }

    public Duration getRegularWork() {
        return (Duration)this.getCachedValue(TaskField.REGULAR_WORK);
    }

    public void setRegularWork(Duration duration) {
        this.set((FieldType)TaskField.REGULAR_WORK, duration);
    }

    public boolean getFlag11() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG11));
    }

    public boolean getFlag12() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG12));
    }

    public boolean getFlag13() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG13));
    }

    public boolean getFlag14() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG14));
    }

    public boolean getFlag15() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG15));
    }

    public boolean getFlag16() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG16));
    }

    public boolean getFlag17() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG17));
    }

    public boolean getFlag18() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG18));
    }

    public boolean getFlag19() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG19));
    }

    public boolean getFlag20() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.FLAG20));
    }

    public void setFlag11(boolean bl) {
        this.set((FieldType)TaskField.FLAG11, bl);
    }

    public void setFlag12(boolean bl) {
        this.set((FieldType)TaskField.FLAG12, bl);
    }

    public void setFlag13(boolean bl) {
        this.set((FieldType)TaskField.FLAG13, bl);
    }

    public void setFlag14(boolean bl) {
        this.set((FieldType)TaskField.FLAG14, bl);
    }

    public void setFlag15(boolean bl) {
        this.set((FieldType)TaskField.FLAG15, bl);
    }

    public void setFlag16(boolean bl) {
        this.set((FieldType)TaskField.FLAG16, bl);
    }

    public void setFlag17(boolean bl) {
        this.set((FieldType)TaskField.FLAG17, bl);
    }

    public void setFlag18(boolean bl) {
        this.set((FieldType)TaskField.FLAG18, bl);
    }

    public void setFlag19(boolean bl) {
        this.set((FieldType)TaskField.FLAG19, bl);
    }

    public void setFlag20(boolean bl) {
        this.set((FieldType)TaskField.FLAG20, bl);
    }

    public void setEffortDriven(boolean bl) {
        this.set((FieldType)TaskField.EFFORT_DRIVEN, bl);
    }

    public boolean getEffortDriven() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.EFFORT_DRIVEN));
    }

    public String getText11() {
        return (String)this.getCachedValue(TaskField.TEXT11);
    }

    public String getText12() {
        return (String)this.getCachedValue(TaskField.TEXT12);
    }

    public String getText13() {
        return (String)this.getCachedValue(TaskField.TEXT13);
    }

    public String getText14() {
        return (String)this.getCachedValue(TaskField.TEXT14);
    }

    public String getText15() {
        return (String)this.getCachedValue(TaskField.TEXT15);
    }

    public String getText16() {
        return (String)this.getCachedValue(TaskField.TEXT16);
    }

    public String getText17() {
        return (String)this.getCachedValue(TaskField.TEXT17);
    }

    public String getText18() {
        return (String)this.getCachedValue(TaskField.TEXT18);
    }

    public String getText19() {
        return (String)this.getCachedValue(TaskField.TEXT19);
    }

    public String getText20() {
        return (String)this.getCachedValue(TaskField.TEXT20);
    }

    public String getText21() {
        return (String)this.getCachedValue(TaskField.TEXT21);
    }

    public String getText22() {
        return (String)this.getCachedValue(TaskField.TEXT22);
    }

    public String getText23() {
        return (String)this.getCachedValue(TaskField.TEXT23);
    }

    public String getText24() {
        return (String)this.getCachedValue(TaskField.TEXT24);
    }

    public String getText25() {
        return (String)this.getCachedValue(TaskField.TEXT25);
    }

    public String getText26() {
        return (String)this.getCachedValue(TaskField.TEXT26);
    }

    public String getText27() {
        return (String)this.getCachedValue(TaskField.TEXT27);
    }

    public String getText28() {
        return (String)this.getCachedValue(TaskField.TEXT28);
    }

    public String getText29() {
        return (String)this.getCachedValue(TaskField.TEXT29);
    }

    public String getText30() {
        return (String)this.getCachedValue(TaskField.TEXT30);
    }

    public void setText11(String string) {
        this.set((FieldType)TaskField.TEXT11, string);
    }

    public void setText12(String string) {
        this.set((FieldType)TaskField.TEXT12, string);
    }

    public void setText13(String string) {
        this.set((FieldType)TaskField.TEXT13, string);
    }

    public void setText14(String string) {
        this.set((FieldType)TaskField.TEXT14, string);
    }

    public void setText15(String string) {
        this.set((FieldType)TaskField.TEXT15, string);
    }

    public void setText16(String string) {
        this.set((FieldType)TaskField.TEXT16, string);
    }

    public void setText17(String string) {
        this.set((FieldType)TaskField.TEXT17, string);
    }

    public void setText18(String string) {
        this.set((FieldType)TaskField.TEXT18, string);
    }

    public void setText19(String string) {
        this.set((FieldType)TaskField.TEXT19, string);
    }

    public void setText20(String string) {
        this.set((FieldType)TaskField.TEXT20, string);
    }

    public void setText21(String string) {
        this.set((FieldType)TaskField.TEXT21, string);
    }

    public void setText22(String string) {
        this.set((FieldType)TaskField.TEXT22, string);
    }

    public void setText23(String string) {
        this.set((FieldType)TaskField.TEXT23, string);
    }

    public void setText24(String string) {
        this.set((FieldType)TaskField.TEXT24, string);
    }

    public void setText25(String string) {
        this.set((FieldType)TaskField.TEXT25, string);
    }

    public void setText26(String string) {
        this.set((FieldType)TaskField.TEXT26, string);
    }

    public void setText27(String string) {
        this.set((FieldType)TaskField.TEXT27, string);
    }

    public void setText28(String string) {
        this.set((FieldType)TaskField.TEXT28, string);
    }

    public void setText29(String string) {
        this.set((FieldType)TaskField.TEXT29, string);
    }

    public void setText30(String string) {
        this.set((FieldType)TaskField.TEXT30, string);
    }

    public void setNumber6(Number number) {
        this.set((FieldType)TaskField.NUMBER6, number);
    }

    public Number getNumber6() {
        return (Number)this.getCachedValue(TaskField.NUMBER6);
    }

    public void setNumber7(Number number) {
        this.set((FieldType)TaskField.NUMBER7, number);
    }

    public Number getNumber7() {
        return (Number)this.getCachedValue(TaskField.NUMBER7);
    }

    public void setNumber8(Number number) {
        this.set((FieldType)TaskField.NUMBER8, number);
    }

    public Number getNumber8() {
        return (Number)this.getCachedValue(TaskField.NUMBER8);
    }

    public void setNumber9(Number number) {
        this.set((FieldType)TaskField.NUMBER9, number);
    }

    public Number getNumber9() {
        return (Number)this.getCachedValue(TaskField.NUMBER9);
    }

    public void setNumber10(Number number) {
        this.set((FieldType)TaskField.NUMBER10, number);
    }

    public Number getNumber10() {
        return (Number)this.getCachedValue(TaskField.NUMBER10);
    }

    public void setNumber11(Number number) {
        this.set((FieldType)TaskField.NUMBER11, number);
    }

    public Number getNumber11() {
        return (Number)this.getCachedValue(TaskField.NUMBER11);
    }

    public void setNumber12(Number number) {
        this.set((FieldType)TaskField.NUMBER12, number);
    }

    public Number getNumber12() {
        return (Number)this.getCachedValue(TaskField.NUMBER12);
    }

    public void setNumber13(Number number) {
        this.set((FieldType)TaskField.NUMBER13, number);
    }

    public Number getNumber13() {
        return (Number)this.getCachedValue(TaskField.NUMBER13);
    }

    public void setNumber14(Number number) {
        this.set((FieldType)TaskField.NUMBER14, number);
    }

    public Number getNumber14() {
        return (Number)this.getCachedValue(TaskField.NUMBER14);
    }

    public void setNumber15(Number number) {
        this.set((FieldType)TaskField.NUMBER15, number);
    }

    public Number getNumber15() {
        return (Number)this.getCachedValue(TaskField.NUMBER15);
    }

    public void setNumber16(Number number) {
        this.set((FieldType)TaskField.NUMBER16, number);
    }

    public Number getNumber16() {
        return (Number)this.getCachedValue(TaskField.NUMBER16);
    }

    public void setNumber17(Number number) {
        this.set((FieldType)TaskField.NUMBER17, number);
    }

    public Number getNumber17() {
        return (Number)this.getCachedValue(TaskField.NUMBER17);
    }

    public void setNumber18(Number number) {
        this.set((FieldType)TaskField.NUMBER18, number);
    }

    public Number getNumber18() {
        return (Number)this.getCachedValue(TaskField.NUMBER18);
    }

    public void setNumber19(Number number) {
        this.set((FieldType)TaskField.NUMBER19, number);
    }

    public Number getNumber19() {
        return (Number)this.getCachedValue(TaskField.NUMBER19);
    }

    public void setNumber20(Number number) {
        this.set((FieldType)TaskField.NUMBER20, number);
    }

    public Number getNumber20() {
        return (Number)this.getCachedValue(TaskField.NUMBER20);
    }

    public Duration getDuration10() {
        return (Duration)this.getCachedValue(TaskField.DURATION10);
    }

    public Duration getDuration4() {
        return (Duration)this.getCachedValue(TaskField.DURATION4);
    }

    public Duration getDuration5() {
        return (Duration)this.getCachedValue(TaskField.DURATION5);
    }

    public Duration getDuration6() {
        return (Duration)this.getCachedValue(TaskField.DURATION6);
    }

    public Duration getDuration7() {
        return (Duration)this.getCachedValue(TaskField.DURATION7);
    }

    public Duration getDuration8() {
        return (Duration)this.getCachedValue(TaskField.DURATION8);
    }

    public Duration getDuration9() {
        return (Duration)this.getCachedValue(TaskField.DURATION9);
    }

    public void setDuration10(Duration duration) {
        this.set((FieldType)TaskField.DURATION10, duration);
    }

    public void setDuration4(Duration duration) {
        this.set((FieldType)TaskField.DURATION4, duration);
    }

    public void setDuration5(Duration duration) {
        this.set((FieldType)TaskField.DURATION5, duration);
    }

    public void setDuration6(Duration duration) {
        this.set((FieldType)TaskField.DURATION6, duration);
    }

    public void setDuration7(Duration duration) {
        this.set((FieldType)TaskField.DURATION7, duration);
    }

    public void setDuration8(Duration duration) {
        this.set((FieldType)TaskField.DURATION8, duration);
    }

    public void setDuration9(Duration duration) {
        this.set((FieldType)TaskField.DURATION9, duration);
    }

    public Date getDate1() {
        return (Date)this.getCachedValue(TaskField.DATE1);
    }

    public Date getDate10() {
        return (Date)this.getCachedValue(TaskField.DATE10);
    }

    public Date getDate2() {
        return (Date)this.getCachedValue(TaskField.DATE2);
    }

    public Date getDate3() {
        return (Date)this.getCachedValue(TaskField.DATE3);
    }

    public Date getDate4() {
        return (Date)this.getCachedValue(TaskField.DATE4);
    }

    public Date getDate5() {
        return (Date)this.getCachedValue(TaskField.DATE5);
    }

    public Date getDate6() {
        return (Date)this.getCachedValue(TaskField.DATE6);
    }

    public Date getDate7() {
        return (Date)this.getCachedValue(TaskField.DATE7);
    }

    public Date getDate8() {
        return (Date)this.getCachedValue(TaskField.DATE8);
    }

    public Date getDate9() {
        return (Date)this.getCachedValue(TaskField.DATE9);
    }

    public void setDate1(Date date) {
        this.set((FieldType)TaskField.DATE1, date);
    }

    public void setDate10(Date date) {
        this.set((FieldType)TaskField.DATE10, date);
    }

    public void setDate2(Date date) {
        this.set((FieldType)TaskField.DATE2, date);
    }

    public void setDate3(Date date) {
        this.set((FieldType)TaskField.DATE3, date);
    }

    public void setDate4(Date date) {
        this.set((FieldType)TaskField.DATE4, date);
    }

    public void setDate5(Date date) {
        this.set((FieldType)TaskField.DATE5, date);
    }

    public void setDate6(Date date) {
        this.set((FieldType)TaskField.DATE6, date);
    }

    public void setDate7(Date date) {
        this.set((FieldType)TaskField.DATE7, date);
    }

    public void setDate8(Date date) {
        this.set((FieldType)TaskField.DATE8, date);
    }

    public void setDate9(Date date) {
        this.set((FieldType)TaskField.DATE9, date);
    }

    public Number getCost10() {
        return (Number)this.getCachedValue(TaskField.COST10);
    }

    public Number getCost4() {
        return (Number)this.getCachedValue(TaskField.COST4);
    }

    public Number getCost5() {
        return (Number)this.getCachedValue(TaskField.COST5);
    }

    public Number getCost6() {
        return (Number)this.getCachedValue(TaskField.COST6);
    }

    public Number getCost7() {
        return (Number)this.getCachedValue(TaskField.COST7);
    }

    public Number getCost8() {
        return (Number)this.getCachedValue(TaskField.COST8);
    }

    public Number getCost9() {
        return (Number)this.getCachedValue(TaskField.COST9);
    }

    public void setCost10(Number number) {
        this.set((FieldType)TaskField.COST10, number);
    }

    public void setCost4(Number number) {
        this.set((FieldType)TaskField.COST4, number);
    }

    public void setCost5(Number number) {
        this.set((FieldType)TaskField.COST5, number);
    }

    public void setCost6(Number number) {
        this.set((FieldType)TaskField.COST6, number);
    }

    public void setCost7(Number number) {
        this.set((FieldType)TaskField.COST7, number);
    }

    public void setCost8(Number number) {
        this.set((FieldType)TaskField.COST8, number);
    }

    public void setCost9(Number number) {
        this.set((FieldType)TaskField.COST9, number);
    }

    public Date getStart10() {
        return (Date)this.getCachedValue(TaskField.START10);
    }

    public Date getStart6() {
        return (Date)this.getCachedValue(TaskField.START6);
    }

    public Date getStart7() {
        return (Date)this.getCachedValue(TaskField.START7);
    }

    public Date getStart8() {
        return (Date)this.getCachedValue(TaskField.START8);
    }

    public Date getStart9() {
        return (Date)this.getCachedValue(TaskField.START9);
    }

    public void setStart10(Date date) {
        this.set((FieldType)TaskField.START10, date);
    }

    public void setStart6(Date date) {
        this.set((FieldType)TaskField.START6, date);
    }

    public void setStart7(Date date) {
        this.set((FieldType)TaskField.START7, date);
    }

    public void setStart8(Date date) {
        this.set((FieldType)TaskField.START8, date);
    }

    public void setStart9(Date date) {
        this.set((FieldType)TaskField.START9, date);
    }

    public Date getFinish10() {
        return (Date)this.getCachedValue(TaskField.FINISH10);
    }

    public Date getFinish6() {
        return (Date)this.getCachedValue(TaskField.FINISH6);
    }

    public Date getFinish7() {
        return (Date)this.getCachedValue(TaskField.FINISH7);
    }

    public Date getFinish8() {
        return (Date)this.getCachedValue(TaskField.FINISH8);
    }

    public Date getFinish9() {
        return (Date)this.getCachedValue(TaskField.FINISH9);
    }

    public void setFinish10(Date date) {
        this.set((FieldType)TaskField.FINISH10, date);
    }

    public void setFinish6(Date date) {
        this.set((FieldType)TaskField.FINISH6, date);
    }

    public void setFinish7(Date date) {
        this.set((FieldType)TaskField.FINISH7, date);
    }

    public void setFinish8(Date date) {
        this.set((FieldType)TaskField.FINISH8, date);
    }

    public void setFinish9(Date date) {
        this.set((FieldType)TaskField.FINISH9, date);
    }

    public Number getOvertimeCost() {
        return (Number)this.getCachedValue(TaskField.OVERTIME_COST);
    }

    public void setOvertimeCost(Number number) {
        this.set((FieldType)TaskField.OVERTIME_COST, number);
    }

    public void setOutlineCode1(String string) {
        this.set((FieldType)TaskField.OUTLINE_CODE1, string);
    }

    public String getOutlineCode1() {
        return (String)this.getCachedValue(TaskField.OUTLINE_CODE1);
    }

    public void setOutlineCode2(String string) {
        this.set((FieldType)TaskField.OUTLINE_CODE2, string);
    }

    public String getOutlineCode2() {
        return (String)this.getCachedValue(TaskField.OUTLINE_CODE2);
    }

    public void setOutlineCode3(String string) {
        this.set((FieldType)TaskField.OUTLINE_CODE3, string);
    }

    public String getOutlineCode3() {
        return (String)this.getCachedValue(TaskField.OUTLINE_CODE3);
    }

    public void setOutlineCode4(String string) {
        this.set((FieldType)TaskField.OUTLINE_CODE4, string);
    }

    public String getOutlineCode4() {
        return (String)this.getCachedValue(TaskField.OUTLINE_CODE4);
    }

    public void setOutlineCode5(String string) {
        this.set((FieldType)TaskField.OUTLINE_CODE5, string);
    }

    public String getOutlineCode5() {
        return (String)this.getCachedValue(TaskField.OUTLINE_CODE5);
    }

    public void setOutlineCode6(String string) {
        this.set((FieldType)TaskField.OUTLINE_CODE6, string);
    }

    public String getOutlineCode6() {
        return (String)this.getCachedValue(TaskField.OUTLINE_CODE6);
    }

    public void setOutlineCode7(String string) {
        this.set((FieldType)TaskField.OUTLINE_CODE7, string);
    }

    public String getOutlineCode7() {
        return (String)this.getCachedValue(TaskField.OUTLINE_CODE7);
    }

    public void setOutlineCode8(String string) {
        this.set((FieldType)TaskField.OUTLINE_CODE8, string);
    }

    public String getOutlineCode8() {
        return (String)this.getCachedValue(TaskField.OUTLINE_CODE8);
    }

    public void setOutlineCode9(String string) {
        this.set((FieldType)TaskField.OUTLINE_CODE9, string);
    }

    public String getOutlineCode9() {
        return (String)this.getCachedValue(TaskField.OUTLINE_CODE9);
    }

    public void setOutlineCode10(String string) {
        this.set((FieldType)TaskField.OUTLINE_CODE10, string);
    }

    public String getOutlineCode10() {
        return (String)this.getCachedValue(TaskField.OUTLINE_CODE10);
    }

    public Number getActualOvertimeCost() {
        return (Number)this.getCachedValue(TaskField.ACTUAL_OVERTIME_COST);
    }

    public void setActualOvertimeCost(Number number) {
        this.set((FieldType)TaskField.ACTUAL_OVERTIME_COST, number);
    }

    public Duration getActualOvertimeWork() {
        return (Duration)this.getCachedValue(TaskField.ACTUAL_OVERTIME_WORK);
    }

    public void setActualOvertimeWork(Duration duration) {
        this.set((FieldType)TaskField.ACTUAL_OVERTIME_WORK, duration);
    }

    public AccrueType getFixedCostAccrual() {
        return (AccrueType)this.getCachedValue(TaskField.FIXED_COST_ACCRUAL);
    }

    public void setFixedCostAccrual(AccrueType accrueType) {
        this.set((FieldType)TaskField.FIXED_COST_ACCRUAL, accrueType);
    }

    public String getHyperlink() {
        return (String)this.getCachedValue(TaskField.HYPERLINK);
    }

    public String getHyperlinkAddress() {
        return (String)this.getCachedValue(TaskField.HYPERLINK_ADDRESS);
    }

    public String getHyperlinkSubAddress() {
        return (String)this.getCachedValue(TaskField.HYPERLINK_SUBADDRESS);
    }

    public void setHyperlink(String string) {
        this.set((FieldType)TaskField.HYPERLINK, string);
    }

    public void setHyperlinkAddress(String string) {
        this.set((FieldType)TaskField.HYPERLINK_ADDRESS, string);
    }

    public void setHyperlinkSubAddress(String string) {
        this.set((FieldType)TaskField.HYPERLINK_SUBADDRESS, string);
    }

    public boolean getLevelAssignments() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.LEVEL_ASSIGNMENTS));
    }

    public void setLevelAssignments(boolean bl) {
        this.set((FieldType)TaskField.LEVEL_ASSIGNMENTS, bl);
    }

    public boolean getLevelingCanSplit() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.LEVELING_CAN_SPLIT));
    }

    public void setLevelingCanSplit(boolean bl) {
        this.set((FieldType)TaskField.LEVELING_CAN_SPLIT, bl);
    }

    public Duration getOvertimeWork() {
        return (Duration)this.getCachedValue(TaskField.OVERTIME_WORK);
    }

    public void setOvertimeWork(Duration duration) {
        this.set((FieldType)TaskField.OVERTIME_WORK, duration);
    }

    public Date getPreleveledStart() {
        return (Date)this.getCachedValue(TaskField.PRELEVELED_START);
    }

    public Date getPreleveledFinish() {
        return (Date)this.getCachedValue(TaskField.PRELEVELED_FINISH);
    }

    public void setPreleveledStart(Date date) {
        this.set((FieldType)TaskField.PRELEVELED_START, date);
    }

    public void setPreleveledFinish(Date date) {
        this.set((FieldType)TaskField.PRELEVELED_FINISH, date);
    }

    public Duration getRemainingOvertimeWork() {
        return (Duration)this.getCachedValue(TaskField.REMAINING_OVERTIME_WORK);
    }

    public void setRemainingOvertimeWork(Duration duration) {
        this.set((FieldType)TaskField.REMAINING_OVERTIME_WORK, duration);
    }

    public Number getRemainingOvertimeCost() {
        return (Number)this.getCachedValue(TaskField.REMAINING_OVERTIME_COST);
    }

    public void setRemainingOvertimeCost(Number number) {
        this.set((FieldType)TaskField.REMAINING_OVERTIME_COST, number);
    }

    public ProjectCalendar getCalendar() {
        return (ProjectCalendar)this.getCachedValue(TaskField.CALENDAR);
    }

    public void setCalendar(ProjectCalendar projectCalendar) {
        this.set((FieldType)TaskField.CALENDAR, projectCalendar);
    }

    public boolean getExpanded() {
        return this.m_expanded;
    }

    public void setExpanded(boolean bl) {
        this.m_expanded = bl;
    }

    public void setStartSlack(Duration duration) {
        this.set((FieldType)TaskField.START_SLACK, duration);
    }

    public void setFinishSlack(Duration duration) {
        this.set((FieldType)TaskField.FINISH_SLACK, duration);
    }

    public Duration getStartSlack() {
        Duration duration;
        Duration duration2 = (Duration)this.getCachedValue(TaskField.START_SLACK);
        if (duration2 == null && (duration = this.getDuration()) != null) {
            duration2 = DateUtility.getVariance(this, this.getLateStart(), this.getEarlyStart(), duration.getUnits());
            this.set((FieldType)TaskField.START_SLACK, duration2);
        }
        return duration2;
    }

    public Duration getFinishSlack() {
        Duration duration;
        Duration duration2 = (Duration)this.getCachedValue(TaskField.FINISH_SLACK);
        if (duration2 == null && (duration = this.getDuration()) != null) {
            duration2 = DateUtility.getVariance(this, this.getLateFinish(), this.getEarlyFinish(), duration.getUnits());
            this.set((FieldType)TaskField.FINISH_SLACK, duration2);
        }
        return duration2;
    }

    public Object getFieldByAlias(String string) {
        return this.getCachedValue(this.getParentFile().getAliasTaskField(string));
    }

    public void setFieldByAlias(String string, Object object) {
        this.set((FieldType)this.getParentFile().getAliasTaskField(string), object);
    }

    public List<DateRange> getSplits() {
        return this.m_splits;
    }

    public void setSplits(List<DateRange> list) {
        this.m_splits = list;
    }

    public Date getSplitCompleteDuration() {
        return this.m_splitsComplete;
    }

    public void setSplitCompleteDuration(Date date) {
        this.m_splitsComplete = date;
    }

    public void remove() {
        this.getParentFile().removeTask(this);
    }

    public SubProject getSubProject() {
        return this.m_subProject;
    }

    public void setSubProject(SubProject subProject) {
        this.m_subProject = subProject;
    }

    public Number getEnterpriseCost(int n) {
        return (Number)this.getCachedValue(this.selectField(ENTERPRISE_COST_FIELDS, n));
    }

    public void setEnterpriseCost(int n, Number number) {
        this.set((FieldType)this.selectField(ENTERPRISE_COST_FIELDS, n), number);
    }

    public Date getEnterpriseDate(int n) {
        return (Date)this.getCachedValue(this.selectField(ENTERPRISE_DATE_FIELDS, n));
    }

    public void setEnterpriseDate(int n, Date date) {
        this.set((FieldType)this.selectField(ENTERPRISE_DATE_FIELDS, n), date);
    }

    public Duration getEnterpriseDuration(int n) {
        return (Duration)this.getCachedValue(this.selectField(ENTERPRISE_DURATION_FIELDS, n));
    }

    public void setEnterpriseDuration(int n, Duration duration) {
        this.set((FieldType)this.selectField(ENTERPRISE_DURATION_FIELDS, n), duration);
    }

    public boolean getEnterpriseFlag(int n) {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(this.selectField(ENTERPRISE_FLAG_FIELDS, n)));
    }

    public void setEnterpriseFlag(int n, boolean bl) {
        this.set((FieldType)this.selectField(ENTERPRISE_FLAG_FIELDS, n), bl);
    }

    public Number getEnterpriseNumber(int n) {
        return (Number)this.getCachedValue(this.selectField(ENTERPRISE_NUMBER_FIELDS, n));
    }

    public void setEnterpriseNumber(int n, Number number) {
        this.set((FieldType)this.selectField(ENTERPRISE_NUMBER_FIELDS, n), number);
    }

    public String getEnterpriseText(int n) {
        return (String)this.getCachedValue(this.selectField(ENTERPRISE_TEXT_FIELDS, n));
    }

    public void setEnterpriseText(int n, String string) {
        this.set((FieldType)this.selectField(ENTERPRISE_TEXT_FIELDS, n), string);
    }

    public void setBaselineCost(int n, Number number) {
        this.set((FieldType)this.selectField(BASELINE_COSTS, n), number);
    }

    public void setBaselineDuration(int n, Duration duration) {
        this.set((FieldType)this.selectField(BASELINE_DURATIONS, n), duration);
    }

    public void setBaselineFinish(int n, Date date) {
        this.set((FieldType)this.selectField(BASELINE_FINISHES, n), date);
    }

    public void setBaselineStart(int n, Date date) {
        this.set((FieldType)this.selectField(BASELINE_STARTS, n), date);
    }

    public void setBaselineWork(int n, Duration duration) {
        this.set((FieldType)this.selectField(BASELINE_WORKS, n), duration);
    }

    public Number getBaselineCost(int n) {
        return (Number)this.getCachedValue(this.selectField(BASELINE_COSTS, n));
    }

    public Duration getBaselineDuration(int n) {
        Object object = this.getCachedValue(this.selectField(BASELINE_DURATIONS, n));
        if (object == null) {
            object = this.getCachedValue(this.selectField(BASELINE_ESTIMATED_DURATIONS, n));
        }
        if (!(object instanceof Duration)) {
            object = null;
        }
        return (Duration)object;
    }

    public String getBaselineDurationText(int n) {
        Object object = this.getCachedValue(this.selectField(BASELINE_DURATIONS, n));
        if (object == null) {
            object = this.getCachedValue(this.selectField(BASELINE_ESTIMATED_DURATIONS, n));
        }
        if (!(object instanceof String)) {
            object = null;
        }
        return (String)object;
    }

    public void setBaselineDurationText(int n, String string) {
        this.set((FieldType)this.selectField(BASELINE_DURATIONS, n), string);
    }

    public Date getBaselineFinish(int n) {
        Object object = this.getCachedValue(this.selectField(BASELINE_FINISHES, n));
        if (object == null) {
            object = this.getCachedValue(this.selectField(BASELINE_ESTIMATED_FINISHES, n));
        }
        if (!(object instanceof Date)) {
            object = null;
        }
        return (Date)object;
    }

    public String getBaselineFinishText(int n) {
        Object object = this.getCachedValue(this.selectField(BASELINE_FINISHES, n));
        if (object == null) {
            object = this.getCachedValue(this.selectField(BASELINE_ESTIMATED_FINISHES, n));
        }
        if (!(object instanceof String)) {
            object = null;
        }
        return (String)object;
    }

    public void setBaselineFinishText(int n, String string) {
        this.set((FieldType)this.selectField(BASELINE_FINISHES, n), string);
    }

    public Date getBaselineStart(int n) {
        Object object = this.getCachedValue(this.selectField(BASELINE_STARTS, n));
        if (object == null) {
            object = this.getCachedValue(this.selectField(BASELINE_ESTIMATED_STARTS, n));
        }
        if (!(object instanceof Date)) {
            object = null;
        }
        return (Date)object;
    }

    public String getBaselineStartText(int n) {
        Object object = this.getCachedValue(this.selectField(BASELINE_STARTS, n));
        if (object == null) {
            object = this.getCachedValue(this.selectField(BASELINE_ESTIMATED_STARTS, n));
        }
        if (!(object instanceof String)) {
            object = null;
        }
        return (String)object;
    }

    public void setBaselineStartText(int n, String string) {
        this.set((FieldType)this.selectField(BASELINE_STARTS, n), string);
    }

    public Duration getBaselineWork(int n) {
        return (Duration)this.getCachedValue(this.selectField(BASELINE_WORKS, n));
    }

    public Date getCompleteThrough() {
        Date date = (Date)this.getCachedValue(TaskField.COMPLETE_THROUGH);
        if (date == null) {
            int n = NumberUtility.getInt(this.getPercentageComplete());
            switch (n) {
                case 0: {
                    break;
                }
                case 100: {
                    date = this.getActualFinish();
                    break;
                }
                default: {
                    Duration duration = this.getDuration();
                    double d = duration.getDuration() * (double)n / 100.0;
                    duration = Duration.getInstance(d, duration.getUnits());
                    ProjectCalendar projectCalendar = this.getCalendar();
                    if (projectCalendar == null) {
                        projectCalendar = this.getParentFile().getCalendar();
                    }
                    date = projectCalendar.getDate(this.getActualStart(), duration, true);
                    break;
                }
            }
            this.set((FieldType)TaskField.COMPLETE_THROUGH, date);
        }
        return date;
    }

    public Date getSummaryProgress() {
        Date date = (Date)this.getCachedValue(TaskField.SUMMARY_PROGRESS);
        return date;
    }

    public void setSummaryProgress(Date date) {
        this.set((FieldType)TaskField.SUMMARY_PROGRESS, date);
    }

    public UUID getGUID() {
        return (UUID)this.getCachedValue(TaskField.GUID);
    }

    public void setGUID(UUID uUID) {
        this.set((FieldType)TaskField.GUID, uUID);
    }

    public TaskMode getTaskMode() {
        return (TaskMode)this.getCachedValue(TaskField.TASK_MODE);
    }

    public void setTaskMode(TaskMode taskMode) {
        this.set((FieldType)TaskField.TASK_MODE, taskMode);
    }

    public boolean getActive() {
        return BooleanUtility.getBoolean((Boolean)this.getCachedValue(TaskField.ACTIVE));
    }

    public void setActive(boolean bl) {
        this.set((FieldType)TaskField.ACTIVE, bl);
    }

    public boolean removePredecessor(Task task, RelationType relationType, Duration duration) {
        boolean bl = false;
        List<Relation> list = this.getPredecessors();
        if (list != null && !list.isEmpty()) {
            List<Relation> list2;
            if (duration == null) {
                duration = Duration.getInstance(0, TimeUnit.DAYS);
            }
            if ((bl = this.removeRelation(list, task, relationType, duration)) && (list2 = task.getSuccessors()) != null && !list2.isEmpty()) {
                this.removeRelation(list2, this, relationType, duration);
            }
        }
        return bl;
    }

    private boolean removeRelation(List<Relation> list, Task task, RelationType relationType, Duration duration) {
        boolean bl = false;
        for (Relation relation : list) {
            if (relation.getTargetTask() != task || relation.getType() != relationType || relation.getLag().compareTo(duration) != 0) continue;
            bl = list.remove(relation);
            break;
        }
        return bl;
    }

    private TaskField selectField(TaskField[] taskFieldArray, int n) {
        if (n < 1 || n > taskFieldArray.length) {
            throw new IllegalArgumentException(n + " is not a valid field index");
        }
        return taskFieldArray[n - 1];
    }

    @Override
    public Object getCachedValue(FieldType fieldType) {
        return fieldType == null ? null : this.m_array[fieldType.getValue()];
    }

    @Override
    public Object getCurrentValue(FieldType fieldType) {
        Object object = null;
        if (fieldType != null) {
            switch ((TaskField)fieldType) {
                case START_VARIANCE: {
                    object = this.getStartVariance();
                    break;
                }
                case COST_VARIANCE: {
                    object = this.getCostVariance();
                    break;
                }
                case DURATION_VARIANCE: {
                    object = this.getDurationVariance();
                    break;
                }
                case WORK_VARIANCE: {
                    object = this.getWorkVariance();
                    break;
                }
                case CV: {
                    object = this.getCV();
                    break;
                }
                case SV: {
                    object = this.getSV();
                    break;
                }
                case TOTAL_SLACK: {
                    object = this.getTotalSlack();
                    break;
                }
                case CRITICAL: {
                    object = this.getCritical();
                    break;
                }
                case COMPLETE_THROUGH: {
                    object = this.getCompleteThrough();
                    break;
                }
                default: {
                    object = this.m_array[fieldType.getValue()];
                }
            }
        }
        return object;
    }

    @Override
    public void set(FieldType fieldType, Object object) {
        if (fieldType != null) {
            int n = fieldType.getValue();
            if (this.m_eventsEnabled) {
                this.fireFieldChangeEvent((TaskField)fieldType, this.m_array[n], object);
            }
            this.m_array[n] = object;
        }
    }

    private void fireFieldChangeEvent(TaskField taskField, Object object, Object object2) {
        switch (taskField) {
            case START: 
            case BASELINE_START: {
                this.m_array[TaskField.START_VARIANCE.getValue()] = null;
                break;
            }
            case FINISH: 
            case BASELINE_FINISH: {
                this.m_array[TaskField.FINISH_VARIANCE.getValue()] = null;
                break;
            }
            case COST: 
            case BASELINE_COST: {
                this.m_array[TaskField.COST_VARIANCE.getValue()] = null;
                break;
            }
            case DURATION: {
                this.m_array[TaskField.DURATION_VARIANCE.getValue()] = null;
                this.m_array[TaskField.COMPLETE_THROUGH.getValue()] = null;
                break;
            }
            case BASELINE_DURATION: {
                this.m_array[TaskField.DURATION_VARIANCE.getValue()] = null;
                break;
            }
            case WORK: 
            case BASELINE_WORK: {
                this.m_array[TaskField.WORK_VARIANCE.getValue()] = null;
                break;
            }
            case BCWP: 
            case ACWP: {
                this.m_array[TaskField.CV.getValue()] = null;
                this.m_array[TaskField.SV.getValue()] = null;
                break;
            }
            case BCWS: {
                this.m_array[TaskField.SV.getValue()] = null;
                break;
            }
            case START_SLACK: 
            case FINISH_SLACK: {
                this.m_array[TaskField.TOTAL_SLACK.getValue()] = null;
                this.m_array[TaskField.CRITICAL.getValue()] = null;
                break;
            }
            case EARLY_FINISH: 
            case LATE_FINISH: {
                this.m_array[TaskField.FINISH_SLACK.getValue()] = null;
                this.m_array[TaskField.TOTAL_SLACK.getValue()] = null;
                this.m_array[TaskField.CRITICAL.getValue()] = null;
                break;
            }
            case EARLY_START: 
            case LATE_START: {
                this.m_array[TaskField.START_SLACK.getValue()] = null;
                this.m_array[TaskField.TOTAL_SLACK.getValue()] = null;
                this.m_array[TaskField.CRITICAL.getValue()] = null;
                break;
            }
            case ACTUAL_START: 
            case PERCENT_COMPLETE: {
                this.m_array[TaskField.COMPLETE_THROUGH.getValue()] = null;
                break;
            }
        }
        if (this.m_listeners != null) {
            for (FieldListener fieldListener : this.m_listeners) {
                fieldListener.fieldChange(this, taskField, object, object2);
            }
        }
    }

    @Override
    public void addFieldListener(FieldListener fieldListener) {
        if (this.m_listeners == null) {
            this.m_listeners = new LinkedList<FieldListener>();
        }
        this.m_listeners.add(fieldListener);
    }

    @Override
    public void removeFieldListener(FieldListener fieldListener) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(fieldListener);
        }
    }

    private void set(FieldType fieldType, boolean bl) {
        this.set(fieldType, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public String toString() {
        return "[Task id=" + this.getID() + " uniqueID=" + this.getUniqueID() + " name=" + this.getName() + (this.getExternalTask() ? " [EXTERNAL uid=" + this.getSubprojectTaskUniqueID() + " id=" + this.getSubprojectTaskID() + "]" : "]") + (this.getSubProject() == null ? "" : " project=" + this.getSubProject());
    }

    public boolean isPredecessor(Task task) {
        return this.isRelated(task, this.getPredecessors());
    }

    public boolean isSucessor(Task task) {
        return this.isRelated(task, this.getSuccessors());
    }

    private boolean isRelated(Task task, List<Relation> list) {
        boolean bl = false;
        if (list != null) {
            for (Relation relation : list) {
                if (relation.getTargetTask().getUniqueID() != task.getUniqueID()) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public void disableEvents() {
        this.m_eventsEnabled = false;
    }

    public void enableEvents() {
        this.m_eventsEnabled = true;
    }
}

