/*
 * Decompiled with CFR 0.152.
 */
package com.projity.field;

import com.projity.configuration.Configuration;
import com.projity.field.Field;
import com.projity.field.FieldContext;
import com.projity.field.FieldParseException;
import com.projity.server.access.ErrorLogger;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class FieldValues {
    public static HashMap getValues(Collection collection, Object object) {
        Iterator iterator = collection.iterator();
        FieldContext fieldContext = null;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        while (iterator.hasNext()) {
            Field field = (Field)iterator.next();
            try {
                Object object2 = field.getValue(object, fieldContext);
                if (object2 == null || !(object2 instanceof Serializable)) continue;
                hashMap.put(field.getId(), object2);
            }
            catch (Exception exception) {
                ErrorLogger.logOnce(field.getName(), "Problem getting field value in FieldValues", exception);
            }
        }
        return hashMap;
    }

    public static void setValuesFromFieldIds(Map map, Object object) {
        if (map == null) {
            return;
        }
        Iterator iterator = map.keySet().iterator();
        FieldContext fieldContext = FieldContext.getNoDirtyInstance();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Field field = Configuration.getFieldFromId(string);
            if (field == null) continue;
            try {
                boolean bl = field.isReadOnly();
                field.setReadOnly(false);
                field.setValue(object, null, map.get(string), fieldContext);
                field.setReadOnly(bl);
            }
            catch (FieldParseException fieldParseException) {
                fieldParseException.printStackTrace();
            }
        }
    }

    public static void dump(Map map) {
        for (String string : map.keySet()) {
            System.out.println("Field " + Configuration.getFieldFromId(string) + " value " + map.get(string));
        }
    }
}

