/*
 * Decompiled with CFR 0.152.
 */
package bsh.util;

import bsh.util.GUIConsoleInterface;
import bsh.util.NameCompletion;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class JConsole
extends JScrollPane
implements GUIConsoleInterface,
ActionListener,
KeyListener,
MouseListener,
PropertyChangeListener,
Runnable {
    private static final String CUT = "Cut";
    private static final String COPY = "Copy";
    private static final String PASTE = "Paste";
    private OutputStream outPipe;
    private InputStream inPipe;
    private InputStream in;
    private PrintStream out;
    private int cmdStart = 0;
    private Vector history = new Vector();
    private String startedLine;
    private int histLine = 0;
    private JPopupMenu menu;
    private JTextPane text;
    private DefaultStyledDocument doc = new DefaultStyledDocument();
    NameCompletion nameCompletion;
    final int SHOW_AMBIG_MAX = 10;
    private boolean gotUp = true;
    String ZEROS = "000";

    public InputStream getInputStream() {
        return this.in;
    }

    public Reader getIn() {
        return new InputStreamReader(this.in);
    }

    public PrintStream getOut() {
        return this.out;
    }

    public PrintStream getErr() {
        return this.out;
    }

    public JConsole() {
        this(null, null);
    }

    public JConsole(InputStream inputStream, OutputStream outputStream) {
        this.text = new JTextPane(this.doc){

            public void cut() {
                if (JConsole.this.text.getCaretPosition() < JConsole.this.cmdStart) {
                    super.copy();
                } else {
                    super.cut();
                }
            }

            public void paste() {
                JConsole.this.forceCaretMoveToEnd();
                super.paste();
            }
        };
        Font font = new Font("Monospaced", 0, 14);
        this.text.setText("");
        this.text.setFont(font);
        this.text.setMargin(new Insets(7, 5, 7, 5));
        this.text.addKeyListener(this);
        this.setViewportView(this.text);
        this.menu = new JPopupMenu("JConsole\tMenu");
        this.menu.add(new JMenuItem(CUT)).addActionListener(this);
        this.menu.add(new JMenuItem(COPY)).addActionListener(this);
        this.menu.add(new JMenuItem(PASTE)).addActionListener(this);
        this.text.addMouseListener(this);
        UIManager.addPropertyChangeListener(this);
        this.outPipe = outputStream;
        if (this.outPipe == null) {
            this.outPipe = new PipedOutputStream();
            try {
                this.in = new PipedInputStream((PipedOutputStream)this.outPipe);
            }
            catch (IOException iOException) {
                this.print("Console internal\terror (1)...", Color.red);
            }
        }
        this.inPipe = inputStream;
        if (this.inPipe == null) {
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            this.out = new PrintStream(pipedOutputStream);
            try {
                this.inPipe = new BlockingPipedInputStream(pipedOutputStream);
            }
            catch (IOException iOException) {
                this.print("Console internal error: " + iOException);
            }
        }
        new Thread(this).start();
        this.requestFocus();
    }

    public void requestFocus() {
        super.requestFocus();
        this.text.requestFocus();
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.type(keyEvent);
        this.gotUp = false;
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.type(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.gotUp = true;
        this.type(keyEvent);
    }

    private synchronized void type(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                if (keyEvent.getID() == 401 && this.gotUp) {
                    this.enter();
                    this.resetCommandStart();
                    this.text.setCaretPosition(this.cmdStart);
                }
                keyEvent.consume();
                this.text.repaint();
                break;
            }
            case 38: {
                if (keyEvent.getID() == 401) {
                    this.historyUp();
                }
                keyEvent.consume();
                break;
            }
            case 40: {
                if (keyEvent.getID() == 401) {
                    this.historyDown();
                }
                keyEvent.consume();
                break;
            }
            case 8: 
            case 37: 
            case 127: {
                if (this.text.getCaretPosition() > this.cmdStart) break;
                keyEvent.consume();
                break;
            }
            case 39: {
                this.forceCaretMoveToStart();
                break;
            }
            case 36: {
                this.text.setCaretPosition(this.cmdStart);
                keyEvent.consume();
                break;
            }
            case 85: {
                if ((keyEvent.getModifiers() & 2) <= 0) break;
                this.replaceRange("", this.cmdStart, this.textLength());
                this.histLine = 0;
                keyEvent.consume();
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 145: 
            case 154: 
            case 155: 
            case 157: {
                break;
            }
            case 67: {
                if (this.text.getSelectedText() != null) break;
                if ((keyEvent.getModifiers() & 2) > 0 && keyEvent.getID() == 401) {
                    this.append("^C");
                }
                keyEvent.consume();
                break;
            }
            case 9: {
                if (keyEvent.getID() == 402) {
                    String string = this.text.getText().substring(this.cmdStart);
                    this.doCommandCompletion(string);
                }
                keyEvent.consume();
                break;
            }
            default: {
                if ((keyEvent.getModifiers() & 0xE) == 0) {
                    this.forceCaretMoveToEnd();
                }
                if (keyEvent.paramString().indexOf("Backspace") == -1 || this.text.getCaretPosition() > this.cmdStart) break;
                keyEvent.consume();
            }
        }
    }

    void doCommandCompletion(String string) {
        if (this.nameCompletion == null) {
            return;
        }
        int n = string.length() - 1;
        while (n >= 0 && (Character.isJavaIdentifierPart(string.charAt(n)) || string.charAt(n) == '.')) {
            --n;
        }
        if ((string = string.substring(n + 1)).length() < 2) {
            return;
        }
        String[] stringArray = this.nameCompletion.completeName(string);
        if (stringArray.length == 0) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (stringArray.length == 1 && !stringArray.equals(string)) {
            String string2 = stringArray[0].substring(string.length());
            this.append(string2);
            return;
        }
        String string3 = this.text.getText();
        String string4 = string3.substring(this.cmdStart);
        n = this.cmdStart;
        while (string3.charAt(n) != '\n' && n > 0) {
            --n;
        }
        String string5 = string3.substring(n + 1, this.cmdStart);
        StringBuffer stringBuffer = new StringBuffer("\n");
        n = 0;
        while (n < stringArray.length && n < 10) {
            stringBuffer.append(stringArray[n] + "\n");
            ++n;
        }
        if (n == 10) {
            stringBuffer.append("...\n");
        }
        this.print((Object)stringBuffer, Color.gray);
        this.print(string5);
        this.append(string4);
    }

    private void resetCommandStart() {
        this.cmdStart = this.textLength();
    }

    private void append(String string) {
        int n = this.textLength();
        this.text.select(n, n);
        this.text.replaceSelection(string);
    }

    String replaceRange(Object object, int n, int n2) {
        String string = object.toString();
        this.text.select(n, n2);
        this.text.replaceSelection(string);
        return string;
    }

    private void forceCaretMoveToEnd() {
        if (this.text.getCaretPosition() < this.cmdStart) {
            this.text.setCaretPosition(this.textLength());
        }
        this.text.repaint();
    }

    private void forceCaretMoveToStart() {
        if (this.text.getCaretPosition() < this.cmdStart) {
            // empty if block
        }
        this.text.repaint();
    }

    private void enter() {
        String string = this.getCmd();
        if (string.length() == 0) {
            string = ";\n";
        } else {
            this.history.addElement(string);
            string = string + "\n";
        }
        this.append("\n");
        this.histLine = 0;
        this.acceptLine(string);
        this.text.repaint();
    }

    private String getCmd() {
        String string = "";
        try {
            string = this.text.getText(this.cmdStart, this.textLength() - this.cmdStart);
        }
        catch (BadLocationException badLocationException) {
            System.out.println("Internal JConsole Error: " + badLocationException);
        }
        return string;
    }

    private void historyUp() {
        if (this.history.size() == 0) {
            return;
        }
        if (this.histLine == 0) {
            this.startedLine = this.getCmd();
        }
        if (this.histLine < this.history.size()) {
            ++this.histLine;
            this.showHistoryLine();
        }
    }

    private void historyDown() {
        if (this.histLine == 0) {
            return;
        }
        --this.histLine;
        this.showHistoryLine();
    }

    private void showHistoryLine() {
        String string = this.histLine == 0 ? this.startedLine : (String)this.history.elementAt(this.history.size() - this.histLine);
        this.replaceRange(string, this.cmdStart, this.textLength());
        this.text.setCaretPosition(this.textLength());
        this.text.repaint();
    }

    private void acceptLine(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            String string2 = Integer.toString(string.charAt(n2), 16);
            string2 = this.ZEROS.substring(0, 4 - string2.length()) + string2;
            stringBuffer.append("\\u" + string2);
            ++n2;
        }
        string = stringBuffer.toString();
        if (this.outPipe == null) {
            this.print("Console internal\terror: cannot output ...", Color.red);
        } else {
            try {
                this.outPipe.write(string.getBytes());
                this.outPipe.flush();
            }
            catch (IOException iOException) {
                this.outPipe = null;
                throw new RuntimeException("Console pipe broken...");
            }
        }
    }

    public void println(String string) {
        this.print(string + "\n");
        this.text.repaint();
    }

    public synchronized void print(String string) {
        this.append(string == null ? "null" : string);
        this.resetCommandStart();
        this.text.setCaretPosition(this.cmdStart);
    }

    public void println() {
        this.print("\n");
        this.text.repaint();
    }

    public void error(String string) {
        this.print(string, Color.red);
    }

    public void println(Object object) {
        this.print(new StringBuffer(String.valueOf(object)).append("\n"));
        this.text.repaint();
    }

    public void println(Icon icon) {
        this.print(icon);
        this.println();
        this.text.repaint();
    }

    public synchronized void print(Object object) {
        this.append(String.valueOf(object));
        this.resetCommandStart();
        this.text.setCaretPosition(this.cmdStart);
    }

    public synchronized void print(Icon icon) {
        if (icon == null) {
            return;
        }
        this.text.insertIcon(icon);
        this.resetCommandStart();
        this.text.setCaretPosition(this.cmdStart);
    }

    public void print(Object object, Font font) {
        this.print(object, font, null);
    }

    public void print(Object object, Color color) {
        this.print(object, null, color);
    }

    public void print(String string, Color color) {
        this.print(string, null, color);
    }

    public synchronized void print(Object object, Font font, Color color) {
        AttributeSet attributeSet = this.getStyle();
        this.setStyle(font, color);
        this.print(object);
        this.setStyle(attributeSet, true);
    }

    public synchronized void print(Object object, String string, int n, Color color) {
        AttributeSet attributeSet = this.getStyle();
        this.setStyle(string, n, color);
        this.print(object);
        this.setStyle(attributeSet, true);
    }

    public synchronized void print(Object object, String string, int n, Color color, boolean bl, boolean bl2, boolean bl3) {
        AttributeSet attributeSet = this.getStyle();
        this.setStyle(string, n, color, bl, bl2, bl3);
        this.print(object);
        this.setStyle(attributeSet, true);
    }

    public AttributeSet setStyle(Font font) {
        return this.setStyle(font, null);
    }

    public AttributeSet setStyle(Color color) {
        return this.setStyle(null, color);
    }

    public AttributeSet setStyle(Font font, Color color) {
        if (font != null) {
            return this.setStyle(font.getFamily(), font.getSize(), color, font.isBold(), font.isItalic(), StyleConstants.isUnderline(this.getStyle()));
        }
        return this.setStyle(null, -1, color);
    }

    public synchronized AttributeSet setStyle(String string, int n, Color color) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        if (color != null) {
            StyleConstants.setForeground(simpleAttributeSet, color);
        }
        if (string != null) {
            StyleConstants.setFontFamily(simpleAttributeSet, string);
        }
        if (n != -1) {
            StyleConstants.setFontSize(simpleAttributeSet, n);
        }
        this.setStyle(simpleAttributeSet);
        return this.getStyle();
    }

    public synchronized AttributeSet setStyle(String string, int n, Color color, boolean bl, boolean bl2, boolean bl3) {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        if (color != null) {
            StyleConstants.setForeground(simpleAttributeSet, color);
        }
        if (string != null) {
            StyleConstants.setFontFamily(simpleAttributeSet, string);
        }
        if (n != -1) {
            StyleConstants.setFontSize(simpleAttributeSet, n);
        }
        StyleConstants.setBold(simpleAttributeSet, bl);
        StyleConstants.setItalic(simpleAttributeSet, bl2);
        StyleConstants.setUnderline(simpleAttributeSet, bl3);
        this.setStyle(simpleAttributeSet);
        return this.getStyle();
    }

    public void setStyle(AttributeSet attributeSet) {
        this.setStyle(attributeSet, false);
    }

    public void setStyle(AttributeSet attributeSet, boolean bl) {
        this.text.setCharacterAttributes(attributeSet, bl);
    }

    public AttributeSet getStyle() {
        return this.text.getCharacterAttributes();
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.text != null) {
            this.text.setFont(font);
        }
    }

    private void inPipeWatcher() throws IOException {
        int n;
        byte[] byArray = new byte[256];
        while ((n = this.inPipe.read(byArray)) != -1) {
            this.print(new String(byArray, 0, n));
        }
        this.println("Console: Input\tclosed...");
    }

    public void run() {
        try {
            this.inPipeWatcher();
        }
        catch (IOException iOException) {
            this.print("Console: I/O Error: " + iOException + "\n", Color.red);
        }
    }

    public String toString() {
        return "BeanShell console";
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.menu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.menu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        }
        this.text.repaint();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("lookAndFeel")) {
            SwingUtilities.updateComponentTreeUI(this.menu);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CUT)) {
            this.text.cut();
        } else if (string.equals(COPY)) {
            this.text.copy();
        } else if (string.equals(PASTE)) {
            this.text.paste();
        }
    }

    public void setNameCompletion(NameCompletion nameCompletion) {
        this.nameCompletion = nameCompletion;
    }

    public void setWaitFeedback(boolean bl) {
        if (bl) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private int textLength() {
        return this.text.getDocument().getLength();
    }

    public static class BlockingPipedInputStream
    extends PipedInputStream {
        boolean closed;

        public BlockingPipedInputStream(PipedOutputStream pipedOutputStream) throws IOException {
            super(pipedOutputStream);
        }

        /*
         * Unable to fully structure code
         */
        public synchronized int read() throws IOException {
            if (!this.closed) ** GOTO lbl9
            throw new IOException("stream closed");
lbl-1000:
            // 1 sources

            {
                this.notifyAll();
                try {
                    this.wait(750L);
                    continue;
                }
                catch (InterruptedException var1_1) {
                    throw new InterruptedIOException();
                }
lbl9:
                // 2 sources

                ** while (this.in < 0)
            }
lbl10:
            // 1 sources

            var1_2 = this.buffer[this.out++] & 255;
            if (this.out >= this.buffer.length) {
                this.out = 0;
            }
            if (this.in == this.out) {
                this.in = -1;
            }
            return var1_2;
        }

        public void close() throws IOException {
            this.closed = true;
            super.close();
        }
    }
}

