/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.issue;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiUtil;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.util.LinkButton;
import org.netbeans.modules.bugtracking.util.StackTraceSupport;
import org.netbeans.modules.bugtracking.util.TextUtils;
import org.netbeans.modules.bugtracking.util.WebUrlHyperlinkSupport;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.issue.AttachmentHyperlinkSupport;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.issue.BugzillaIssueFinder;
import org.netbeans.modules.bugzilla.kenai.KenaiRepository;
import org.netbeans.modules.bugzilla.repository.IssueField;
import org.openide.ErrorManager;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CommentsPanel
extends JPanel {
    static final RequestProcessor RP = new RequestProcessor("Bugzilla Comments Panel", 5, false);
    private static final DateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private static final String ISSUE_ATTRIBUTE = "issue";
    private static final String URL_ATTRIBUTE = "url hyperlink";
    private static final String ATTACHMENT_ATTRIBUTE = "attachment hyperlink";
    private static final String REPLY_TO_PROPERTY = "replyTo";
    private static final String QUOTE_PREFIX = "> ";
    private static final int MAX_COMMENT_HEIGHT = 10000;
    private final JPopupMenu commentsPopup = new PopupMenu();
    private final BugzillaIssueFinder issueFinder;
    private BugzillaIssue issue;
    private List<BugzillaIssue.Attachment> attachments;
    private List<String> attachmentIds;
    private MouseAdapter listener;
    private MouseMotionListener motionListener;
    private NewCommentHandler newCommentHandler;
    private ActionListener replyListener;

    public CommentsPanel() {
        this.setBackground(UIManager.getColor("EditorPane.background"));
        this.motionListener = new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                JTextPane pane = (JTextPane)e.getSource();
                StyledDocument doc = pane.getStyledDocument();
                Element elem = doc.getCharacterElement(pane.viewToModel(e.getPoint()));
                AttributeSet as = elem.getAttributes();
                if (StyleConstants.isUnderline(as)) {
                    pane.setCursor(new Cursor(12));
                } else {
                    pane.setCursor(new Cursor(0));
                }
            }
        };
        this.listener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        JTextPane pane = (JTextPane)e.getSource();
                        StyledDocument doc = pane.getStyledDocument();
                        Element elem = doc.getCharacterElement(pane.viewToModel(e.getPoint()));
                        AttributeSet as = elem.getAttributes();
                        IssueAction issueAction = (IssueAction)as.getAttribute(CommentsPanel.ISSUE_ATTRIBUTE);
                        if (issueAction != null) {
                            int startOffset = elem.getStartOffset();
                            int endOffset = elem.getEndOffset();
                            int length = endOffset - startOffset;
                            String hyperlinkText = doc.getText(startOffset, length);
                            issueAction.openIssue(hyperlinkText);
                            return;
                        }
                        UrlAction urlAction = (UrlAction)as.getAttribute(CommentsPanel.URL_ATTRIBUTE);
                        if (urlAction != null) {
                            int startOffset = elem.getStartOffset();
                            int endOffset = elem.getEndOffset();
                            int length = endOffset - startOffset;
                            String hyperlinkText = doc.getText(startOffset, length);
                            urlAction.openUrlHyperlink(hyperlinkText);
                            return;
                        }
                        if (as.getAttribute(CommentsPanel.ATTACHMENT_ATTRIBUTE) != null) {
                            CommentsPanel.this.openAttachmentHyperlink(pane);
                            return;
                        }
                    }
                }
                catch (Exception ex) {
                    Bugzilla.LOG.log(Level.SEVERE, null, ex);
                }
            }
        };
        this.issueFinder = (BugzillaIssueFinder)((Object)Lookup.getDefault().lookup(BugzillaIssueFinder.class));
        assert (this.issueFinder != null);
    }

    void setIssue(BugzillaIssue issue, List<BugzillaIssue.Attachment> attachments) {
        this.removeAll();
        this.issue = issue;
        this.attachments = attachments;
        this.attachmentIds = CommentsPanel.getAttachmentIds(attachments);
        GroupLayout layout = new GroupLayout((Container)this);
        GroupLayout.ParallelGroup horizontalGroup = layout.createParallelGroup(1);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)horizontalGroup).addContainerGap());
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup();
        verticalGroup.addContainerGap();
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)verticalGroup));
        DateFormat format = DateFormat.getDateTimeInstance(2, 3);
        String creationTxt = issue.getFieldValue(IssueField.CREATION);
        try {
            Date creation = dateTimeFormat.parse(creationTxt);
            creationTxt = format.format(creation);
        }
        catch (ParseException pex) {
            Bugzilla.LOG.log(Level.INFO, null, pex);
        }
        this.addSection(layout, issue.getFieldValue(IssueField.DESCRIPTION), issue.getFieldValue(IssueField.REPORTER), issue.getFieldValue(IssueField.REPORTER_NAME), creationTxt, horizontalGroup, verticalGroup, true);
        for (BugzillaIssue.Comment comment : issue.getComments()) {
            String when = format.format(comment.getWhen());
            this.addSection(layout, comment.getText(), comment.getAuthor(), comment.getAuthorName(), when, horizontalGroup, verticalGroup, false);
        }
        verticalGroup.addContainerGap();
        this.setLayout((LayoutManager)layout);
    }

    private static List<String> getAttachmentIds(List<BugzillaIssue.Attachment> attachments) {
        if (attachments.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(attachments.size());
        for (BugzillaIssue.Attachment attachment : attachments) {
            result.add(attachment.getId());
        }
        return result;
    }

    public void setNewCommentHandler(NewCommentHandler handler) {
        this.newCommentHandler = handler;
    }

    private void addSection(GroupLayout layout, String text, String author, String authorName, String dateTimeString, GroupLayout.ParallelGroup horizontalGroup, GroupLayout.SequentialGroup verticalGroup, boolean description) {
        String leftTxt;
        JTextPane textPane = new JTextPane();
        JLabel leftLabel = new JLabel();
        ResourceBundle bundle = NbBundle.getBundle(CommentsPanel.class);
        if (description) {
            String leftFormat = bundle.getString("CommentsPanel.leftLabel.format");
            String summary = TextUtils.escapeForHTMLLabel((String)this.issue.getSummary());
            leftTxt = MessageFormat.format(leftFormat, summary);
        } else {
            leftTxt = bundle.getString("CommentsPanel.leftLabel.text");
        }
        leftLabel.setText(leftTxt);
        JLabel rightLabel = new JLabel();
        String rightFormat = bundle.getString("CommentsPanel.rightLabel.format");
        String authorTxt = authorName != null && authorName.trim().length() > 0 ? authorName : author;
        String rightTxt = MessageFormat.format(rightFormat, dateTimeString, authorTxt);
        rightLabel.setText(rightTxt);
        rightLabel.setLabelFor(textPane);
        JLabel stateLabel = null;
        if (this.issue.getRepository() instanceof KenaiRepository) {
            int index = author.indexOf(64);
            String userName = index == -1 ? author : author.substring(0, index);
            String host = ((KenaiRepository)this.issue.getRepository()).getHost();
            stateLabel = KenaiUtil.createUserWidget((String)userName, (String)host, (String)KenaiUtil.getChatLink((Issue)this.issue));
            stateLabel.setText(null);
        }
        LinkButton replyButton = new LinkButton(bundle.getString("Comments.replyButton.text"));
        replyButton.addActionListener(this.getReplyListener());
        replyButton.putClientProperty((Object)REPLY_TO_PROPERTY, (Object)textPane);
        replyButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommentsPanel.class, (String)"CommentsPanel.replyButton.AccessibleContext.accessibleDescription"));
        this.setupTextPane(textPane, text);
        JComponent pane = textPane;
        if (textPane.getPreferredSize().height > Short.MAX_VALUE) {
            pane = new JScrollPane(textPane);
            pane.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Label.foreground")));
            textPane.setBorder(null);
            Dimension dim = new Dimension(textPane.getPreferredSize());
            dim.height = 10000;
            pane.setPreferredSize(dim);
        }
        GroupLayout.SequentialGroup hGroup = layout.createSequentialGroup().add((Component)leftLabel, 0, 0, Short.MAX_VALUE).addPreferredGap(0).add((Component)replyButton).addPreferredGap(0).add((Component)rightLabel);
        if (stateLabel != null) {
            hGroup.addPreferredGap(0);
            hGroup.add((Component)stateLabel);
        }
        horizontalGroup.add((GroupLayout.Group)hGroup).add((Component)pane, -1, -1, Short.MAX_VALUE);
        if (!description) {
            verticalGroup.addPreferredGap(1);
        }
        GroupLayout.ParallelGroup vGroup = layout.createParallelGroup(3).add((Component)leftLabel).add((Component)replyButton).add((Component)rightLabel);
        if (stateLabel != null) {
            vGroup.add((Component)stateLabel);
        }
        verticalGroup.add((GroupLayout.Group)vGroup).add((Component)pane, -2, -1, -2);
    }

    private void setupTextPane(JTextPane textPane, String comment) {
        int off;
        int i;
        Style defStyle;
        int[] boundaries;
        StyledDocument doc = textPane.getStyledDocument();
        Caret caret = textPane.getCaret();
        if (caret instanceof DefaultCaret) {
            ((DefaultCaret)caret).setUpdatePolicy(1);
        }
        textPane.setText(comment);
        StackTraceSupport.addHyperlinks((JTextPane)textPane);
        int[] pos = this.issueFinder.getIssueSpans(comment);
        if (pos.length > 0) {
            Style defStyle2 = StyleContext.getDefaultStyleContext().getStyle("default");
            Style hlStyle = doc.addStyle("bugBlue", defStyle2);
            hlStyle.addAttribute(ISSUE_ATTRIBUTE, new IssueAction());
            StyleConstants.setForeground(hlStyle, Color.BLUE);
            StyleConstants.setUnderline(hlStyle, true);
            for (int i2 = 0; i2 < pos.length; i2 += 2) {
                int off2 = pos[i2];
                int length = pos[i2 + 1] - pos[i2];
                try {
                    doc.remove(off2, length);
                    doc.insertString(off2, comment.substring(pos[i2], pos[i2 + 1]), hlStyle);
                    continue;
                }
                catch (BadLocationException blex) {
                    Bugzilla.LOG.log(Level.INFO, blex.getMessage(), blex);
                }
            }
        }
        if ((boundaries = WebUrlHyperlinkSupport.findBoundaries((String)comment)) != null && boundaries.length != 0) {
            defStyle = StyleContext.getDefaultStyleContext().getStyle("default");
            Style hlStyle = doc.addStyle("regularBlue", defStyle);
            hlStyle.addAttribute(URL_ATTRIBUTE, new UrlAction());
            StyleConstants.setForeground(hlStyle, Color.BLUE);
            StyleConstants.setUnderline(hlStyle, true);
            for (i = 0; i < boundaries.length; i += 2) {
                off = boundaries[i];
                int length = boundaries[i + 1] - boundaries[i];
                try {
                    doc.remove(off, length);
                    doc.insertString(off, comment.substring(boundaries[i], boundaries[i + 1]), hlStyle);
                    continue;
                }
                catch (BadLocationException ex) {
                    Bugzilla.LOG.log(Level.INFO, ex.getMessage(), ex);
                }
            }
        }
        if (!this.attachmentIds.isEmpty() && (boundaries = AttachmentHyperlinkSupport.findBoundaries(comment, this.attachmentIds)) != null && boundaries.length != 0) {
            defStyle = StyleContext.getDefaultStyleContext().getStyle("default");
            Style hlStyle = doc.addStyle("regularBlue", defStyle);
            hlStyle.addAttribute(ATTACHMENT_ATTRIBUTE, new Object());
            StyleConstants.setForeground(hlStyle, Color.BLUE);
            StyleConstants.setUnderline(hlStyle, true);
            for (i = 0; i < boundaries.length; i += 2) {
                off = boundaries[i];
                int length = boundaries[i + 1] - boundaries[i];
                try {
                    doc.remove(off, length);
                    doc.insertString(off, comment.substring(boundaries[i], boundaries[i + 1]), hlStyle);
                    continue;
                }
                catch (BadLocationException ex) {
                    Bugzilla.LOG.log(Level.INFO, ex.getMessage(), ex);
                }
            }
        }
        textPane.setComponentPopupMenu(this.commentsPopup);
        textPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getColor("Label.foreground")), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        textPane.setEditable(false);
        textPane.addMouseListener(this.listener);
        textPane.addMouseMotionListener(this.motionListener);
        textPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommentsPanel.class, (String)"CommentsPanel.textPane.AccessibleContext.accessibleName"));
        textPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommentsPanel.class, (String)"CommentsPanel.textPane.AccessibleContext.accessibleDescription"));
    }

    private ActionListener getReplyListener() {
        if (this.replyListener == null) {
            this.replyListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JComponent comp;
                    Object value;
                    Object source = e.getSource();
                    if (source instanceof JComponent && (value = (comp = (JComponent)source).getClientProperty(CommentsPanel.REPLY_TO_PROPERTY)) instanceof JTextPane) {
                        JTextPane pane = (JTextPane)value;
                        String text = pane.getText();
                        StringBuilder sb = new StringBuilder();
                        StringTokenizer tokenizer = new StringTokenizer(text, "\n");
                        while (tokenizer.hasMoreElements()) {
                            String line = tokenizer.nextToken();
                            sb.append(CommentsPanel.QUOTE_PREFIX).append(line).append('\n');
                        }
                        CommentsPanel.this.newCommentHandler.append(sb.toString());
                    }
                }
            };
        }
        return this.replyListener;
    }

    private void openAttachmentHyperlink(JTextPane textPane) {
        String attachmentId = null;
        try {
            BugzillaIssue.Attachment attachment = this.getAttachment(textPane);
            if (attachment != null) {
                attachment.open();
            }
        }
        catch (Exception ex) {
            assert (false);
            String errMsg = "Could not open attachment";
            if (attachmentId != null) {
                errMsg = errMsg + " #" + attachmentId;
            }
            ErrorManager.getDefault().log(16, errMsg);
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    private BugzillaIssue.Attachment getAttachment(JTextPane textPane) {
        int index;
        String commentText = textPane.getText();
        String attachmentId = AttachmentHyperlinkSupport.getAttachmentId(commentText);
        if (attachmentId != null && (index = this.attachmentIds.indexOf(attachmentId)) != -1) {
            return this.attachments.get(index);
        }
        return null;
    }

    public static interface NewCommentHandler {
        public void append(String var1);
    }

    class PopupMenu
    extends JPopupMenu {
        private final Point clickPoint = new Point();

        PopupMenu() {
        }

        @Override
        public void show(Component invoker, int x, int y) {
            this.clickPoint.setLocation(x, y);
            super.show(invoker, x, y);
        }

        @Override
        public void setVisible(boolean b) {
            if (b) {
                BugzillaIssue.Attachment attachment;
                JTextPane pane = (JTextPane)this.getInvoker();
                StyledDocument doc = pane.getStyledDocument();
                Element elem = doc.getCharacterElement(pane.viewToModel(this.clickPoint));
                if (elem.getAttributes().getAttribute(CommentsPanel.ATTACHMENT_ATTRIBUTE) != null && (attachment = CommentsPanel.this.getAttachment(pane)) != null) {
                    this.add(new JMenuItem(attachment.new BugzillaIssue.Attachment.DefaultAttachmentAction()));
                    this.add(new JMenuItem(attachment.new BugzillaIssue.Attachment.SaveAttachmentAction()));
                    if ("1".equals(attachment.getIsPatch())) {
                        this.add(attachment.new BugzillaIssue.Attachment.ApplyPatchAction());
                    }
                    super.setVisible(true);
                }
            } else {
                super.setVisible(false);
                this.removeAll();
            }
        }
    }

    private class UrlAction {
        private UrlAction() {
        }

        void openUrlHyperlink(String hyperlinkText) {
            try {
                URL url = new URI(hyperlinkText).toURL();
                HtmlBrowser.URLDisplayer.getDefault().showURL(url);
            }
            catch (Exception ex) {
                assert (false);
                ErrorManager.getDefault().log(16, "Could not open URL: " + hyperlinkText);
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    private class IssueAction {
        private IssueAction() {
        }

        void openIssue(String hyperlinkText) {
            final String issueNo = CommentsPanel.this.issueFinder.getIssueId(hyperlinkText);
            RP.post(new Runnable(){

                @Override
                public void run() {
                    Issue is = CommentsPanel.this.issue.getRepository().getIssue(issueNo);
                    if (is != null) {
                        is.open();
                    }
                }
            });
        }
    }
}

