/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.actions;

import java.io.File;
import java.util.List;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.mobility.project.ui.actions.NodeAction;
import org.netbeans.modules.mobility.project.ui.customizer.VisualClassPathItem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class AddJarAction
extends NodeAction<File> {
    private static File lastFile = null;

    private AddJarAction() {
        super(NbBundle.getMessage(AddJarAction.class, (String)"LBL_CustLibs_Add_Jar"));
    }

    public static Action getStaticInstance() {
        return new AddJarAction();
    }

    protected File[] getItems() {
        File[] files = null;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(true);
        chooser.setDialogTitle(NbBundle.getMessage(AddJarAction.class, (String)"LBL_Classpath_AddJar"));
        chooser.setFileFilter(new JarFileFilter());
        chooser.setAcceptAllFileFilterUsed(false);
        if (this.defaultDir != null) {
            chooser.setSelectedFile(FileUtil.toFile((FileObject)this.defaultDir.getChildren()[0]));
        } else if (lastFile != null) {
            chooser.setSelectedFile(lastFile);
        }
        int option = chooser.showOpenDialog(null);
        if (option == 0 && (files = chooser.getSelectedFiles()).length > 0) {
            lastFile = files[0];
        }
        return files;
    }

    protected List<VisualClassPathItem> addItems(File[] files, List<VisualClassPathItem> set, Node node) {
        for (File file : files) {
            file = FileUtil.normalizeFile((File)file);
            set.add(new VisualClassPathItem(file, 0, null, file.getPath()));
        }
        return set;
    }

    private static class JarFileFilter
    extends FileFilter {
        JarFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            String s = f.getName().toLowerCase();
            return f.isDirectory() || s.endsWith(".zip") || s.endsWith(".jar");
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(AddJarAction.class, (String)"LBL_JarFileFilter");
        }
    }
}

