/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.dd.api.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.j2ee.dd.api.client.AppClient;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.impl.client.AppClientProxy;
import org.netbeans.modules.j2ee.dd.impl.client.ClientParseUtils;
import org.netbeans.modules.j2ee.dd.impl.common.DDUtils;
import org.netbeans.modules.schema2beans.BaseBean;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public final class DDProvider {
    private static final DDProvider ddProvider = new DDProvider();
    private final FCA fileChangeListener;
    private final Map<URL, WeakReference<AppClientProxy>> ddMap = new HashMap<URL, WeakReference<AppClientProxy>>(5);
    private final Map<URL, WeakReference<AppClient>> baseBeanMap = new HashMap<URL, WeakReference<AppClient>>(5);
    private final Map<URL, SAXParseException> errorMap = new HashMap<URL, SAXParseException>(5);

    private DDProvider() {
        this.fileChangeListener = new FCA();
    }

    public static DDProvider getDefault() {
        return ddProvider;
    }

    public AppClient getDDRoot(File f) throws IOException, SAXException {
        return DDUtils.createAppClient(new FileInputStream(f), ClientParseUtils.getVersion(new FileInputStream(f)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized AppClient getDDRoot(FileObject fo) throws IOException {
        AppClientProxy appClient;
        block19: {
            if (fo == null) {
                return null;
            }
            appClient = null;
            Map<URL, WeakReference<AppClientProxy>> map = this.ddMap;
            synchronized (map) {
                appClient = this.getFromCache(fo);
                if (appClient != null) {
                    return appClient;
                }
            }
            fo.addFileChangeListener((FileChangeListener)this.fileChangeListener);
            String version = null;
            SAXParseException error = null;
            try {
                AppClient original = null;
                Map<URL, WeakReference<AppClient>> map2 = this.baseBeanMap;
                synchronized (map2) {
                    original = this.getOriginalFromCache(fo);
                    if (original == null) {
                        version = ClientParseUtils.getVersion(fo.getInputStream());
                        error = ClientParseUtils.parse(fo);
                        original = DDUtils.createAppClient(fo.getInputStream(), version);
                        this.baseBeanMap.put(fo.getURL(), new WeakReference<AppClient>(original));
                        this.errorMap.put(fo.getURL(), error);
                    } else {
                        BigDecimal orgVersion = original.getVersion();
                        if (orgVersion != null) {
                            version = orgVersion.toPlainString();
                        }
                        error = this.errorMap.get(fo.getURL());
                    }
                }
                appClient = new AppClientProxy(original, version);
                if (error != null) {
                    appClient.setStatus(1);
                    appClient.setError(error);
                }
            }
            catch (SAXException ex) {
                appClient = new AppClientProxy(null, version);
                appClient.setStatus(2);
                if (ex instanceof SAXParseException) {
                    appClient.setError((SAXParseException)ex);
                }
                if (!(ex.getException() instanceof SAXParseException)) break block19;
                appClient.setError((SAXParseException)ex.getException());
            }
        }
        Map<URL, WeakReference<AppClientProxy>> map = this.ddMap;
        synchronized (map) {
            AppClientProxy cached = this.getFromCache(fo);
            if (cached != null) {
                return cached;
            }
            this.ddMap.put(fo.getURL(), new WeakReference<AppClientProxy>(appClient));
        }
        return appClient;
    }

    public AppClient getDDRootCopy(FileObject fo) throws IOException {
        return (AppClient)this.getDDRoot(fo).clone();
    }

    private AppClientProxy getFromCache(FileObject fo) throws IOException {
        if (fo == null) {
            return null;
        }
        WeakReference<AppClientProxy> wr = this.ddMap.get(fo.getURL());
        if (wr == null) {
            return null;
        }
        AppClientProxy appClient = (AppClientProxy)wr.get();
        if (appClient == null) {
            this.ddMap.remove(fo.getURL());
        }
        return appClient;
    }

    private AppClient getOriginalFromCache(FileObject fo) throws IOException {
        WeakReference<AppClient> wr = this.baseBeanMap.get(fo.getURL());
        if (wr == null) {
            return null;
        }
        AppClient appClient = (AppClient)wr.get();
        if (appClient == null) {
            this.baseBeanMap.remove(fo.getURL());
            this.errorMap.remove(fo.getURL());
        }
        return appClient;
    }

    public BaseBean getBaseBean(CommonDDBean bean) {
        Object result = bean instanceof BaseBean ? (BaseBean)bean : (bean instanceof AppClientProxy ? (BaseBean)((AppClientProxy)bean).getOriginal() : null);
        return result;
    }

    private class FCA
    extends FileChangeAdapter {
        private FCA() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fileChanged(FileEvent evt) {
            FileObject fo = evt.getFile();
            try {
                Map map = DDProvider.this.ddMap;
                synchronized (map) {
                    Map map2 = DDProvider.this.baseBeanMap;
                    synchronized (map2) {
                        AppClientProxy appClient = DDProvider.this.getFromCache(fo);
                        AppClient orig = DDProvider.this.getOriginalFromCache(fo);
                        if (appClient != null) {
                            String version = null;
                            try {
                                version = ClientParseUtils.getVersion(fo.getInputStream());
                                SAXParseException error = ClientParseUtils.parse(fo);
                                if (error != null) {
                                    appClient.setError(error);
                                    appClient.setStatus(1);
                                } else {
                                    appClient.setError(null);
                                    appClient.setStatus(0);
                                }
                                AppClient original = DDUtils.createAppClient(fo.getInputStream(), version);
                                DDProvider.this.baseBeanMap.put(fo.getURL(), new WeakReference<AppClient>(original));
                                DDProvider.this.errorMap.put(fo.getURL(), appClient.getError());
                                appClient.merge(original, 3);
                            }
                            catch (SAXException ex) {
                                if (ex instanceof SAXParseException) {
                                    appClient.setError((SAXParseException)ex);
                                } else if (ex.getException() instanceof SAXParseException) {
                                    appClient.setError((SAXParseException)ex.getException());
                                }
                                appClient.setStatus(2);
                                appClient.setOriginal(null);
                                appClient.setProxyVersion(version);
                            }
                        } else if (orig != null) {
                            String version = null;
                            try {
                                version = ClientParseUtils.getVersion(fo.getInputStream());
                                AppClient original = DDUtils.createAppClient(fo.getInputStream(), version);
                                if (original.getClass().equals(orig.getClass())) {
                                    orig.merge(original, 3);
                                } else {
                                    DDProvider.this.baseBeanMap.put(fo.getURL(), new WeakReference<AppClient>(original));
                                }
                            }
                            catch (SAXException ex) {
                                DDProvider.this.baseBeanMap.remove(fo.getURL());
                            }
                        }
                    }
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

