/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyModule;
import org.jruby.nb.ast.BlockAcceptingNode;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.ASTInterpreter;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class SuperNode
extends Node
implements BlockAcceptingNode {
    private final Node argsNode;
    private Node iterNode;

    public SuperNode(ISourcePosition position, Node argsNode) {
        this(position, argsNode, null);
    }

    public SuperNode(ISourcePosition position, Node argsNode, Node iterNode) {
        super(position, NodeType.SUPERNODE);
        this.argsNode = argsNode;
        this.iterNode = iterNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitSuperNode(this);
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    @Override
    public List<Node> childNodes() {
        return this.iterNode != null ? SuperNode.createList(this.argsNode, this.iterNode) : SuperNode.createList(this.argsNode);
    }

    @Override
    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public Node setIterNode(Node iterNode) {
        this.iterNode = iterNode;
        return this;
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        RuntimeHelpers.checkSuperDisabledOrOutOfMethod(context);
        IRubyObject[] args = ASTInterpreter.setupArgs(runtime, context, this.argsNode, self, aBlock);
        Block block = ASTInterpreter.getBlock(runtime, context, self, aBlock, this.iterNode);
        if (this.iterNode == null && !block.isGiven()) {
            block = aBlock;
        }
        return self.callSuper(context, args, block);
    }

    @Override
    public String definition(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        String name = context.getFrameName();
        RubyModule klazz = context.getFrameKlazz();
        if (name != null && klazz != null && klazz.getSuperClass().isMethodBound(name, false)) {
            return ASTInterpreter.getArgumentDefinition(runtime, context, this.argsNode, "super", self, aBlock);
        }
        return null;
    }
}

