/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.visualizers.threadmap;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.netbeans.modules.dlight.visualizers.threadmap.ThreadsPanel;
import org.netbeans.modules.dlight.visualizers.threadmap.TimeLine;
import org.netbeans.modules.dlight.visualizers.threadmap.TimeLineUtils;

public class ThreadStateHeaderRenderer
extends JPanel
implements TableCellRenderer,
Serializable {
    private ThreadsPanel viewManager;
    private long dataStart;
    private long viewEnd;
    private long viewStart;
    private TimeLine timeLine;
    static int shift = 0;

    public ThreadStateHeaderRenderer(ThreadsPanel viewManager) {
        this.viewManager = viewManager;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public boolean isOpaque() {
        Color back = this.getBackground();
        Container p = this.getParent();
        if (p != null) {
            p = p.getParent();
        }
        boolean colorMatch = back != null && p != null && back.equals(p.getBackground()) && p.isOpaque();
        return !colorMatch && super.isOpaque();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(super.getPreferredSize().width, this.getFont().getSize() + 11);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.viewStart = this.viewManager.getViewStart();
        this.viewEnd = this.viewManager.getViewEnd();
        this.dataStart = this.viewManager.getDataStart();
        this.timeLine = this.viewManager.getTimeLine();
        return this;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.paintResizableMark(g);
        this.paintTimeMarks(g);
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void validate() {
    }

    private void paintResizableMark(Graphics g) {
        int margin;
        int i;
        g.setColor(Color.BLACK);
        for (i = margin = 4; i < this.getSize().height - margin; i += 2) {
            g.drawLine(1, i, 1, i);
        }
        for (i = margin + 1; i < this.getSize().height - margin - 1; i += 2) {
            g.drawLine(0, i, 0, i);
        }
        g.setClip(4, 0, this.getWidth() - 3, this.getHeight());
    }

    private void paintTimeMarkString(Graphics g, int currentMark, int optimalUnits, int x, int y) {
        int markStringMillisMargin = 0;
        int markStringMillisReduce = 2;
        Font markStringNoMillisFont = g.getFont();
        Font markStringMillisFont = markStringNoMillisFont.deriveFont((float)(markStringNoMillisFont.getSize() - 2));
        String markStringNoMillis = TimeLineUtils.getTimeMarkNoMillisString(currentMark, optimalUnits);
        int wMarkStringNoMillis = g.getFontMetrics().stringWidth(markStringNoMillis);
        String markStringMillis = TimeLineUtils.getTimeMarkMillisString(currentMark, optimalUnits);
        if (!markStringMillis.equals("")) {
            markStringMillis = "." + markStringMillis;
        }
        int xMarkStringNoMillis = x - wMarkStringNoMillis / 2 + 1;
        int xMarkStringMillis = xMarkStringNoMillis + wMarkStringNoMillis + markStringMillisMargin;
        g.setColor(TimeLineUtils.BASE_TIMELINE_COLOR);
        g.drawString(markStringNoMillis, xMarkStringNoMillis, y);
        g.setFont(markStringMillisFont);
        g.drawString(markStringMillis, xMarkStringMillis, y - markStringMillisReduce + 1);
        g.setFont(markStringNoMillisFont);
    }

    private void paintTimeMarks(Graphics g) {
        g.setFont(g.getFont().deriveFont(1));
        if (this.viewEnd - this.viewStart > 0L) {
            long time;
            int firstValue = (int)(this.viewStart - this.dataStart);
            int lastValue = (int)(this.viewEnd - this.dataStart);
            float factor = (float)this.getWidth() / (float)(this.viewEnd - this.viewStart);
            int optimalUnits = TimeLineUtils.getOptimalUnits(factor);
            int firstMark = Math.max((int)(Math.ceil((double)firstValue / (double)optimalUnits) * (double)optimalUnits), 0);
            int componentFontSize = this.getFont().getSize();
            for (int currentMark = firstMark - optimalUnits; currentMark <= lastValue + optimalUnits; currentMark += optimalUnits) {
                if (currentMark < 0) continue;
                float currentMarkRel = currentMark - firstValue;
                int markPosition = (int)(currentMarkRel * factor);
                this.paintTimeTicks(g, (int)(currentMarkRel * factor), (int)((currentMarkRel + (float)optimalUnits) * factor), TimeLineUtils.getTicksCount(optimalUnits));
                g.setColor(TimeLineUtils.BASE_TIMELINE_COLOR);
                g.drawLine(markPosition += shift, 0, markPosition, 4);
                this.paintTimeMarkString(g, currentMark, optimalUnits, markPosition, 5 + componentFontSize);
                g.setColor(TimeLineUtils.MAIN_TIMELINE_COLOR);
                g.drawLine(markPosition, 8 + componentFontSize, markPosition, this.getHeight() - 1);
            }
            Font origFont = g.getFont();
            Font plainFont = origFont.deriveFont(0);
            String sLegend = TimeLineUtils.getUnitsLegend(lastValue, optimalUnits);
            int wLegend = g.getFontMetrics(plainFont).stringWidth(sLegend);
            if (wLegend + 7 <= this.getWidth()) {
                g.setFont(plainFont);
                g.setColor(Color.WHITE);
                g.fillRect(this.getWidth() - wLegend - 6, 5, wLegend + 7, 4 + plainFont.getSize());
                g.setColor(Color.BLACK);
                g.drawString(sLegend, this.getWidth() - wLegend - 2, 5 + plainFont.getSize());
                g.setFont(origFont);
            }
            if (this.timeLine != null && this.viewStart < (time = this.timeLine.getTimeStamp() + (long)(this.timeLine.getInterval() / 2)) && time < this.viewEnd) {
                int x = (int)((long)this.getWidth() * (time - this.viewStart) / (this.viewEnd - this.viewStart));
                g.setColor(TimeLineUtils.TIMELINE_CURSOR_COLOR);
                g.drawLine((x += shift) - 3, 0, x - 3, 2);
                g.drawLine(x - 3, 2, x, 5);
                g.drawLine(x, 5, x + 3, 2);
                g.drawLine(x + 3, 2, x + 3, 0);
                g.drawLine(x + 3, 0, x - 3, 0);
            }
        }
    }

    private void paintTimeTicks(Graphics g, int startPos, int endPos, int count) {
        long time;
        float factor = (float)(endPos - startPos) / (float)count;
        for (int i = 1; i < count; ++i) {
            int x = startPos + (int)((float)i * factor);
            g.setColor(TimeLineUtils.BASE_TIMELINE_COLOR);
            g.drawLine(x += shift, 0, x, 2);
            g.setColor(TimeLineUtils.TICK_TIMELINE_COLOR);
            g.drawLine(x, 3, x, this.getHeight() - 1);
        }
        if (this.timeLine != null && this.viewStart < (time = this.timeLine.getTimeStamp() + (long)(this.timeLine.getInterval() / 2)) && time < this.viewEnd) {
            int x = (int)((long)this.getWidth() * (time - this.viewStart) / (this.viewEnd - this.viewStart));
            g.setColor(TimeLineUtils.TIMELINE_CURSOR_COLOR);
            g.drawLine(x += shift, 6, x, this.getHeight() - 1);
        }
    }
}

