/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyModule(name={"GC"})
public class RubyGC {
    private static volatile boolean gcDisabled = false;
    private static volatile boolean stress = false;

    public static RubyModule createGCModule(Ruby runtime2) {
        RubyModule result = runtime2.defineModule("GC");
        runtime2.setGC(result);
        result.defineAnnotatedMethods(RubyGC.class);
        return result;
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject start(ThreadContext context, IRubyObject recv2) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod
    public static IRubyObject garbage_collect(ThreadContext context, IRubyObject recv2) {
        return context.getRuntime().getNil();
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject enable(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        RubyGC.emptyImplementationWarning(runtime2, "GC.enable");
        boolean old = gcDisabled;
        gcDisabled = false;
        return runtime2.newBoolean(old);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject disable(ThreadContext context, IRubyObject recv2) {
        Ruby runtime2 = context.getRuntime();
        RubyGC.emptyImplementationWarning(runtime2, "GC.disable");
        boolean old = gcDisabled;
        gcDisabled = true;
        return runtime2.newBoolean(old);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject stress(ThreadContext context, IRubyObject recv2) {
        return context.getRuntime().newBoolean(stress);
    }

    @JRubyMethod(name={"stress="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject stress_set(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        Ruby runtime2 = context.getRuntime();
        RubyGC.emptyImplementationWarning(runtime2, "GC.stress=");
        stress = arg2.isTrue();
        return runtime2.newBoolean(stress);
    }

    private static void emptyImplementationWarning(Ruby runtime2, String name2) {
        runtime2.getWarnings().warn(IRubyWarnings.ID.EMPTY_IMPLEMENTATION, name2 + " does nothing on JRuby", name2);
    }
}

