/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.dd.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.j2ee.persistence.dd.common.ParseUtils;
import org.openide.filesystems.FileObject;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class JPAParseUtils {
    private static final Logger LOGGER = Logger.getLogger(JPAParseUtils.class.getName());

    public static String getVersion(InputStream inputStream) throws IOException, SAXException {
        return ParseUtils.getVersion(inputStream, (DefaultHandler)new VersionHandler(), (EntityResolver)DDResolver.getInstance());
    }

    public static String getVersion(InputSource inputSource) throws IOException, SAXException {
        return ParseUtils.getVersion(inputSource, (DefaultHandler)new VersionHandler(), (EntityResolver)DDResolver.getInstance());
    }

    public static SAXParseException parse(FileObject fileObject) throws SAXException, IOException {
        return JPAParseUtils.parse(new InputSource(fileObject.getInputStream()));
    }

    public static SAXParseException parse(InputSource inputSource) throws SAXException, IOException {
        return ParseUtils.parseDD(inputSource, DDResolver.getInstance());
    }

    public static SAXParseException parse(InputSource inputSource, EntityResolver entityResolver) throws SAXException, IOException {
        return ParseUtils.parseDD(inputSource, entityResolver);
    }

    private static class DDResolver
    implements EntityResolver {
        static DDResolver resolver;

        private DDResolver() {
        }

        static synchronized DDResolver getInstance() {
            if (resolver == null) {
                resolver = new DDResolver();
            }
            return resolver;
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Resolving entity [publicId: '" + string + "', systemId: '" + string2 + "']");
            }
            String string3 = null;
            if (string2 != null && string2.endsWith("persistence_2_0.xsd")) {
                string3 = "/org/netbeans/modules/j2ee/persistence/dd/resources/persistence_2_0.xsd";
            } else if (string2 != null && string2.endsWith("persistence_1_0.xsd")) {
                string3 = "/org/netbeans/modules/j2ee/persistence/dd/resources/persistence_1_0.xsd";
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Got resource: " + string3);
            }
            if (string3 == null) {
                return null;
            }
            URL uRL = this.getClass().getResource(string3);
            return new InputSource(uRL.toString());
        }
    }

    private static class VersionHandler
    extends DefaultHandler {
        private VersionHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if ("persistence".equals(string3)) {
                String string4 = attributes.getValue("version");
                throw new SAXException("version:" + (string4 == null ? "2.0" : string4));
            }
        }

        @Override
        public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
            return super.resolveEntity(string, string2);
        }

        @Override
        public void startElement(String string, String string2, String string3, org.xml.sax.Attributes attributes) throws SAXException {
            if ("persistence".equals(string3)) {
                String string4 = attributes.getValue("version");
                throw new SAXException("version:" + (string4 == null ? "2.0" : string4));
            }
        }
    }
}

