/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.netbeans.spi.java.queries.MultipleRootsUnitTestForSourceQueryImplementation;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class TestQuery
implements MultipleRootsUnitTestForSourceQueryImplementation {
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final AuxiliaryConfiguration aux;

    public TestQuery(AntProjectHelper helper, PropertyEvaluator eval, AuxiliaryConfiguration aux) {
        this.helper = helper;
        this.eval = eval;
        this.aux = aux;
    }

    public URL[] findUnitTests(FileObject source) {
        URL sourceURL;
        URL[][] data = this.findSourcesAndTests();
        try {
            sourceURL = source.getURL();
        }
        catch (FileStateInvalidException e) {
            return null;
        }
        if (Arrays.asList(data[0]).contains(sourceURL)) {
            return data[1];
        }
        return null;
    }

    public URL[] findSources(FileObject unitTest) {
        URL testURL;
        URL[][] data = this.findSourcesAndTests();
        try {
            testURL = unitTest.getURL();
        }
        catch (FileStateInvalidException e) {
            return null;
        }
        if (Arrays.asList(data[1]).contains(testURL)) {
            return data[0];
        }
        return null;
    }

    private URL[][] findSourcesAndTests() {
        ArrayList sources = new ArrayList();
        ArrayList<URL> tests = new ArrayList<URL>();
        Element data = this.aux.getConfigurationFragment("java-data", "http://www.netbeans.org/ns/freeform-project-java/3", true);
        if (data != null) {
            for (Element cu : XMLUtil.findSubElements((Element)data)) {
                assert (cu.getLocalName().equals("compilation-unit")) : cu;
                boolean isTests = XMLUtil.findElement((Element)cu, (String)"unit-tests", (String)"http://www.netbeans.org/ns/freeform-project-java/3") != null;
                for (Element pr : XMLUtil.findSubElements((Element)cu)) {
                    if (!pr.getLocalName().equals("package-root")) continue;
                    String rawtext = XMLUtil.findText((Node)pr);
                    assert (rawtext != null);
                    String evaltext = this.eval.evaluate(rawtext);
                    if (evaltext == null) continue;
                    (isTests ? tests : sources).add(this.evalTextToURL(evaltext));
                }
            }
        }
        return new URL[][]{sources.toArray(new URL[sources.size()]), tests.toArray(new URL[tests.size()])};
    }

    private URL evalTextToURL(String evaltext) {
        File location = this.helper.resolveFile(evaltext);
        return FileUtil.urlForArchiveOrDir((File)location);
    }
}

