/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.ParseException;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.support.RemoteException;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.remote.sync.BaseSyncWorker;
import org.netbeans.modules.cnd.remote.sync.RfsLocalController;
import org.netbeans.modules.cnd.remote.sync.RfsSetupProvider;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

final class RfsSyncWorker
extends BaseSyncWorker
implements RemoteSyncWorker {
    private static final RequestProcessor RP = new RequestProcessor("RFS Sync Worker", 20);
    private NativeProcess remoteControllerProcess;
    private RfsLocalController localController;
    private String remoteDir;

    public RfsSyncWorker(ExecutionEnvironment executionEnvironment, PrintWriter out, PrintWriter err, File privProjectStorageDir, File ... files) {
        super(executionEnvironment, out, err, privProjectStorageDir, files);
    }

    public boolean startup(Map<String, String> env2add) {
        boolean success;
        block11: {
            RemotePathMap mapper = RemotePathMap.getPathMap(this.executionEnvironment);
            this.remoteDir = mapper.getRemotePath("/", false);
            if (this.remoteDir == null) {
                if (this.err != null) {
                    this.err.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Cant_find_sync_root", (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString()));
                }
                return false;
            }
            success = false;
            try {
                Future mkDir;
                if (this.out != null) {
                    this.out.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Copying", (Object)this.remoteDir, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString()));
                }
                if ((Integer)(mkDir = CommonTasksSupport.mkDir((ExecutionEnvironment)this.executionEnvironment, (String)this.remoteDir, (Writer)this.err)).get() != 0) {
                    throw new IOException("Can not create directory " + this.remoteDir);
                }
                this.startupImpl(env2add);
                success = true;
            }
            catch (RemoteException ex) {
                this.printErr(ex);
            }
            catch (InterruptedException ex) {
                RemoteUtil.LOGGER.finest(ex.getMessage());
            }
            catch (InterruptedIOException ex) {
                RemoteUtil.LOGGER.finest(ex.getMessage());
            }
            catch (ExecutionException ex) {
                RemoteUtil.LOGGER.log(Level.FINE, null, ex);
                if (this.err != null) {
                    this.err.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Error_Copying", (Object)this.remoteDir, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString(), (Object)ex.getLocalizedMessage()));
                }
            }
            catch (IOException ex) {
                RemoteUtil.LOGGER.log(Level.FINE, null, ex);
                if (this.err == null) break block11;
                this.err.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Error_Copying", (Object)this.remoteDir, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString(), (Object)ex.getLocalizedMessage()));
            }
        }
        return success;
    }

    private void printErr(Exception ex) throws MissingResourceException {
        RemoteUtil.LOGGER.finest(ex.getMessage());
        if (this.err != null) {
            String message = NbBundle.getMessage(this.getClass(), (String)"MSG_Error_Copying", (Object)this.remoteDir, (Object)ServerList.get((ExecutionEnvironment)this.executionEnvironment).toString(), (Object)ex.getLocalizedMessage());
            this.err.printf("%s\n", message);
            this.err.printf("%s\n", NbBundle.getMessage(this.getClass(), (String)"MSG_Build_Failed"));
            this.err.printf("%s\n", message);
        }
    }

    private void startupImpl(Map<String, String> env2add) throws IOException, InterruptedException, ExecutionException, RemoteException {
        String ldLibraryPath;
        String remoteControllerPath;
        try {
            remoteControllerPath = RfsSetupProvider.getControllerPath(this.executionEnvironment);
            CndUtils.assertTrue((remoteControllerPath != null ? 1 : 0) != 0);
            ldLibraryPath = RfsSetupProvider.getLdLibraryPath(this.executionEnvironment);
            CndUtils.assertTrue((ldLibraryPath != null ? 1 : 0) != 0);
        }
        catch (ParseException ex) {
            throw new ExecutionException(ex);
        }
        NativeProcessBuilder pb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.executionEnvironment);
        this.remoteControllerCleanup();
        pb.setExecutable(remoteControllerPath);
        pb.setWorkingDirectory(this.remoteDir);
        String rfsTrace = System.getProperty("cnd.rfs.controller.trace");
        if (rfsTrace != null) {
            pb.getEnvironment().put("RFS_CONTROLLER_TRACE", rfsTrace);
        }
        this.remoteControllerProcess = pb.call();
        RP.post((Runnable)new ErrorReader(this.remoteControllerProcess.getErrorStream(), this.err));
        InputStream rcInputStream = this.remoteControllerProcess.getInputStream();
        OutputStream rcOutputStream = this.remoteControllerProcess.getOutputStream();
        BufferedReader rcInputStreamReader = ProcessUtils.getReader((InputStream)rcInputStream, (boolean)this.executionEnvironment.isRemote());
        PrintWriter rcOutputStreamWriter = ProcessUtils.getWriter((OutputStream)rcOutputStream, (boolean)this.executionEnvironment.isRemote());
        this.localController = new RfsLocalController(this.executionEnvironment, this.files, rcInputStreamReader, rcOutputStreamWriter, this.err, this.privProjectStorageDir);
        this.localController.init();
        String line = rcInputStreamReader.readLine();
        if (line == null || !line.startsWith("PORT ")) {
            if (line == null) {
                int rc = this.remoteControllerProcess.waitFor();
                throw new ExecutionException(String.format("Remote controller failed; rc=%d\n", rc), null);
            }
            String message = String.format("Protocol error: read \"%s\" expected \"%s\"\n", line, "PORT <port-number>");
            System.err.printf(message, new Object[0]);
            this.remoteControllerProcess.destroy();
            throw new ExecutionException(message, null);
        }
        String port = line.substring(5);
        RemoteUtil.LOGGER.log(Level.FINE, "Remote Controller listens port {0}", port);
        RP.post((Runnable)((Object)this.localController));
        String preload = RfsSetupProvider.getPreloadName(this.executionEnvironment);
        CndUtils.assertTrue((preload != null ? 1 : 0) != 0);
        env2add.put("LD_PRELOAD", preload);
        String ldLibPathVar = "LD_LIBRARY_PATH";
        String oldLdLibPath = MacroMap.forExecEnv((ExecutionEnvironment)this.executionEnvironment).get(ldLibPathVar);
        if (oldLdLibPath != null) {
            ldLibraryPath = ldLibraryPath + ":" + oldLdLibPath;
        }
        env2add.put(ldLibPathVar, ldLibraryPath);
        env2add.put("RFS_CONTROLLER_DIR", this.remoteDir);
        env2add.put("RFS_CONTROLLER_PORT", port);
        this.addRemoteEnv(env2add, "cnd.rfs.preload.sleep", "RFS_PRELOAD_SLEEP");
        this.addRemoteEnv(env2add, "cnd.rfs.preload.log", "RFS_PRELOAD_LOG");
        this.addRemoteEnv(env2add, "cnd.rfs.controller.log", "RFS_CONTROLLER_LOG");
        this.addRemoteEnv(env2add, "cnd.rfs.controller.port", "RFS_CONTROLLER_PORT");
        this.addRemoteEnv(env2add, "cnd.rfs.controller.host", "RFS_CONTROLLER_HOST");
        this.addRemoteEnv(env2add, "cnd.rfs.preload.trace", "RFS_PRELOAD_TRACE");
        RemoteUtil.LOGGER.fine("Setting environment:");
    }

    private void addRemoteEnv(Map<String, String> env2add, String localJavaPropertyName, String remoteEnvVarName) {
        String value = System.getProperty(localJavaPropertyName, null);
        if (value != null) {
            env2add.put(remoteEnvVarName, value);
        }
    }

    public void shutdown() {
        this.remoteControllerCleanup();
        this.localControllerCleanup();
    }

    public boolean cancel() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void localControllerCleanup() {
        RfsSyncWorker rfsSyncWorker = this;
        synchronized (rfsSyncWorker) {
            RfsLocalController lc = this.localController;
            this.localController = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remoteControllerCleanup() {
        NativeProcess rc;
        RfsSyncWorker rfsSyncWorker = this;
        synchronized (rfsSyncWorker) {
            rc = this.remoteControllerProcess;
            this.remoteControllerProcess = null;
        }
        if (rc != null) {
            rc.destroy();
            rc = null;
        }
    }

    private static class ErrorReader
    implements Runnable {
        private final BufferedReader errorReader;
        private final PrintWriter errorWriter;

        public ErrorReader(InputStream errorStream, PrintWriter errorWriter) {
            this.errorReader = new BufferedReader(new InputStreamReader(errorStream));
            this.errorWriter = errorWriter;
        }

        @Override
        public void run() {
            try {
                String line;
                while ((line = this.errorReader.readLine()) != null) {
                    if (this.errorWriter != null) {
                        this.errorWriter.println(line);
                    }
                    RemoteUtil.LOGGER.fine(line);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

