/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.support;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.support.RemoteConnectionSupport;
import org.netbeans.modules.cnd.remote.support.RemoteUtil;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.openide.util.Utilities;

public class RemoteNativeExecutionSupport
extends RemoteConnectionSupport {
    private NativeProcess process;
    private final Object procLock = new Object();
    private final File dirf;
    private final String cmd;
    private final String args;
    private final Map<String, String> env;
    private final boolean x11forwarding;

    public RemoteNativeExecutionSupport(ExecutionEnvironment execEnv, File dirf, String cmd, String args, Map<String, String> env) {
        this(execEnv, dirf, cmd, args, env, false);
    }

    public RemoteNativeExecutionSupport(ExecutionEnvironment execEnv, File dirf, String cmd, String args, Map<String, String> env, boolean x11forwarding) {
        super(execEnv);
        this.args = args;
        this.dirf = dirf;
        this.cmd = cmd;
        this.env = env;
        this.x11forwarding = x11forwarding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(PrintWriter out, Reader userInput) {
        CndUtils.assertTrue((this.process == null ? 1 : 0) != 0, (String)("Instance of " + this.getClass().getSimpleName() + " should not be reused"));
        try {
            int read;
            NativeProcessBuilder pb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.executionEnvironment);
            pb.setExecutable(this.cmd);
            pb.getEnvironment().putAll(this.env);
            if (this.args != null) {
                pb.setArguments(Utilities.parseParameters((String)this.args));
            }
            pb.redirectError();
            pb.setX11Forwarding(this.x11forwarding);
            String path = null;
            if (this.dirf != null) {
                path = RemotePathMap.getPathMap(this.executionEnvironment).getRemotePath(this.dirf.getAbsolutePath(), true);
                if (RemoteUtil.LOGGER.isLoggable(Level.FINEST) && path.contains(" ")) {
                    RemoteUtil.LOGGER.finest("A PATH WITH A SPACE\n");
                }
                pb = pb.setWorkingDirectory(path);
            }
            RemoteUtil.LOGGER.log(Level.FINE, "RNES<Init>: Running [{0}] on {1} in {2}", new Object[]{this.cmd, this.executionEnvironment, path});
            Object object = this.procLock;
            synchronized (object) {
                this.process = pb.call();
            }
            InputStream is = this.process.getInputStream();
            InputStreamReader in = new InputStreamReader(is);
            if (userInput != null) {
                InputReaderThread inputReaderThread = new InputReaderThread(this.process.getOutputStream(), new ReaderInputStream(userInput));
                inputReaderThread.start();
            }
            while ((read = ((Reader)in).read()) != -1) {
                if (read == 10) {
                    out.append('\n');
                    continue;
                }
                out.append((char)read);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            int rc = this.process.waitFor();
            if (rc != 0 && RemoteUtil.LOGGER.isLoggable(Level.FINEST)) {
                String errMsg;
                RemoteUtil.LOGGER.log(Level.FINEST, "RNES: {0} on {1} in {2} finished; rc={3}", new Object[]{this.cmd, this.executionEnvironment, path, rc});
                if (this.env == null) {
                    RemoteUtil.LOGGER.finest("RNES: env == null");
                } else {
                    for (Map.Entry<String, String> entry : this.env.entrySet()) {
                        RemoteUtil.LOGGER.log(Level.FINEST, "\tRNES: {0}={1}", new Object[]{entry.getKey(), entry.getValue()});
                    }
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
                while ((errMsg = reader.readLine()) != null) {
                    RemoteUtil.LOGGER.log(Level.FINEST, "RNES ERROR: {0}", errMsg);
                }
            }
            this.setExitStatus(rc);
            out.flush();
            is.close();
            ((Reader)in).close();
        }
        catch (InterruptedException ie) {
            RemoteUtil.LOGGER.fine("RNES: interrupted (1)");
            this.kill();
        }
        catch (InterruptedIOException ie) {
            RemoteUtil.LOGGER.fine("RNES: interrupted (2)");
            this.kill();
        }
        catch (IOException ioe) {
            RemoteUtil.LOGGER.log(Level.WARNING, ioe.getMessage(), ioe);
        }
        catch (Exception ex) {
            RemoteUtil.LOGGER.log(Level.WARNING, ex.getMessage(), ex);
        }
        finally {
            RemoteUtil.LOGGER.log(Level.FINEST, "RNES return value: {0}", this.getExitStatus());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void kill() {
        NativeProcess p = null;
        Object object = this.procLock;
        synchronized (object) {
            p = this.process;
        }
        if (p == null) {
            RemoteUtil.LOGGER.fine("RNES: process is null, can't kill");
        } else {
            RemoteUtil.LOGGER.log(Level.FINE, "RNES: killing {0}", p);
            p.destroy();
        }
    }

    public void stop() {
        RemoteUtil.LOGGER.log(Level.FINE, "RNES: stop {0}", this.process);
        this.kill();
    }

    private static final class ReaderInputStream
    extends InputStream {
        private final Reader reader;

        public ReaderInputStream(Reader reader) {
            this.reader = reader;
        }

        @Override
        public int read() throws IOException {
            int t = this.reader.read();
            return t;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int c = this.read();
            if (c == -1) {
                return -1;
            }
            b[off] = (byte)c;
            return 1;
        }
    }

    private static final class InputReaderThread
    extends Thread {
        private InputStream in;
        private OutputStream pout;

        public InputReaderThread(OutputStream pout, InputStream in) {
            this.pout = pout;
            this.in = in;
            this.setName("inputReaderThread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int ch;
                while ((ch = this.in.read()) != -1) {
                    this.pout.write((char)ch);
                    this.pout.flush();
                }
            }
            catch (IOException e) {
            }
            finally {
                try {
                    this.pout.flush();
                    this.pout.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

